var log4javascript=function(){var global=function(){return this}();function isUndefined(obj){return typeof obj==="undefined"}function hasMethod(obj,methodName){return typeof obj[methodName]==="function"}function isHostMethod(object,property){var t=typeof object[property];return t==="function"||!!(t==="object"&&object[property])||t==="unknown"}function isHostCollection(object,property){var t=typeof object[property];return!!(t==="object"&&object[property])||t==="function"}function isHostObject(object,property){return!!(typeof object[property]==="object"&&object[property])}var Arrays=function(){var push=Array.prototype.push?function(arr,val){return arr.push(val)}:function(arr,val){arr[arr.length]=val;return arr.length};var shift=Array.prototype.shift?function(arr){return arr.shift()}:function(arr){if(arr.length>0){var firstItem=arr[0];for(var i=0,len=arr.length-1;i<len;i++){arr[i]=arr[i+1]}arr.length=arr.length-1;return firstItem}};var indexOf=Array.prototype.indexOf?function(arr,val,from){return arr.indexOf(val,from)}:function(arr,val,from){var len=arr.length;from=Number(arguments[2])||0;from=Math.floor(Math.max(from,0));for(;from<len;from++){if(typeof arr[from]!=="undefined"&&arr[from]===val){return from}}return-1};var remove=Array.prototype.splice?function(arr,val){var index=indexOf(arr,val);if(index>=0){arr.splice(index,1);return true}else{return false}}:function(arr,val){var index=indexOf(arr,val);var i,len,itemsToAdd,removedAny=false;if(index>=0){if(index==arr.length-1){arr.length--}else{itemsToAdd=arr.slice(index+1);arr.length=index;for(i=0,len=itemsToAdd.length;i<len;i++){Arrays.push(arr,itemsToAdd[i])}}removedAny=true}return removedAny};function contains(arr,val){return indexOf(arr,val)>-1}return{push:push,shift:shift,indexOf:indexOf,remove:remove,contains:contains}}();function EventSupport(){}EventSupport.prototype={eventTypes:[],eventListeners:{},setEventTypes:function(eventTypesParam){if(eventTypesParam instanceof Array){this.eventTypes=eventTypesParam;this.eventListeners={};for(var i=0,len=this.eventTypes.length;i<len;i++){this.eventListeners[this.eventTypes[i]]=[]}}else{handleError("log4javascript.EventSupport ["+this+"]: setEventTypes: eventTypes parameter must be an Array")}},addEventListener:function(eventType,listener){if(typeof listener=="function"){if(!Arrays.contains(this.eventTypes,eventType)){handleError("log4javascript.EventSupport ["+this+"]: addEventListener: no event called '"+eventType+"'")}Arrays.push(this.eventListeners[eventType],listener)}else{handleError("log4javascript.EventSupport ["+this+"]: addEventListener: listener must be a function")}},removeEventListener:function(eventType,listener){if(typeof listener=="function"){if(!Arrays.contains(this.eventTypes,eventType)){handleError("log4javascript.EventSupport ["+this+"]: removeEventListener: no event called '"+eventType+"'")}Arrays.remove(this.eventListeners[eventType],listener)}else{handleError("log4javascript.EventSupport ["+this+"]: removeEventListener: listener must be a function")}},dispatchEvent:function(eventType,eventArgs){if(Arrays.contains(this.eventTypes,eventType)){var listeners=this.eventListeners[eventType];for(var i=0,len=listeners.length;i<len;i++){listeners[i](this,eventType,eventArgs)}}else{handleError("log4javascript.EventSupport ["+this+"]: dispatchEvent: no event called '"+eventType+"'")}}};var applicationStartDate=new Date;var uniqueId="log4javascript_"+applicationStartDate.getTime()+"_"+Math.floor(Math.random()*1e8);var emptyFunction=function(){};var newLine="\r\n";var pageLoaded=false;function Log4JavaScript(){}Log4JavaScript.prototype=new EventSupport;log4javascript=new Log4JavaScript;log4javascript.version="1.5 dev";log4javascript.edition="log4javascript";function toStr(obj){if(obj&&obj.toString){return obj.toString()}else{return String(obj)}}function getExceptionMessage(ex){if(ex.message){return ex.message}else if(ex.description){return ex.description}else{return toStr(ex)}}function getUrlFileName(url){var lastSlashIndex=Math.max(url.lastIndexOf("/"),url.lastIndexOf("\\"));return url.substr(lastSlashIndex+1)}function getExceptionStringRep(ex){if(ex){var exStr="Exception: "+getExceptionMessage(ex);try{if(ex.lineNumber){exStr+=" on line number "+ex.lineNumber}if(ex.fileName){exStr+=" in file "+getUrlFileName(ex.fileName)}}catch(localEx){logLog.warn("Unable to obtain file and line information for error")}if(showStackTraces&&ex.stack){exStr+=newLine+"Stack trace:"+newLine+ex.stack}return exStr}return null}function bool(obj){return Boolean(obj)}function trim(str){return str.replace(/^\s+/,"").replace(/\s+$/,"")}function splitIntoLines(text){var text2=text.replace(/\r\n/g,"\n").replace(/\r/g,"\n");return text2.split("\n")}function createCharString(str,len){var c=[],i=len;while(i--){c[i]=str}return c.join("")}function leftPad(str,len,padStr){return createCharString(padStr,len)+str}function rightPad(str,len,padStr){return str+createCharString(padStr,len)}var urlEncode=function(){function toUtf8(str,useCaching){var i,len,c,cachedChars,newStrParts=[],cachedParts={},newPart;if(useCaching){cachedChars={}}for(i=0,len=str.length;i<len;i++){c=str.charCodeAt(i);newPart=useCaching?cachedParts[c]:null;if(!newPart){if(c<128){newPart=String.fromCharCode(c)}else if(c>127&&c<2048){newPart=String.fromCharCode(c>>6|192)+String.fromCharCode(c&63|128)}else{newPart=String.fromCharCode(c>>12|224)+String.fromCharCode(c>>6&63|128)+String.fromCharCode(c&63|128)}}if(useCaching){cachedParts[c]=newPart}Arrays.push(newStrParts,newPart)}return newStrParts.join("")}function hex(charCode){return(charCode<16?"%0"+charCode.toString(16):"%"+charCode.toString(16)).toUpperCase()}var unencodedCharRegex=/[a-z0-9.\-*_]/i;return function(str){var i,len,c,newStrParts=[],newPart,character;var newStr=toStr(str).replace(/\r\n/g,"\n").replace(/[\r\n]/g,"\r\n");newStr=toUtf8(newStr,true);for(i=0,len=newStr.length;i<len;i++){c=newStr.charCodeAt(i);character=String.fromCharCode(c);if(unencodedCharRegex.test(character)){newPart=character}else if(character==" "){newPart="+"}else{newPart=hex(c)}Arrays.push(newStrParts,newPart)}return newStrParts.join("")}}();function extractBooleanFromParam(param,defaultValue){if(isUndefined(param)){return defaultValue}else{return bool(param)}}function extractStringFromParam(param,defaultValue){if(isUndefined(param)){return defaultValue}else{return String(param)}}function extractIntFromParam(param,defaultValue){var value;if(isUndefined(param)){return defaultValue}else{try{value=parseInt(param,10);return isNaN(value)?defaultValue:value}catch(ex){logLog.warn("Invalid int param "+param,ex);return defaultValue}}}function extractFunctionFromParam(param,defaultValue){if(typeof param=="function"){return param}else{return defaultValue}}function isError(err){return err instanceof Error}if(!Function.prototype.apply){Function.prototype.apply=function(obj,args){var methodName="__apply__";if(typeof obj[methodName]!="undefined"){methodName+=String(Math.random()).substr(2)}obj[methodName]=this;var argsStrings=[];for(var i=0,len=args.length;i<len;i++){argsStrings[i]="args["+i+"]"}var script="obj."+methodName+"("+argsStrings.join(",")+")";var returnValue=eval(script);delete obj[methodName];return returnValue}}if(!Function.prototype.call){Function.prototype.call=function(obj){var args=[];for(var i=1,len=arguments.length;i<len;i++){args[i-1]=arguments[i]}return this.apply(obj,args)}}function getListenersPropertyName(eventName){return"__log4javascript_listeners__"+eventName}function addEvent(node,eventName,listener,useCapture,win){win=win?win:window;if(node.addEventListener){node.addEventListener(eventName,listener,useCapture)}else if(node.attachEvent){node.attachEvent("on"+eventName,listener)}else{var propertyName=getListenersPropertyName(eventName);if(!node[propertyName]){node[propertyName]=[];node["on"+eventName]=function(evt){evt=evt||win.event;var listenersPropertyName=getListenersPropertyName(eventName);var listeners=this[listenersPropertyName].concat([]);var currentListener;while(currentListener=listeners.shift()){currentListener.call(this,evt)}}}Arrays.push(node[propertyName],listener)}}var logLog={quietMode:false,debugMessages:[],setQuietMode:function(quietMode){this.quietMode=bool(quietMode)},numberOfErrors:0,alertAllErrors:false,setAlertAllErrors:function(alertAllErrors){this.alertAllErrors=alertAllErrors},debug:function(message){Arrays.push(this.debugMessages,message)},displayDebug:function(){alert(this.debugMessages.join(newLine))},warn:function(){},error:function(message,exception){if(++this.numberOfErrors==1||this.alertAllErrors){if(!this.quietMode){var alertMessage="log4javascript error: "+message;if(exception){alertMessage+=newLine+newLine+"Original error: "+getExceptionStringRep(exception)}alert(alertMessage)}}}};log4javascript.logLog=logLog;log4javascript.setEventTypes(["load","error"]);function handleError(message,exception){logLog.error(message,exception);log4javascript.dispatchEvent("error",{message:message,exception:exception})}log4javascript.handleError=handleError;var enabled=!(typeof global.log4javascript_disabled!=="undefined"&&global.log4javascript_disabled);log4javascript.setEnabled=function(enable){enabled=!!enable};log4javascript.isEnabled=function(){return enabled};var useTimeStampsInMilliseconds=true;log4javascript.setTimeStampsInMilliseconds=function(timeStampsInMilliseconds){useTimeStampsInMilliseconds=!!timeStampsInMilliseconds};log4javascript.isTimeStampsInMilliseconds=function(){return useTimeStampsInMilliseconds};log4javascript.evalInScope=function(expr){return eval(expr)};var showStackTraces=false;log4javascript.setShowStackTraces=function(show){showStackTraces=!!show};var Level=function(level,name){this.level=level;this.name=name};Level.prototype={toString:function(){return this.name},equals:function(level){return this.level==level.level},isGreaterOrEqual:function(level){return this.level>=level.level}};Level.ALL=new Level(Number.MIN_VALUE,"ALL");Level.TRACE=new Level(1e4,"TRACE");Level.DEBUG=new Level(2e4,"DEBUG");Level.INFO=new Level(3e4,"INFO");Level.WARN=new Level(4e4,"WARN");Level.ERROR=new Level(5e4,"ERROR");Level.FATAL=new Level(6e4,"FATAL");Level.OFF=new Level(Number.MAX_VALUE,"OFF");log4javascript.Level=Level;function Timer(name,level){this.name=name;this.level=level||Level.INFO;this.start=new Date}Timer.prototype.getElapsedTime=function(){return(new Date).getTime()-this.start.getTime()};function Renderer(testFn,renderFn){this.shouldRender=testFn;this.doRender=renderFn}var renderers=[];Renderer.forInstancesOf=function(constructorFn,renderFn){return new Renderer(function(obj){return obj instanceof constructorFn},renderFn)};function render(obj){var i=renderers.length,renderer;while(i--){renderer=renderers[i];if(renderer.shouldRender(obj)){return renderer.doRender(obj)}}return null}log4javascript.addRenderer=function(testFn,renderFn){Arrays.push(renderers,new Renderer(testFn,renderFn))};log4javascript.addRendererForInstancesOf=function(constructorFn,renderFn){Arrays.push(renderers,Renderer.forInstancesOf(constructorFn,renderFn))};var anonymousLoggerName="[anonymous]";var nullLoggerName="[null]";var rootLoggerName="root";function Logger(name){this.name=name;this.parent=null;this.children=[];var appenders=[];var loggerLevel=null;var isRoot=this.name===rootLoggerName;var isNull=this.name===nullLoggerName;var appenderCache=null;var appenderCacheInvalidated=false;var additive=true;this.getAdditivity=function(){return additive};this.setAdditivity=function(additivity){var valueChanged=additive!=additivity;additive=additivity;if(valueChanged){this.invalidateAppenderCache()}};this.addAppender=function(appender){if(isNull){handleError("Logger.addAppender: you may not add an appender to the null logger")}else{if(appender instanceof log4javascript.Appender){if(!Arrays.contains(appenders,appender)){Arrays.push(appenders,appender);appender.setAddedToLogger(this);this.invalidateAppenderCache()}}else{handleError("Logger.addAppender: appender supplied ('"+toStr(appender)+"') is not a subclass of Appender")}}};this.removeAppender=function(appender){Arrays.remove(appenders,appender);appender.setRemovedFromLogger(this);this.invalidateAppenderCache()};this.removeAllAppenders=function(){var appenderCount=appenders.length;if(appenderCount>0){for(var i=0;i<appenderCount;i++){appenders[i].setRemovedFromLogger(this)}appenders.length=0;this.invalidateAppenderCache()}};this.getEffectiveAppenders=function(){if(appenderCache===null||appenderCacheInvalidated){var parentEffectiveAppenders=isRoot||!this.getAdditivity()?[]:this.parent.getEffectiveAppenders();appenderCache=parentEffectiveAppenders.concat(appenders);appenderCacheInvalidated=false}return appenderCache};this.invalidateAppenderCache=function(){appenderCacheInvalidated=true;for(var i=0,len=this.children.length;i<len;i++){this.children[i].invalidateAppenderCache()}};this.log=function(level,params){var exception,finalParamIndex,lastParam,messages,date,loggingEvent,i;if(enabled&&level.isGreaterOrEqual(this.getEffectiveLevel())){date=new Date;finalParamIndex=params.length-1;lastParam=params[finalParamIndex];if(params.length>1&&isError(lastParam)){exception=lastParam;finalParamIndex--}messages=[];for(i=0;i<=finalParamIndex;i++){messages[i]=params[i]}loggingEvent=new LoggingEvent(this,date,level,messages,exception);this.callAppenders(loggingEvent)}};this.setLevel=function(level){if(isRoot&&level===null){handleError("Logger.setLevel: you cannot set the level of the root logger to null")}else if(level instanceof Level){loggerLevel=level}else{handleError("Logger.setLevel: level supplied to logger "+this.name+" is not an instance of log4javascript.Level")}};this.getLevel=function(){return loggerLevel};var timers={};this.time=function(name,level){if(enabled){if(isUndefined(name)){handleError("Logger.time: a name for the timer must be supplied")}else if(level&&!(level instanceof Level)){handleError("Logger.time: level supplied to timer "+name+" is not an instance of log4javascript.Level")}else{timers[name]=new Timer(name,level)}}};this.timeEnd=function(name){var timer,milliseconds;if(enabled){if(isUndefined(name)){handleError("Logger.timeEnd: a name for the timer must be supplied")}else if(timers[name]){timer=timers[name];milliseconds=timer.getElapsedTime();this.log(timer.level,['Timer "'+toStr(name)+'" completed in '+milliseconds+"ms"]);timers[name]=null}else{logLog.warn('Logger.timeEnd: no timer found with name "'+name+'"')}}}}Logger.prototype={isEnabledFor:function(level){return level.isGreaterOrEqual(this.getEffectiveLevel())},addChild:function(childLogger){Arrays.push(this.children,childLogger);childLogger.parent=this;childLogger.invalidateAppenderCache()},callAppenders:function(loggingEvent){var effectiveAppenders=this.getEffectiveAppenders();var i=effectiveAppenders.length;while(i--){effectiveAppenders[i].doAppend(loggingEvent)}},getEffectiveLevel:function(){for(var logger=this;logger!==null;logger=logger.parent){var level=logger.getLevel();if(level!==null){return level}}},group:function(name,initiallyExpanded){var effectiveAppenders,i;if(enabled){effectiveAppenders=this.getEffectiveAppenders();i=effectiveAppenders.length;while(i--){effectiveAppenders[i].group(name,initiallyExpanded)}}},groupEnd:function(){var effectiveAppenders,i;if(enabled){effectiveAppenders=this.getEffectiveAppenders();i=effectiveAppenders.length;while(i--){effectiveAppenders[i].groupEnd()}}},assert:function(expr){var args,i,len;if(enabled&&!expr){args=[];for(i=1,len=arguments.length;i<len;i++){Arrays.push(args,arguments[i])}args=args.length>0?args:["Assertion Failure"];Arrays.push(args,newLine);Arrays.push(args,expr);this.log(Level.ERROR,args)}},toString:function(){return"Logger["+this.name+"]"}};function stringFormat(str,replacements){var formattedString=str;var i=replacements.length;while(i--){formattedString=formattedString.replace("{"+i+"}",replacements[i])}return formattedString}(function(){function createLevelMethods(levelName){var upper=levelName.toUpperCase(),lower=levelName.toLowerCase();var level=Level[upper];Logger.prototype[lower]=function(){this.log(level,arguments)};Logger.prototype[lower+"Format"]=function(){this.log(level,[stringFormat(arguments[0],Array.prototype.slice.call(arguments,1))])};Logger.prototype["is"+levelName+"Enabled"]=function(){return this.isEnabledFor(level)}}var i,levelNames=["Trace","Debug","Info","Warn","Error","Fatal"];i=levelNames.length;while(i--){createLevelMethods(levelNames[i])}})();var loggers={};var loggerNames=[];var ROOT_LOGGER_DEFAULT_LEVEL=Level.DEBUG;var rootLogger=new Logger(rootLoggerName);rootLogger.setLevel(ROOT_LOGGER_DEFAULT_LEVEL);log4javascript.getRootLogger=function(){return rootLogger};log4javascript.getLogger=function(loggerName){if(!(typeof loggerName=="string")){loggerName=anonymousLoggerName;logLog.warn("log4javascript.getLogger: non-string logger name "+toStr(loggerName)+" supplied, returning anonymous logger")}if(loggerName==rootLoggerName){handleError("log4javascript.getLogger: root logger may not be obtained by name")}if(!loggers[loggerName]){var logger=new Logger(loggerName);loggers[loggerName]=logger;Arrays.push(loggerNames,loggerName);var lastDotIndex=loggerName.lastIndexOf(".");var parentLogger;if(lastDotIndex>-1){var parentLoggerName=loggerName.substring(0,lastDotIndex);parentLogger=log4javascript.getLogger(parentLoggerName)}else{parentLogger=rootLogger}parentLogger.addChild(logger)}return loggers[loggerName]};var nullLogger=null;log4javascript.getNullLogger=function(){if(!nullLogger){nullLogger=new Logger(nullLoggerName);nullLogger.setLevel(Level.OFF)}return nullLogger};log4javascript.resetConfiguration=function(){rootLogger.setLevel(ROOT_LOGGER_DEFAULT_LEVEL);loggers={}};var LoggingEvent=function(logger,timeStamp,level,messages,exception){this.logger=logger;this.timeStamp=timeStamp;this.timeStampInMilliseconds=timeStamp.getTime();this.timeStampInSeconds=Math.floor(this.timeStampInMilliseconds/1e3);this.milliseconds=this.timeStamp.getMilliseconds();this.level=level;this.messages=messages;this.exception=exception};LoggingEvent.prototype={getThrowableStrRep:function(){return this.exception?getExceptionStringRep(this.exception):""},getCombinedMessages:function(){return this.messages.length===1?this.messages[0]:this.messages.join(newLine)},getRenderedMessages:function(){var renderedMessages=[];for(var i=0,len=this.messages.length;i<len;i++){renderedMessages[i]=render(this.messages[i])}return renderedMessages},getCombinedRenderedMessages:function(){return this.messages.length===1?render(this.messages[0]):this.getRenderedMessages().join(newLine)},toString:function(){return"LoggingEvent["+this.level+"]"}};log4javascript.LoggingEvent=LoggingEvent;var Layout=function(){};Layout.prototype={defaults:{loggerKey:"logger",timeStampKey:"timestamp",millisecondsKey:"milliseconds",levelKey:"level",messageKey:"message",exceptionKey:"exception",urlKey:"url"},loggerKey:"logger",timeStampKey:"timestamp",millisecondsKey:"milliseconds",levelKey:"level",messageKey:"message",exceptionKey:"exception",urlKey:"url",batchHeader:"",batchFooter:"",batchSeparator:"",returnsPostData:false,overrideTimeStampsSetting:false,useTimeStampsInMilliseconds:null,format:function(){handleError("Layout.format: layout supplied has no format() method")},ignoresThrowable:function(){handleError("Layout.ignoresThrowable: layout supplied has no ignoresThrowable() method")},getContentType:function(){return"text/plain"},allowBatching:function(){return true},setTimeStampsInMilliseconds:function(timeStampsInMilliseconds){this.overrideTimeStampsSetting=true;this.useTimeStampsInMilliseconds=bool(timeStampsInMilliseconds)},isTimeStampsInMilliseconds:function(){return this.overrideTimeStampsSetting?this.useTimeStampsInMilliseconds:useTimeStampsInMilliseconds},getTimeStampValue:function(loggingEvent){return this.isTimeStampsInMilliseconds()?loggingEvent.timeStampInMilliseconds:loggingEvent.timeStampInSeconds},getDataValues:function(loggingEvent,combineMessages){var dataValues=[[this.loggerKey,loggingEvent.logger.name],[this.timeStampKey,this.getTimeStampValue(loggingEvent)],[this.levelKey,loggingEvent.level.name],[this.urlKey,window.location.href],[this.messageKey,combineMessages?loggingEvent.getCombinedMessages():loggingEvent.messages]];if(!this.isTimeStampsInMilliseconds()){Arrays.push(dataValues,[this.millisecondsKey,loggingEvent.milliseconds])}if(loggingEvent.exception){Arrays.push(dataValues,[this.exceptionKey,getExceptionStringRep(loggingEvent.exception)])}if(this.hasCustomFields()){for(var i=0,len=this.customFields.length;i<len;i++){var val=this.customFields[i].value;if(typeof val==="function"){val=val(this,loggingEvent)}Arrays.push(dataValues,[this.customFields[i].name,val])}}return dataValues},setKeys:function(loggerKey,timeStampKey,levelKey,messageKey,exceptionKey,urlKey,millisecondsKey){this.loggerKey=extractStringFromParam(loggerKey,this.defaults.loggerKey);this.timeStampKey=extractStringFromParam(timeStampKey,this.defaults.timeStampKey);this.levelKey=extractStringFromParam(levelKey,this.defaults.levelKey);this.messageKey=extractStringFromParam(messageKey,this.defaults.messageKey);this.exceptionKey=extractStringFromParam(exceptionKey,this.defaults.exceptionKey);this.urlKey=extractStringFromParam(urlKey,this.defaults.urlKey);this.millisecondsKey=extractStringFromParam(millisecondsKey,this.defaults.millisecondsKey)},setCustomField:function(name,value){var fieldUpdated=false;for(var i=0,len=this.customFields.length;i<len;i++){if(this.customFields[i].name===name){this.customFields[i].value=value;fieldUpdated=true}}if(!fieldUpdated){Arrays.push(this.customFields,{name:name,value:value})}},hasCustomFields:function(){return this.customFields.length>0},toString:function(){handleError("Layout.toString: all layouts must override this method")}};log4javascript.Layout=Layout;var Appender=function(){};Appender.prototype=new EventSupport;Appender.prototype.layout=new PatternLayout;Appender.prototype.threshold=Level.ALL;Appender.prototype.loggers=[];Appender.prototype.doAppend=function(loggingEvent){if(enabled&&loggingEvent.level.level>=this.threshold.level){this.append(loggingEvent)}};Appender.prototype.append=function(loggingEvent){};Appender.prototype.setLayout=function(layout){if(layout instanceof Layout){this.layout=layout}else{handleError("Appender.setLayout: layout supplied to "+this.toString()+" is not a subclass of Layout")}};Appender.prototype.getLayout=function(){return this.layout};Appender.prototype.setThreshold=function(threshold){if(threshold instanceof Level){this.threshold=threshold}else{handleError("Appender.setThreshold: threshold supplied to "+this.toString()+" is not a subclass of Level")}};Appender.prototype.getThreshold=function(){return this.threshold};Appender.prototype.setAddedToLogger=function(logger){Arrays.push(this.loggers,logger)};Appender.prototype.setRemovedFromLogger=function(logger){Arrays.remove(this.loggers,logger)};Appender.prototype.group=function(){logLog.warn("Appender.group: grouping not supported by this appender")};Appender.prototype.groupEnd=function(){logLog.warn("Appender.groupEnd: grouping not supported by this appender")};Appender.prototype.toString=function(){handleError("Appender.toString: all appenders must override this method")};log4javascript.Appender=Appender;var defaultLoggerName="[default]";var defaultLogger=null;function getDefaultPopUpLogger(){if(!defaultLogger){defaultLogger=log4javascript.getLogger(defaultLoggerName);var a=new log4javascript.PopUpAppender;defaultLogger.addAppender(a)}return defaultLogger}var defaultInPageLoggerName="[default_in_page]";var defaultInPageLogger=null;function getDefaultInPageLogger(){if(!defaultInPageLogger){defaultInPageLogger=log4javascript.getLogger(defaultInPageLoggerName);var a=new log4javascript.InPageAppender;defaultInPageLogger.addAppender(a)}return defaultInPageLogger}log4javascript.getDefaultLogger=function(inPage){return inPage?getDefaultInPageLogger():getDefaultPopUpLogger()};log4javascript.getDefaultInPageLogger=function(){return getDefaultInPageLogger()};function SimpleLayout(){this.customFields=[]}SimpleLayout.prototype=new Layout;SimpleLayout.prototype.format=function(loggingEvent){return loggingEvent.level.name+" - "+loggingEvent.getCombinedMessages()};SimpleLayout.prototype.ignoresThrowable=function(){return true};SimpleLayout.prototype.toString=function(){return"SimpleLayout"};log4javascript.SimpleLayout=SimpleLayout;function NullLayout(){this.customFields=[]}NullLayout.prototype=new Layout;NullLayout.prototype.format=function(loggingEvent){return loggingEvent.messages};NullLayout.prototype.ignoresThrowable=function(){return true};NullLayout.prototype.toString=function(){return"NullLayout"};log4javascript.NullLayout=NullLayout;function XmlLayout(combineMessages){this.combineMessages=extractBooleanFromParam(combineMessages,true);this.customFields=[]}XmlLayout.prototype=new Layout;XmlLayout.prototype.isCombinedMessages=function(){return this.combineMessages};XmlLayout.prototype.getContentType=function(){return"text/xml"};XmlLayout.prototype.escapeCdata=function(str){return str.replace(/\]\]>/,"]]>]]&gt;<![CDATA[")};XmlLayout.prototype.format=function(loggingEvent){var layout=this;var i,len;function formatMessage(message){message=typeof message==="string"?message:toStr(message);return"<log4javascript:message><![CDATA["+layout.escapeCdata(message)+"]]></log4javascript:message>"}var str='<log4javascript:event logger="'+loggingEvent.logger.name+'" timestamp="'+this.getTimeStampValue(loggingEvent)+'"';if(!this.isTimeStampsInMilliseconds()){str+=' milliseconds="'+loggingEvent.milliseconds+'"'}str+=' level="'+loggingEvent.level.name+'">'+newLine;if(this.combineMessages){str+=formatMessage(loggingEvent.getCombinedMessages())}else{str+="<log4javascript:messages>"+newLine;for(i=0,len=loggingEvent.messages.length;i<len;i++){str+=formatMessage(loggingEvent.messages[i])+newLine}str+="</log4javascript:messages>"+newLine}if(this.hasCustomFields()){for(i=0,len=this.customFields.length;i<len;i++){str+='<log4javascript:customfield name="'+this.customFields[i].name+'"><![CDATA['+this.customFields[i].value.toString()+"]]></log4javascript:customfield>"+newLine}}if(loggingEvent.exception){str+="<log4javascript:exception><![CDATA["+getExceptionStringRep(loggingEvent.exception)+"]]></log4javascript:exception>"+newLine}str+="</log4javascript:event>"+newLine+newLine;return str};XmlLayout.prototype.ignoresThrowable=function(){return false};XmlLayout.prototype.toString=function(){return"XmlLayout"};log4javascript.XmlLayout=XmlLayout;function escapeNewLines(str){return str.replace(/\r\n|\r|\n/g,"\\r\\n")}function JsonLayout(readable,combineMessages){this.readable=extractBooleanFromParam(readable,false);this.combineMessages=extractBooleanFromParam(combineMessages,true);this.batchHeader=this.readable?"["+newLine:"[";this.batchFooter=this.readable?"]"+newLine:"]";this.batchSeparator=this.readable?","+newLine:",";this.setKeys();this.colon=this.readable?": ":":";this.tab=this.readable?"	":"";this.lineBreak=this.readable?newLine:"";this.customFields=[]}JsonLayout.prototype=new Layout;JsonLayout.prototype.isReadable=function(){return this.readable};JsonLayout.prototype.isCombinedMessages=function(){return this.combineMessages};JsonLayout.prototype.format=function(loggingEvent){var layout=this;var dataValues=this.getDataValues(loggingEvent,this.combineMessages);var str="{"+this.lineBreak;var i;function formatValue(val,prefix,expand){var formattedValue;var valType=typeof val;if(val instanceof Date){formattedValue=String(val.getTime())}else if(expand&&val instanceof Array){formattedValue="["+layout.lineBreak;for(i=0,len=val.length;i<len;i++){var childPrefix=prefix+layout.tab;formattedValue+=childPrefix+formatValue(val[i],childPrefix,false);if(i<val.length-1){formattedValue+=","}formattedValue+=layout.lineBreak}formattedValue+=prefix+"]"}else if(valType!=="number"&&valType!=="boolean"){formattedValue='"'+escapeNewLines(toStr(val).replace(/\"/g,'\\"'))+'"'}else{formattedValue=val}return formattedValue}for(i=0,len=dataValues.length;i<len;i++){str+=this.tab+'"'+dataValues[i][0]+'"'+this.colon+formatValue(dataValues[i][1],this.tab,true);if(i<dataValues.length-1){str+=","}str+=this.lineBreak}str+="}"+this.lineBreak;return str};JsonLayout.prototype.ignoresThrowable=function(){return false};JsonLayout.prototype.toString=function(){return"JsonLayout"};JsonLayout.prototype.getContentType=function(){return"application/json"};log4javascript.JsonLayout=JsonLayout;function HttpPostDataLayout(){this.setKeys();this.customFields=[]}HttpPostDataLayout.prototype=new Layout;HttpPostDataLayout.prototype.returnsPostData=true;HttpPostDataLayout.prototype.allowBatching=function(){return false};HttpPostDataLayout.prototype.format=function(loggingEvent){var dataValues=this.getDataValues(loggingEvent);var queryBits=[];for(var i=0,len=dataValues.length;i<len;i++){var val=dataValues[i][1]instanceof Date?String(dataValues[i][1].getTime()):dataValues[i][1];Arrays.push(queryBits,urlEncode(dataValues[i][0])+"="+urlEncode(val))}return queryBits.join("&")};HttpPostDataLayout.prototype.ignoresThrowable=function(loggingEvent){return false};HttpPostDataLayout.prototype.toString=function(){return"HttpPostDataLayout"};log4javascript.HttpPostDataLayout=HttpPostDataLayout;function ConsoleMessage(message){this.message=message}ConsoleMessage.prototype.toString=function(){return this.message};var formatObjectExpansion=function(){function PropertyExpansion(indentation,name){this.indentation=indentation;this.name=name;this.value=null}PropertyExpansion.prototype.toString=function(){return this.indentation+this.name+": "+this.value};function propertyComparer(prop1,prop2){return prop1.name===prop2.name?0:prop1.name>prop2.name?1:-1}function formatString(text,addQuotes,indentation){var lines=splitIntoLines(text);for(var i=1,len=lines.length;i<len;i++){lines[i]=indentation+lines[i]}var str=lines.join(newLine);return addQuotes?'"'+str+'"':str}function createFormattingContext(maxDepth,showMethods,alphabetical){return{maxDepth:maxDepth,objectsExpanded:[],showMethods:showMethods,alphabetical:alphabetical}}function doFormat(obj,depth,indentation,quoteStrings,context){var i,len,childDepth,childIndentation,childLines,expansion,childExpansion,isMethod,properties,methods;indentation=indentation||"";var renderedObj=render(obj);if(renderedObj!==null){return renderedObj}else if(obj===null){return"null"}else if(typeof obj==="undefined"){return"undefined"}else if(obj instanceof ConsoleMessage){return obj.message}else if(typeof obj==="string"){return formatString(obj,quoteStrings,indentation)}else if(typeof obj==="function"){return formatString(obj.toString(),false,indentation)}else if(typeof obj==="object"&&Arrays.contains(context.objectsExpanded,obj)){try{expansion=toStr(obj)}catch(ex){expansion="(Error formatting property. Details: "+getExceptionStringRep(ex)+")"}return expansion+" (already expanded)"}else if(obj instanceof Array&&depth>0){Arrays.push(context.objectsExpanded,obj);expansion="["+newLine;childDepth=depth-1;childIndentation=indentation+"  ";childLines=[];for(i=0,len=obj.length;i<len;i++){try{childExpansion=doFormat(obj[i],childDepth,childIndentation,true,context);Arrays.push(childLines,childIndentation+childExpansion)}catch(ex){Arrays.push(childLines,childIndentation+"(Error formatting array member. Details: "+getExceptionStringRep(ex)+")")}}expansion+=childLines.join(","+newLine)+newLine+indentation+"]";return expansion}else if(typeof obj==="object"&&depth>0){Arrays.push(context.objectsExpanded,obj);expansion="{"+newLine;childDepth=depth-1;childIndentation=indentation+"  ";properties=[];methods=[];for(i in obj){childExpansion=new PropertyExpansion(childIndentation,i);isMethod=false;try{isMethod=typeof obj[i]==="function";if(!isMethod||context.showMethods){childExpansion.value=doFormat(obj[i],childDepth,childIndentation,true,context)}}catch(ex){childExpansion.value="(Error formatting property. Details: "+getExceptionStringRep(ex)+")"}Arrays.push(isMethod?methods:properties,childExpansion);

}if(context.alphabetical){properties.sort(propertyComparer);methods.sort(propertyComparer)}properties=properties.concat(methods);expansion+=properties.join(","+newLine)+newLine+indentation+"}";return expansion}else{return formatString(toStr(obj),false,indentation)}}return function(obj,maxDepth,indentation,quoteStrings,alphabetical,showMethods){var context=createFormattingContext(maxDepth,showMethods,alphabetical);return doFormat(obj,maxDepth,indentation,quoteStrings,context)}}();var SimpleDateFormat=function(){var regex=/('[^']*')|(G+|y+|M+|w+|W+|D+|d+|F+|E+|a+|H+|k+|K+|h+|m+|s+|S+|Z+)|([a-zA-Z]+)|([^a-zA-Z']+)/;var monthNames=["January","February","March","April","May","June","July","August","September","October","November","December"];var dayNames=["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"];var TEXT2=0,TEXT3=1,NUMBER=2,YEAR=3,MONTH=4,TIMEZONE=5;var types={G:TEXT2,y:YEAR,M:MONTH,w:NUMBER,W:NUMBER,D:NUMBER,d:NUMBER,F:NUMBER,E:TEXT3,a:TEXT2,H:NUMBER,k:NUMBER,K:NUMBER,h:NUMBER,m:NUMBER,s:NUMBER,S:NUMBER,Z:TIMEZONE};var ONE_DAY=24*60*60*1e3;var ONE_WEEK=7*ONE_DAY;var DEFAULT_MINIMAL_DAYS_IN_FIRST_WEEK=1;var newDateAtMidnight=function(year,month,day){var d=new Date(year,month,day,0,0,0);d.setMilliseconds(0);return d};function getUTCTime(d){return Date.UTC(d.getFullYear(),d.getMonth(),d.getDate(),d.getHours(),d.getMinutes(),d.getSeconds(),d.getMilliseconds())}function getTimeSince(d1,d2){return getUTCTime(d1)-getUTCTime(d2)}function getPreviousSunday(d){var midday=new Date(d.getFullYear(),d.getMonth(),d.getDate(),12,0,0);var previousSunday=new Date(midday.getTime()-d.getDay()*ONE_DAY);return newDateAtMidnight(previousSunday.getFullYear(),previousSunday.getMonth(),previousSunday.getDate())}function getWeekInYear(d,minimalDaysInFirstWeek){if(isUndefined(minimalDaysInFirstWeek)){minimalDaysInFirstWeek=DEFAULT_MINIMAL_DAYS_IN_FIRST_WEEK}var previousSunday=getPreviousSunday(d);var startOfYear=newDateAtMidnight(d.getFullYear(),0,1);var numberOfSundays=previousSunday<startOfYear?0:1+Math.floor(getTimeSince(previousSunday,startOfYear)/ONE_WEEK);var numberOfDaysInFirstWeek=7-startOfYear.getDay();var weekInYear=numberOfSundays;if(numberOfDaysInFirstWeek<minimalDaysInFirstWeek){weekInYear--}return weekInYear}function getWeekInMonth(d,minimalDaysInFirstWeek){if(isUndefined(minimalDaysInFirstWeek)){minimalDaysInFirstWeek=DEFAULT_MINIMAL_DAYS_IN_FIRST_WEEK}var previousSunday=getPreviousSunday(d);var startOfMonth=newDateAtMidnight(d.getFullYear(),d.getMonth(),1);var numberOfSundays=previousSunday<startOfMonth?0:1+Math.floor(getTimeSince(previousSunday,startOfMonth)/ONE_WEEK);var numberOfDaysInFirstWeek=7-startOfMonth.getDay();var weekInMonth=numberOfSundays;if(numberOfDaysInFirstWeek>=minimalDaysInFirstWeek){weekInMonth++}return weekInMonth}function getDayInYear(d){var startOfYear=newDateAtMidnight(d.getFullYear(),0,1);return 1+Math.floor(getTimeSince(d,startOfYear)/ONE_DAY)}function SimpleDateFormat(formatString){this.formatString=formatString}SimpleDateFormat.prototype.setMinimalDaysInFirstWeek=function(days){this.minimalDaysInFirstWeek=days};SimpleDateFormat.prototype.getMinimalDaysInFirstWeek=function(){return isUndefined(this.minimalDaysInFirstWeek)?DEFAULT_MINIMAL_DAYS_IN_FIRST_WEEK:this.minimalDaysInFirstWeek};function formatText(data,numberOfLetters,minLength){return numberOfLetters>=4?data:data.substr(0,Math.max(minLength,numberOfLetters))}function formatNumber(data,numberOfLetters){var dataString=""+data;return leftPad(dataString,numberOfLetters-dataString.length,"0")}SimpleDateFormat.prototype.format=function(date){var parts=[];var result;var searchString=this.formatString;var dataString,prefix,absData,hours,minutes;while(result=regex.exec(searchString)){var quotedString=result[1];var patternLetters=result[2];var otherLetters=result[3];var otherCharacters=result[4];if(quotedString){if(quotedString=="''"){Arrays.push(parts,"'")}else{Arrays.push(parts,quotedString.substring(1,quotedString.length-1))}}else if(otherLetters){}else if(otherCharacters){Arrays.push(parts,otherCharacters)}else if(patternLetters){var patternLetter=patternLetters.charAt(0);var numberOfLetters=patternLetters.length;var rawData="";switch(patternLetter){case"G":rawData="AD";break;case"y":rawData=date.getFullYear();break;case"M":rawData=date.getMonth();break;case"w":rawData=getWeekInYear(date,this.getMinimalDaysInFirstWeek());break;case"W":rawData=getWeekInMonth(date,this.getMinimalDaysInFirstWeek());break;case"D":rawData=getDayInYear(date);break;case"d":rawData=date.getDate();break;case"F":rawData=1+Math.floor((date.getDate()-1)/7);break;case"E":rawData=dayNames[date.getDay()];break;case"a":rawData=date.getHours()>=12?"PM":"AM";break;case"H":rawData=date.getHours();break;case"k":rawData=date.getHours()||24;break;case"K":rawData=date.getHours()%12;break;case"h":rawData=date.getHours()%12||12;break;case"m":rawData=date.getMinutes();break;case"s":rawData=date.getSeconds();break;case"S":rawData=date.getMilliseconds();break;case"Z":rawData=date.getTimezoneOffset();break}switch(types[patternLetter]){case TEXT2:Arrays.push(parts,formatText(rawData,numberOfLetters,2));break;case TEXT3:Arrays.push(parts,formatText(rawData,numberOfLetters,3));break;case NUMBER:Arrays.push(parts,formatNumber(rawData,numberOfLetters));break;case YEAR:if(numberOfLetters<=3){dataString=""+rawData;Arrays.push(parts,dataString.substr(2,2))}else{Arrays.push(parts,formatNumber(rawData,numberOfLetters))}break;case MONTH:if(numberOfLetters>=3){Arrays.push(parts,formatText(monthNames[rawData],numberOfLetters,numberOfLetters))}else{Arrays.push(parts,formatNumber(rawData+1,numberOfLetters))}break;case TIMEZONE:prefix=rawData>0?"-":"+";absData=Math.abs(rawData);hours=leftPad(""+Math.floor(absData/60),2,"0");minutes=leftPad(""+absData%60,2,"0");Arrays.push(parts,prefix+hours+minutes);break}}searchString=searchString.substr(result.index+result[0].length)}return parts.join("")};return SimpleDateFormat}();log4javascript.SimpleDateFormat=SimpleDateFormat;function PatternLayout(pattern){if(pattern){this.pattern=pattern}else{this.pattern=PatternLayout.DEFAULT_CONVERSION_PATTERN}this.customFields=[]}PatternLayout.TTCC_CONVERSION_PATTERN="%r %p %c - %m%n";PatternLayout.DEFAULT_CONVERSION_PATTERN="%m%n";PatternLayout.ISO8601_DATEFORMAT="yyyy-MM-dd HH:mm:ss,SSS";PatternLayout.DATETIME_DATEFORMAT="dd MMM yyyy HH:mm:ss,SSS";PatternLayout.ABSOLUTETIME_DATEFORMAT="HH:mm:ss,SSS";PatternLayout.prototype=new Layout;PatternLayout.prototype.format=function(loggingEvent){var regex=/%(-?[0-9]+)?(\.?[0-9]+)?([acdfmMnpr%])(\{([^\}]+)\})?|([^%]+)/;var parts=[];var result;var searchString=this.pattern;var i,len,l,replacement,replacementParts,replacementLen,depth;var matchedString,padding,truncation,conversionCharacter,specifier,text;while(result=regex.exec(searchString)){matchedString=result[0];padding=result[1];truncation=result[2];conversionCharacter=result[3];specifier=result[5];text=result[6];if(text){Arrays.push(parts,text)}else{replacement="";switch(conversionCharacter){case"a":case"m":depth=0;replacementParts=[];if(specifier){depth=parseInt(specifier,10);if(isNaN(depth)){handleError("PatternLayout.format: invalid specifier '"+specifier+"' for conversion character '"+conversionCharacter+"' - should be a number");depth=0}}var messages=conversionCharacter==="a"?loggingEvent.messages[0]:loggingEvent.messages;for(i=0,len=messages.length;i<len;i++){if(depth===0){Arrays.push(replacementParts,messages[i])}else{Arrays.push(replacementParts,formatObjectExpansion(messages[i],depth,"",false,true,true))}}replacement=replacementParts.join(" ");break;case"c":var loggerName=loggingEvent.logger.name;if(specifier){var precision=parseInt(specifier,10);var loggerNameBits=loggingEvent.logger.name.split(".");if(precision>=loggerNameBits.length){replacement=loggerName}else{replacement=loggerNameBits.slice(loggerNameBits.length-precision).join(".")}}else{replacement=loggerName}break;case"d":var dateFormat=PatternLayout.ISO8601_DATEFORMAT;if(specifier){dateFormat=specifier;if(dateFormat=="ISO8601"){dateFormat=PatternLayout.ISO8601_DATEFORMAT}else if(dateFormat=="ABSOLUTE"){dateFormat=PatternLayout.ABSOLUTETIME_DATEFORMAT}else if(dateFormat=="DATE"){dateFormat=PatternLayout.DATETIME_DATEFORMAT}}replacement=new SimpleDateFormat(dateFormat).format(loggingEvent.timeStamp);break;case"f":if(this.hasCustomFields()){var fieldIndex=0;if(specifier){fieldIndex=parseInt(specifier,10);if(isNaN(fieldIndex)){handleError("PatternLayout.format: invalid specifier '"+specifier+"' for conversion character 'f' - should be a number")}else if(fieldIndex===0){handleError("PatternLayout.format: invalid specifier '"+specifier+"' for conversion character 'f' - must be greater than zero")}else if(fieldIndex>this.customFields.length){handleError("PatternLayout.format: invalid specifier '"+specifier+"' for conversion character 'f' - there aren't that many custom fields")}else{fieldIndex=fieldIndex-1}}replacement=this.customFields[fieldIndex].value}break;case"n":replacement=newLine;break;case"p":replacement=loggingEvent.level.name;break;case"r":replacement=""+(loggingEvent.timeStamp-applicationStartDate);break;case"%":replacement="%";break;default:replacement=matchedString;break}if(truncation){l=parseInt(truncation.substr(1),10);var strLen=replacement.length;if(l<strLen){replacement=replacement.substring(strLen-l,strLen)}}if(padding){if(padding.charAt(0)=="-"){l=parseInt(padding.substr(1),10);replacementLen=replacement.length;if(replacementLen<l){replacement=rightPad(replacement,l-replacementLen," ")}}else{l=parseInt(padding,10);replacementLen=replacement.length;while(replacement.length<l){replacement=leftPad(replacement,l-replacementLen," ")}}}Arrays.push(parts,replacement)}searchString=searchString.substr(result.index+result[0].length)}return parts.join("")};PatternLayout.prototype.ignoresThrowable=function(){return true};PatternLayout.prototype.toString=function(){return"PatternLayout"};log4javascript.PatternLayout=PatternLayout;function AlertAppender(){}AlertAppender.prototype=new Appender;AlertAppender.prototype.layout=new SimpleLayout;AlertAppender.prototype.append=function(loggingEvent){var formattedMessage=this.getLayout().format(loggingEvent);if(this.getLayout().ignoresThrowable()){formattedMessage+=loggingEvent.getThrowableStrRep()}alert(formattedMessage)};AlertAppender.prototype.toString=function(){return"AlertAppender"};log4javascript.AlertAppender=AlertAppender;function BrowserConsoleAppender(){}BrowserConsoleAppender.prototype=new log4javascript.Appender;BrowserConsoleAppender.prototype.layout=new NullLayout;BrowserConsoleAppender.prototype.threshold=Level.DEBUG;BrowserConsoleAppender.prototype.append=function(loggingEvent){var appender=this;var formattedMesage,console;var getFormattedMessage=function(){var layout=appender.getLayout();var formattedMessage=layout.format(loggingEvent);if(layout.ignoresThrowable()&&loggingEvent.exception){formattedMessage+=loggingEvent.getThrowableStrRep()}return formattedMessage};if(typeof window.opera!="undefined"&&window.opera.postError){window.opera.postError(getFormattedMessage())}else if(window.console&&window.log){console=window.console;formattedMesage=getFormattedMessage();if(console.debug&&Level.DEBUG.isGreaterOrEqual(loggingEvent.level)){console.debug(formattedMesage)}else if(console.info&&Level.INFO.equals(loggingEvent.level)){console.info(formattedMesage)}else if(console.warn&&Level.WARN.equals(loggingEvent.level)){console.warn(formattedMesage)}else if(console.error&&loggingEvent.level.isGreaterOrEqual(Level.ERROR)){console.error(formattedMesage)}else{log(formattedMesage)}}};BrowserConsoleAppender.prototype.group=function(name){if(window.console&&window.console.group){window.console.group(name)}};BrowserConsoleAppender.prototype.groupEnd=function(){if(window.console&&window.console.groupEnd){window.console.groupEnd()}};BrowserConsoleAppender.prototype.toString=function(){return"BrowserConsoleAppender"};log4javascript.BrowserConsoleAppender=BrowserConsoleAppender;var xmlHttpFactories=[function(){return new XMLHttpRequest},function(){return new ActiveXObject("Msxml2.XMLHTTP")},function(){return new ActiveXObject("Microsoft.XMLHTTP")}];var getXmlHttp=function(errorHandler){var xmlHttp=null,factory;for(var i=0,len=xmlHttpFactories.length;i<len;i++){factory=xmlHttpFactories[i];try{xmlHttp=factory();getXmlHttp=factory;return xmlHttp}catch(e){}}if(errorHandler){errorHandler()}else{handleError("getXmlHttp: unable to obtain XMLHttpRequest object")}};function isHttpRequestSuccessful(xmlHttp){return isUndefined(xmlHttp.status)||xmlHttp.status===0||xmlHttp.status>=200&&xmlHttp.status<300}function AjaxAppender(url){var appender=this;var isSupported=true;if(!url){handleError("AjaxAppender: URL must be specified in constructor");isSupported=false}var timed=this.defaults.timed;var waitForResponse=this.defaults.waitForResponse;var batchSize=this.defaults.batchSize;var timerInterval=this.defaults.timerInterval;var requestSuccessCallback=this.defaults.requestSuccessCallback;var failCallback=this.defaults.failCallback;var postVarName=this.defaults.postVarName;var sendAllOnUnload=this.defaults.sendAllOnUnload;var sessionId=null;var queuedLoggingEvents=[];var queuedRequests=[];var sending=false;var initialized=false;function checkCanConfigure(configOptionName){if(initialized){handleError("AjaxAppender: configuration option '"+configOptionName+"' may not be set after the appender has been initialized");return false}return true}this.getSessionId=function(){return sessionId};this.setSessionId=function(sessionIdParam){sessionId=extractStringFromParam(sessionIdParam,null);this.layout.setCustomField("sessionid",sessionId)};this.setLayout=function(layoutParam){if(checkCanConfigure("layout")){this.layout=layoutParam;if(sessionId!==null){this.setSessionId(sessionId)}}};this.isTimed=function(){return timed};this.setTimed=function(timedParam){if(checkCanConfigure("timed")){timed=bool(timedParam)}};this.getTimerInterval=function(){return timerInterval};this.setTimerInterval=function(timerIntervalParam){if(checkCanConfigure("timerInterval")){timerInterval=extractIntFromParam(timerIntervalParam,timerInterval)}};this.isWaitForResponse=function(){return waitForResponse};this.setWaitForResponse=function(waitForResponseParam){if(checkCanConfigure("waitForResponse")){waitForResponse=bool(waitForResponseParam)}};this.getBatchSize=function(){return batchSize};this.setBatchSize=function(batchSizeParam){if(checkCanConfigure("batchSize")){batchSize=extractIntFromParam(batchSizeParam,batchSize)}};this.isSendAllOnUnload=function(){return sendAllOnUnload};this.setSendAllOnUnload=function(sendAllOnUnloadParam){if(checkCanConfigure("sendAllOnUnload")){sendAllOnUnload=extractIntFromParam(sendAllOnUnloadParam,sendAllOnUnload)}};this.setRequestSuccessCallback=function(requestSuccessCallbackParam){requestSuccessCallback=extractFunctionFromParam(requestSuccessCallbackParam,requestSuccessCallback)};this.setFailCallback=function(failCallbackParam){failCallback=extractFunctionFromParam(failCallbackParam,failCallback)};this.getPostVarName=function(){return postVarName};this.setPostVarName=function(postVarNameParam){if(checkCanConfigure("postVarName")){postVarName=extractStringFromParam(postVarNameParam,postVarName)}};function sendAll(){if(isSupported&&enabled){sending=true;var currentRequestBatch;if(waitForResponse){if(queuedRequests.length>0){currentRequestBatch=Arrays.shift(queuedRequests);sendRequest(preparePostData(currentRequestBatch),sendAll)}else{sending=false;if(timed){scheduleSending()}}}else{while(currentRequestBatch=Arrays.shift(queuedRequests)){sendRequest(preparePostData(currentRequestBatch))}sending=false;if(timed){scheduleSending()}}}}this.sendAll=sendAll;function sendAllRemaining(){if(isSupported&&enabled){var actualBatchSize=appender.getLayout().allowBatching()?batchSize:1;var currentLoggingEvent;var postData="";var batchedLoggingEvents=[];while(currentLoggingEvent=Arrays.shift(queuedLoggingEvents)){Arrays.push(batchedLoggingEvents,currentLoggingEvent);if(queuedLoggingEvents.length>=actualBatchSize){Arrays.push(queuedRequests,batchedLoggingEvents);batchedLoggingEvents=[]}}if(batchedLoggingEvents.length>0){Arrays.push(queuedRequests,batchedLoggingEvents)}waitForResponse=false;timed=false;sendAll()}}function preparePostData(batchedLoggingEvents){var formattedMessages=[];var currentLoggingEvent;var postData="";while(currentLoggingEvent=Arrays.shift(batchedLoggingEvents)){var currentFormattedMessage=appender.getLayout().format(currentLoggingEvent);if(appender.getLayout().ignoresThrowable()){currentFormattedMessage+=loggingEvent.getThrowableStrRep()}Arrays.push(formattedMessages,currentFormattedMessage)}if(batchedLoggingEvents.length==1){postData=formattedMessages.join("")}else{postData=appender.getLayout().batchHeader+formattedMessages.join(appender.getLayout().batchSeparator)+appender.getLayout().batchFooter}postData=appender.getLayout().returnsPostData?postData:urlEncode(postVarName)+"="+urlEncode(postData);if(postData.length>0){postData+="&"}return postData+"layout="+urlEncode(appender.getLayout().toString())}function scheduleSending(){setTimeout(sendAll,timerInterval)}function xmlHttpErrorHandler(){var msg="AjaxAppender: could not create XMLHttpRequest object. AjaxAppender disabled";handleError(msg);isSupported=false;if(failCallback){failCallback(msg)}}function sendRequest(postData,successCallback){try{var xmlHttp=getXmlHttp(xmlHttpErrorHandler);if(isSupported){if(xmlHttp.overrideMimeType){xmlHttp.overrideMimeType(appender.getLayout().getContentType())}xmlHttp.onreadystatechange=function(){if(xmlHttp.readyState==4){if(isHttpRequestSuccessful(xmlHttp)){if(requestSuccessCallback){requestSuccessCallback(xmlHttp)}if(successCallback){successCallback(xmlHttp)}}else{var msg="AjaxAppender.append: XMLHttpRequest request to URL "+url+" returned status code "+xmlHttp.status;handleError(msg);if(failCallback){failCallback(msg)}}xmlHttp.onreadystatechange=emptyFunction;xmlHttp=null}};xmlHttp.open("POST",url,true);try{xmlHttp.setRequestHeader("Content-Type","application/x-www-form-urlencoded")}catch(headerEx){var msg="AjaxAppender.append: your browser's XMLHttpRequest implementation"+" does not support setRequestHeader, therefore cannot post data. AjaxAppender disabled";handleError(msg);isSupported=false;if(failCallback){failCallback(msg)}return}xmlHttp.send(postData)}}catch(ex){var errMsg="AjaxAppender.append: error sending log message to "+url;handleError(errMsg,ex);isSupported=false;if(failCallback){failCallback(errMsg+". Details: "+getExceptionStringRep(ex))}}}this.append=function(loggingEvent){if(isSupported){if(!initialized){init()}Arrays.push(queuedLoggingEvents,loggingEvent);var actualBatchSize=this.getLayout().allowBatching()?batchSize:1;if(queuedLoggingEvents.length>=actualBatchSize){var currentLoggingEvent;var batchedLoggingEvents=[];while(currentLoggingEvent=Arrays.shift(queuedLoggingEvents)){Arrays.push(batchedLoggingEvents,currentLoggingEvent)}Arrays.push(queuedRequests,batchedLoggingEvents);if(!timed&&(!waitForResponse||waitForResponse&&!sending)){sendAll()}}}};function init(){initialized=true;if(sendAllOnUnload){addEvent(window,"unload",sendAllRemaining)}if(timed){scheduleSending()}}}AjaxAppender.prototype=new Appender;AjaxAppender.prototype.defaults={waitForResponse:false,timed:false,timerInterval:1e3,batchSize:1,sendAllOnUnload:true,requestSuccessCallback:null,failCallback:null,postVarName:"data"};AjaxAppender.prototype.layout=new HttpPostDataLayout;AjaxAppender.prototype.toString=function(){return"AjaxAppender"};log4javascript.AjaxAppender=AjaxAppender;function setCookie(name,value,days,path){var expires;path=path?"; path="+path:"";if(days){var date=new Date;date.setTime(date.getTime()+days*24*60*60*1e3);expires="; expires="+date.toGMTString()}else{expires=""}document.cookie=escape(name)+"="+escape(value)+expires+path}function getCookie(name){var nameEquals=escape(name)+"=";var ca=document.cookie.split(";");for(var i=0,len=ca.length;i<len;i++){var c=ca[i];while(c.charAt(0)===" "){c=c.substring(1,c.length)}if(c.indexOf(nameEquals)===0){return unescape(c.substring(nameEquals.length,c.length))}}return null}function getBaseUrl(){var scripts=document.getElementsByTagName("script");for(var i=0,len=scripts.length;i<len;++i){if(scripts[i].src.indexOf("log4javascript")!=-1){var lastSlash=scripts[i].src.lastIndexOf("/");return lastSlash==-1?"":scripts[i].src.substr(0,lastSlash+1)}}return null}function isLoaded(win){try{return bool(win.loaded)}catch(ex){return false}}var ConsoleAppender;(function(){var getConsoleHtmlLines=function(){return['<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "'+'http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">','<html xmlns="http://www.w3.org/1999/xhtml" lang="en" xml:lang="en">',"	<head>","		<title>log4javascript</title>",'		<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />',"		<!-- Make IE8 behave like IE7, having gone to all the trouble of making IE work -->",'		<meta http-equiv="X-UA-Compatible" content="IE=7" />','		<script type="text/javascript">var isIe = false, isIePre7 = false;</script>','		<!--[if IE]><script type="text/javascript">isIe = true</script><![endif]-->','		<!--[if lt IE 7]><script type="text/javascript">isIePre7 = true</script><![endif]-->','		<script type="text/javascript">',"			//<![CDATA[","			var loggingEnabled = true;","			var logQueuedEventsTimer = null;","			var logEntries = [];","			var logEntriesAndSeparators = [];","			var logItems = [];","			var renderDelay = 100;","			var unrenderedLogItemsExist = false;","			var rootGroup, currentGroup = null;","			var loaded = false;","			var currentLogItem = null;","			var logMainContainer;","","			function extend(obj, props) {","				for (var i in props) {","					obj[i] = props[i];","				}","			}","","			/* ---------------------------------------------------------------------- */","			// Array-related stuff, the first two for the sole benefit of IE5","		","			var Arrays = {","				// This restricts push to a single value, but that's all that's needed","				push: Boolean(Array.prototype.push) ?","					function(arr, val) {","						return arr.push(val);","					} :","					function(arr, val) {","						arr[arr.length] = val;","						return arr.length;","					},","","				pop: Boolean(Array.prototype.pop) ?","					function(arr) {","						return arr.pop();","					} :","					function(arr) {","						if (arr.length > 0) {","							var val = arr[arr.length - 1];","							arr.length = arr.length - 1;","							return val;","						}","					},","","				remove: function(arr, val) {","					var index = -1;","					for (var i = 0, len = arr.length; i < len; i++) {","						if (arr[i] === val) {","							index = i;","							break;","						}","					}","					if (index >= 0) {","						if (arr.splice) {","							arr.splice(index, 1);","						} else {","							if (index == arr.length - 1) {","								arr.length = arr.length - 1;","							} else {","								var itemsToAdd = arr.slice(index + 1);","								arr.length = index;","								for (i = 0, len = itemsToAdd.length; i < len; i++) {","									Arrays.push(arr, itemsToAdd[i]);","								}","							}","						}","						return true;","					} else {","						return false;","					}","				},","","				removeFromStart: function(arr, numberToRemove) {","					if (Array.prototype.splice) {","						arr.splice(0, numberToRemove);","					} else {","						for (var i = numberToRemove, len = arr.length; i < len; i++) {","							arr[i - numberToRemove] = arr[i];","						}","						arr.length = arr.length - numberToRemove;","					}","					return arr;","				},","","				contains: function(arr, val) {","					for (var i = 0, len = arr.length; i < len; i++) {","						if (arr[i] === val) {","							return true;","						}","					}","					return false;","				}","			};","","			/*----------------------------------------------------------------*/","","			function LogItem() {","			}","","			LogItem.prototype = {","				mainContainer: null,","				wrappedContainer: null,","				unwrappedContainer: null,","				group: null,","","				appendToLog: function() {","					for (var i = 0, len = this.elementContainers.length; i < len; i++) {","						this.elementContainers[i].appendToLog();","					}","					this.group.update();","				},","","				doRemove: function(doUpdate, removeFromGroup) {","					if (this.rendered) {","						for (var i = 0, len = this.elementContainers.length; i < len; i++) {","							this.elementContainers[i].remove();","						}","						this.unwrappedElementContainer = null;","						this.wrappedElementContainer = null;","						this.mainElementContainer = null;","					}","					if (this.group && removeFromGroup) {","						this.group.removeChild(this, doUpdate);","					}","					if (this === currentLogItem) {","						currentLogItem = null;","					}","				},","","				remove: function(doUpdate, removeFromGroup) {","					this.doRemove(doUpdate, removeFromGroup);","				},","","				render: function() {},","","				accept: function(visitor) {","					visitor.visit(this);","				},","","				getUnwrappedDomContainer: function() {","					return this.group.unwrappedElementContainer.contentDiv;","				},","","				getWrappedDomContainer: function() {","					return this.group.wrappedElementContainer.contentDiv;","				},","","				getMainDomContainer: function() {","					return this.group.mainElementContainer.contentDiv;","				}","			};","","			LogItem.serializedItemKeys = {LOG_ENTRY: 0, GROUP_START: 1, GROUP_END: 2};","","			/*----------------------------------------------------------------*/","","			function LogItemContainerElement() {","			}","","			LogItemContainerElement.prototype = {","				appendToLog: function() {","					var insertBeforeFirst = (newestAtTop && this.containerDomNode.hasChildNodes());","					if (insertBeforeFirst) {","						this.containerDomNode.insertBefore(this.mainDiv, this.containerDomNode.firstChild);","					} else {","						this.containerDomNode.appendChild(this.mainDiv);","					}","				}","			};","","			/*----------------------------------------------------------------*/","","			function SeparatorElementContainer(containerDomNode) {","				this.containerDomNode = containerDomNode;",'				this.mainDiv = document.createElement("div");','				this.mainDiv.className = "separator";','				this.mainDiv.innerHTML = "&nbsp;";',"			}","","			SeparatorElementContainer.prototype = new LogItemContainerElement();","","			SeparatorElementContainer.prototype.remove = function() {","				this.mainDiv.parentNode.removeChild(this.mainDiv);","				this.mainDiv = null;","			};","","			/*----------------------------------------------------------------*/","","			function Separator() {","				this.rendered = false;","			}","","			Separator.prototype = new LogItem();","","			extend(Separator.prototype, {","				render: function() {","					var containerDomNode = this.group.contentDiv;","					if (isIe) {","						this.unwrappedElementContainer = new SeparatorElementContainer(this.getUnwrappedDomContainer());","						this.wrappedElementContainer = new SeparatorElementContainer(this.getWrappedDomContainer());","						this.elementContainers = [this.unwrappedElementContainer, this.wrappedElementContainer];","					} else {","						this.mainElementContainer = new SeparatorElementContainer(this.getMainDomContainer());","						this.elementContainers = [this.mainElementContainer];","					}","					this.content = this.formattedMessage;","					this.rendered = true;","				}","			});","","			/*----------------------------------------------------------------*/","","			function GroupElementContainer(group, containerDomNode, isRoot, isWrapped) {","				this.group = group;","				this.containerDomNode = containerDomNode;","				this.isRoot = isRoot;","				this.isWrapped = isWrapped;","				this.expandable = false;","","				if (this.isRoot) {","					if (isIe) {",'						this.contentDiv = logMainContainer.appendChild(document.createElement("div"));','						this.contentDiv.id = this.isWrapped ? "log_wrapped" : "log_unwrapped";',"					} else {","						this.contentDiv = logMainContainer;","					}","				} else {","					var groupElementContainer = this;","					",'					this.mainDiv = document.createElement("div");','					this.mainDiv.className = "group";',"",'					this.headingDiv = this.mainDiv.appendChild(document.createElement("div"));','					this.headingDiv.className = "groupheading";',"",'					this.expander = this.headingDiv.appendChild(document.createElement("span"));','					this.expander.className = "expander unselectable greyedout";',"					this.expander.unselectable = true;",'					var expanderText = this.group.expanded ? "-" : "+";',"					this.expanderTextNode = this.expander.appendChild(document.createTextNode(expanderText));","					",'					this.headingDiv.appendChild(document.createTextNode(" " + this.group.name));',"",'					this.contentDiv = this.mainDiv.appendChild(document.createElement("div"));','					var contentCssClass = this.group.expanded ? "expanded" : "collapsed";','					this.contentDiv.className = "groupcontent " + contentCssClass;',"","					this.expander.onclick = function() {","						if (groupElementContainer.group.expandable) {","							groupElementContainer.group.toggleExpanded();","						}","					};","				}","			}","","			GroupElementContainer.prototype = new LogItemContainerElement();","","			extend(GroupElementContainer.prototype, {","				toggleExpanded: function() {","					if (!this.isRoot) {","						var oldCssClass, newCssClass, expanderText;","						if (this.group.expanded) {",'							newCssClass = "expanded";','							oldCssClass = "collapsed";','							expanderText = "-";',"						} else {",'							newCssClass = "collapsed";','							oldCssClass = "expanded";','							expanderText = "+";',"						}","						replaceClass(this.contentDiv, newCssClass, oldCssClass);","						this.expanderTextNode.nodeValue = expanderText;","					}","				},","","				remove: function() {","					if (!this.isRoot) {","						this.headingDiv = null;","						this.expander.onclick = null;","						this.expander = null;","						this.expanderTextNode = null;","						this.contentDiv = null;","						this.containerDomNode = null;","						this.mainDiv.parentNode.removeChild(this.mainDiv);","						this.mainDiv = null;","					}","				},","","				reverseChildren: function() {","					// Invert the order of the log entries","					var node = null;","","					// Remove all the log container nodes","					var childDomNodes = [];","					while ((node = this.contentDiv.firstChild)) {","						this.contentDiv.removeChild(node);","						Arrays.push(childDomNodes, node);","					}","","					// Put them all back in reverse order","					while ((node = Arrays.pop(childDomNodes))) {","						this.contentDiv.appendChild(node);","					}","				},","","				update: function() {","					if (!this.isRoot) {","						if (this.group.expandable) {",'							removeClass(this.expander, "greyedout");',"						} else {",'							addClass(this.expander, "greyedout");',"						}","					}","				},","","				clear: function() {","					if (this.isRoot) {",'						this.contentDiv.innerHTML = "";',"					}","				}","			});","","			/*----------------------------------------------------------------*/","","			function Group(name, isRoot, initiallyExpanded) {","				this.name = name;","				this.group = null;","				this.isRoot = isRoot;","				this.initiallyExpanded = initiallyExpanded;","				this.elementContainers = [];","				this.children = [];","				this.expanded = initiallyExpanded;","				this.rendered = false;","				this.expandable = false;","			}","","			Group.prototype = new LogItem();","","			extend(Group.prototype, {","				addChild: function(logItem) {","					Arrays.push(this.children, logItem);","					logItem.group = this;","				},","","				render: function() {","					if (isIe) {","						var unwrappedDomContainer, wrappedDomContainer;","						if (this.isRoot) {","							unwrappedDomContainer = logMainContainer;","							wrappedDomContainer = logMainContainer;","						} else {","							unwrappedDomContainer = this.getUnwrappedDomContainer();","							wrappedDomContainer = this.getWrappedDomContainer();","						}","						this.unwrappedElementContainer = new GroupElementContainer(this, unwrappedDomContainer, this.isRoot, false);","						this.wrappedElementContainer = new GroupElementContainer(this, wrappedDomContainer, this.isRoot, true);","						this.elementContainers = [this.unwrappedElementContainer, this.wrappedElementContainer];","					} else {","						var mainDomContainer = this.isRoot ? logMainContainer : this.getMainDomContainer();","						this.mainElementContainer = new GroupElementContainer(this, mainDomContainer, this.isRoot, false);","						this.elementContainers = [this.mainElementContainer];","					}","					this.rendered = true;","				},","","				toggleExpanded: function() {","					this.expanded = !this.expanded;","					for (var i = 0, len = this.elementContainers.length; i < len; i++) {","						this.elementContainers[i].toggleExpanded();","					}","				},","","				expand: function() {","					if (!this.expanded) {","						this.toggleExpanded();","					}","				},","","				accept: function(visitor) {","					visitor.visitGroup(this);","				},","","				reverseChildren: function() {","					if (this.rendered) {","						for (var i = 0, len = this.elementContainers.length; i < len; i++) {","							this.elementContainers[i].reverseChildren();","						}","					}","				},","","				update: function() {","					var previouslyExpandable = this.expandable;","					this.expandable = (this.children.length !== 0);","					if (this.expandable !== previouslyExpandable) {","						for (var i = 0, len = this.elementContainers.length; i < len; i++) {","							this.elementContainers[i].update();","						}","					}","				},","","				flatten: function() {","					var visitor = new GroupFlattener();","					this.accept(visitor);","					return visitor.logEntriesAndSeparators;","				},","","				removeChild: function(child, doUpdate) {","					Arrays.remove(this.children, child);","					child.group = null;","					if (doUpdate) {","						this.update();","					}","				},","","				remove: function(doUpdate, removeFromGroup) {","					for (var i = 0, len = this.children.length; i < len; i++) {","						this.children[i].remove(false, false);","					}","					this.children = [];","					this.update();","					if (this === currentGroup) {","						currentGroup = this.group;","					}","					this.doRemove(doUpdate, removeFromGroup);","				},","","				serialize: function(items) {","					Arrays.push(items, [LogItem.serializedItemKeys.GROUP_START, this.name]);","					for (var i = 0, len = this.children.length; i < len; i++) {","						this.children[i].serialize(items);","					}","					if (this !== currentGroup) {","						Arrays.push(items, [LogItem.serializedItemKeys.GROUP_END]);","					}","				},","","				clear: function() {","					for (var i = 0, len = this.elementContainers.length; i < len; i++) {","						this.elementContainers[i].clear();","					}","				}","			});","","			/*----------------------------------------------------------------*/","","			function LogEntryElementContainer() {","			}","","			LogEntryElementContainer.prototype = new LogItemContainerElement();","","			extend(LogEntryElementContainer.prototype, {","				remove: function() {","					this.doRemove();","				},","","				doRemove: function() {","					this.mainDiv.parentNode.removeChild(this.mainDiv);","					this.mainDiv = null;","					this.contentElement = null;","					this.containerDomNode = null;","				},","","				setContent: function(content, wrappedContent) {","					if (content === this.formattedMessage) {",'						this.contentElement.innerHTML = "";',"						this.contentElement.appendChild(document.createTextNode(this.formattedMessage));","					} else {","						this.contentElement.innerHTML = content;","					}","				},","","				setSearchMatch: function(isMatch) {",'					var oldCssClass = isMatch ? "searchnonmatch" : "searchmatch";','					var newCssClass = isMatch ? "searchmatch" : "searchnonmatch";',"					replaceClass(this.mainDiv, newCssClass, oldCssClass);","				},","","				clearSearch: function() {",'					removeClass(this.mainDiv, "searchmatch");','					removeClass(this.mainDiv, "searchnonmatch");',"				}","			});","","			/*----------------------------------------------------------------*/","","			function LogEntryWrappedElementContainer(logEntry, containerDomNode) {","				this.logEntry = logEntry;","				this.containerDomNode = containerDomNode;",'				this.mainDiv = document.createElement("div");',"				this.mainDiv.appendChild(document.createTextNode(this.logEntry.formattedMessage));",'				this.mainDiv.className = "logentry wrapped " + this.logEntry.level;',"				this.contentElement = this.mainDiv;","			}","","			LogEntryWrappedElementContainer.prototype = new LogEntryElementContainer();","","			LogEntryWrappedElementContainer.prototype.setContent = function(content, wrappedContent) {","				if (content === this.formattedMessage) {",'					this.contentElement.innerHTML = "";',"					this.contentElement.appendChild(document.createTextNode(this.formattedMessage));","				} else {","					this.contentElement.innerHTML = wrappedContent;","				}","			};","","			/*----------------------------------------------------------------*/","","			function LogEntryUnwrappedElementContainer(logEntry, containerDomNode) {","				this.logEntry = logEntry;","				this.containerDomNode = containerDomNode;",'				this.mainDiv = document.createElement("div");','				this.mainDiv.className = "logentry unwrapped " + this.logEntry.level;','				this.pre = this.mainDiv.appendChild(document.createElement("pre"));',"				this.pre.appendChild(document.createTextNode(this.logEntry.formattedMessage));",'				this.pre.className = "unwrapped";',"				this.contentElement = this.pre;","			}","","			LogEntryUnwrappedElementContainer.prototype = new LogEntryElementContainer();","","			LogEntryUnwrappedElementContainer.prototype.remove = function() {","				this.doRemove();","				this.pre = null;","			};","","			/*----------------------------------------------------------------*/","","			function LogEntryMainElementContainer(logEntry, containerDomNode) {","				this.logEntry = logEntry;","				this.containerDomNode = containerDomNode;",'				this.mainDiv = document.createElement("div");','				this.mainDiv.className = "logentry nonielogentry " + this.logEntry.level;','				this.contentElement = this.mainDiv.appendChild(document.createElement("span"));',"				this.contentElement.appendChild(document.createTextNode(this.logEntry.formattedMessage));","			}","","			LogEntryMainElementContainer.prototype = new LogEntryElementContainer();","","			/*----------------------------------------------------------------*/","","			function LogEntry(level, formattedMessage) {","				this.level = level;","				this.formattedMessage = formattedMessage;","				this.rendered = false;","			}","","			LogEntry.prototype = new LogItem();","","			extend(LogEntry.prototype, {","				render: function() {","					var logEntry = this;","					var containerDomNode = this.group.contentDiv;","","					// Support for the CSS attribute white-space in IE for Windows is","					// non-existent pre version 6 and slightly odd in 6, so instead","					// use two different HTML elements","					if (isIe) {",'						this.formattedMessage = this.formattedMessage.replace(/\\r\\n/g, "\\r"); // Workaround for IE\'s treatment of white space',"						this.unwrappedElementContainer = new LogEntryUnwrappedElementContainer(this, this.getUnwrappedDomContainer());","						this.wrappedElementContainer = new LogEntryWrappedElementContainer(this, this.getWrappedDomContainer());","						this.elementContainers = [this.unwrappedElementContainer, this.wrappedElementContainer];","					} else {","						this.mainElementContainer = new LogEntryMainElementContainer(this, this.getMainDomContainer());","						this.elementContainers = [this.mainElementContainer];","					}","					this.content = this.formattedMessage;","					this.rendered = true;","				},","","				setContent: function(content, wrappedContent) {","					if (content != this.content) {","						if (isIe && (content !== this.formattedMessage)) {",'							content = content.replace(/\\r\\n/g, "\\r"); // Workaround for IE\'s treatment of white space',"						}","						for (var i = 0, len = this.elementContainers.length; i < len; i++) {","							this.elementContainers[i].setContent(content, wrappedContent);","						}","						this.content = content;","					}","				},","","				getSearchMatches: function() {","					var matches = [];","					var i, len;","					if (isIe) {",'						var unwrappedEls = getElementsByClass(this.unwrappedElementContainer.mainDiv, "searchterm", "span");','						var wrappedEls = getElementsByClass(this.wrappedElementContainer.mainDiv, "searchterm", "span");',"						for (i = 0, len = unwrappedEls.length; i < len; i++) {","							matches[i] = new Match(this.level, null, unwrappedEls[i], wrappedEls[i]);","						}","					} else {",'						var els = getElementsByClass(this.mainElementContainer.mainDiv, "searchterm", "span");',"						for (i = 0, len = els.length; i < len; i++) {","							matches[i] = new Match(this.level, els[i]);","						}","					}","					return matches;","				},","","				setSearchMatch: function(isMatch) {","					for (var i = 0, len = this.elementContainers.length; i < len; i++) {","						this.elementContainers[i].setSearchMatch(isMatch);","					}","				},","","				clearSearch: function() {","					for (var i = 0, len = this.elementContainers.length; i < len; i++) {","						this.elementContainers[i].clearSearch();","					}","				},","","				accept: function(visitor) {","					visitor.visitLogEntry(this);","				},","","				serialize: function(items) {","					Arrays.push(items, [LogItem.serializedItemKeys.LOG_ENTRY, this.level, this.formattedMessage]);","				}","			});","","			/*----------------------------------------------------------------*/","","			function LogItemVisitor() {","			}","","			LogItemVisitor.prototype = {","				visit: function(logItem) {","				},","","				visitParent: function(logItem) {","					if (logItem.group) {","						logItem.group.accept(this);","					}","				},","","				visitChildren: function(logItem) {","					for (var i = 0, len = logItem.children.length; i < len; i++) {","						logItem.children[i].accept(this);","					}","				},","","				visitLogEntry: function(logEntry) {","					this.visit(logEntry);","				},","","				visitSeparator: function(separator) {","					this.visit(separator);","				},","","				visitGroup: function(group) {","					this.visit(group);","				}","			};","","			/*----------------------------------------------------------------*/","","			function GroupFlattener() {","				this.logEntriesAndSeparators = [];","			}","","			GroupFlattener.prototype = new LogItemVisitor();","","			GroupFlattener.prototype.visitGroup = function(group) {","				this.visitChildren(group);","			};","","			GroupFlattener.prototype.visitLogEntry = function(logEntry) {","				Arrays.push(this.logEntriesAndSeparators, logEntry);","			};","","			GroupFlattener.prototype.visitSeparator = function(separator) {","				Arrays.push(this.logEntriesAndSeparators, separator);","			};","","			/*----------------------------------------------------------------*/","","			window.onload = function() {","				// Sort out document.domain","				if (location.search) {",'					var queryBits = unescape(location.search).substr(1).split("&"), nameValueBits;',"					for (var i = 0, len = queryBits.length; i < len; i++) {",'						nameValueBits = queryBits[i].split("=");','						if (nameValueBits[0] == "log4javascript_domain") {',"							document.domain = nameValueBits[1];","							break;","						}","					}","				}","","				// Create DOM objects",'				logMainContainer = $("log");',"				if (isIePre7) {",'					addClass(logMainContainer, "oldIe");',"				}","",'				rootGroup = new Group("root", true);',"				rootGroup.render();","				currentGroup = rootGroup;","				","				setCommandInputWidth();","				setLogContainerHeight();","				toggleLoggingEnabled();","				toggleSearchEnabled();","				toggleSearchFilter();","				toggleSearchHighlight();","				applyFilters();","				checkAllLevels();","				toggleWrap();","				toggleNewestAtTop();","				toggleScrollToLatest();","				renderQueuedLogItems();","				loaded = true;",'				$("command").value = "";','				$("command").autocomplete = "off";','				$("command").onkeydown = function(evt) {',"					evt = getEvent(evt);","					if (evt.keyCode == 10 || evt.keyCode == 13) { // Return/Enter","						evalCommandLine();","						stopPropagation(evt);","					//} else if (evt.keyCode == 9) { // Tab",'					//	this.value = "";',"					//	this.focus();","					} else if (evt.keyCode == 27) { // Escape",'						this.value = "";',"						this.focus();","					} else if (evt.keyCode == 38 && commandHistory.length > 0) { // Up","						currentCommandIndex = Math.max(0, currentCommandIndex - 1);","						this.value = commandHistory[currentCommandIndex];","						moveCaretToEnd(this);","					} else if (evt.keyCode == 40 && commandHistory.length > 0) { // Down","						currentCommandIndex = Math.min(commandHistory.length - 1, currentCommandIndex + 1);","						this.value = commandHistory[currentCommandIndex];","						moveCaretToEnd(this);","					}","				};","","				// Prevent the keypress moving the caret in Firefox",'				$("command").onkeypress = function(evt) {',"					evt = getEvent(evt);","					if (evt.keyCode == 38 && commandHistory.length > 0 && evt.preventDefault) { // Up","						evt.preventDefault();","					}","				};","","				// Prevent the keyup event blurring the input in Opera",'				$("command").onkeyup = function(evt) {',"					evt = getEvent(evt);","					if (evt.keyCode == 27 && evt.preventDefault) { // Up","						evt.preventDefault();","						this.focus();","					}","				};","","				// Add document keyboard shortcuts","				document.onkeydown = function keyEventHandler(evt) {","					evt = getEvent(evt);","					switch (evt.keyCode) {","						case 69: // Ctrl + shift + E: re-execute last command","							if (evt.shiftKey && (evt.ctrlKey || evt.metaKey)) {","								evalLastCommand();","								cancelKeyEvent(evt);","								return false;","							}","							break;","						case 75: // Ctrl + shift + K: focus search","							if (evt.shiftKey && (evt.ctrlKey || evt.metaKey)) {","								focusSearch();","								cancelKeyEvent(evt);","								return false;","							}","							break;","						case 40: // Ctrl + shift + down arrow: focus command line","						case 76: // Ctrl + shift + L: focus command line","							if (evt.shiftKey && (evt.ctrlKey || evt.metaKey)) {","								focusCommandLine();","								cancelKeyEvent(evt);","								return false;","							}","							break;","					}","				};","","				// Workaround to make sure log div starts at the correct size","				setTimeout(setLogContainerHeight, 20);","","				setShowCommandLine(showCommandLine);","				doSearch();","			};","","			window.onunload = function() {","				if (mainWindowExists()) {","					appender.unload();","				}","				appender = null;","			};","","			/*----------------------------------------------------------------*/","","			function toggleLoggingEnabled() {",'				setLoggingEnabled($("enableLogging").checked);',"			}","","			function setLoggingEnabled(enable) {","				loggingEnabled = enable;","			}","","			var appender = null;","","			function setAppender(appenderParam) {","				appender = appenderParam;","			}","","			function setShowCloseButton(showCloseButton) {",'				$("closeButton").style.display = showCloseButton ? "inline" : "none";',"			}","","			function setShowHideButton(showHideButton) {",'				$("hideButton").style.display = showHideButton ? "inline" : "none";',"			}","","			var newestAtTop = false;","","			/*----------------------------------------------------------------*/","","			function LogItemContentReverser() {","			}","			","			LogItemContentReverser.prototype = new LogItemVisitor();","			","			LogItemContentReverser.prototype.visitGroup = function(group) {","				group.reverseChildren();","				this.visitChildren(group);","			};","","			/*----------------------------------------------------------------*/","","			function setNewestAtTop(isNewestAtTop) {","				var oldNewestAtTop = newestAtTop;","				var i, iLen, j, jLen;","				newestAtTop = Boolean(isNewestAtTop);","				if (oldNewestAtTop != newestAtTop) {","					var visitor = new LogItemContentReverser();","					rootGroup.accept(visitor);","","					// Reassemble the matches array","					if (currentSearch) {","						var currentMatch = currentSearch.matches[currentMatchIndex];","						var matchIndex = 0;","						var matches = [];","						var actOnLogEntry = function(logEntry) {","							var logEntryMatches = logEntry.getSearchMatches();","							for (j = 0, jLen = logEntryMatches.length; j < jLen; j++) {","								matches[matchIndex] = logEntryMatches[j];","								if (currentMatch && logEntryMatches[j].equals(currentMatch)) {","									currentMatchIndex = matchIndex;","								}","								matchIndex++;","							}","						};","						if (newestAtTop) {","							for (i = logEntries.length - 1; i >= 0; i--) {","								actOnLogEntry(logEntries[i]);","							}","						} else {","							for (i = 0, iLen = logEntries.length; i < iLen; i++) {","								actOnLogEntry(logEntries[i]);","							}","						}","						currentSearch.matches = matches;","						if (currentMatch) {","							currentMatch.setCurrent();","						}","					} else if (scrollToLatest) {","						doScrollToLatest();","					}","				}",'				$("newestAtTop").checked = isNewestAtTop;',"			}","","			function toggleNewestAtTop() {",'				var isNewestAtTop = $("newestAtTop").checked;',"				setNewestAtTop(isNewestAtTop);","			}","","			var scrollToLatest = true;","","			function setScrollToLatest(isScrollToLatest) {","				scrollToLatest = isScrollToLatest;","				if (scrollToLatest) {","					doScrollToLatest();","				}",'				$("scrollToLatest").checked = isScrollToLatest;',"			}","","			function toggleScrollToLatest() {",'				var isScrollToLatest = $("scrollToLatest").checked;',"				setScrollToLatest(isScrollToLatest);","			}","","			function doScrollToLatest() {","				var l = logMainContainer;",'				if (typeof l.scrollTop != "undefined") {',"					if (newestAtTop) {","						l.scrollTop = 0;","					} else {","						var latestLogEntry = l.lastChild;","						if (latestLogEntry) {","							l.scrollTop = l.scrollHeight;","						}","					}","				}","			}","","			var closeIfOpenerCloses = true;","","			function setCloseIfOpenerCloses(isCloseIfOpenerCloses) {","				closeIfOpenerCloses = isCloseIfOpenerCloses;","			}","","			var maxMessages = null;","","			function setMaxMessages(max) {","				maxMessages = max;","				pruneLogEntries();","			}","","			var showCommandLine = false;","","			function setShowCommandLine(isShowCommandLine) {","				showCommandLine = isShowCommandLine;","				if (loaded) {",'					$("commandLine").style.display = showCommandLine ? "block" : "none";',"					setCommandInputWidth();","					setLogContainerHeight();","				}","			}","","			function focusCommandLine() {","				if (loaded) {",'					$("command").focus();',"				}","			}","","			function focusSearch() {","				if (loaded) {",'					$("searchBox").focus();',"				}","			}","","			function getLogItems() {","				var items = [];","				for (var i = 0, len = logItems.length; i < len; i++) {","					logItems[i].serialize(items);","				}","				return items;","			}","","			function setLogItems(items) {","				var loggingReallyEnabled = loggingEnabled;","				// Temporarily turn logging on","				loggingEnabled = true;","				for (var i = 0, len = items.length; i < len; i++) {","					switch (items[i][0]) {","						case LogItem.serializedItemKeys.LOG_ENTRY:","							log(items[i][1], items[i][2]);","							break;","						case LogItem.serializedItemKeys.GROUP_START:","							group(items[i][1]);","							break;","						case LogItem.serializedItemKeys.GROUP_END:","							groupEnd();","							break;","					}","				}","				loggingEnabled = loggingReallyEnabled;","			}","","			function log(logLevel, formattedMessage) {","				if (loggingEnabled) {","					var logEntry = new LogEntry(logLevel, formattedMessage);","					Arrays.push(logEntries, logEntry);","					Arrays.push(logEntriesAndSeparators, logEntry);","					Arrays.push(logItems, logEntry);","					currentGroup.addChild(logEntry);","					if (loaded) {","						if (logQueuedEventsTimer !== null) {","							clearTimeout(logQueuedEventsTimer);","						}","						logQueuedEventsTimer = setTimeout(renderQueuedLogItems, renderDelay);","						unrenderedLogItemsExist = true;","					}","				}","			}","","			function renderQueuedLogItems() {","				logQueuedEventsTimer = null;","				var pruned = pruneLogEntries();","","				// Render any unrendered log entries and apply the current search to them","				var initiallyHasMatches = currentSearch ? currentSearch.hasMatches() : false;","				for (var i = 0, len = logItems.length; i < len; i++) {","					if (!logItems[i].rendered) {","						logItems[i].render();","						logItems[i].appendToLog();","						if (currentSearch && (logItems[i] instanceof LogEntry)) {","							currentSearch.applyTo(logItems[i]);","						}","					}","				}","				if (currentSearch) {","					if (pruned) {","						if (currentSearch.hasVisibleMatches()) {","							if (currentMatchIndex === null) {","								setCurrentMatchIndex(0);","							}","							displayMatches();","						} else {","							displayNoMatches();","						}","					} else if (!initiallyHasMatches && currentSearch.hasVisibleMatches()) {","						setCurrentMatchIndex(0);","						displayMatches();","					}","				}","				if (scrollToLatest) {","					doScrollToLatest();","				}","				unrenderedLogItemsExist = false;","			}","","			function pruneLogEntries() {","				if ((maxMessages !== null) && (logEntriesAndSeparators.length > maxMessages)) {","					var numberToDelete = logEntriesAndSeparators.length - maxMessages;","					var prunedLogEntries = logEntriesAndSeparators.slice(0, numberToDelete);","					if (currentSearch) {","						currentSearch.removeMatches(prunedLogEntries);","					}","					var group;","					for (var i = 0; i < numberToDelete; i++) {","						group = logEntriesAndSeparators[i].group;","						Arrays.remove(logItems, logEntriesAndSeparators[i]);","						Arrays.remove(logEntries, logEntriesAndSeparators[i]);","						logEntriesAndSeparators[i].remove(true, true);","						if (group.children.length === 0 && group !== currentGroup && group !== rootGroup) {","							Arrays.remove(logItems, group);","							group.remove(true, true);","						}","					}","					logEntriesAndSeparators = Arrays.removeFromStart(logEntriesAndSeparators, numberToDelete);","					return true;","				}","				return false;","			}","","			function group(name, startExpanded) {","				if (loggingEnabled) {",'					initiallyExpanded = (typeof startExpanded === "undefined") ? true : Boolean(startExpanded);',"					var newGroup = new Group(name, false, initiallyExpanded);","					currentGroup.addChild(newGroup);","					currentGroup = newGroup;","					Arrays.push(logItems, newGroup);","					if (loaded) {","						if (logQueuedEventsTimer !== null) {","							clearTimeout(logQueuedEventsTimer);","						}","						logQueuedEventsTimer = setTimeout(renderQueuedLogItems, renderDelay);","						unrenderedLogItemsExist = true;","					}","				}","			}","","			function groupEnd() {","				currentGroup = (currentGroup === rootGroup) ? rootGroup : currentGroup.group;","			}","","			function mainPageReloaded() {","				currentGroup = rootGroup;","				var separator = new Separator();","				Arrays.push(logEntriesAndSeparators, separator);","				Arrays.push(logItems, separator);","				currentGroup.addChild(separator);","			}","","			function closeWindow() {","				if (appender && mainWindowExists()) {","					appender.close(true);","				} else {","					window.close();","				}","			}","","			function hide() {","				if (appender && mainWindowExists()) {","					appender.hide();","				}","			}","","			var mainWindow = window;",'			var windowId = "log4javascriptConsoleWindow_" + new Date().getTime() + "_" + ("" + Math.random()).substr(2);',"","			function setMainWindow(win) {","				mainWindow = win;","				mainWindow[windowId] = window;","				// If this is a pop-up, poll the opener to see if it's closed","				if (opener && closeIfOpenerCloses) {","					pollOpener();","				}","			}","","			function pollOpener() {","				if (closeIfOpenerCloses) {","					if (mainWindowExists()) {","						setTimeout(pollOpener, 500);","					} else {","						closeWindow();","					}","				}","			}","","			function mainWindowExists() {","				try {","					return (mainWindow && !mainWindow.closed &&","						mainWindow[windowId] == window);","				} catch (ex) {}","				return false;","			}","",'			var logLevels = ["TRACE", "DEBUG", "INFO", "WARN", "ERROR", "FATAL"];',"","			function getCheckBox(logLevel) {",'				return $("switch_" + logLevel);',"			}","","			function getIeWrappedLogContainer() {",'				return $("log_wrapped");',"			}","","			function getIeUnwrappedLogContainer() {",'				return $("log_unwrapped");',"			}","","			function applyFilters() {","				for (var i = 0; i < logLevels.length; i++) {","					if (getCheckBox(logLevels[i]).checked) {","						addClass(logMainContainer, logLevels[i]);","					} else {","						removeClass(logMainContainer, logLevels[i]);","					}","				}","				updateSearchFromFilters();","			}","","			function toggleAllLevels() {",'				var turnOn = $("switch_ALL").checked;',"				for (var i = 0; i < logLevels.length; i++) {","					getCheckBox(logLevels[i]).checked = turnOn;","					if (turnOn) {","						addClass(logMainContainer, logLevels[i]);","					} else {","						removeClass(logMainContainer, logLevels[i]);","					}","				}","			}","","			function checkAllLevels() {","				for (var i = 0; i < logLevels.length; i++) {","					if (!getCheckBox(logLevels[i]).checked) {",'						getCheckBox("ALL").checked = false;',"						return;","					}","				}",'				getCheckBox("ALL").checked = true;',"			}","","			function clearLog() {","				rootGroup.clear();","				currentGroup = rootGroup;","				logEntries = [];","				logItems = [];","				logEntriesAndSeparators = [];"," 				doSearch();","			}","","			function toggleWrap() {",'				var enable = $("wrap").checked;',"				if (enable) {",'					addClass(logMainContainer, "wrap");',"				} else {",'					removeClass(logMainContainer, "wrap");',"				}","				refreshCurrentMatch();","			}","","			/* ------------------------------------------------------------------- */","","			// Search","","			var searchTimer = null;","","			function scheduleSearch() {","				try {","					clearTimeout(searchTimer);","				} catch (ex) {","					// Do nothing","				}","				searchTimer = setTimeout(doSearch, 500);","			}","","			function Search(searchTerm, isRegex, searchRegex, isCaseSensitive) {","				this.searchTerm = searchTerm;","				this.isRegex = isRegex;","				this.searchRegex = searchRegex;","				this.isCaseSensitive = isCaseSensitive;","				this.matches = [];","			}","","			Search.prototype = {","				hasMatches: function() {","					return this.matches.length > 0;","				},","","				hasVisibleMatches: function() {","					if (this.hasMatches()) {","						for (var i = 0; i < this.matches.length; i++) {","							if (this.matches[i].isVisible()) {","								return true;","							}","						}","					}","					return false;","				},","","				match: function(logEntry) {","					var entryText = String(logEntry.formattedMessage);","					var matchesSearch = false;","					if (this.isRegex) {","						matchesSearch = this.searchRegex.test(entryText);","					} else if (this.isCaseSensitive) {","						matchesSearch = (entryText.indexOf(this.searchTerm) > -1);","					} else {","						matchesSearch = (entryText.toLowerCase().indexOf(this.searchTerm.toLowerCase()) > -1);","					}","					return matchesSearch;","				},","","				getNextVisibleMatchIndex: function() {","					for (var i = currentMatchIndex + 1; i < this.matches.length; i++) {","						if (this.matches[i].isVisible()) {","							return i;","						}","					}","					// Start again from the first match","					for (i = 0; i <= currentMatchIndex; i++) {","						if (this.matches[i].isVisible()) {","							return i;","						}","					}","					return -1;","				},","","				getPreviousVisibleMatchIndex: function() {","					for (var i = currentMatchIndex - 1; i >= 0; i--) {","						if (this.matches[i].isVisible()) {","							return i;","						}","					}","					// Start again from the last match","					for (var i = this.matches.length - 1; i >= currentMatchIndex; i--) {","						if (this.matches[i].isVisible()) {","							return i;","						}","					}","					return -1;","				},","","				applyTo: function(logEntry) {","					var doesMatch = this.match(logEntry);","					if (doesMatch) {","						logEntry.group.expand();","						logEntry.setSearchMatch(true);","						var logEntryContent;","						var wrappedLogEntryContent;",'						var searchTermReplacementStartTag = "<span class=\\"searchterm\\">";','						var searchTermReplacementEndTag = "<" + "/span>";','						var preTagName = isIe ? "pre" : "span";','						var preStartTag = "<" + preTagName + " class=\\"pre\\">";','						var preEndTag = "<" + "/" + preTagName + ">";',"						var startIndex = 0;","						var searchIndex, matchedText, textBeforeMatch;","						if (this.isRegex) {",'							var flags = this.isCaseSensitive ? "g" : "gi";','							var capturingRegex = new RegExp("(" + this.searchRegex.source + ")", flags);',"","							// Replace the search term with temporary tokens for the start and end tags",'							var rnd = ("" + Math.random()).substr(2);','							var startToken = "%%s" + rnd + "%%";','							var endToken = "%%e" + rnd + "%%";','							logEntryContent = logEntry.formattedMessage.replace(capturingRegex, startToken + "$1" + endToken);',"","							// Escape the HTML to get rid of angle brackets","							logEntryContent = escapeHtml(logEntryContent);","","							// Substitute the proper HTML back in for the search match","							var result;","							var searchString = logEntryContent;",'							logEntryContent = "";','							wrappedLogEntryContent = "";',"							while ((searchIndex = searchString.indexOf(startToken, startIndex)) > -1) {","								var endTokenIndex = searchString.indexOf(endToken, searchIndex);","								matchedText = searchString.substring(searchIndex + startToken.length, endTokenIndex);","								textBeforeMatch = searchString.substring(startIndex, searchIndex);","								logEntryContent += preStartTag + textBeforeMatch + preEndTag;","								logEntryContent += searchTermReplacementStartTag + preStartTag + matchedText +","									preEndTag + searchTermReplacementEndTag;","								if (isIe) {","									wrappedLogEntryContent += textBeforeMatch + searchTermReplacementStartTag +","										matchedText + searchTermReplacementEndTag;","								}","								startIndex = endTokenIndex + endToken.length;","							}","							logEntryContent += preStartTag + searchString.substr(startIndex) + preEndTag;","							if (isIe) {","								wrappedLogEntryContent += searchString.substr(startIndex);","							}","						} else {",'							logEntryContent = "";','							wrappedLogEntryContent = "";',"							var searchTermReplacementLength = searchTermReplacementStartTag.length +","								this.searchTerm.length + searchTermReplacementEndTag.length;","							var searchTermLength = this.searchTerm.length;","							var searchTermLowerCase = this.searchTerm.toLowerCase();","							var logTextLowerCase = logEntry.formattedMessage.toLowerCase();","							while ((searchIndex = logTextLowerCase.indexOf(searchTermLowerCase, startIndex)) > -1) {","								matchedText = escapeHtml(logEntry.formattedMessage.substr(searchIndex, this.searchTerm.length));","								textBeforeMatch = escapeHtml(logEntry.formattedMessage.substring(startIndex, searchIndex));","								var searchTermReplacement = searchTermReplacementStartTag +","									preStartTag + matchedText + preEndTag + searchTermReplacementEndTag;","								logEntryContent += preStartTag + textBeforeMatch + preEndTag + searchTermReplacement;","								if (isIe) {","									wrappedLogEntryContent += textBeforeMatch + searchTermReplacementStartTag +","										matchedText + searchTermReplacementEndTag;","								}","								startIndex = searchIndex + searchTermLength;","							}","							var textAfterLastMatch = escapeHtml(logEntry.formattedMessage.substr(startIndex));","							logEntryContent += preStartTag + textAfterLastMatch + preEndTag;","							if (isIe) {","								wrappedLogEntryContent += textAfterLastMatch;","							}","						}","						logEntry.setContent(logEntryContent, wrappedLogEntryContent);","						var logEntryMatches = logEntry.getSearchMatches();","						this.matches = this.matches.concat(logEntryMatches);","					} else {","						logEntry.setSearchMatch(false);","						logEntry.setContent(logEntry.formattedMessage, logEntry.formattedMessage);","					}","					return doesMatch;","				},","","				removeMatches: function(logEntries) {","					var matchesToRemoveCount = 0;","					var currentMatchRemoved = false;","					var matchesToRemove = [];","					var i, iLen, j, jLen;","","					// Establish the list of matches to be removed","					for (i = 0, iLen = this.matches.length; i < iLen; i++) {","						for (j = 0, jLen = logEntries.length; j < jLen; j++) {","							if (this.matches[i].belongsTo(logEntries[j])) {","								Arrays.push(matchesToRemove, this.matches[i]);","								if (i === currentMatchIndex) {","									currentMatchRemoved = true;","								}","							}","						}","					}","","					// Set the new current match index if the current match has been deleted","					// This will be the first match that appears after the first log entry being","					// deleted, if one exists; otherwise, it's the first match overall","					var newMatch = currentMatchRemoved ? null : this.matches[currentMatchIndex];","					if (currentMatchRemoved) {","						for (i = currentMatchIndex, iLen = this.matches.length; i < iLen; i++) {","							if (this.matches[i].isVisible() && !Arrays.contains(matchesToRemove, this.matches[i])) {","								newMatch = this.matches[i];","								break;","							}","						}","					}","","					// Remove the matches","					for (i = 0, iLen = matchesToRemove.length; i < iLen; i++) {","						Arrays.remove(this.matches, matchesToRemove[i]);","						matchesToRemove[i].remove();","					}","","					// Set the new match, if one exists","					if (this.hasVisibleMatches()) {","						if (newMatch === null) {","							setCurrentMatchIndex(0);","						} else {","							// Get the index of the new match","							var newMatchIndex = 0;","							for (i = 0, iLen = this.matches.length; i < iLen; i++) {","								if (newMatch === this.matches[i]) {","									newMatchIndex = i;","									break;","								}","							}","							setCurrentMatchIndex(newMatchIndex);","						}","					} else {","						currentMatchIndex = null;","						displayNoMatches();","					}","				}","			};","","			function getPageOffsetTop(el, container) {","				var currentEl = el;","				var y = 0;","				while (currentEl && currentEl != container) {","					y += currentEl.offsetTop;","					currentEl = currentEl.offsetParent;","				}","				return y;","			}","","			function scrollIntoView(el) {","				var logContainer = logMainContainer;","				// Check if the whole width of the element is visible and centre if not",'				if (!$("wrap").checked) {',"					var logContainerLeft = logContainer.scrollLeft;","					var logContainerRight = logContainerLeft  + logContainer.offsetWidth;","					var elLeft = el.offsetLeft;","					var elRight = elLeft + el.offsetWidth;","					if (elLeft < logContainerLeft || elRight > logContainerRight) {","						logContainer.scrollLeft = elLeft - (logContainer.offsetWidth - el.offsetWidth) / 2;","					}","				}","				// Check if the whole height of the element is visible and centre if not","				var logContainerTop = logContainer.scrollTop;","				var logContainerBottom = logContainerTop  + logContainer.offsetHeight;","				var elTop = getPageOffsetTop(el) - getToolBarsHeight();","				var elBottom = elTop + el.offsetHeight;","				if (elTop < logContainerTop || elBottom > logContainerBottom) {","					logContainer.scrollTop = elTop - (logContainer.offsetHeight - el.offsetHeight) / 2;","				}","			}","","			function Match(logEntryLevel, spanInMainDiv, spanInUnwrappedPre, spanInWrappedDiv) {","				this.logEntryLevel = logEntryLevel;","				this.spanInMainDiv = spanInMainDiv;","				if (isIe) {","					this.spanInUnwrappedPre = spanInUnwrappedPre;","					this.spanInWrappedDiv = spanInWrappedDiv;","				}","				this.mainSpan = isIe ? spanInUnwrappedPre : spanInMainDiv;","			}","","			Match.prototype = {","				equals: function(match) {","					return this.mainSpan === match.mainSpan;","				},","","				setCurrent: function() {","					if (isIe) {",'						addClass(this.spanInUnwrappedPre, "currentmatch");','						addClass(this.spanInWrappedDiv, "currentmatch");',"						// Scroll the visible one into view",'						var elementToScroll = $("wrap").checked ? this.spanInWrappedDiv : this.spanInUnwrappedPre;',"						scrollIntoView(elementToScroll);","					} else {",'						addClass(this.spanInMainDiv, "currentmatch");',"						scrollIntoView(this.spanInMainDiv);","					}","				},","","				belongsTo: function(logEntry) {","					if (isIe) {","						return isDescendant(this.spanInUnwrappedPre, logEntry.unwrappedPre);","					} else {","						return isDescendant(this.spanInMainDiv, logEntry.mainDiv);","					}","				},","","				setNotCurrent: function() {","					if (isIe) {",'						removeClass(this.spanInUnwrappedPre, "currentmatch");','						removeClass(this.spanInWrappedDiv, "currentmatch");',"					} else {",'						removeClass(this.spanInMainDiv, "currentmatch");',"					}","				},","","				isOrphan: function() {","					return isOrphan(this.mainSpan);","				},","","				isVisible: function() {","					return getCheckBox(this.logEntryLevel).checked;","				},","","				remove: function() {","					if (isIe) {","						this.spanInUnwrappedPre = null;","						this.spanInWrappedDiv = null;","					} else {","						this.spanInMainDiv = null;","					}","				}","			};","","			var currentSearch = null;","			var currentMatchIndex = null;","","			function doSearch() {",'				var searchBox = $("searchBox");',"				var searchTerm = searchBox.value;",'				var isRegex = $("searchRegex").checked;','				var isCaseSensitive = $("searchCaseSensitive").checked;',"				var i;","",'				if (searchTerm === "") {','					$("searchReset").disabled = true;','					$("searchNav").style.display = "none";','					removeClass(document.body, "searching");','					removeClass(searchBox, "hasmatches");','					removeClass(searchBox, "nomatches");',"					for (i = 0; i < logEntries.length; i++) {","						logEntries[i].clearSearch();","						logEntries[i].setContent(logEntries[i].formattedMessage, logEntries[i].formattedMessage);","					}","					currentSearch = null;","					setLogContainerHeight();","				} else {",'					$("searchReset").disabled = false;','					$("searchNav").style.display = "block";',"					var searchRegex;","					var regexValid;","					if (isRegex) {","						try {",'							searchRegex = isCaseSensitive ? new RegExp(searchTerm, "g") : new RegExp(searchTerm, "gi");',"							regexValid = true;",'							replaceClass(searchBox, "validregex", "invalidregex");','							searchBox.title = "Valid regex";',"						} catch (ex) {","							regexValid = false;",'							replaceClass(searchBox, "invalidregex", "validregex");','							searchBox.title = "Invalid regex: " + (ex.message ? ex.message : (ex.description ? ex.description : "unknown error"));',"							return;","						}","					} else {",'						searchBox.title = "";','						removeClass(searchBox, "validregex");','						removeClass(searchBox, "invalidregex");',"					}",'					addClass(document.body, "searching");',"					currentSearch = new Search(searchTerm, isRegex, searchRegex, isCaseSensitive);","					for (i = 0; i < logEntries.length; i++) {","						currentSearch.applyTo(logEntries[i]);","					}","					setLogContainerHeight();","","					// Highlight the first search match","					if (currentSearch.hasVisibleMatches()) {","						setCurrentMatchIndex(0);","						displayMatches();","					} else {","						displayNoMatches();","					}","				}","			}","","			function updateSearchFromFilters() {","				if (currentSearch) {","					if (currentSearch.hasMatches()) {","						if (currentMatchIndex === null) {","							currentMatchIndex = 0;","						}","						var currentMatch = currentSearch.matches[currentMatchIndex];","						if (currentMatch.isVisible()) {","							displayMatches();","							setCurrentMatchIndex(currentMatchIndex);","						} else {","							currentMatch.setNotCurrent();","							// Find the next visible match, if one exists","							var nextVisibleMatchIndex = currentSearch.getNextVisibleMatchIndex();","							if (nextVisibleMatchIndex > -1) {","								setCurrentMatchIndex(nextVisibleMatchIndex);","								displayMatches();","							} else {","								displayNoMatches();","							}","						}","					} else {","						displayNoMatches();","					}","				}","			}","","			function refreshCurrentMatch() {","				if (currentSearch && currentSearch.hasVisibleMatches()) {","					setCurrentMatchIndex(currentMatchIndex);","				}","			}","","			function displayMatches() {",'				replaceClass($("searchBox"), "hasmatches", "nomatches");','				$("searchBox").title = "" + currentSearch.matches.length + " matches found";','				$("searchNav").style.display = "block";',"				setLogContainerHeight();","			}","","			function displayNoMatches() {",'				replaceClass($("searchBox"), "nomatches", "hasmatches");','				$("searchBox").title = "No matches found";','				$("searchNav").style.display = "none";',"				setLogContainerHeight();","			}","","			function toggleSearchEnabled(enable) {",'				enable = (typeof enable == "undefined") ? !$("searchDisable").checked : enable;','				$("searchBox").disabled = !enable;','				$("searchReset").disabled = !enable;','				$("searchRegex").disabled = !enable;','				$("searchNext").disabled = !enable;','				$("searchPrevious").disabled = !enable;','				$("searchCaseSensitive").disabled = !enable;','				$("searchNav").style.display = (enable && ($("searchBox").value !== "") &&',"						currentSearch && currentSearch.hasVisibleMatches()) ?",'					"block" : "none";',"				if (enable) {",'					removeClass($("search"), "greyedout");','					addClass(document.body, "searching");','					if ($("searchHighlight").checked) {','						addClass(logMainContainer, "searchhighlight");',"					} else {",'						removeClass(logMainContainer, "searchhighlight");',"					}",'					if ($("searchFilter").checked) {','						addClass(logMainContainer, "searchfilter");',"					} else {",'						removeClass(logMainContainer, "searchfilter");',"					}",'					$("searchDisable").checked = !enable;',"				} else {",'					addClass($("search"), "greyedout");','					removeClass(document.body, "searching");','					removeClass(logMainContainer, "searchhighlight");','					removeClass(logMainContainer, "searchfilter");',"				}","				setLogContainerHeight();","			}","","			function toggleSearchFilter() {",'				var enable = $("searchFilter").checked;',"				if (enable) {",'					addClass(logMainContainer, "searchfilter");',"				} else {",'					removeClass(logMainContainer, "searchfilter");',"				}","				refreshCurrentMatch();","			}","","			function toggleSearchHighlight() {",'				var enable = $("searchHighlight").checked;',"				if (enable) {",'					addClass(logMainContainer, "searchhighlight");',"				} else {",'					removeClass(logMainContainer, "searchhighlight");',"				}","			}","","			function clearSearch() {",'				$("searchBox").value = "";',"				doSearch();","			}","","			function searchNext() {","				if (currentSearch !== null && currentMatchIndex !== null) {","					currentSearch.matches[currentMatchIndex].setNotCurrent();","					var nextMatchIndex = currentSearch.getNextVisibleMatchIndex();",'					if (nextMatchIndex > currentMatchIndex || confirm("Reached the end of the page. Start from the top?")) {',"						setCurrentMatchIndex(nextMatchIndex);","					}","				}","			}","","			function searchPrevious() {","				if (currentSearch !== null && currentMatchIndex !== null) {","					currentSearch.matches[currentMatchIndex].setNotCurrent();","					var previousMatchIndex = currentSearch.getPreviousVisibleMatchIndex();",'					if (previousMatchIndex < currentMatchIndex || confirm("Reached the start of the page. Continue from the bottom?")) {',"						setCurrentMatchIndex(previousMatchIndex);","					}","				}","			}","","			function setCurrentMatchIndex(index) {","				currentMatchIndex = index;","				currentSearch.matches[currentMatchIndex].setCurrent();","			}","","			/* ------------------------------------------------------------------------- */","","			// CSS Utilities","","			function addClass(el, cssClass) {","				if (!hasClass(el, cssClass)) {","					if (el.className) {",'						el.className += " " + cssClass;',"					} else {","						el.className = cssClass;","					}","				}","			}","","			function hasClass(el, cssClass) {","				if (el.className) {",'					var classNames = el.className.split(" ");',"					return Arrays.contains(classNames, cssClass);","				}","				return false;","			}","","			function removeClass(el, cssClass) {","				if (hasClass(el, cssClass)) {","					// Rebuild the className property",'					var existingClasses = el.className.split(" ");',"					var newClasses = [];","					for (var i = 0, len = existingClasses.length; i < len; i++) {","						if (existingClasses[i] != cssClass) {","							newClasses[newClasses.length] = existingClasses[i];","						}","					}",'					el.className = newClasses.join(" ");',"				}","			}","","			function replaceClass(el, newCssClass, oldCssClass) {","				removeClass(el, oldCssClass);","				addClass(el, newCssClass);","			}","","			/* ------------------------------------------------------------------------- */","","			// Other utility functions","","			function getElementsByClass(el, cssClass, tagName) {","				var elements = el.getElementsByTagName(tagName);","				var matches = [];","				for (var i = 0, len = elements.length; i < len; i++) {","					if (hasClass(elements[i], cssClass)) {","						Arrays.push(matches, elements[i]);","					}","				}","				return matches;","			}","","			// Syntax borrowed from Prototype library","			function $(id) {","				return document.getElementById(id);","			}","","			function isDescendant(node, ancestorNode) {","				while (node != null) {","					if (node === ancestorNode) {","						return true;","					}","					node = node.parentNode;","				}","				return false;","			}","","			function isOrphan(node) {","				var currentNode = node;","				while (currentNode) {","					if (currentNode == document.body) {","						return false;","					}","					currentNode = currentNode.parentNode;","				}","				return true;","			}","","			function escapeHtml(str) {",'				return str.replace(/&/g, "&amp;").replace(/[<]/g, "&lt;").replace(/>/g, "&gt;");',"			}","","			function getWindowWidth() {","				if (window.innerWidth) {","					return window.innerWidth;","				} else if (document.documentElement && document.documentElement.clientWidth) {","					return document.documentElement.clientWidth;","				} else if (document.body) {","					return document.body.clientWidth;","				}","				return 0;","			}","","			function getWindowHeight() {","				if (window.innerHeight) {","					return window.innerHeight;","				} else if (document.documentElement && document.documentElement.clientHeight) {","					return document.documentElement.clientHeight;","				} else if (document.body) {","					return document.body.clientHeight;","				}","				return 0;","			}","","			function getToolBarsHeight() {",'				return $("switches").offsetHeight;',"			}","","			function getChromeHeight() {","				var height = getToolBarsHeight();","				if (showCommandLine) {",'					height += $("commandLine").offsetHeight;',"				}","				return height;","			}","","			function setLogContainerHeight() {","				if (logMainContainer) {","					var windowHeight = getWindowHeight();",'					$("body").style.height = getWindowHeight() + "px";','					logMainContainer.style.height = "" +','						Math.max(0, windowHeight - getChromeHeight()) + "px";',"				}","			}","","			function setCommandInputWidth() {","				if (showCommandLine) {",'					$("command").style.width = "" + Math.max(0, $("commandLineContainer").offsetWidth -','						($("evaluateButton").offsetWidth + 13)) + "px";',"				}","			}","","			window.onresize = function() {","				setCommandInputWidth();","				setLogContainerHeight();","			};","","			function getErrorMessage(ex) {","				if (ex.message) {","					return ex.message;","				} else if (ex.description) {","					return ex.description;","				}",'				return "" + ex;',"			}","","			function moveCaretToEnd(input) {","				if (input.setSelectionRange) {","					input.focus();","					var length = input.value.length;","					input.setSelectionRange(length, length);","				} else if (input.createTextRange) {","					var range = input.createTextRange();","					range.collapse(false);","					range.select();","				}","				input.focus();","			}","","			function stopPropagation(evt) {","				if (evt.stopPropagation) {","					evt.stopPropagation();",'				} else if (typeof evt.cancelBubble != "undefined") {',"					evt.cancelBubble = true;","				}","			}","","			function getEvent(evt) {","				return evt ? evt : event;","			}","","			function getTarget(evt) {","				return evt.target ? evt.target : evt.srcElement;","			}","","			function getRelatedTarget(evt) {","				if (evt.relatedTarget) {","					return evt.relatedTarget;","				} else if (evt.srcElement) {","					switch(evt.type) {",'						case "mouseover":',"							return evt.fromElement;",'						case "mouseout":',"							return evt.toElement;","						default:","							return evt.srcElement;","					}","				}","			}","","			function cancelKeyEvent(evt) {","				evt.returnValue = false;","				stopPropagation(evt);","			}","","			function evalCommandLine() {",'				var expr = $("command").value;',"				evalCommand(expr);",'				$("command").value = "";',"			}","","			function evalLastCommand() {","				if (lastCommand != null) {","					evalCommand(lastCommand);","				}","			}","","			var lastCommand = null;","			var commandHistory = [];","			var currentCommandIndex = 0;","","			function evalCommand(expr) {","				if (appender) {","					appender.evalCommandAndAppend(expr);","				} else {",'					var prefix = ">>> " + expr + "\\r\\n";',"					try {",'						log("INFO", prefix + eval(expr));',"					} catch (ex) {",'						log("ERROR", prefix + "Error: " + getErrorMessage(ex));',"					}","				}","				// Update command history","				if (expr != commandHistory[commandHistory.length - 1]) {","					Arrays.push(commandHistory, expr);","					// Update the appender","					if (appender) {","						appender.storeCommandHistory(commandHistory);","					}","				}","				currentCommandIndex = (expr == commandHistory[currentCommandIndex]) ? currentCommandIndex + 1 : commandHistory.length;","				lastCommand = expr;","			}","			//]]>","		</script>",'		<style type="text/css">',"			body {","				background-color: white;","				color: black;","				padding: 0;","				margin: 0;","				font-family: tahoma, verdana, arial, helvetica, sans-serif;","				overflow: hidden;","			}","","			div#switchesContainer input {","				margin-bottom: 0;","			}","","			div.toolbar {","				border-top: solid #ffffff 1px;","				border-bottom: solid #aca899 1px;","				background-color: #f1efe7;","				padding: 3px 5px;","				font-size: 68.75%;","			}","","			div.toolbar, div#search input {","				font-family: tahoma, verdana, arial, helvetica, sans-serif;","			}","","			div.toolbar input.button {","				padding: 0 5px;","				font-size: 100%;","			}","","			div.toolbar input.hidden {","				display: none;","			}","","			div#switches input#clearButton {","				margin-left: 20px;","			}","","			div#levels label {","				font-weight: bold;","			}","","			div#levels label, div#options label {","				margin-right: 5px;","			}","","			div#levels label#wrapLabel {","				font-weight: normal;","			}","","			div#search label {","				margin-right: 10px;","			}","","			div#search label.searchboxlabel {","				margin-right: 0;","			}","","			div#search input {","				font-size: 100%;","			}","","			div#search input.validregex {","				color: green;","			}","","			div#search input.invalidregex {","				color: red;","			}","","			div#search input.nomatches {","				color: white;","				background-color: #ff6666;","			}","","			div#search input.nomatches {","				color: white;","				background-color: #ff6666;","			}","","			div#searchNav {","				display: none;","			}","","			div#commandLine {","				display: none;","			}","","			div#commandLine input#command {","				font-size: 100%;","				font-family: Courier New, Courier;","			}","","			div#commandLine input#evaluateButton {","			}","","			*.greyedout {","				color: gray !important;","				border-color: gray !important;","			}","","			*.greyedout *.alwaysenabled { color: black; }","","			*.unselectable {","				-khtml-user-select: none;","				-moz-user-select: none;","				user-select: none;","			}","","			div#log {","				font-family: Courier New, Courier;","				font-size: 75%;","				width: 100%;","				overflow: auto;","				clear: both;","				position: relative;","			}","","			div.group {","				border-color: #cccccc;","				border-style: solid;","				border-width: 1px 0 1px 1px;","				overflow: visible;","			}","","			div.oldIe div.group, div.oldIe div.group *, div.oldIe *.logentry {","				height: 1%;","			}","","			div.group div.groupheading span.expander {","				border: solid black 1px;","				font-family: Courier New, Courier;","				font-size: 0.833em;","				background-color: #eeeeee;","				position: relative;","				top: -1px;","				color: black;","				padding: 0 2px;","				cursor: pointer;","				cursor: hand;","				height: 1%;","			}","","			div.group div.groupcontent {","				margin-left: 10px;","				padding-bottom: 2px;","				overflow: visible;","			}","","			div.group div.expanded {","				display: block;","			}","","			div.group div.collapsed {","				display: none;","			}","","			*.logentry {","				overflow: visible;","				display: none;","				white-space: pre;","			}","","			span.pre {","				white-space: pre;","			}","			","			pre.unwrapped {","				display: inline !important;","			}","","			pre.unwrapped pre.pre, div.wrapped pre.pre {","				display: inline;","			}","","			div.wrapped pre.pre {","				white-space: normal;","			}","","			div.wrapped {","				display: none;","			}","","			body.searching *.logentry span.currentmatch {","				color: white !important;","				background-color: green !important;","			}","","			body.searching div.searchhighlight *.logentry span.searchterm {","				color: black;","				background-color: yellow;","			}","","			div.wrap *.logentry {","				white-space: normal !important;","				border-width: 0 0 1px 0;","				border-color: #dddddd;","				border-style: dotted;","			}","","			div.wrap #log_wrapped, #log_unwrapped {","				display: block;","			}","","			div.wrap #log_unwrapped, #log_wrapped {","				display: none;","			}","","			div.wrap *.logentry span.pre {","				overflow: visible;","				white-space: normal;","			}","","			div.wrap *.logentry pre.unwrapped {","				display: none;","			}","","			div.wrap *.logentry span.wrapped {","				display: inline;","			}","","			div.searchfilter *.searchnonmatch {","				display: none !important;","			}","","			div#log *.TRACE, label#label_TRACE {","				color: #666;","			}","","			div#log *.DEBUG, label#label_DEBUG {","				color: green;","			}","","			div#log *.INFO, label#label_INFO {","				color: #009;","			}","","			div#log *.WARN, label#label_WARN {","				color: #c60;","			}","","			div#log *.ERROR, label#label_ERROR {","				color: red;","			}","","			div#log *.FATAL, label#label_FATAL {","				color: #c0c;","			}","","			div.TRACE#log *.TRACE,","			div.DEBUG#log *.DEBUG,","			div.INFO#log *.INFO,","			div.WARN#log *.WARN,","			div.ERROR#log *.ERROR,","			div.FATAL#log *.FATAL {","				display: block;","			}","","			div#log div.separator {","				background-color: #cccccc;","				margin: 5px 0;","				line-height: 1px;","			}","		</style>","	</head>","",'	<body id="body">','		<div id="switchesContainer">','			<div id="switches">','				<div id="levels" class="toolbar">',"					Filters:",'					<input type="checkbox" id="switch_TRACE" onclick="applyFilters(); checkAllLevels()" checked="checked" title="Show/hide trace messages" /><label for="switch_TRACE" id="label_TRACE">trace</label>','					<input type="checkbox" id="switch_DEBUG" onclick="applyFilters(); checkAllLevels()" checked="checked" title="Show/hide debug messages" /><label for="switch_DEBUG" id="label_DEBUG">debug</label>','					<input type="checkbox" id="switch_INFO" onclick="applyFilters(); checkAllLevels()" checked="checked" title="Show/hide info messages" /><label for="switch_INFO" id="label_INFO">info</label>','					<input type="checkbox" id="switch_WARN" onclick="applyFilters(); checkAllLevels()" checked="checked" title="Show/hide warn messages" /><label for="switch_WARN" id="label_WARN">warn</label>','					<input type="checkbox" id="switch_ERROR" onclick="applyFilters(); checkAllLevels()" checked="checked" title="Show/hide error messages" /><label for="switch_ERROR" id="label_ERROR">error</label>','					<input type="checkbox" id="switch_FATAL" onclick="applyFilters(); checkAllLevels()" checked="checked" title="Show/hide fatal messages" /><label for="switch_FATAL" id="label_FATAL">fatal</label>','					<input type="checkbox" id="switch_ALL" onclick="toggleAllLevels(); applyFilters()" checked="checked" title="Show/hide all messages" /><label for="switch_ALL" id="label_ALL">all</label>',"				</div>",'				<div id="search" class="toolbar">','					<label for="searchBox" class="searchboxlabel">Search:</label> <input type="text" id="searchBox" onclick="toggleSearchEnabled(true)" onkeyup="scheduleSearch()" size="20" />','					<input type="button" id="searchReset" disabled="disabled" value="Reset" onclick="clearSearch()" class="button" title="Reset the search" />','					<input type="checkbox" id="searchRegex" onclick="doSearch()" title="If checked, search is treated as a regular expression" /><label for="searchRegex">Regex</label>','					<input type="checkbox" id="searchCaseSensitive" onclick="doSearch()" title="If checked, search is case sensitive" /><label for="searchCaseSensitive">Match case</label>','					<input type="checkbox" id="searchDisable" onclick="toggleSearchEnabled()" title="Enable/disable search" /><label for="searchDisable" class="alwaysenabled">Disable</label>','					<div id="searchNav">','						<input type="button" id="searchNext" disabled="disabled" value="Next" onclick="searchNext()" class="button" title="Go to the next matching log entry" />','						<input type="button" id="searchPrevious" disabled="disabled" value="Previous" onclick="searchPrevious()" class="button" title="Go to the previous matching log entry" />','						<input type="checkbox" id="searchFilter" onclick="toggleSearchFilter()" title="If checked, non-matching log entries are filtered out" /><label for="searchFilter">Filter</label>','						<input type="checkbox" id="searchHighlight" onclick="toggleSearchHighlight()" title="Highlight matched search terms" /><label for="searchHighlight" class="alwaysenabled">Highlight all</label>',"					</div>","				</div>",'				<div id="options" class="toolbar">',"					Options:",'					<input type="checkbox" id="enableLogging" onclick="toggleLoggingEnabled()" checked="checked" title="Enable/disable logging" /><label for="enableLogging" id="enableLoggingLabel">Log</label>','					<input type="checkbox" id="wrap" onclick="toggleWrap()" title="Enable / disable word wrap" /><label for="wrap" id="wrapLabel">Wrap</label>','					<input type="checkbox" id="newestAtTop" onclick="toggleNewestAtTop()" title="If checked, causes newest messages to appear at the top" /><label for="newestAtTop" id="newestAtTopLabel">Newest at the top</label>','					<input type="checkbox" id="scrollToLatest" onclick="toggleScrollToLatest()" checked="checked" title="If checked, window automatically scrolls to a new message when it is added" /><label for="scrollToLatest" id="scrollToLatestLabel">Scroll to latest</label>','					<input type="button" id="clearButton" value="Clear" onclick="clearLog()" class="button" title="Clear all log messages"  />','					<input type="button" id="hideButton" value="Hide" onclick="hide()" class="hidden button" title="Hide the console" />','					<input type="button" id="closeButton" value="Close" onclick="closeWindow()" class="hidden button" title="Close the window" />',"				</div>","			</div>","		</div>",'		<div id="log" class="TRACE DEBUG INFO WARN ERROR FATAL"></div>','		<div id="commandLine" class="toolbar">','			<div id="commandLineContainer">','				<input type="text" id="command" title="Enter a JavaScript command here and hit return or press \'Evaluate\'" />','				<input type="button" id="evaluateButton" value="Evaluate" class="button" title="Evaluate the command" onclick="evalCommandLine()" />',"			</div>","		</div>","	</body>","</html>",""];

};var defaultCommandLineFunctions=[];ConsoleAppender=function(){};var consoleAppenderIdCounter=1;ConsoleAppender.prototype=new Appender;ConsoleAppender.prototype.create=function(inPage,container,lazyInit,initiallyMinimized,useDocumentWrite,width,height,focusConsoleWindow){var appender=this;var initialized=false;var consoleWindowCreated=false;var consoleWindowLoaded=false;var consoleClosed=false;var queuedLoggingEvents=[];var isSupported=true;var consoleAppenderId=consoleAppenderIdCounter++;initiallyMinimized=extractBooleanFromParam(initiallyMinimized,this.defaults.initiallyMinimized);lazyInit=extractBooleanFromParam(lazyInit,this.defaults.lazyInit);useDocumentWrite=extractBooleanFromParam(useDocumentWrite,this.defaults.useDocumentWrite);var newestMessageAtTop=this.defaults.newestMessageAtTop;var scrollToLatestMessage=this.defaults.scrollToLatestMessage;width=width?width:this.defaults.width;height=height?height:this.defaults.height;var maxMessages=this.defaults.maxMessages;var showCommandLine=this.defaults.showCommandLine;var commandLineObjectExpansionDepth=this.defaults.commandLineObjectExpansionDepth;var showHideButton=this.defaults.showHideButton;var showCloseButton=this.defaults.showCloseButton;this.setLayout(this.defaults.layout);var init,createWindow,safeToAppend,getConsoleWindow,open;var appenderName=inPage?"InPageAppender":"PopUpAppender";var checkCanConfigure=function(configOptionName){if(consoleWindowCreated){handleError(appenderName+": configuration option '"+configOptionName+"' may not be set after the appender has been initialized");return false}return true};var consoleWindowExists=function(){return consoleWindowLoaded&&isSupported&&!consoleClosed};this.isNewestMessageAtTop=function(){return newestMessageAtTop};this.setNewestMessageAtTop=function(newestMessageAtTopParam){newestMessageAtTop=bool(newestMessageAtTopParam);if(consoleWindowExists()){getConsoleWindow().setNewestAtTop(newestMessageAtTop)}};this.isScrollToLatestMessage=function(){return scrollToLatestMessage};this.setScrollToLatestMessage=function(scrollToLatestMessageParam){scrollToLatestMessage=bool(scrollToLatestMessageParam);if(consoleWindowExists()){getConsoleWindow().setScrollToLatest(scrollToLatestMessage)}};this.getWidth=function(){return width};this.setWidth=function(widthParam){if(checkCanConfigure("width")){width=extractStringFromParam(widthParam,width)}};this.getHeight=function(){return height};this.setHeight=function(heightParam){if(checkCanConfigure("height")){height=extractStringFromParam(heightParam,height)}};this.getMaxMessages=function(){return maxMessages};this.setMaxMessages=function(maxMessagesParam){maxMessages=extractIntFromParam(maxMessagesParam,maxMessages);if(consoleWindowExists()){getConsoleWindow().setMaxMessages(maxMessages)}};this.isShowCommandLine=function(){return showCommandLine};this.setShowCommandLine=function(showCommandLineParam){showCommandLine=bool(showCommandLineParam);if(consoleWindowExists()){getConsoleWindow().setShowCommandLine(showCommandLine)}};this.isShowHideButton=function(){return showHideButton};this.setShowHideButton=function(showHideButtonParam){showHideButton=bool(showHideButtonParam);if(consoleWindowExists()){getConsoleWindow().setShowHideButton(showHideButton)}};this.isShowCloseButton=function(){return showCloseButton};this.setShowCloseButton=function(showCloseButtonParam){showCloseButton=bool(showCloseButtonParam);if(consoleWindowExists()){getConsoleWindow().setShowCloseButton(showCloseButton)}};this.getCommandLineObjectExpansionDepth=function(){return commandLineObjectExpansionDepth};this.setCommandLineObjectExpansionDepth=function(commandLineObjectExpansionDepthParam){commandLineObjectExpansionDepth=extractIntFromParam(commandLineObjectExpansionDepthParam,commandLineObjectExpansionDepth)};var minimized=initiallyMinimized;this.isInitiallyMinimized=function(){return initiallyMinimized};this.setInitiallyMinimized=function(initiallyMinimizedParam){if(checkCanConfigure("initiallyMinimized")){initiallyMinimized=bool(initiallyMinimizedParam);minimized=initiallyMinimized}};this.isUseDocumentWrite=function(){return useDocumentWrite};this.setUseDocumentWrite=function(useDocumentWriteParam){if(checkCanConfigure("useDocumentWrite")){useDocumentWrite=bool(useDocumentWriteParam)}};function QueuedLoggingEvent(loggingEvent,formattedMessage){this.loggingEvent=loggingEvent;this.levelName=loggingEvent.level.name;this.formattedMessage=formattedMessage}QueuedLoggingEvent.prototype.append=function(){getConsoleWindow().log(this.levelName,this.formattedMessage)};function QueuedGroup(name,initiallyExpanded){this.name=name;this.initiallyExpanded=initiallyExpanded}QueuedGroup.prototype.append=function(){getConsoleWindow().group(this.name,this.initiallyExpanded)};function QueuedGroupEnd(){}QueuedGroupEnd.prototype.append=function(){getConsoleWindow().groupEnd()};var checkAndAppend=function(){safeToAppend();if(!initialized){init()}else if(consoleClosed&&reopenWhenClosed){createWindow()}if(safeToAppend()){appendQueuedLoggingEvents()}};this.append=function(loggingEvent){if(isSupported){var formattedMessage=appender.getLayout().format(loggingEvent);if(this.getLayout().ignoresThrowable()){formattedMessage+=loggingEvent.getThrowableStrRep()}Arrays.push(queuedLoggingEvents,new QueuedLoggingEvent(loggingEvent,formattedMessage));checkAndAppend()}};this.group=function(name,initiallyExpanded){if(isSupported){Arrays.push(queuedLoggingEvents,new QueuedGroup(name,initiallyExpanded));checkAndAppend()}};this.groupEnd=function(){if(isSupported){Arrays.push(queuedLoggingEvents,new QueuedGroupEnd);checkAndAppend()}};var appendQueuedLoggingEvents=function(){while(queuedLoggingEvents.length>0){Arrays.shift(queuedLoggingEvents).append()}if(focusConsoleWindow){getConsoleWindow().focus()}};this.setAddedToLogger=function(logger){Arrays.push(this.loggers,logger);if(enabled&&!lazyInit){init()}};this.clear=function(){if(consoleWindowExists()){getConsoleWindow().clearLog()}queuedLoggingEvents.length=0};this.focus=function(){if(consoleWindowExists()){getConsoleWindow().focus()}};this.focusCommandLine=function(){if(consoleWindowExists()){getConsoleWindow().focusCommandLine()}};this.focusSearch=function(){if(consoleWindowExists()){getConsoleWindow().focusSearch()}};var commandWindow=window;this.getCommandWindow=function(){return commandWindow};this.setCommandWindow=function(commandWindowParam){commandWindow=commandWindowParam};this.executeLastCommand=function(){if(consoleWindowExists()){getConsoleWindow().evalLastCommand()}};var commandLayout=new PatternLayout("%m");this.getCommandLayout=function(){return commandLayout};this.setCommandLayout=function(commandLayoutParam){commandLayout=commandLayoutParam};this.evalCommandAndAppend=function(expr){var commandReturnValue={appendResult:true,isError:false,isMessage:false};var commandOutput="";try{var result,i;if(!commandWindow.eval&&commandWindow.execScript){commandWindow.execScript("null")}var commandLineFunctionsHash={};for(i=0,len=commandLineFunctions.length;i<len;i++){commandLineFunctionsHash[commandLineFunctions[i][0]]=commandLineFunctions[i][1]}var objectsToRestore=[];var addObjectToRestore=function(name){Arrays.push(objectsToRestore,[name,commandWindow[name]])};addObjectToRestore("appender");commandWindow.appender=appender;addObjectToRestore("commandReturnValue");commandWindow.commandReturnValue=commandReturnValue;addObjectToRestore("commandLineFunctionsHash");commandWindow.commandLineFunctionsHash=commandLineFunctionsHash;var addFunctionToWindow=function(name){addObjectToRestore(name);commandWindow[name]=function(){return this.commandLineFunctionsHash[name](appender,arguments,commandReturnValue)}};for(i=0,len=commandLineFunctions.length;i<len;i++){addFunctionToWindow(commandLineFunctions[i][0])}if(commandWindow===window&&commandWindow.execScript){addObjectToRestore("evalExpr");addObjectToRestore("result");window.evalExpr=expr;commandWindow.execScript("window.result=eval(window.evalExpr);");result=window.result}else{result=commandWindow.eval(expr)}commandOutput=formatObjectExpansion(result,commandLineObjectExpansionDepth,"",true,true,true);for(i=0,len=objectsToRestore.length;i<len;i++){commandWindow[objectsToRestore[i][0]]=objectsToRestore[i][1]}}catch(ex){commandOutput="Error evaluating command: "+getExceptionStringRep(ex);commandReturnValue.isError=true}if(commandReturnValue.appendResult){var message=">>> "+expr;if(!isUndefined(commandOutput)){message+=newLine+commandOutput}var level=commandReturnValue.isError?Level.ERROR:Level.INFO;var loggingEvent=new LoggingEvent(null,new Date,level,[message],null);var mainLayout=this.getLayout();this.setLayout(commandLayout);this.append(loggingEvent);this.setLayout(mainLayout)}};var commandLineFunctions=defaultCommandLineFunctions.concat([]);this.addCommandLineFunction=function(functionName,commandLineFunction){Arrays.push(commandLineFunctions,[functionName,commandLineFunction])};var commandHistoryCookieName="log4javascriptCommandHistory";this.storeCommandHistory=function(commandHistory){setCookie(commandHistoryCookieName,commandHistory.join(","))};var writeHtml=function(doc){var lines=getConsoleHtmlLines();doc.open();for(var i=0,len=lines.length;i<len;i++){doc.writeln(lines[i])}doc.close()};this.setEventTypes(["load","unload"]);var consoleWindowLoadHandler=function(){var win=getConsoleWindow();win.setAppender(appender);win.setNewestAtTop(newestMessageAtTop);win.setScrollToLatest(scrollToLatestMessage);win.setMaxMessages(maxMessages);win.setShowCommandLine(showCommandLine);win.setShowHideButton(showHideButton);win.setShowCloseButton(showCloseButton);win.setMainWindow(window);var storedValue=getCookie(commandHistoryCookieName);if(storedValue){win.commandHistory=storedValue.split(",");win.currentCommandIndex=win.commandHistory.length}appender.dispatchEvent("load",{win:win})};this.unload=function(){logLog.debug("unload "+this+", caller: "+this.unload.caller);if(!consoleClosed){logLog.debug("really doing unload "+this);consoleClosed=true;consoleWindowLoaded=false;consoleWindowCreated=false;appender.dispatchEvent("unload",{})}};var pollConsoleWindow=function(windowTest,interval,successCallback,errorMessage){function doPoll(){try{if(consoleClosed){clearInterval(poll)}if(windowTest(getConsoleWindow())){clearInterval(poll);successCallback()}}catch(ex){clearInterval(poll);isSupported=false;handleError(errorMessage,ex)}}var poll=setInterval(doPoll,interval)};var getConsoleUrl=function(){var documentDomainSet=document.domain!=location.hostname;return useDocumentWrite?"":getBaseUrl()+"console_uncompressed.html"+(documentDomainSet?"?log4javascript_domain="+escape(document.domain):"")};if(inPage){var iframeHeightCookieName="log4javascript_inpageappender_height";var containerElement=null;var bottomMarginDiv=null;var cssProperties=[];this.addCssProperty=function(name,value){if(checkCanConfigure("cssProperties")){Arrays.push(cssProperties,[name,value])}};var windowCreationStarted=false;var iframeContainerDiv;var iframeId=uniqueId+"_InPageAppender_"+consoleAppenderId;this.hide=function(){if(initialized&&consoleWindowCreated){if(consoleWindowExists()){getConsoleWindow().$("command").blur()}iframeContainerDiv.style.display="none";minimized=true}};this.show=function(){if(initialized){if(consoleWindowCreated){iframeContainerDiv.style.display="block";this.setShowCommandLine(showCommandLine);minimized=false}else if(!windowCreationStarted){createWindow(true)}}};this.isVisible=function(){return!minimized};this.close=function(fromButton){if(!consoleClosed&&(!fromButton||confirm("This will permanently remove the console from the page. No more messages will be logged. Do you wish to continue?"))){iframeContainerDiv.parentNode.removeChild(iframeContainerDiv);this.unload()}};open=function(){var initErrorMessage="InPageAppender.open: unable to create console iframe";function finalInit(){try{if(!initiallyMinimized){appender.show()}bottomMarginDiv.style.height=containerElement.offsetHeight+"px";consoleWindowLoadHandler();consoleWindowLoaded=true;appendQueuedLoggingEvents()}catch(ex){isSupported=false;handleError(initErrorMessage,ex)}}function writeToDocument(){try{var windowTest=function(win){return isLoaded(win)};if(useDocumentWrite){writeHtml(getConsoleWindow().document)}if(windowTest(getConsoleWindow())){finalInit()}else{pollConsoleWindow(windowTest,100,finalInit,initErrorMessage)}}catch(ex){isSupported=false;handleError(initErrorMessage,ex)}}minimized=false;iframeContainerDiv=containerElement.appendChild(document.createElement("div"));iframeContainerDiv.style.width=width;iframeContainerDiv.style.height=getCookie(iframeHeightCookieName)||height;iframeContainerDiv.style.border="solid gray 1px";for(var i=0,len=cssProperties.length;i<len;i++){iframeContainerDiv.style[cssProperties[i][0]]=cssProperties[i][1]}var iframeSrc=useDocumentWrite?"":" src='"+getConsoleUrl()+"'";iframeContainerDiv.innerHTML="<iframe id='"+iframeId+"' name='"+iframeId+"' width='100%' height='100%' frameborder='0'"+iframeSrc+"scrolling='no'></iframe>";consoleClosed=false;var iframeDocumentExistsTest=function(win){try{return bool(win)&&bool(win.document)}catch(ex){return false}};if(iframeDocumentExistsTest(getConsoleWindow())){writeToDocument()}else{pollConsoleWindow(iframeDocumentExistsTest,100,writeToDocument,initErrorMessage)}consoleWindowCreated=true};var getMargin=typeof window.getComputedStyle!="undefined"?function(el,side){return parseInt(window.getComputedStyle(el,null).getPropertyValue("margin-"+side.toLowerCase()),10)||0}:function(el,side){if(typeof el.currentStyle!="undefined"){return parseInt(el.currentStyle["margin"+side],10)||0}return 0};function getDocumentDimensions(win){var doc=win.document,body=doc.body||document.getElementsByTagName("body")[0];var width=0,height=0;if(doc.documentElement&&(!doc.compatMode||doc.compatMode=="CSS1Compat")){width=Math.max(body.offsetWidth+getMargin(body,"Left")+getMargin(body,"Right"),doc.documentElement.clientWidth);height=Math.max(body.offsetHeight+getMargin(body,"Top")+getMargin(body,"Bottom"),doc.documentElement.clientHeight,doc.documentElement.scrollHeight,win.innerHeight||0)}else{width=Math.max(body.clientWidth,body.scrollWidth);height=Math.max(body.clientHeight,body.scrollHeight,win.innerHeight||0)}if(isNaN(width)||width==0){width=win.innerWidth||0}return{width:width,height:height}}function createResizer(containerElement){var resizer=document.createElement("div");resizer.style.fontSize="1px";resizer.style.height="4px";resizer.style.cursor="n-resize";resizer.style.backgroundColor="#cccccc";var oldMouseMove,oldMouseUp;var startY;var startHeight,startIframeHeight;var overlayDiv;var mouseMove=function(evt){evt=evt||window.event;var heightDiff=startY-evt.clientY;containerElement.style.height=startHeight+heightDiff+"px";iframeContainerDiv.style.height=startIframeHeight+heightDiff+"px";getConsoleWindow().setLogContainerHeight();bottomMarginDiv.style.height=containerElement.style.height;return false};var mouseUp=function(evt){evt=evt||window.event;document.onmousemove=oldMouseMove||function(){};document.onmouseup=oldMouseUp||function(){};document.body.removeChild(overlayDiv);document.body.style.cursor="auto";setCookie(iframeHeightCookieName,iframeContainerDiv.style.height)};resizer.onmousedown=function(evt){evt=evt||window.event;startY=evt.clientY;var h=containerElement.offsetHeight;containerElement.style.height=h+"px";startHeight=2*h-containerElement.offsetHeight;containerElement.style.height=startHeight+"px";var iframeH=iframeContainerDiv.offsetHeight;iframeContainerDiv.style.height=iframeH+"px";startIframeHeight=2*iframeH-iframeContainerDiv.offsetHeight;iframeContainerDiv.style.height=startIframeHeight+"px";overlayDiv=document.body.appendChild(document.createElement("div"));var op="0",opIe="0";var docSize=getDocumentDimensions(window);var s=overlayDiv.style;s.position="absolute";s.left="0";s.top="0";s.width=docSize.width+"px";s.height=docSize.height+"px";s.backgroundColor="white";s.zIndex="1000001";s.overflow="hidden";s.KhtmlOpacity=op;s.MozOpacity=op;s.filter="alpha(opacity="+opIe+")";s.opacity=op;oldMouseMove=document.onmousemove;oldMouseUp=document.onmouseup;document.onmousemove=mouseMove;document.onmouseup=mouseUp;document.body.style.cursor="n-resize";return false};return resizer}createWindow=function(show){if(show||!initiallyMinimized){var pageLoadHandler=function(){if(!container){containerElement=document.createElement("div");containerElement.appendChild(createResizer(containerElement));containerElement.style.position="fixed";containerElement.style.left="0";containerElement.style.right="0";containerElement.style.bottom="0";document.body.appendChild(containerElement);appender.addCssProperty("borderWidth","1px 0 0 0");appender.addCssProperty("zIndex",1e6);bottomMarginDiv=document.createElement("div");bottomMarginDiv.style.padding="0";bottomMarginDiv.style.margin="0";bottomMarginDiv.style.borderWidth="0";document.body.appendChild(bottomMarginDiv);open()}else{try{var el=document.getElementById(container);if(el.nodeType==1){containerElement=el}open()}catch(ex){handleError("InPageAppender.init: invalid container element '"+container+"' supplied",ex)}}};if(pageLoaded&&container&&container.appendChild){containerElement=container;open()}else if(pageLoaded){pageLoadHandler()}else{log4javascript.addEventListener("load",pageLoadHandler)}windowCreationStarted=true}};init=function(){createWindow();initialized=true};getConsoleWindow=function(){var iframe=window.frames[iframeId];if(iframe){return iframe}};safeToAppend=function(){if(isSupported&&!consoleClosed){if(consoleWindowCreated&&!consoleWindowLoaded&&getConsoleWindow()&&isLoaded(getConsoleWindow())){consoleWindowLoaded=true}return consoleWindowLoaded}return false}}else{var useOldPopUp=appender.defaults.useOldPopUp;var complainAboutPopUpBlocking=appender.defaults.complainAboutPopUpBlocking;var reopenWhenClosed=this.defaults.reopenWhenClosed;this.isUseOldPopUp=function(){return useOldPopUp};this.setUseOldPopUp=function(useOldPopUpParam){if(checkCanConfigure("useOldPopUp")){useOldPopUp=bool(useOldPopUpParam)}};this.isComplainAboutPopUpBlocking=function(){return complainAboutPopUpBlocking};this.setComplainAboutPopUpBlocking=function(complainAboutPopUpBlockingParam){if(checkCanConfigure("complainAboutPopUpBlocking")){complainAboutPopUpBlocking=bool(complainAboutPopUpBlockingParam)}};this.isFocusPopUp=function(){return focusConsoleWindow};this.setFocusPopUp=function(focusPopUpParam){focusConsoleWindow=bool(focusPopUpParam)};this.isReopenWhenClosed=function(){return reopenWhenClosed};this.setReopenWhenClosed=function(reopenWhenClosedParam){reopenWhenClosed=bool(reopenWhenClosedParam)};this.close=function(){logLog.debug("close "+this);try{popUp.close();this.unload()}catch(ex){}};this.hide=function(){logLog.debug("hide "+this);if(consoleWindowExists()){this.close()}};this.show=function(){logLog.debug("show "+this);if(!consoleWindowCreated){open()}};var popUp;open=function(){var windowProperties="width="+width+",height="+height+",status,resizable";var windowName="PopUp_"+location.host.replace(/[^a-z0-9]/gi,"_")+"_"+consoleAppenderId;if(!useOldPopUp||!useDocumentWrite){windowName=windowName+"_"+uniqueId}var checkPopUpClosed=function(win){if(consoleClosed){return true}else{try{return bool(win)&&win.closed}catch(ex){}}return false};var popUpClosedCallback=function(){if(!consoleClosed){appender.unload()}};function finalInit(){getConsoleWindow().setCloseIfOpenerCloses(!useOldPopUp||!useDocumentWrite);consoleWindowLoadHandler();consoleWindowLoaded=true;appendQueuedLoggingEvents();pollConsoleWindow(checkPopUpClosed,500,popUpClosedCallback,"PopUpAppender.checkPopUpClosed: error checking pop-up window")}try{popUp=window.open(getConsoleUrl(),windowName,windowProperties);consoleClosed=false;consoleWindowCreated=true;if(popUp&&popUp.document){if(useDocumentWrite&&useOldPopUp&&isLoaded(popUp)){popUp.mainPageReloaded();finalInit()}else{if(useDocumentWrite){writeHtml(popUp.document)}var popUpLoadedTest=function(win){return bool(win)&&isLoaded(win)};if(isLoaded(popUp)){finalInit()}else{pollConsoleWindow(popUpLoadedTest,100,finalInit,"PopUpAppender.init: unable to create console window")}}}else{isSupported=false;logLog.warn("PopUpAppender.init: pop-ups blocked, please unblock to use PopUpAppender");if(complainAboutPopUpBlocking){handleError("log4javascript: pop-up windows appear to be blocked. Please unblock them to use pop-up logging.")}}}catch(ex){handleError("PopUpAppender.init: error creating pop-up",ex)}};createWindow=function(){if(!initiallyMinimized){open()}};init=function(){createWindow();initialized=true};getConsoleWindow=function(){return popUp};safeToAppend=function(){if(isSupported&&!isUndefined(popUp)&&!consoleClosed){if(popUp.closed||consoleWindowLoaded&&isUndefined(popUp.closed)){appender.unload();logLog.debug("PopUpAppender: pop-up closed");return false}if(!consoleWindowLoaded&&isLoaded(popUp)){consoleWindowLoaded=true}}return isSupported&&consoleWindowLoaded&&!consoleClosed};this.isVisible=function(){return safeToAppend()}}this.getConsoleWindow=getConsoleWindow};ConsoleAppender.addGlobalCommandLineFunction=function(functionName,commandLineFunction){Arrays.push(defaultCommandLineFunctions,[functionName,commandLineFunction])};function PopUpAppender(lazyInit,initiallyMinimized,useDocumentWrite,width,height){this.create(false,null,lazyInit,initiallyMinimized,useDocumentWrite,width,height,this.defaults.focusPopUp)}PopUpAppender.prototype=new ConsoleAppender;PopUpAppender.prototype.defaults={layout:new PatternLayout("%d{HH:mm:ss} %-5p - %m{1}%n"),initiallyMinimized:false,focusPopUp:false,lazyInit:true,useOldPopUp:true,complainAboutPopUpBlocking:true,newestMessageAtTop:false,scrollToLatestMessage:true,width:"600",height:"400",reopenWhenClosed:false,maxMessages:null,showCommandLine:true,commandLineObjectExpansionDepth:1,showHideButton:false,showCloseButton:true,useDocumentWrite:true};PopUpAppender.prototype.toString=function(){return"PopUpAppender"};log4javascript.PopUpAppender=PopUpAppender;function InPageAppender(container,lazyInit,initiallyMinimized,useDocumentWrite,width,height){this.create(true,container,lazyInit,initiallyMinimized,useDocumentWrite,width,height,false)}InPageAppender.prototype=new ConsoleAppender;InPageAppender.prototype.defaults={layout:new PatternLayout("%d{HH:mm:ss} %-5p - %m{1}%n"),initiallyMinimized:false,lazyInit:true,newestMessageAtTop:false,scrollToLatestMessage:true,width:"100%",height:"220px",maxMessages:null,showCommandLine:true,commandLineObjectExpansionDepth:1,showHideButton:false,showCloseButton:false,useDocumentWrite:true};InPageAppender.prototype.toString=function(){return"InPageAppender"};log4javascript.InPageAppender=InPageAppender;log4javascript.InlineAppender=InPageAppender})();function padWithSpaces(str,len){if(str.length<len){var spaces=[];var numberOfSpaces=Math.max(0,len-str.length);for(var i=0;i<numberOfSpaces;i++){spaces[i]=" "}str+=spaces.join("")}return str}(function(){function dir(obj){var maxLen=0;for(var p in obj){maxLen=Math.max(toStr(p).length,maxLen)}var propList=[];for(p in obj){var propNameStr="  "+padWithSpaces(toStr(p),maxLen+2);var propVal;try{propVal=splitIntoLines(toStr(obj[p])).join(padWithSpaces(newLine,maxLen+6))}catch(ex){propVal="[Error obtaining property. Details: "+getExceptionMessage(ex)+"]"}Arrays.push(propList,propNameStr+propVal)}return propList.join(newLine)}var nodeTypes={ELEMENT_NODE:1,ATTRIBUTE_NODE:2,TEXT_NODE:3,CDATA_SECTION_NODE:4,ENTITY_REFERENCE_NODE:5,ENTITY_NODE:6,PROCESSING_INSTRUCTION_NODE:7,COMMENT_NODE:8,DOCUMENT_NODE:9,DOCUMENT_TYPE_NODE:10,DOCUMENT_FRAGMENT_NODE:11,NOTATION_NODE:12};var preFormattedElements=["script","pre"];var emptyElements=["br","img","hr","param","link","area","input","col","base","meta"];var indentationUnit="  ";function getXhtml(rootNode,includeRootNode,indentation,startNewLine,preformatted){includeRootNode=typeof includeRootNode=="undefined"?true:!!includeRootNode;if(typeof indentation!="string"){indentation=""}startNewLine=!!startNewLine;preformatted=!!preformatted;var xhtml;function isWhitespace(node){return node.nodeType==nodeTypes.TEXT_NODE&&/^[ \t\r\n]*$/.test(node.data)}function fixAttributeValue(attrValue){return attrValue.toString().replace(/\&/g,"&amp;").replace(/</g,"&lt;").replace(/\"/g,"&quot;")}function getStyleAttributeValue(el){var stylePairs=el.style.cssText.split(";");var styleValue="";for(var j=0,len=stylePairs.length;j<len;j++){var nameValueBits=stylePairs[j].split(":");var props=[];if(!/^\s*$/.test(nameValueBits[0])){Arrays.push(props,trim(nameValueBits[0]).toLowerCase()+":"+trim(nameValueBits[1]))}styleValue=props.join(";")}return styleValue}function getNamespace(el){if(el.prefix){return el.prefix}else if(el.outerHTML){var regex=new RegExp("<([^:]+):"+el.tagName+"[^>]*>","i");if(regex.test(el.outerHTML)){return RegExp.$1.toLowerCase()}}return""}var lt="<";var gt=">";if(includeRootNode&&rootNode.nodeType!=nodeTypes.DOCUMENT_FRAGMENT_NODE){switch(rootNode.nodeType){case nodeTypes.ELEMENT_NODE:var tagName=rootNode.tagName.toLowerCase();xhtml=startNewLine?newLine+indentation:"";xhtml+=lt;var prefix=getNamespace(rootNode);var hasPrefix=!!prefix;if(hasPrefix){xhtml+=prefix+":"}xhtml+=tagName;for(i=0,len=rootNode.attributes.length;i<len;i++){var currentAttr=rootNode.attributes[i];if(!currentAttr.specified||currentAttr.nodeValue===null||currentAttr.nodeName.toLowerCase()==="style"||typeof currentAttr.nodeValue!=="string"||currentAttr.nodeName.indexOf("_moz")===0){continue}xhtml+=" "+currentAttr.nodeName.toLowerCase()+'="';xhtml+=fixAttributeValue(currentAttr.nodeValue);xhtml+='"'}if(rootNode.style.cssText){var styleValue=getStyleAttributeValue(rootNode);if(styleValue!==""){xhtml+=' style="'+getStyleAttributeValue(rootNode)+'"'}}if(Arrays.contains(emptyElements,tagName)||hasPrefix&&!rootNode.hasChildNodes()){xhtml+="/"+gt}else{xhtml+=gt;var childStartNewLine=!(rootNode.childNodes.length===1&&rootNode.childNodes[0].nodeType===nodeTypes.TEXT_NODE);var childPreformatted=Arrays.contains(preFormattedElements,tagName);for(var i=0,len=rootNode.childNodes.length;i<len;i++){xhtml+=getXhtml(rootNode.childNodes[i],true,indentation+indentationUnit,childStartNewLine,childPreformatted)}var endTag=lt+"/"+tagName+gt;xhtml+=childStartNewLine?newLine+indentation+endTag:endTag}return xhtml;case nodeTypes.TEXT_NODE:if(isWhitespace(rootNode)){xhtml=""}else{if(preformatted){xhtml=rootNode.nodeValue}else{var lines=splitIntoLines(trim(rootNode.nodeValue));var trimmedLines=[];for(var i=0,len=lines.length;i<len;i++){trimmedLines[i]=trim(lines[i])}xhtml=trimmedLines.join(newLine+indentation)}if(startNewLine){xhtml=newLine+indentation+xhtml}}return xhtml;case nodeTypes.CDATA_SECTION_NODE:return"<![CDA"+"TA["+rootNode.nodeValue+"]"+"]>"+newLine;case nodeTypes.DOCUMENT_NODE:xhtml="";for(var i=0,len=rootNode.childNodes.length;i<len;i++){xhtml+=getXhtml(rootNode.childNodes[i],true,indentation)}return xhtml;default:return""}}else{xhtml="";for(var i=0,len=rootNode.childNodes.length;i<len;i++){xhtml+=getXhtml(rootNode.childNodes[i],true,indentation+indentationUnit)}return xhtml}}function createCommandLineFunctions(appender){ConsoleAppender.addGlobalCommandLineFunction("$",function(appender,args,returnValue){return document.getElementById(args[0])});ConsoleAppender.addGlobalCommandLineFunction("dir",function(appender,args,returnValue){var lines=[];for(var i=0,len=args.length;i<len;i++){lines[i]=dir(args[i])}return lines.join(newLine+newLine)});ConsoleAppender.addGlobalCommandLineFunction("dirxml",function(appender,args,returnValue){var lines=[];for(var i=0,len=args.length;i<len;i++){lines[i]=getXhtml(args[i])}return lines.join(newLine+newLine)});ConsoleAppender.addGlobalCommandLineFunction("cd",function(appender,args,returnValue){var win,message;if(args.length===0||args[0]===""){win=window;message="Command line set to run in main window"}else{if(args[0].window==args[0]){win=args[0];message="Command line set to run in frame '"+args[0].name+"'"}else{win=window.frames[args[0]];if(win){message="Command line set to run in frame '"+args[0]+"'"}else{returnValue.isError=true;message="Frame '"+args[0]+"' does not exist";win=appender.getCommandWindow()}}}appender.setCommandWindow(win);return new ConsoleMessage(message)});ConsoleAppender.addGlobalCommandLineFunction("clear",function(appender,args,returnValue){returnValue.appendResult=false;appender.clear()});ConsoleAppender.addGlobalCommandLineFunction("keys",function(appender,args,returnValue){var keys=[];for(var k in args[0]){Arrays.push(keys,k)}return keys});ConsoleAppender.addGlobalCommandLineFunction("values",function(appender,args,returnValue){var values=[];for(var k in args[0]){try{Arrays.push(values,args[0][k])}catch(ex){logLog.warn("values(): Unable to obtain value for key "+k+". Details: "+getExceptionMessage(ex))}}return values});ConsoleAppender.addGlobalCommandLineFunction("expansionDepth",function(appender,args,returnValue){var expansionDepth=parseInt(args[0],10);var message;if(isNaN(expansionDepth)||expansionDepth<0){returnValue.isError=true;message=""+args[0]+" is not a valid expansion depth"}else{appender.setCommandLineObjectExpansionDepth(expansionDepth);message="Object expansion depth set to "+expansionDepth}return new ConsoleMessage(message)})}function init(){createCommandLineFunctions()}init()})();log4javascript.setDocumentReady=function(){pageLoaded=true;log4javascript.dispatchEvent("load",{})};if(window.addEventListener){window.addEventListener("load",log4javascript.setDocumentReady,false)}else if(window.attachEvent){window.attachEvent("onload",log4javascript.setDocumentReady)}else{var oldOnload=window.onload;if(typeof window.onload!="function"){window.onload=log4javascript.setDocumentReady}else{window.onload=function(evt){if(oldOnload){oldOnload(evt)}log4javascript.setDocumentReady()}}}window.log4javascript=log4javascript;return log4javascript}();(function(){var ctor=function(){};var inherits=function(parent,protoProps){var child;if(protoProps&&protoProps.hasOwnProperty("constructor")){child=protoProps.constructor}else{child=function(){return parent.apply(this,arguments)}}ctor.prototype=parent.prototype;child.prototype=new ctor;if(protoProps)extend(child.prototype,protoProps);child.prototype.constructor=child;child.__super__=parent.prototype;return child};function extend(target,ref){var name,value;for(name in ref){value=ref[name];if(value!==undefined){target[name]=value}}return target}var Undo={version:"0.1.15"};Undo.Stack=function(){this.commands=[];this.stackPosition=-1;this.savePosition=-1};extend(Undo.Stack.prototype,{execute:function(command){this._clearRedo();command.execute();this.commands.push(command);this.stackPosition++;this.changed()},undo:function(){this.commands[this.stackPosition].undo();this.stackPosition--;this.changed()},canUndo:function(){return this.stackPosition>=0},redo:function(){this.stackPosition++;this.commands[this.stackPosition].redo();this.changed()},canRedo:function(){return this.stackPosition<this.commands.length-1},save:function(){this.savePosition=this.stackPosition;this.changed()},dirty:function(){return this.stackPosition!=this.savePosition},_clearRedo:function(){this.commands=this.commands.slice(0,this.stackPosition+1)},changed:function(){}});Undo.Command=function(name){this.name=name};var up=new Error("override me!");extend(Undo.Command.prototype,{execute:function(){throw up},undo:function(){throw up},redo:function(){this.execute()}});Undo.Command.extend=function(protoProps){var child=inherits(this,protoProps);child.extend=Undo.Command.extend;return child};if(typeof define==="function"&&define.amd){define(Undo)}else if(typeof module!="undefined"&&module.exports){module.exports=Undo}else{this.Undo=Undo}}).call(this);(function(factory,root){if(typeof define=="function"&&define.amd){define(factory)}else if(typeof module!="undefined"&&typeof exports=="object"){module.exports=factory()}else{root.rangy=factory()}})(function(){var log=log4javascript.getLogger("rangy.core");var OBJECT="object",FUNCTION="function",UNDEFINED="undefined";

var domRangeProperties=["startContainer","startOffset","endContainer","endOffset","collapsed","commonAncestorContainer"];var domRangeMethods=["setStart","setStartBefore","setStartAfter","setEnd","setEndBefore","setEndAfter","collapse","selectNode","selectNodeContents","compareBoundaryPoints","deleteContents","extractContents","cloneContents","insertNode","surroundContents","cloneRange","toString","detach"];var textRangeProperties=["boundingHeight","boundingLeft","boundingTop","boundingWidth","htmlText","text"];var textRangeMethods=["collapse","compareEndPoints","duplicate","moveToElementText","parentElement","select","setEndPoint","getBoundingClientRect"];function isHostMethod(o,p){var t=typeof o[p];return t==FUNCTION||!!(t==OBJECT&&o[p])||t=="unknown"}function isHostObject(o,p){return!!(typeof o[p]==OBJECT&&o[p])}function isHostProperty(o,p){return typeof o[p]!=UNDEFINED}function createMultiplePropertyTest(testFunc){return function(o,props){var i=props.length;while(i--){if(!testFunc(o,props[i])){return false}}return true}}var areHostMethods=createMultiplePropertyTest(isHostMethod);var areHostObjects=createMultiplePropertyTest(isHostObject);var areHostProperties=createMultiplePropertyTest(isHostProperty);function isTextRange(range){return range&&areHostMethods(range,textRangeMethods)&&areHostProperties(range,textRangeProperties)}function getBody(doc){return isHostObject(doc,"body")?doc.body:doc.getElementsByTagName("body")[0]}var forEach=[].forEach?function(arr,func){arr.forEach(func)}:function(arr,func){for(var i=0,len=arr.length;i<len;++i){func(arr[i],i)}};var modules={};var isBrowser=typeof window!=UNDEFINED&&typeof document!=UNDEFINED;var util={isHostMethod:isHostMethod,isHostObject:isHostObject,isHostProperty:isHostProperty,areHostMethods:areHostMethods,areHostObjects:areHostObjects,areHostProperties:areHostProperties,isTextRange:isTextRange,getBody:getBody,forEach:forEach};var api={version:"%%build:version%%",initialized:false,isBrowser:isBrowser,supported:true,util:util,features:{},modules:modules,config:{alertOnFail:false,alertOnWarn:false,preferTextRange:false,autoInitialize:typeof rangyAutoInitialize==UNDEFINED?true:rangyAutoInitialize}};function consoleLog(msg){if(typeof console!=UNDEFINED&&isHostMethod(console,"log")){log(msg)}}function alertOrLog(msg,shouldAlert){if(isBrowser&&shouldAlert){alert(msg)}else{consoleLog(msg)}}function fail(reason){api.initialized=true;api.supported=false;alertOrLog("Rangy is not supported in this environment. Reason: "+reason,api.config.alertOnFail)}api.fail=fail;function warn(msg){alertOrLog("Rangy warning: "+msg,api.config.alertOnWarn)}api.warn=warn;var extend;if({}.hasOwnProperty){util.extend=extend=function(obj,props,deep){var o,p;for(var i in props){if(props.hasOwnProperty(i)){o=obj[i];p=props[i];if(deep&&o!==null&&typeof o=="object"&&p!==null&&typeof p=="object"){extend(o,p,true)}obj[i]=p}}if(props.hasOwnProperty("toString")){obj.toString=props.toString}return obj};util.createOptions=function(optionsParam,defaults){var options={};extend(options,defaults);if(optionsParam){extend(options,optionsParam)}return options}}else{fail("hasOwnProperty not supported")}if(!isBrowser){fail("Rangy can only run in a browser")}(function(){var toArray;if(isBrowser){var el=document.createElement("div");el.appendChild(document.createElement("span"));var slice=[].slice;try{if(slice.call(el.childNodes,0)[0].nodeType==1){toArray=function(arrayLike){return slice.call(arrayLike,0)}}}catch(e){}}if(!toArray){toArray=function(arrayLike){var arr=[];for(var i=0,len=arrayLike.length;i<len;++i){arr[i]=arrayLike[i]}return arr}}util.toArray=toArray})();var addListener;if(isBrowser){if(isHostMethod(document,"addEventListener")){addListener=function(obj,eventType,listener){obj.addEventListener(eventType,listener,false)}}else if(isHostMethod(document,"attachEvent")){addListener=function(obj,eventType,listener){obj.attachEvent("on"+eventType,listener)}}else{fail("Document does not have required addEventListener or attachEvent method")}util.addListener=addListener}var initListeners=[];function getErrorDesc(ex){return ex.message||ex.description||String(ex)}function init(){if(!isBrowser||api.initialized){return}var testRange;var implementsDomRange=false,implementsTextRange=false;if(isHostMethod(document,"createRange")){testRange=document.createRange();if(areHostMethods(testRange,domRangeMethods)&&areHostProperties(testRange,domRangeProperties)){implementsDomRange=true}}var body=getBody(document);if(!body||body.nodeName.toLowerCase()!="body"){fail("No body element found");return}if(body&&isHostMethod(body,"createTextRange")){testRange=body.createTextRange();if(isTextRange(testRange)){implementsTextRange=true}}if(!implementsDomRange&&!implementsTextRange){fail("Neither Range nor TextRange are available");return}api.initialized=true;api.features={implementsDomRange:implementsDomRange,implementsTextRange:implementsTextRange};var module,errorMessage;for(var moduleName in modules){if((module=modules[moduleName])instanceof Module){module.init(module,api)}}for(var i=0,len=initListeners.length;i<len;++i){try{initListeners[i](api)}catch(ex){errorMessage="Rangy init listener threw an exception. Continuing. Detail: "+getErrorDesc(ex);log.error(errorMessage,ex);consoleLog(errorMessage)}}}function deprecationNotice(deprecated,replacement,module){if(module){deprecated+=" in module "+module.name}api.warn("DEPRECATED: "+deprecated+" is deprecated. Please use "+replacement+" instead.")}function createAliasForDeprecatedMethod(owner,deprecated,replacement,module){owner[deprecated]=function(){deprecationNotice(deprecated,replacement,module);return owner[replacement].apply(owner,util.toArray(arguments))}}util.deprecationNotice=deprecationNotice;util.createAliasForDeprecatedMethod=createAliasForDeprecatedMethod;api.init=init;api.addInitListener=function(listener){if(api.initialized){listener(api)}else{initListeners.push(listener)}};var shimListeners=[];api.addShimListener=function(listener){shimListeners.push(listener)};function shim(win){win=win||window;init();for(var i=0,len=shimListeners.length;i<len;++i){shimListeners[i](win)}}if(isBrowser){api.shim=api.createMissingNativeApi=shim;createAliasForDeprecatedMethod(api,"createMissingNativeApi","shim")}function Module(name,dependencies,initializer){this.name=name;this.dependencies=dependencies;this.initialized=false;this.supported=false;this.initializer=initializer}Module.prototype={init:function(){var requiredModuleNames=this.dependencies||[];for(var i=0,len=requiredModuleNames.length,requiredModule,moduleName;i<len;++i){moduleName=requiredModuleNames[i];requiredModule=modules[moduleName];if(!requiredModule||!(requiredModule instanceof Module)){throw new Error("required module '"+moduleName+"' not found")}requiredModule.init();if(!requiredModule.supported){throw new Error("required module '"+moduleName+"' not supported")}}this.initializer(this)},fail:function(reason){this.initialized=true;this.supported=false;log.error("Module '"+this.name+"' failed to load: "+reason);throw new Error(reason)},warn:function(msg){api.warn("Module "+this.name+": "+msg)},deprecationNotice:function(deprecated,replacement){api.warn("DEPRECATED: "+deprecated+" in module "+this.name+" is deprecated. Please use "+replacement+" instead")},createError:function(msg){return new Error("Error in Rangy "+this.name+" module: "+msg)}};function createModule(name,dependencies,initFunc){var newModule=new Module(name,dependencies,function(module){if(!module.initialized){module.initialized=true;try{initFunc(api,module);module.supported=true}catch(ex){var errorMessage="Module '"+name+"' failed to load: "+getErrorDesc(ex);log.error(errorMessage,ex);consoleLog(errorMessage);if(ex.stack){consoleLog(ex.stack)}}}});modules[name]=newModule;return newModule}api.createModule=function(name){var initFunc,dependencies;if(arguments.length==2){initFunc=arguments[1];dependencies=[]}else{initFunc=arguments[2];dependencies=arguments[1]}var module=createModule(name,dependencies,initFunc);if(api.initialized&&api.supported){module.init()}};api.createCoreModule=function(name,dependencies,initFunc){createModule(name,dependencies,initFunc)};function RangePrototype(){}api.RangePrototype=RangePrototype;api.rangePrototype=new RangePrototype;function SelectionPrototype(){}api.selectionPrototype=new SelectionPrototype;var docReady=false;var loadHandler=function(e){log.info("loadHandler triggered by "+(e?e.type+" event":"document already loaded"));if(!docReady){docReady=true;if(!api.initialized&&api.config.autoInitialize){init()}}};if(isBrowser){if(document.readyState=="complete"){loadHandler()}else{if(isHostMethod(document,"addEventListener")){document.addEventListener("DOMContentLoaded",loadHandler,false)}addListener(window,"load",loadHandler)}}return api},this);rangy.createCoreModule("DomUtil",[],function(api,module){var log=log4javascript.getLogger("rangy.dom");var UNDEF="undefined";var util=api.util;var getBody=util.getBody;if(!util.areHostMethods(document,["createDocumentFragment","createElement","createTextNode"])){module.fail("document missing a Node creation method")}if(!util.isHostMethod(document,"getElementsByTagName")){module.fail("document missing getElementsByTagName method")}var el=document.createElement("div");if(!util.areHostMethods(el,["insertBefore","appendChild","cloneNode"]||!util.areHostObjects(el,["previousSibling","nextSibling","childNodes","parentNode"]))){module.fail("Incomplete Element implementation")}if(!util.isHostProperty(el,"innerHTML")){module.fail("Element is missing innerHTML property")}var textNode=document.createTextNode("test");if(!util.areHostMethods(textNode,["splitText","deleteData","insertData","appendData","cloneNode"]||!util.areHostObjects(el,["previousSibling","nextSibling","childNodes","parentNode"])||!util.areHostProperties(textNode,["data"]))){module.fail("Incomplete Text Node implementation")}var arrayContains=function(arr,val){var i=arr.length;while(i--){if(arr[i]===val){return true}}return false};function isHtmlNamespace(node){var ns;return typeof node.namespaceURI==UNDEF||((ns=node.namespaceURI)===null||ns=="http://www.w3.org/1999/xhtml")}function parentElement(node){var parent=node.parentNode;return parent.nodeType==1?parent:null}function getNodeIndex(node){var i=0;while(node=node.previousSibling){++i}return i}function getNodeLength(node){switch(node.nodeType){case 7:case 10:return 0;case 3:case 8:return node.length;default:return node.childNodes.length}}function getCommonAncestor(node1,node2){var ancestors=[],n;for(n=node1;n;n=n.parentNode){ancestors.push(n)}for(n=node2;n;n=n.parentNode){if(arrayContains(ancestors,n)){return n}}return null}function isAncestorOf(ancestor,descendant,selfIsAncestor){var n=selfIsAncestor?descendant:descendant.parentNode;while(n){if(n===ancestor){return true}else{n=n.parentNode}}return false}function isOrIsAncestorOf(ancestor,descendant){return isAncestorOf(ancestor,descendant,true)}function getClosestAncestorIn(node,ancestor,selfIsAncestor){var p,n=selfIsAncestor?node:node.parentNode;while(n){p=n.parentNode;if(p===ancestor){return n}n=p}return null}function isCharacterDataNode(node){var t=node.nodeType;return t==3||t==4||t==8}function isTextOrCommentNode(node){if(!node){return false}var t=node.nodeType;return t==3||t==8}function insertAfter(node,precedingNode){var nextNode=precedingNode.nextSibling,parent=precedingNode.parentNode;if(nextNode){parent.insertBefore(node,nextNode)}else{parent.appendChild(node)}return node}function splitDataNode(node,index,positionsToPreserve){log.debug("splitDataNode called at index "+index+" in node "+inspectNode(node));var newNode=node.cloneNode(false);newNode.deleteData(0,index);node.deleteData(index,node.length-index);insertAfter(newNode,node);if(positionsToPreserve){for(var i=0,position;position=positionsToPreserve[i++];){if(position.node==node&&position.offset>index){position.node=newNode;position.offset-=index}else if(position.node==node.parentNode&&position.offset>getNodeIndex(node)){++position.offset}}}return newNode}function getDocument(node){if(node.nodeType==9){return node}else if(typeof node.ownerDocument!=UNDEF){return node.ownerDocument}else if(typeof node.document!=UNDEF){return node.document}else if(node.parentNode){return getDocument(node.parentNode)}else{throw module.createError("getDocument: no document found for node")}}function getWindow(node){var doc=getDocument(node);if(typeof doc.defaultView!=UNDEF){return doc.defaultView}else if(typeof doc.parentWindow!=UNDEF){return doc.parentWindow}else{throw module.createError("Cannot get a window object for node")}}function getIframeDocument(iframeEl){if(typeof iframeEl.contentDocument!=UNDEF){return iframeEl.contentDocument}else if(typeof iframeEl.contentWindow!=UNDEF){return iframeEl.contentWindow.document}else{throw module.createError("getIframeDocument: No Document object found for iframe element")}}function getIframeWindow(iframeEl){if(typeof iframeEl.contentWindow!=UNDEF){return iframeEl.contentWindow}else if(typeof iframeEl.contentDocument!=UNDEF){return iframeEl.contentDocument.defaultView}else{throw module.createError("getIframeWindow: No Window object found for iframe element")}}function isWindow(obj){return obj&&util.isHostMethod(obj,"setTimeout")&&util.isHostObject(obj,"document")}function getContentDocument(obj,module,methodName){var doc;if(!obj){doc=document}else if(util.isHostProperty(obj,"nodeType")){doc=obj.nodeType==1&&obj.tagName.toLowerCase()=="iframe"?getIframeDocument(obj):getDocument(obj)}else if(isWindow(obj)){doc=obj.document}if(!doc){throw module.createError(methodName+"(): Parameter must be a Window object or DOM node")}return doc}function getRootContainer(node){var parent;while(parent=node.parentNode){node=parent}return node}function comparePoints(nodeA,offsetA,nodeB,offsetB){var nodeC,root,childA,childB,n;if(nodeA==nodeB){log.debug("case 1");return offsetA===offsetB?0:offsetA<offsetB?-1:1}else if(nodeC=getClosestAncestorIn(nodeB,nodeA,true)){log.debug("case 2",inspectNode(nodeC),getNodeIndex(nodeC));return offsetA<=getNodeIndex(nodeC)?-1:1}else if(nodeC=getClosestAncestorIn(nodeA,nodeB,true)){log.debug("case 3");return getNodeIndex(nodeC)<offsetB?-1:1}else{root=getCommonAncestor(nodeA,nodeB);if(!root){throw new Error("comparePoints error: nodes have no common ancestor")}log.debug("case 4");childA=nodeA===root?root:getClosestAncestorIn(nodeA,root,true);childB=nodeB===root?root:getClosestAncestorIn(nodeB,root,true);if(childA===childB){log.warn("comparePoints got to case 4 and childA and childB are the same!",nodeA,offsetA,nodeB,offsetB);throw module.createError("comparePoints got to case 4 and childA and childB are the same!")}else{n=root.firstChild;while(n){if(n===childA){return-1}else if(n===childB){return 1}n=n.nextSibling}}}}var crashyTextNodes=false;function isBrokenNode(node){var n;try{n=node.parentNode;return false}catch(e){return true}}(function(){var el=document.createElement("b");el.innerHTML="1";var textNode=el.firstChild;el.innerHTML="<br />";crashyTextNodes=isBrokenNode(textNode);api.features.crashyTextNodes=crashyTextNodes})();function inspectNode(node){if(!node){return"[No node]"}if(crashyTextNodes&&isBrokenNode(node)){return"[Broken node]"}if(isCharacterDataNode(node)){return'"'+node.data+'"'}if(node.nodeType==1){var idAttr=node.id?' id="'+node.id+'"':"";return"<"+node.nodeName+idAttr+">[index:"+getNodeIndex(node)+",length:"+node.childNodes.length+"]["+(node.innerHTML||"[innerHTML not supported]").slice(0,25)+"]"}return node.nodeName}function fragmentFromNodeChildren(node){var fragment=getDocument(node).createDocumentFragment(),child;while(child=node.firstChild){fragment.appendChild(child)}return fragment}var getComputedStyleProperty;if(typeof window.getComputedStyle!=UNDEF){getComputedStyleProperty=function(el,propName){return getWindow(el).getComputedStyle(el,null)[propName]}}else if(typeof document.documentElement.currentStyle!=UNDEF){getComputedStyleProperty=function(el,propName){return el.currentStyle?el.currentStyle[propName]:""}}else{module.fail("No means of obtaining computed style properties found")}function createTestElement(doc,html,contentEditable){var body=getBody(doc);var el=doc.createElement("div");el.contentEditable=""+!!contentEditable;if(html){el.innerHTML=html}var bodyFirstChild=body.firstChild;if(bodyFirstChild){body.insertBefore(el,bodyFirstChild)}else{body.appendChild(el)}return el}function removeNode(node){return node.parentNode.removeChild(node)}function NodeIterator(root){this.root=root;this._next=root}NodeIterator.prototype={_current:null,hasNext:function(){return!!this._next},next:function(){var n=this._current=this._next;var child,next;if(this._current){child=n.firstChild;if(child){this._next=child}else{next=null;while(n!==this.root&&!(next=n.nextSibling)){n=n.parentNode}this._next=next}}return this._current},detach:function(){this._current=this._next=this.root=null}};function createIterator(root){return new NodeIterator(root)}function DomPosition(node,offset){this.node=node;this.offset=offset}DomPosition.prototype={equals:function(pos){return!!pos&&this.node===pos.node&&this.offset==pos.offset},inspect:function(){return"[DomPosition("+inspectNode(this.node)+":"+this.offset+")]"},toString:function(){return this.inspect()}};function DOMException(codeName){this.code=this[codeName];this.codeName=codeName;this.message="DOMException: "+this.codeName}DOMException.prototype={INDEX_SIZE_ERR:1,HIERARCHY_REQUEST_ERR:3,WRONG_DOCUMENT_ERR:4,NO_MODIFICATION_ALLOWED_ERR:7,NOT_FOUND_ERR:8,NOT_SUPPORTED_ERR:9,INVALID_STATE_ERR:11,INVALID_NODE_TYPE_ERR:24};DOMException.prototype.toString=function(){return this.message};api.dom={arrayContains:arrayContains,isHtmlNamespace:isHtmlNamespace,parentElement:parentElement,getNodeIndex:getNodeIndex,getNodeLength:getNodeLength,getCommonAncestor:getCommonAncestor,isAncestorOf:isAncestorOf,isOrIsAncestorOf:isOrIsAncestorOf,getClosestAncestorIn:getClosestAncestorIn,isCharacterDataNode:isCharacterDataNode,isTextOrCommentNode:isTextOrCommentNode,insertAfter:insertAfter,splitDataNode:splitDataNode,getDocument:getDocument,getWindow:getWindow,getIframeWindow:getIframeWindow,getIframeDocument:getIframeDocument,getBody:getBody,isWindow:isWindow,getContentDocument:getContentDocument,getRootContainer:getRootContainer,comparePoints:comparePoints,isBrokenNode:isBrokenNode,inspectNode:inspectNode,getComputedStyleProperty:getComputedStyleProperty,createTestElement:createTestElement,removeNode:removeNode,fragmentFromNodeChildren:fragmentFromNodeChildren,createIterator:createIterator,DomPosition:DomPosition};api.DOMException=DOMException});rangy.createCoreModule("DomRange",["DomUtil"],function(api,module){var log=log4javascript.getLogger("rangy.DomRange");var dom=api.dom;var util=api.util;var DomPosition=dom.DomPosition;var DOMException=api.DOMException;var isCharacterDataNode=dom.isCharacterDataNode;var getNodeIndex=dom.getNodeIndex;var isOrIsAncestorOf=dom.isOrIsAncestorOf;var getDocument=dom.getDocument;var comparePoints=dom.comparePoints;var splitDataNode=dom.splitDataNode;var getClosestAncestorIn=dom.getClosestAncestorIn;var getNodeLength=dom.getNodeLength;var arrayContains=dom.arrayContains;var getRootContainer=dom.getRootContainer;var crashyTextNodes=api.features.crashyTextNodes;var removeNode=dom.removeNode;function isNonTextPartiallySelected(node,range){return node.nodeType!=3&&(isOrIsAncestorOf(node,range.startContainer)||isOrIsAncestorOf(node,range.endContainer))}function getRangeDocument(range){return range.document||getDocument(range.startContainer)}function getRangeRoot(range){return getRootContainer(range.startContainer)}function getBoundaryBeforeNode(node){return new DomPosition(node.parentNode,getNodeIndex(node))}function getBoundaryAfterNode(node){return new DomPosition(node.parentNode,getNodeIndex(node)+1)}function insertNodeAtPosition(node,n,o){var firstNodeInserted=node.nodeType==11?node.firstChild:node;if(isCharacterDataNode(n)){if(o==n.length){dom.insertAfter(node,n)}else{n.parentNode.insertBefore(node,o==0?n:splitDataNode(n,o))}}else if(o>=n.childNodes.length){n.appendChild(node)}else{n.insertBefore(node,n.childNodes[o])}return firstNodeInserted}function rangesIntersect(rangeA,rangeB,touchingIsIntersecting){assertRangeValid(rangeA);assertRangeValid(rangeB);if(getRangeDocument(rangeB)!=getRangeDocument(rangeA)){throw new DOMException("WRONG_DOCUMENT_ERR")}var startComparison=comparePoints(rangeA.startContainer,rangeA.startOffset,rangeB.endContainer,rangeB.endOffset),endComparison=comparePoints(rangeA.endContainer,rangeA.endOffset,rangeB.startContainer,rangeB.startOffset);return touchingIsIntersecting?startComparison<=0&&endComparison>=0:startComparison<0&&endComparison>0}function cloneSubtree(iterator){var partiallySelected;for(var node,frag=getRangeDocument(iterator.range).createDocumentFragment(),subIterator;node=iterator.next();){partiallySelected=iterator.isPartiallySelectedSubtree();log.debug("cloneSubtree got node "+dom.inspectNode(node)+" from iterator. partiallySelected: "+partiallySelected);node=node.cloneNode(!partiallySelected);if(partiallySelected){subIterator=iterator.getSubtreeIterator();node.appendChild(cloneSubtree(subIterator));subIterator.detach()}if(node.nodeType==10){throw new DOMException("HIERARCHY_REQUEST_ERR")}frag.appendChild(node)}return frag}function iterateSubtree(rangeIterator,func,iteratorState){var it,n;iteratorState=iteratorState||{stop:false};for(var node,subRangeIterator;node=rangeIterator.next();){if(rangeIterator.isPartiallySelectedSubtree()){if(func(node)===false){iteratorState.stop=true;return}else{subRangeIterator=rangeIterator.getSubtreeIterator();iterateSubtree(subRangeIterator,func,iteratorState);subRangeIterator.detach();if(iteratorState.stop){return}}}else{it=dom.createIterator(node);while(n=it.next()){if(func(n)===false){iteratorState.stop=true;return}}}}}function deleteSubtree(iterator){var subIterator;while(iterator.next()){if(iterator.isPartiallySelectedSubtree()){subIterator=iterator.getSubtreeIterator();deleteSubtree(subIterator);subIterator.detach()}else{iterator.remove()}}}function extractSubtree(iterator){log.debug("extract on iterator",iterator);for(var node,frag=getRangeDocument(iterator.range).createDocumentFragment(),subIterator;node=iterator.next();){log.debug("extractSubtree got node "+dom.inspectNode(node)+" from iterator. partiallySelected: "+iterator.isPartiallySelectedSubtree());if(iterator.isPartiallySelectedSubtree()){node=node.cloneNode(false);subIterator=iterator.getSubtreeIterator();node.appendChild(extractSubtree(subIterator));subIterator.detach()}else{iterator.remove()}if(node.nodeType==10){throw new DOMException("HIERARCHY_REQUEST_ERR")}frag.appendChild(node)}return frag}function getNodesInRange(range,nodeTypes,filter){var filterNodeTypes=!!(nodeTypes&&nodeTypes.length),regex;var filterExists=!!filter;if(filterNodeTypes){regex=new RegExp("^("+nodeTypes.join("|")+")$")}var nodes=[];iterateSubtree(new RangeIterator(range,false),function(node){if(filterNodeTypes&&!regex.test(node.nodeType)){return}if(filterExists&&!filter(node)){return}var sc=range.startContainer;if(node==sc&&isCharacterDataNode(sc)&&range.startOffset==sc.length){return}var ec=range.endContainer;if(node==ec&&isCharacterDataNode(ec)&&range.endOffset==0){return}nodes.push(node)});return nodes}function inspect(range){var name=typeof range.getName=="undefined"?"Range":range.getName();return"["+name+"("+dom.inspectNode(range.startContainer)+":"+range.startOffset+", "+dom.inspectNode(range.endContainer)+":"+range.endOffset+")]"}function RangeIterator(range,clonePartiallySelectedTextNodes){this.range=range;this.clonePartiallySelectedTextNodes=clonePartiallySelectedTextNodes;log.info("New RangeIterator ",dom.inspectNode(range.startContainer),range.startOffset,dom.inspectNode(range.endContainer),range.endOffset);if(!range.collapsed){this.sc=range.startContainer;this.so=range.startOffset;this.ec=range.endContainer;this.eo=range.endOffset;var root=range.commonAncestorContainer;if(this.sc===this.ec&&isCharacterDataNode(this.sc)){this.isSingleCharacterDataNode=true;this._first=this._last=this._next=this.sc}else{this._first=this._next=this.sc===root&&!isCharacterDataNode(this.sc)?this.sc.childNodes[this.so]:getClosestAncestorIn(this.sc,root,true);this._last=this.ec===root&&!isCharacterDataNode(this.ec)?this.ec.childNodes[this.eo-1]:getClosestAncestorIn(this.ec,root,true)}log.info("RangeIterator first and last",dom.inspectNode(this._first),dom.inspectNode(this._last))}}RangeIterator.prototype={_current:null,_next:null,_first:null,_last:null,isSingleCharacterDataNode:false,reset:function(){this._current=null;this._next=this._first},hasNext:function(){return!!this._next},next:function(){var current=this._current=this._next;if(current){this._next=current!==this._last?current.nextSibling:null;if(isCharacterDataNode(current)&&this.clonePartiallySelectedTextNodes){if(current===this.ec){(current=current.cloneNode(true)).deleteData(this.eo,current.length-this.eo)}if(this._current===this.sc){(current=current.cloneNode(true)).deleteData(0,this.so)}}}return current},remove:function(){var current=this._current,start,end;if(isCharacterDataNode(current)&&(current===this.sc||current===this.ec)){start=current===this.sc?this.so:0;end=current===this.ec?this.eo:current.length;if(start!=end){current.deleteData(start,end-start)}}else{if(current.parentNode){removeNode(current)}else{log.warn("Node to be removed has no parent node. Is this the child of an attribute node in Firefox 2?")}}},isPartiallySelectedSubtree:function(){var current=this._current;return isNonTextPartiallySelected(current,this.range)},getSubtreeIterator:function(){var subRange;if(this.isSingleCharacterDataNode){subRange=this.range.cloneRange();subRange.collapse(false)}else{subRange=new Range(getRangeDocument(this.range));var current=this._current;var startContainer=current,startOffset=0,endContainer=current,endOffset=getNodeLength(current);if(isOrIsAncestorOf(current,this.sc)){startContainer=this.sc;startOffset=this.so}if(isOrIsAncestorOf(current,this.ec)){endContainer=this.ec;endOffset=this.eo}updateBoundaries(subRange,startContainer,startOffset,endContainer,endOffset)}return new RangeIterator(subRange,this.clonePartiallySelectedTextNodes)},detach:function(){this.range=this._current=this._next=this._first=this._last=this.sc=this.so=this.ec=this.eo=null}};var beforeAfterNodeTypes=[1,3,4,5,7,8,10];var rootContainerNodeTypes=[2,9,11];var readonlyNodeTypes=[5,6,10,12];var insertableNodeTypes=[1,3,4,5,7,8,10,11];var surroundNodeTypes=[1,3,4,5,7,8];function createAncestorFinder(nodeTypes){return function(node,selfIsAncestor){var t,n=selfIsAncestor?node:node.parentNode;while(n){t=n.nodeType;if(arrayContains(nodeTypes,t)){return n}n=n.parentNode}return null}}var getDocumentOrFragmentContainer=createAncestorFinder([9,11]);var getReadonlyAncestor=createAncestorFinder(readonlyNodeTypes);var getDocTypeNotationEntityAncestor=createAncestorFinder([6,10,12]);function assertNoDocTypeNotationEntityAncestor(node,allowSelf){if(getDocTypeNotationEntityAncestor(node,allowSelf)){throw new DOMException("INVALID_NODE_TYPE_ERR")}}function assertValidNodeType(node,invalidTypes){if(!arrayContains(invalidTypes,node.nodeType)){throw new DOMException("INVALID_NODE_TYPE_ERR")}}function assertValidOffset(node,offset){if(offset<0||offset>(isCharacterDataNode(node)?node.length:node.childNodes.length)){throw new DOMException("INDEX_SIZE_ERR")}}function assertSameDocumentOrFragment(node1,node2){if(getDocumentOrFragmentContainer(node1,true)!==getDocumentOrFragmentContainer(node2,true)){throw new DOMException("WRONG_DOCUMENT_ERR")}}function assertNodeNotReadOnly(node){if(getReadonlyAncestor(node,true)){throw new DOMException("NO_MODIFICATION_ALLOWED_ERR")}}function assertNode(node,codeName){if(!node){throw new DOMException(codeName)}}function isValidOffset(node,offset){return offset<=(isCharacterDataNode(node)?node.length:node.childNodes.length)}function isRangeValid(range){return!!range.startContainer&&!!range.endContainer&&!(crashyTextNodes&&(dom.isBrokenNode(range.startContainer)||dom.isBrokenNode(range.endContainer)))&&getRootContainer(range.startContainer)==getRootContainer(range.endContainer)&&isValidOffset(range.startContainer,range.startOffset)&&isValidOffset(range.endContainer,range.endOffset)}function assertRangeValid(range){if(!isRangeValid(range)){throw new Error("Range error: Range is not valid. This usually happens after DOM mutation. Range: ("+range.inspect()+")")}}var styleEl=document.createElement("style");var htmlParsingConforms=false;try{styleEl.innerHTML="<b>x</b>";htmlParsingConforms=styleEl.firstChild.nodeType==3}catch(e){}api.features.htmlParsingConforms=htmlParsingConforms;var createContextualFragment=htmlParsingConforms?function(fragmentStr){var node=this.startContainer;var doc=getDocument(node);if(!node){throw new DOMException("INVALID_STATE_ERR")}var el=null;if(node.nodeType==1){el=node}else if(isCharacterDataNode(node)){el=dom.parentElement(node)}if(el===null||el.nodeName=="HTML"&&dom.isHtmlNamespace(getDocument(el).documentElement)&&dom.isHtmlNamespace(el)){el=doc.createElement("body")}else{el=el.cloneNode(false)}el.innerHTML=fragmentStr;return dom.fragmentFromNodeChildren(el)}:function(fragmentStr){var doc=getRangeDocument(this);var el=doc.createElement("body");el.innerHTML=fragmentStr;return dom.fragmentFromNodeChildren(el)};function splitRangeBoundaries(range,positionsToPreserve){assertRangeValid(range);log.debug("splitBoundaries called "+range.inspect(),positionsToPreserve);var sc=range.startContainer,so=range.startOffset,ec=range.endContainer,eo=range.endOffset;var startEndSame=sc===ec;if(isCharacterDataNode(ec)&&eo>0&&eo<ec.length){splitDataNode(ec,eo,positionsToPreserve);log.debug("Split end",dom.inspectNode(ec),eo)}if(isCharacterDataNode(sc)&&so>0&&so<sc.length){log.debug("Splitting start",dom.inspectNode(sc),so);sc=splitDataNode(sc,so,positionsToPreserve);if(startEndSame){eo-=so;ec=sc}else if(ec==sc.parentNode&&eo>=getNodeIndex(sc)){eo++}so=0;log.debug("Split start",dom.inspectNode(sc),so)}range.setStartAndEnd(sc,so,ec,eo);log.debug("splitBoundaries done")}function rangeToHtml(range){assertRangeValid(range);var container=range.commonAncestorContainer.parentNode.cloneNode(false);container.appendChild(range.cloneContents());return container.innerHTML}var rangeProperties=["startContainer","startOffset","endContainer","endOffset","collapsed","commonAncestorContainer"];var s2s=0,s2e=1,e2e=2,e2s=3;var n_b=0,n_a=1,n_b_a=2,n_i=3;util.extend(api.rangePrototype,{compareBoundaryPoints:function(how,range){assertRangeValid(this);assertSameDocumentOrFragment(this.startContainer,range.startContainer);var nodeA,offsetA,nodeB,offsetB;var prefixA=how==e2s||how==s2s?"start":"end";var prefixB=how==s2e||how==s2s?"start":"end";nodeA=this[prefixA+"Container"];offsetA=this[prefixA+"Offset"];nodeB=range[prefixB+"Container"];offsetB=range[prefixB+"Offset"];return comparePoints(nodeA,offsetA,nodeB,offsetB)},insertNode:function(node){assertRangeValid(this);assertValidNodeType(node,insertableNodeTypes);assertNodeNotReadOnly(this.startContainer);if(isOrIsAncestorOf(node,this.startContainer)){throw new DOMException("HIERARCHY_REQUEST_ERR")}var firstNodeInserted=insertNodeAtPosition(node,this.startContainer,this.startOffset);this.setStartBefore(firstNodeInserted)},cloneContents:function(){assertRangeValid(this);var clone,frag;if(this.collapsed){return getRangeDocument(this).createDocumentFragment()}else{if(this.startContainer===this.endContainer&&isCharacterDataNode(this.startContainer)){clone=this.startContainer.cloneNode(true);clone.data=clone.data.slice(this.startOffset,this.endOffset);frag=getRangeDocument(this).createDocumentFragment();frag.appendChild(clone);return frag}else{var iterator=new RangeIterator(this,true);clone=cloneSubtree(iterator);iterator.detach()}return clone}},canSurroundContents:function(){assertRangeValid(this);assertNodeNotReadOnly(this.startContainer);assertNodeNotReadOnly(this.endContainer);

var iterator=new RangeIterator(this,true);var boundariesInvalid=iterator._first&&isNonTextPartiallySelected(iterator._first,this)||iterator._last&&isNonTextPartiallySelected(iterator._last,this);iterator.detach();return!boundariesInvalid},surroundContents:function(node){assertValidNodeType(node,surroundNodeTypes);if(!this.canSurroundContents()){throw new DOMException("INVALID_STATE_ERR")}var content=this.extractContents();if(node.hasChildNodes()){while(node.lastChild){node.removeChild(node.lastChild)}}insertNodeAtPosition(node,this.startContainer,this.startOffset);node.appendChild(content);this.selectNode(node)},cloneRange:function(){assertRangeValid(this);var range=new Range(getRangeDocument(this));var i=rangeProperties.length,prop;while(i--){prop=rangeProperties[i];range[prop]=this[prop]}return range},toString:function(){assertRangeValid(this);var sc=this.startContainer;if(sc===this.endContainer&&isCharacterDataNode(sc)){return sc.nodeType==3||sc.nodeType==4?sc.data.slice(this.startOffset,this.endOffset):""}else{var textParts=[],iterator=new RangeIterator(this,true);log.info("toString iterator: "+dom.inspectNode(iterator._first)+", "+dom.inspectNode(iterator._last));iterateSubtree(iterator,function(node){if(node.nodeType==3||node.nodeType==4){textParts.push(node.data)}});iterator.detach();return textParts.join("")}},compareNode:function(node){assertRangeValid(this);var parent=node.parentNode;var nodeIndex=getNodeIndex(node);if(!parent){throw new DOMException("NOT_FOUND_ERR")}var startComparison=this.comparePoint(parent,nodeIndex),endComparison=this.comparePoint(parent,nodeIndex+1);if(startComparison<0){return endComparison>0?n_b_a:n_b}else{return endComparison>0?n_a:n_i}},comparePoint:function(node,offset){assertRangeValid(this);assertNode(node,"HIERARCHY_REQUEST_ERR");assertSameDocumentOrFragment(node,this.startContainer);if(comparePoints(node,offset,this.startContainer,this.startOffset)<0){return-1}else if(comparePoints(node,offset,this.endContainer,this.endOffset)>0){return 1}return 0},createContextualFragment:createContextualFragment,toHtml:function(){return rangeToHtml(this)},intersectsNode:function(node,touchingIsIntersecting){assertRangeValid(this);if(getRootContainer(node)!=getRangeRoot(this)){return false}var parent=node.parentNode,offset=getNodeIndex(node);if(!parent){return true}var startComparison=comparePoints(parent,offset,this.endContainer,this.endOffset),endComparison=comparePoints(parent,offset+1,this.startContainer,this.startOffset);return touchingIsIntersecting?startComparison<=0&&endComparison>=0:startComparison<0&&endComparison>0},isPointInRange:function(node,offset){assertRangeValid(this);assertNode(node,"HIERARCHY_REQUEST_ERR");assertSameDocumentOrFragment(node,this.startContainer);return comparePoints(node,offset,this.startContainer,this.startOffset)>=0&&comparePoints(node,offset,this.endContainer,this.endOffset)<=0},intersectsRange:function(range){return rangesIntersect(this,range,false)},intersectsOrTouchesRange:function(range){return rangesIntersect(this,range,true)},intersection:function(range){if(this.intersectsRange(range)){var startComparison=comparePoints(this.startContainer,this.startOffset,range.startContainer,range.startOffset),endComparison=comparePoints(this.endContainer,this.endOffset,range.endContainer,range.endOffset);var intersectionRange=this.cloneRange();log.info("intersection",this.inspect(),range.inspect(),startComparison,endComparison);if(startComparison==-1){intersectionRange.setStart(range.startContainer,range.startOffset)}if(endComparison==1){intersectionRange.setEnd(range.endContainer,range.endOffset)}return intersectionRange}return null},union:function(range){if(this.intersectsOrTouchesRange(range)){var unionRange=this.cloneRange();if(comparePoints(range.startContainer,range.startOffset,this.startContainer,this.startOffset)==-1){unionRange.setStart(range.startContainer,range.startOffset)}if(comparePoints(range.endContainer,range.endOffset,this.endContainer,this.endOffset)==1){unionRange.setEnd(range.endContainer,range.endOffset)}return unionRange}else{throw new DOMException("Ranges do not intersect")}},containsNode:function(node,allowPartial){if(allowPartial){return this.intersectsNode(node,false)}else{return this.compareNode(node)==n_i}},containsNodeContents:function(node){return this.comparePoint(node,0)>=0&&this.comparePoint(node,getNodeLength(node))<=0},containsRange:function(range){var intersection=this.intersection(range);return intersection!==null&&range.equals(intersection)},containsNodeText:function(node){var nodeRange=this.cloneRange();nodeRange.selectNode(node);var textNodes=nodeRange.getNodes([3]);if(textNodes.length>0){nodeRange.setStart(textNodes[0],0);var lastTextNode=textNodes.pop();nodeRange.setEnd(lastTextNode,lastTextNode.length);return this.containsRange(nodeRange)}else{return this.containsNodeContents(node)}},getNodes:function(nodeTypes,filter){assertRangeValid(this);return getNodesInRange(this,nodeTypes,filter)},getDocument:function(){return getRangeDocument(this)},collapseBefore:function(node){this.setEndBefore(node);this.collapse(false)},collapseAfter:function(node){this.setStartAfter(node);this.collapse(true)},getBookmark:function(containerNode){var doc=getRangeDocument(this);var preSelectionRange=api.createRange(doc);containerNode=containerNode||dom.getBody(doc);preSelectionRange.selectNodeContents(containerNode);var range=this.intersection(preSelectionRange);var start=0,end=0;if(range){preSelectionRange.setEnd(range.startContainer,range.startOffset);start=preSelectionRange.toString().length;end=start+range.toString().length}return{start:start,end:end,containerNode:containerNode}},moveToBookmark:function(bookmark){var containerNode=bookmark.containerNode;var charIndex=0;this.setStart(containerNode,0);this.collapse(true);var nodeStack=[containerNode],node,foundStart=false,stop=false;var nextCharIndex,i,childNodes;while(!stop&&(node=nodeStack.pop())){if(node.nodeType==3){nextCharIndex=charIndex+node.length;if(!foundStart&&bookmark.start>=charIndex&&bookmark.start<=nextCharIndex){this.setStart(node,bookmark.start-charIndex);foundStart=true}if(foundStart&&bookmark.end>=charIndex&&bookmark.end<=nextCharIndex){this.setEnd(node,bookmark.end-charIndex);stop=true}charIndex=nextCharIndex}else{childNodes=node.childNodes;i=childNodes.length;while(i--){nodeStack.push(childNodes[i])}}}},getName:function(){return"DomRange"},equals:function(range){return Range.rangesEqual(this,range)},isValid:function(){return isRangeValid(this)},inspect:function(){return inspect(this)},detach:function(){}});function copyComparisonConstantsToObject(obj){obj.START_TO_START=s2s;obj.START_TO_END=s2e;obj.END_TO_END=e2e;obj.END_TO_START=e2s;obj.NODE_BEFORE=n_b;obj.NODE_AFTER=n_a;obj.NODE_BEFORE_AND_AFTER=n_b_a;obj.NODE_INSIDE=n_i}function copyComparisonConstants(constructor){copyComparisonConstantsToObject(constructor);copyComparisonConstantsToObject(constructor.prototype)}function createRangeContentRemover(remover,boundaryUpdater){return function(){assertRangeValid(this);var sc=this.startContainer,so=this.startOffset,root=this.commonAncestorContainer;var iterator=new RangeIterator(this,true);var node,boundary;if(sc!==root){node=getClosestAncestorIn(sc,root,true);boundary=getBoundaryAfterNode(node);sc=boundary.node;so=boundary.offset}iterateSubtree(iterator,assertNodeNotReadOnly);iterator.reset();var returnValue=remover(iterator);iterator.detach();boundaryUpdater(this,sc,so,sc,so);return returnValue}}function createPrototypeRange(constructor,boundaryUpdater){function createBeforeAfterNodeSetter(isBefore,isStart){return function(node){assertValidNodeType(node,beforeAfterNodeTypes);assertValidNodeType(getRootContainer(node),rootContainerNodeTypes);var boundary=(isBefore?getBoundaryBeforeNode:getBoundaryAfterNode)(node);(isStart?setRangeStart:setRangeEnd)(this,boundary.node,boundary.offset)}}function setRangeStart(range,node,offset){var ec=range.endContainer,eo=range.endOffset;if(node!==range.startContainer||offset!==range.startOffset){if(getRootContainer(node)!=getRootContainer(ec)||comparePoints(node,offset,ec,eo)==1){ec=node;eo=offset}boundaryUpdater(range,node,offset,ec,eo)}}function setRangeEnd(range,node,offset){var sc=range.startContainer,so=range.startOffset;if(node!==range.endContainer||offset!==range.endOffset){if(getRootContainer(node)!=getRootContainer(sc)||comparePoints(node,offset,sc,so)==-1){sc=node;so=offset}boundaryUpdater(range,sc,so,node,offset)}}var F=function(){};F.prototype=api.rangePrototype;constructor.prototype=new F;util.extend(constructor.prototype,{setStart:function(node,offset){assertNoDocTypeNotationEntityAncestor(node,true);assertValidOffset(node,offset);setRangeStart(this,node,offset)},setEnd:function(node,offset){assertNoDocTypeNotationEntityAncestor(node,true);assertValidOffset(node,offset);setRangeEnd(this,node,offset)},setStartAndEnd:function(){var args=arguments;var sc=args[0],so=args[1],ec=sc,eo=so;switch(args.length){case 3:eo=args[2];break;case 4:ec=args[2];eo=args[3];break}boundaryUpdater(this,sc,so,ec,eo)},setBoundary:function(node,offset,isStart){this["set"+(isStart?"Start":"End")](node,offset)},setStartBefore:createBeforeAfterNodeSetter(true,true),setStartAfter:createBeforeAfterNodeSetter(false,true),setEndBefore:createBeforeAfterNodeSetter(true,false),setEndAfter:createBeforeAfterNodeSetter(false,false),collapse:function(isStart){assertRangeValid(this);if(isStart){boundaryUpdater(this,this.startContainer,this.startOffset,this.startContainer,this.startOffset)}else{boundaryUpdater(this,this.endContainer,this.endOffset,this.endContainer,this.endOffset)}},selectNodeContents:function(node){assertNoDocTypeNotationEntityAncestor(node,true);boundaryUpdater(this,node,0,node,getNodeLength(node))},selectNode:function(node){assertNoDocTypeNotationEntityAncestor(node,false);assertValidNodeType(node,beforeAfterNodeTypes);var start=getBoundaryBeforeNode(node),end=getBoundaryAfterNode(node);boundaryUpdater(this,start.node,start.offset,end.node,end.offset)},extractContents:createRangeContentRemover(extractSubtree,boundaryUpdater),deleteContents:createRangeContentRemover(deleteSubtree,boundaryUpdater),canSurroundContents:function(){assertRangeValid(this);assertNodeNotReadOnly(this.startContainer);assertNodeNotReadOnly(this.endContainer);var iterator=new RangeIterator(this,true);var boundariesInvalid=iterator._first&&isNonTextPartiallySelected(iterator._first,this)||iterator._last&&isNonTextPartiallySelected(iterator._last,this);iterator.detach();return!boundariesInvalid},splitBoundaries:function(){splitRangeBoundaries(this)},splitBoundariesPreservingPositions:function(positionsToPreserve){splitRangeBoundaries(this,positionsToPreserve)},normalizeBoundaries:function(){assertRangeValid(this);var sc=this.startContainer,so=this.startOffset,ec=this.endContainer,eo=this.endOffset;var mergeForward=function(node){var sibling=node.nextSibling;if(sibling&&sibling.nodeType==node.nodeType){ec=node;eo=node.length;node.appendData(sibling.data);removeNode(sibling)}};var mergeBackward=function(node){var sibling=node.previousSibling;if(sibling&&sibling.nodeType==node.nodeType){sc=node;var nodeLength=node.length;so=sibling.length;node.insertData(0,sibling.data);removeNode(sibling);if(sc==ec){eo+=so;ec=sc}else if(ec==node.parentNode){var nodeIndex=getNodeIndex(node);if(eo==nodeIndex){ec=node;eo=nodeLength}else if(eo>nodeIndex){eo--}}}};var normalizeStart=true;var sibling;if(isCharacterDataNode(ec)){if(eo==ec.length){mergeForward(ec)}else if(eo==0){sibling=ec.previousSibling;if(sibling&&sibling.nodeType==ec.nodeType){eo=sibling.length;if(sc==ec){normalizeStart=false}sibling.appendData(ec.data);removeNode(ec);ec=sibling}}}else{if(eo>0){var endNode=ec.childNodes[eo-1];if(endNode&&isCharacterDataNode(endNode)){mergeForward(endNode)}}normalizeStart=!this.collapsed}if(normalizeStart){if(isCharacterDataNode(sc)){if(so==0){mergeBackward(sc)}else if(so==sc.length){sibling=sc.nextSibling;if(sibling&&sibling.nodeType==sc.nodeType){if(ec==sibling){ec=sc;eo+=sc.length}sc.appendData(sibling.data);removeNode(sibling)}}}else{if(so<sc.childNodes.length){var startNode=sc.childNodes[so];if(startNode&&isCharacterDataNode(startNode)){mergeBackward(startNode)}}}}else{sc=ec;so=eo}boundaryUpdater(this,sc,so,ec,eo)},collapseToPoint:function(node,offset){assertNoDocTypeNotationEntityAncestor(node,true);assertValidOffset(node,offset);this.setStartAndEnd(node,offset)}});copyComparisonConstants(constructor)}function updateCollapsedAndCommonAncestor(range){range.collapsed=range.startContainer===range.endContainer&&range.startOffset===range.endOffset;range.commonAncestorContainer=range.collapsed?range.startContainer:dom.getCommonAncestor(range.startContainer,range.endContainer)}function updateBoundaries(range,startContainer,startOffset,endContainer,endOffset){range.startContainer=startContainer;range.startOffset=startOffset;range.endContainer=endContainer;range.endOffset=endOffset;range.document=dom.getDocument(startContainer);updateCollapsedAndCommonAncestor(range)}function Range(doc){this.startContainer=doc;this.startOffset=0;this.endContainer=doc;this.endOffset=0;this.document=doc;updateCollapsedAndCommonAncestor(this)}createPrototypeRange(Range,updateBoundaries);util.extend(Range,{rangeProperties:rangeProperties,RangeIterator:RangeIterator,copyComparisonConstants:copyComparisonConstants,createPrototypeRange:createPrototypeRange,inspect:inspect,toHtml:rangeToHtml,getRangeDocument:getRangeDocument,rangesEqual:function(r1,r2){return r1.startContainer===r2.startContainer&&r1.startOffset===r2.startOffset&&r1.endContainer===r2.endContainer&&r1.endOffset===r2.endOffset}});api.DomRange=Range});rangy.createCoreModule("WrappedRange",["DomRange"],function(api,module){var WrappedRange,WrappedTextRange;var dom=api.dom;var util=api.util;var DomPosition=dom.DomPosition;var DomRange=api.DomRange;var getBody=dom.getBody;var getContentDocument=dom.getContentDocument;var isCharacterDataNode=dom.isCharacterDataNode;var log=log4javascript.getLogger("rangy.WrappedRange");if(api.features.implementsDomRange){(function(){var rangeProto;var rangeProperties=DomRange.rangeProperties;function updateRangeProperties(range){var i=rangeProperties.length,prop;while(i--){prop=rangeProperties[i];range[prop]=range.nativeRange[prop]}range.collapsed=range.startContainer===range.endContainer&&range.startOffset===range.endOffset}function updateNativeRange(range,startContainer,startOffset,endContainer,endOffset){var startMoved=range.startContainer!==startContainer||range.startOffset!=startOffset;var endMoved=range.endContainer!==endContainer||range.endOffset!=endOffset;var nativeRangeDifferent=!range.equals(range.nativeRange);if(startMoved||endMoved||nativeRangeDifferent){range.setEnd(endContainer,endOffset);range.setStart(startContainer,startOffset)}}var createBeforeAfterNodeSetter;WrappedRange=function(range){if(!range){throw module.createError("WrappedRange: Range must be specified")}this.nativeRange=range;updateRangeProperties(this)};DomRange.createPrototypeRange(WrappedRange,updateNativeRange);rangeProto=WrappedRange.prototype;rangeProto.selectNode=function(node){this.nativeRange.selectNode(node);updateRangeProperties(this)};rangeProto.cloneContents=function(){return this.nativeRange.cloneContents()};rangeProto.surroundContents=function(node){this.nativeRange.surroundContents(node);updateRangeProperties(this)};rangeProto.collapse=function(isStart){this.nativeRange.collapse(isStart);updateRangeProperties(this)};rangeProto.cloneRange=function(){return new WrappedRange(this.nativeRange.cloneRange())};rangeProto.refresh=function(){updateRangeProperties(this)};rangeProto.toString=function(){return this.nativeRange.toString()};var testTextNode=document.createTextNode("test");getBody(document).appendChild(testTextNode);var range=document.createRange();range.setStart(testTextNode,0);range.setEnd(testTextNode,0);try{range.setStart(testTextNode,1);rangeProto.setStart=function(node,offset){this.nativeRange.setStart(node,offset);updateRangeProperties(this)};rangeProto.setEnd=function(node,offset){this.nativeRange.setEnd(node,offset);updateRangeProperties(this)};createBeforeAfterNodeSetter=function(name){return function(node){this.nativeRange[name](node);updateRangeProperties(this)}}}catch(ex){log.info("Browser has bug (present in Firefox 2 and below) that prevents moving the start of a Range to a point after its current end. Correcting for it.");rangeProto.setStart=function(node,offset){try{this.nativeRange.setStart(node,offset)}catch(ex){this.nativeRange.setEnd(node,offset);this.nativeRange.setStart(node,offset)}updateRangeProperties(this)};rangeProto.setEnd=function(node,offset){try{this.nativeRange.setEnd(node,offset)}catch(ex){this.nativeRange.setStart(node,offset);this.nativeRange.setEnd(node,offset)}updateRangeProperties(this)};createBeforeAfterNodeSetter=function(name,oppositeName){return function(node){try{this.nativeRange[name](node)}catch(ex){this.nativeRange[oppositeName](node);this.nativeRange[name](node)}updateRangeProperties(this)}}}rangeProto.setStartBefore=createBeforeAfterNodeSetter("setStartBefore","setEndBefore");rangeProto.setStartAfter=createBeforeAfterNodeSetter("setStartAfter","setEndAfter");rangeProto.setEndBefore=createBeforeAfterNodeSetter("setEndBefore","setStartBefore");rangeProto.setEndAfter=createBeforeAfterNodeSetter("setEndAfter","setStartAfter");rangeProto.selectNodeContents=function(node){this.setStartAndEnd(node,0,dom.getNodeLength(node))};range.selectNodeContents(testTextNode);range.setEnd(testTextNode,3);var range2=document.createRange();range2.selectNodeContents(testTextNode);range2.setEnd(testTextNode,4);range2.setStart(testTextNode,2);if(range.compareBoundaryPoints(range.START_TO_END,range2)==-1&&range.compareBoundaryPoints(range.END_TO_START,range2)==1){log.info("START_TO_END and END_TO_START wrong way round. Correcting in wrapper.");rangeProto.compareBoundaryPoints=function(type,range){range=range.nativeRange||range;if(type==range.START_TO_END){type=range.END_TO_START}else if(type==range.END_TO_START){type=range.START_TO_END}return this.nativeRange.compareBoundaryPoints(type,range)}}else{rangeProto.compareBoundaryPoints=function(type,range){return this.nativeRange.compareBoundaryPoints(type,range.nativeRange||range)}}var el=document.createElement("div");el.innerHTML="123";var textNode=el.firstChild;var body=getBody(document);body.appendChild(el);range.setStart(textNode,1);range.setEnd(textNode,2);range.deleteContents();if(textNode.data=="13"){rangeProto.deleteContents=function(){this.nativeRange.deleteContents();updateRangeProperties(this)};rangeProto.extractContents=function(){var frag=this.nativeRange.extractContents();updateRangeProperties(this);return frag}}else{log.info("Incorrect native Range deleteContents() implementation. Using Rangy's own.")}body.removeChild(el);body=null;if(util.isHostMethod(range,"createContextualFragment")){rangeProto.createContextualFragment=function(fragmentStr){return this.nativeRange.createContextualFragment(fragmentStr)}}getBody(document).removeChild(testTextNode);rangeProto.getName=function(){return"WrappedRange"};api.WrappedRange=WrappedRange;api.createNativeRange=function(doc){doc=getContentDocument(doc,module,"createNativeRange");return doc.createRange()}})()}if(api.features.implementsTextRange){var getTextRangeContainerElement=function(textRange){var parentEl=textRange.parentElement();log.info("getTextRangeContainerElement parentEl is "+dom.inspectNode(parentEl));var range=textRange.duplicate();range.collapse(true);var startEl=range.parentElement();range=textRange.duplicate();range.collapse(false);var endEl=range.parentElement();var startEndContainer=startEl==endEl?startEl:dom.getCommonAncestor(startEl,endEl);return startEndContainer==parentEl?startEndContainer:dom.getCommonAncestor(parentEl,startEndContainer)};var textRangeIsCollapsed=function(textRange){return textRange.compareEndPoints("StartToEnd",textRange)==0};var getTextRangeBoundaryPosition=function(textRange,wholeRangeContainerElement,isStart,isCollapsed,startInfo){var workingRange=textRange.duplicate();workingRange.collapse(isStart);var containerElement=workingRange.parentElement();if(!dom.isOrIsAncestorOf(wholeRangeContainerElement,containerElement)){containerElement=wholeRangeContainerElement;log.warn("Collapse has moved TextRange outside its original container, so correcting",dom.inspectNode(containerElement))}log.debug("getTextRangeBoundaryPosition start "+isStart+", containerElement is "+dom.inspectNode(containerElement));if(!containerElement.canHaveHTML){var pos=new DomPosition(containerElement.parentNode,dom.getNodeIndex(containerElement));return{boundaryPosition:pos,nodeInfo:{nodeIndex:pos.offset,containerElement:pos.node}}}var workingNode=dom.getDocument(containerElement).createElement("span");if(workingNode.parentNode){dom.removeNode(workingNode)}var comparison,workingComparisonType=isStart?"StartToStart":"StartToEnd";var previousNode,nextNode,boundaryPosition,boundaryNode;var start=startInfo&&startInfo.containerElement==containerElement?startInfo.nodeIndex:0;var childNodeCount=containerElement.childNodes.length;var end=childNodeCount;var nodeIndex=end;while(true){log.debug("nodeIndex is "+nodeIndex+", start: "+start+", end: "+end);if(nodeIndex==childNodeCount){containerElement.appendChild(workingNode)}else{containerElement.insertBefore(workingNode,containerElement.childNodes[nodeIndex])}workingRange.moveToElementText(workingNode);comparison=workingRange.compareEndPoints(workingComparisonType,textRange);if(comparison==0||start==end){break}else if(comparison==-1){if(end==start+1){break}else{start=nodeIndex}}else{end=end==start+1?start:nodeIndex}nodeIndex=Math.floor((start+end)/2);containerElement.removeChild(workingNode)}log.debug("*** GOT node index "+nodeIndex);boundaryNode=workingNode.nextSibling;if(comparison==-1&&boundaryNode&&isCharacterDataNode(boundaryNode)){workingRange.setEndPoint(isStart?"EndToStart":"EndToEnd",textRange);var offset;if(/[\r\n]/.test(boundaryNode.data)){var tempRange=workingRange.duplicate();var rangeLength=tempRange.text.replace(/\r\n/g,"\r").length;offset=tempRange.moveStart("character",rangeLength);while((comparison=tempRange.compareEndPoints("StartToEnd",tempRange))==-1){offset++;tempRange.moveStart("character",1)}}else{offset=workingRange.text.length}boundaryPosition=new DomPosition(boundaryNode,offset)}else{log.debug("Range boundary is at node boundary");previousNode=(isCollapsed||!isStart)&&workingNode.previousSibling;nextNode=(isCollapsed||isStart)&&workingNode.nextSibling;log.info("workingNode: "+dom.inspectNode(workingNode));log.info("previousNode: "+dom.inspectNode(previousNode));log.info("nextNode: "+dom.inspectNode(nextNode));if(nextNode&&isCharacterDataNode(nextNode)){boundaryPosition=new DomPosition(nextNode,0)}else if(previousNode&&isCharacterDataNode(previousNode)){boundaryPosition=new DomPosition(previousNode,previousNode.data.length)}else{boundaryPosition=new DomPosition(containerElement,dom.getNodeIndex(workingNode))}}dom.removeNode(workingNode);return{boundaryPosition:boundaryPosition,nodeInfo:{nodeIndex:nodeIndex,containerElement:containerElement}}};var createBoundaryTextRange=function(boundaryPosition,isStart){var boundaryNode,boundaryParent,boundaryOffset=boundaryPosition.offset;var doc=dom.getDocument(boundaryPosition.node);var workingNode,childNodes,workingRange=getBody(doc).createTextRange();var nodeIsDataNode=isCharacterDataNode(boundaryPosition.node);if(nodeIsDataNode){boundaryNode=boundaryPosition.node;boundaryParent=boundaryNode.parentNode}else{childNodes=boundaryPosition.node.childNodes;boundaryNode=boundaryOffset<childNodes.length?childNodes[boundaryOffset]:null;boundaryParent=boundaryPosition.node}workingNode=doc.createElement("span");workingNode.innerHTML="&#feff;";if(boundaryNode){boundaryParent.insertBefore(workingNode,boundaryNode)}else{boundaryParent.appendChild(workingNode)}workingRange.moveToElementText(workingNode);workingRange.collapse(!isStart);boundaryParent.removeChild(workingNode);if(nodeIsDataNode){workingRange[isStart?"moveStart":"moveEnd"]("character",boundaryOffset)}return workingRange};WrappedTextRange=function(textRange){this.textRange=textRange;this.refresh()};WrappedTextRange.prototype=new DomRange(document);WrappedTextRange.prototype.refresh=function(){var start,end,startBoundary;var rangeContainerElement=getTextRangeContainerElement(this.textRange);if(textRangeIsCollapsed(this.textRange)){end=start=getTextRangeBoundaryPosition(this.textRange,rangeContainerElement,true,true).boundaryPosition}else{log.debug("Refreshing Range from TextRange. parent element: "+dom.inspectNode(rangeContainerElement)+", parentElement(): "+dom.inspectNode(this.textRange.parentElement()));startBoundary=getTextRangeBoundaryPosition(this.textRange,rangeContainerElement,true,false);start=startBoundary.boundaryPosition;end=getTextRangeBoundaryPosition(this.textRange,rangeContainerElement,false,false,startBoundary.nodeInfo).boundaryPosition}this.setStart(start.node,start.offset);this.setEnd(end.node,end.offset)};WrappedTextRange.prototype.getName=function(){return"WrappedTextRange"};DomRange.copyComparisonConstants(WrappedTextRange);var rangeToTextRange=function(range){if(range.collapsed){return createBoundaryTextRange(new DomPosition(range.startContainer,range.startOffset),true)}else{var startRange=createBoundaryTextRange(new DomPosition(range.startContainer,range.startOffset),true);var endRange=createBoundaryTextRange(new DomPosition(range.endContainer,range.endOffset),false);var textRange=getBody(DomRange.getRangeDocument(range)).createTextRange();textRange.setEndPoint("StartToStart",startRange);textRange.setEndPoint("EndToEnd",endRange);return textRange}};WrappedTextRange.rangeToTextRange=rangeToTextRange;WrappedTextRange.prototype.toTextRange=function(){return rangeToTextRange(this)};api.WrappedTextRange=WrappedTextRange;if(!api.features.implementsDomRange||api.config.preferTextRange){var globalObj=function(f){return f("return this;")()}(Function);if(typeof globalObj.Range=="undefined"){globalObj.Range=WrappedTextRange}api.createNativeRange=function(doc){doc=getContentDocument(doc,module,"createNativeRange");return getBody(doc).createTextRange()};api.WrappedRange=WrappedTextRange}}api.createRange=function(doc){doc=getContentDocument(doc,module,"createRange");return new api.WrappedRange(api.createNativeRange(doc))};api.createRangyRange=function(doc){doc=getContentDocument(doc,module,"createRangyRange");return new DomRange(doc)};util.createAliasForDeprecatedMethod(api,"createIframeRange","createRange");util.createAliasForDeprecatedMethod(api,"createIframeRangyRange","createRangyRange");api.addShimListener(function(win){var doc=win.document;if(typeof doc.createRange=="undefined"){doc.createRange=function(){return api.createRange(doc)}}doc=win=null})});rangy.createCoreModule("WrappedSelection",["DomRange","WrappedRange"],function(api,module){api.config.checkSelectionRanges=true;var BOOLEAN="boolean";var NUMBER="number";var dom=api.dom;var util=api.util;var isHostMethod=util.isHostMethod;var DomRange=api.DomRange;var WrappedRange=api.WrappedRange;var DOMException=api.DOMException;var DomPosition=dom.DomPosition;var getNativeSelection;var selectionIsCollapsed;var features=api.features;var CONTROL="Control";var getDocument=dom.getDocument;var getBody=dom.getBody;var rangesEqual=DomRange.rangesEqual;var log=log4javascript.getLogger("rangy.WrappedSelection");function isDirectionBackward(dir){return typeof dir=="string"?/^backward(s)?$/i.test(dir):!!dir}function getWindow(win,methodName){if(!win){return window}else if(dom.isWindow(win)){return win}else if(win instanceof WrappedSelection){return win.win}else{var doc=dom.getContentDocument(win,module,methodName);return dom.getWindow(doc)}}function getWinSelection(winParam){return getWindow(winParam,"getWinSelection").getSelection()}function getDocSelection(winParam){return getWindow(winParam,"getDocSelection").document.selection}function winSelectionIsBackward(sel){var backward=false;if(sel.anchorNode){backward=dom.comparePoints(sel.anchorNode,sel.anchorOffset,sel.focusNode,sel.focusOffset)==1}return backward}var implementsWinGetSelection=isHostMethod(window,"getSelection"),implementsDocSelection=util.isHostObject(document,"selection");features.implementsWinGetSelection=implementsWinGetSelection;features.implementsDocSelection=implementsDocSelection;var useDocumentSelection=implementsDocSelection&&(!implementsWinGetSelection||api.config.preferTextRange);if(useDocumentSelection){getNativeSelection=getDocSelection;api.isSelectionValid=function(winParam){var doc=getWindow(winParam,"isSelectionValid").document,nativeSel=doc.selection;return nativeSel.type!="None"||getDocument(nativeSel.createRange().parentElement())==doc}}else if(implementsWinGetSelection){getNativeSelection=getWinSelection;api.isSelectionValid=function(){return true}}else{module.fail("Neither document.selection or window.getSelection() detected.");return false}api.getNativeSelection=getNativeSelection;var testSelection=getNativeSelection();if(!testSelection){module.fail("Native selection was null (possibly issue 138?)");return false}var testRange=api.createNativeRange(document);var body=getBody(document);var selectionHasAnchorAndFocus=util.areHostProperties(testSelection,["anchorNode","focusNode","anchorOffset","focusOffset"]);features.selectionHasAnchorAndFocus=selectionHasAnchorAndFocus;var selectionHasExtend=isHostMethod(testSelection,"extend");features.selectionHasExtend=selectionHasExtend;var selectionHasRangeCount=typeof testSelection.rangeCount==NUMBER;features.selectionHasRangeCount=selectionHasRangeCount;var selectionSupportsMultipleRanges=false;var collapsedNonEditableSelectionsSupported=true;var addRangeBackwardToNative=selectionHasExtend?function(nativeSelection,range){var doc=DomRange.getRangeDocument(range);var endRange=api.createRange(doc);endRange.collapseToPoint(range.endContainer,range.endOffset);nativeSelection.addRange(getNativeRange(endRange));nativeSelection.extend(range.startContainer,range.startOffset)}:null;if(util.areHostMethods(testSelection,["addRange","getRangeAt","removeAllRanges"])&&typeof testSelection.rangeCount==NUMBER&&features.implementsDomRange){(function(){var sel=window.getSelection();if(sel){var originalSelectionRangeCount=sel.rangeCount;var selectionHasMultipleRanges=originalSelectionRangeCount>1;var originalSelectionRanges=[];var originalSelectionBackward=winSelectionIsBackward(sel);for(var i=0;i<originalSelectionRangeCount;++i){originalSelectionRanges[i]=sel.getRangeAt(i)}var testEl=dom.createTestElement(document,"",false);var textNode=testEl.appendChild(document.createTextNode("   "));var r1=document.createRange();r1.setStart(textNode,1);r1.collapse(true);sel.removeAllRanges();sel.addRange(r1);collapsedNonEditableSelectionsSupported=sel.rangeCount==1;sel.removeAllRanges();if(!selectionHasMultipleRanges){var chromeMatch=window.navigator.appVersion.match(/Chrome\/(.*?) /);if(chromeMatch&&parseInt(chromeMatch[1])>=36){selectionSupportsMultipleRanges=false}else{var r2=r1.cloneRange();r1.setStart(textNode,0);r2.setEnd(textNode,3);r2.setStart(textNode,2);sel.addRange(r1);sel.addRange(r2);selectionSupportsMultipleRanges=sel.rangeCount==2}}dom.removeNode(testEl);sel.removeAllRanges();for(i=0;i<originalSelectionRangeCount;++i){if(i==0&&originalSelectionBackward){if(addRangeBackwardToNative){addRangeBackwardToNative(sel,originalSelectionRanges[i])}else{api.warn("Rangy initialization: original selection was backwards but selection has been restored forwards because the browser does not support Selection.extend");sel.addRange(originalSelectionRanges[i])}}else{sel.addRange(originalSelectionRanges[i])}}}})()}features.selectionSupportsMultipleRanges=selectionSupportsMultipleRanges;features.collapsedNonEditableSelectionsSupported=collapsedNonEditableSelectionsSupported;var implementsControlRange=false,testControlRange;if(body&&isHostMethod(body,"createControlRange")){testControlRange=body.createControlRange();

if(util.areHostProperties(testControlRange,["item","add"])){implementsControlRange=true}}features.implementsControlRange=implementsControlRange;if(selectionHasAnchorAndFocus){selectionIsCollapsed=function(sel){return sel.anchorNode===sel.focusNode&&sel.anchorOffset===sel.focusOffset}}else{selectionIsCollapsed=function(sel){return sel.rangeCount?sel.getRangeAt(sel.rangeCount-1).collapsed:false}}function updateAnchorAndFocusFromRange(sel,range,backward){var anchorPrefix=backward?"end":"start",focusPrefix=backward?"start":"end";sel.anchorNode=range[anchorPrefix+"Container"];sel.anchorOffset=range[anchorPrefix+"Offset"];sel.focusNode=range[focusPrefix+"Container"];sel.focusOffset=range[focusPrefix+"Offset"]}function updateAnchorAndFocusFromNativeSelection(sel){var nativeSel=sel.nativeSelection;sel.anchorNode=nativeSel.anchorNode;sel.anchorOffset=nativeSel.anchorOffset;sel.focusNode=nativeSel.focusNode;sel.focusOffset=nativeSel.focusOffset}function updateEmptySelection(sel){sel.anchorNode=sel.focusNode=null;sel.anchorOffset=sel.focusOffset=0;sel.rangeCount=0;sel.isCollapsed=true;sel._ranges.length=0}function getNativeRange(range){var nativeRange;if(range instanceof DomRange){nativeRange=api.createNativeRange(range.getDocument());nativeRange.setEnd(range.endContainer,range.endOffset);nativeRange.setStart(range.startContainer,range.startOffset)}else if(range instanceof WrappedRange){nativeRange=range.nativeRange}else if(features.implementsDomRange&&range instanceof dom.getWindow(range.startContainer).Range){nativeRange=range}return nativeRange}function rangeContainsSingleElement(rangeNodes){if(!rangeNodes.length||rangeNodes[0].nodeType!=1){return false}for(var i=1,len=rangeNodes.length;i<len;++i){if(!dom.isAncestorOf(rangeNodes[0],rangeNodes[i])){return false}}return true}function getSingleElementFromRange(range){var nodes=range.getNodes();if(!rangeContainsSingleElement(nodes)){throw module.createError("getSingleElementFromRange: range "+range.inspect()+" did not consist of a single element")}return nodes[0]}function isTextRange(range){return!!range&&typeof range.text!="undefined"}function updateFromTextRange(sel,range){var wrappedRange=new WrappedRange(range);sel._ranges=[wrappedRange];updateAnchorAndFocusFromRange(sel,wrappedRange,false);sel.rangeCount=1;sel.isCollapsed=wrappedRange.collapsed}function updateControlSelection(sel){sel._ranges.length=0;if(sel.docSelection.type=="None"){updateEmptySelection(sel)}else{var controlRange=sel.docSelection.createRange();if(isTextRange(controlRange)){updateFromTextRange(sel,controlRange)}else{sel.rangeCount=controlRange.length;var range,doc=getDocument(controlRange.item(0));for(var i=0;i<sel.rangeCount;++i){range=api.createRange(doc);range.selectNode(controlRange.item(i));sel._ranges.push(range)}sel.isCollapsed=sel.rangeCount==1&&sel._ranges[0].collapsed;updateAnchorAndFocusFromRange(sel,sel._ranges[sel.rangeCount-1],false)}}}function addRangeToControlSelection(sel,range){var controlRange=sel.docSelection.createRange();var rangeElement=getSingleElementFromRange(range);var doc=getDocument(controlRange.item(0));var newControlRange=getBody(doc).createControlRange();for(var i=0,len=controlRange.length;i<len;++i){newControlRange.add(controlRange.item(i))}try{newControlRange.add(rangeElement)}catch(ex){throw module.createError("addRange(): Element within the specified Range could not be added to control selection (does it have layout?)")}newControlRange.select();updateControlSelection(sel)}var getSelectionRangeAt;if(isHostMethod(testSelection,"getRangeAt")){getSelectionRangeAt=function(sel,index){try{return sel.getRangeAt(index)}catch(ex){return null}}}else if(selectionHasAnchorAndFocus){getSelectionRangeAt=function(sel){var doc=getDocument(sel.anchorNode);var range=api.createRange(doc);range.setStartAndEnd(sel.anchorNode,sel.anchorOffset,sel.focusNode,sel.focusOffset);if(range.collapsed!==this.isCollapsed){range.setStartAndEnd(sel.focusNode,sel.focusOffset,sel.anchorNode,sel.anchorOffset)}return range}}function WrappedSelection(selection,docSelection,win){this.nativeSelection=selection;this.docSelection=docSelection;this._ranges=[];this.win=win;this.refresh()}WrappedSelection.prototype=api.selectionPrototype;function deleteProperties(sel){sel.win=sel.anchorNode=sel.focusNode=sel._ranges=null;sel.rangeCount=sel.anchorOffset=sel.focusOffset=0;sel.detached=true}var cachedRangySelections=[];function actOnCachedSelection(win,action){var i=cachedRangySelections.length,cached,sel;while(i--){cached=cachedRangySelections[i];sel=cached.selection;if(action=="deleteAll"){deleteProperties(sel)}else if(cached.win==win){if(action=="delete"){cachedRangySelections.splice(i,1);return true}else{return sel}}}if(action=="deleteAll"){cachedRangySelections.length=0}return null}var getSelection=function(win){if(win&&win instanceof WrappedSelection){win.refresh();return win}win=getWindow(win,"getNativeSelection");var sel=actOnCachedSelection(win);var nativeSel=getNativeSelection(win),docSel=implementsDocSelection?getDocSelection(win):null;if(sel){sel.nativeSelection=nativeSel;sel.docSelection=docSel;sel.refresh()}else{sel=new WrappedSelection(nativeSel,docSel,win);cachedRangySelections.push({win:win,selection:sel})}return sel};api.getSelection=getSelection;util.createAliasForDeprecatedMethod(api,"getIframeSelection","getSelection");var selProto=WrappedSelection.prototype;function createControlSelection(sel,ranges){var doc=getDocument(ranges[0].startContainer);var controlRange=getBody(doc).createControlRange();for(var i=0,el,len=ranges.length;i<len;++i){el=getSingleElementFromRange(ranges[i]);try{controlRange.add(el)}catch(ex){throw module.createError("setRanges(): Element within one of the specified Ranges could not be added to control selection (does it have layout?)")}}controlRange.select();updateControlSelection(sel)}if(!useDocumentSelection&&selectionHasAnchorAndFocus&&util.areHostMethods(testSelection,["removeAllRanges","addRange"])){selProto.removeAllRanges=function(){this.nativeSelection.removeAllRanges();updateEmptySelection(this)};var addRangeBackward=function(sel,range){addRangeBackwardToNative(sel.nativeSelection,range);sel.refresh()};if(selectionHasRangeCount){selProto.addRange=function(range,direction){if(implementsControlRange&&implementsDocSelection&&this.docSelection.type==CONTROL){addRangeToControlSelection(this,range)}else{if(isDirectionBackward(direction)&&selectionHasExtend){addRangeBackward(this,range)}else{var previousRangeCount;if(selectionSupportsMultipleRanges){previousRangeCount=this.rangeCount}else{this.removeAllRanges();previousRangeCount=0}var clonedNativeRange=getNativeRange(range).cloneRange();try{this.nativeSelection.addRange(clonedNativeRange)}catch(ex){log.error("Native addRange threw error '"+ex+"' with range "+DomRange.inspect(clonedNativeRange),ex)}this.rangeCount=this.nativeSelection.rangeCount;if(this.rangeCount==previousRangeCount+1){if(api.config.checkSelectionRanges){var nativeRange=getSelectionRangeAt(this.nativeSelection,this.rangeCount-1);if(nativeRange&&!rangesEqual(nativeRange,range)){range=new WrappedRange(nativeRange)}}this._ranges[this.rangeCount-1]=range;updateAnchorAndFocusFromRange(this,range,selectionIsBackward(this.nativeSelection));this.isCollapsed=selectionIsCollapsed(this)}else{this.refresh()}}}}}else{selProto.addRange=function(range,direction){if(isDirectionBackward(direction)&&selectionHasExtend){addRangeBackward(this,range)}else{this.nativeSelection.addRange(getNativeRange(range));this.refresh()}}}selProto.setRanges=function(ranges){if(implementsControlRange&&implementsDocSelection&&ranges.length>1){createControlSelection(this,ranges)}else{this.removeAllRanges();for(var i=0,len=ranges.length;i<len;++i){this.addRange(ranges[i])}}}}else if(isHostMethod(testSelection,"empty")&&isHostMethod(testRange,"select")&&implementsControlRange&&useDocumentSelection){selProto.removeAllRanges=function(){try{this.docSelection.empty();if(this.docSelection.type!="None"){var doc;if(this.anchorNode){doc=getDocument(this.anchorNode)}else if(this.docSelection.type==CONTROL){var controlRange=this.docSelection.createRange();if(controlRange.length){doc=getDocument(controlRange.item(0))}}if(doc){var textRange=getBody(doc).createTextRange();textRange.select();this.docSelection.empty()}}}catch(ex){}updateEmptySelection(this)};selProto.addRange=function(range){if(this.docSelection.type==CONTROL){addRangeToControlSelection(this,range)}else{api.WrappedTextRange.rangeToTextRange(range).select();this._ranges[0]=range;this.rangeCount=1;this.isCollapsed=this._ranges[0].collapsed;updateAnchorAndFocusFromRange(this,range,false)}};selProto.setRanges=function(ranges){this.removeAllRanges();var rangeCount=ranges.length;if(rangeCount>1){createControlSelection(this,ranges)}else if(rangeCount){this.addRange(ranges[0])}}}else{module.fail("No means of selecting a Range or TextRange was found");return false}selProto.getRangeAt=function(index){if(index<0||index>=this.rangeCount){throw new DOMException("INDEX_SIZE_ERR")}else{return this._ranges[index].cloneRange()}};var refreshSelection;if(useDocumentSelection){refreshSelection=function(sel){var range;if(api.isSelectionValid(sel.win)){range=sel.docSelection.createRange()}else{range=getBody(sel.win.document).createTextRange();range.collapse(true)}log.warn("selection refresh called, selection type: "+sel.docSelection.type);if(sel.docSelection.type==CONTROL){updateControlSelection(sel)}else if(isTextRange(range)){updateFromTextRange(sel,range)}else{updateEmptySelection(sel)}}}else if(isHostMethod(testSelection,"getRangeAt")&&typeof testSelection.rangeCount==NUMBER){refreshSelection=function(sel){if(implementsControlRange&&implementsDocSelection&&sel.docSelection.type==CONTROL){updateControlSelection(sel)}else{sel._ranges.length=sel.rangeCount=sel.nativeSelection.rangeCount;if(sel.rangeCount){for(var i=0,len=sel.rangeCount;i<len;++i){sel._ranges[i]=new api.WrappedRange(sel.nativeSelection.getRangeAt(i))}updateAnchorAndFocusFromRange(sel,sel._ranges[sel.rangeCount-1],selectionIsBackward(sel.nativeSelection));sel.isCollapsed=selectionIsCollapsed(sel)}else{updateEmptySelection(sel)}}}}else if(selectionHasAnchorAndFocus&&typeof testSelection.isCollapsed==BOOLEAN&&typeof testRange.collapsed==BOOLEAN&&features.implementsDomRange){refreshSelection=function(sel){var range,nativeSel=sel.nativeSelection;if(nativeSel.anchorNode){range=getSelectionRangeAt(nativeSel,0);sel._ranges=[range];sel.rangeCount=1;updateAnchorAndFocusFromNativeSelection(sel);sel.isCollapsed=selectionIsCollapsed(sel)}else{updateEmptySelection(sel)}}}else{module.fail("No means of obtaining a Range or TextRange from the user's selection was found");return false}selProto.refresh=function(checkForChanges){var oldRanges=checkForChanges?this._ranges.slice(0):null;var oldAnchorNode=this.anchorNode,oldAnchorOffset=this.anchorOffset;refreshSelection(this);if(checkForChanges){var i=oldRanges.length;if(i!=this._ranges.length){log.debug("Selection.refresh: Range count has changed: was "+i+", is now "+this._ranges.length);return true}if(this.anchorNode!=oldAnchorNode||this.anchorOffset!=oldAnchorOffset){log.debug("Selection.refresh: anchor different, so selection has changed");return true}while(i--){if(!rangesEqual(oldRanges[i],this._ranges[i])){log.debug("Selection.refresh: Range at index "+i+" has changed: was "+oldRanges[i].inspect()+", is now "+this._ranges[i].inspect());return true}}return false}};var removeRangeManually=function(sel,range){var ranges=sel.getAllRanges();sel.removeAllRanges();for(var i=0,len=ranges.length;i<len;++i){if(!rangesEqual(range,ranges[i])){sel.addRange(ranges[i])}}if(!sel.rangeCount){updateEmptySelection(sel)}};if(implementsControlRange&&implementsDocSelection){selProto.removeRange=function(range){if(this.docSelection.type==CONTROL){var controlRange=this.docSelection.createRange();var rangeElement=getSingleElementFromRange(range);var doc=getDocument(controlRange.item(0));var newControlRange=getBody(doc).createControlRange();var el,removed=false;for(var i=0,len=controlRange.length;i<len;++i){el=controlRange.item(i);if(el!==rangeElement||removed){newControlRange.add(controlRange.item(i))}else{removed=true}}newControlRange.select();updateControlSelection(this)}else{removeRangeManually(this,range)}}}else{selProto.removeRange=function(range){removeRangeManually(this,range)}}var selectionIsBackward;if(!useDocumentSelection&&selectionHasAnchorAndFocus&&features.implementsDomRange){selectionIsBackward=winSelectionIsBackward;selProto.isBackward=function(){return selectionIsBackward(this)}}else{selectionIsBackward=selProto.isBackward=function(){return false}}selProto.isBackwards=selProto.isBackward;selProto.toString=function(){log.debug("selection toString called");var rangeTexts=[];for(var i=0,len=this.rangeCount;i<len;++i){rangeTexts[i]=""+this._ranges[i]}return rangeTexts.join("")};function assertNodeInSameDocument(sel,node){if(sel.win.document!=getDocument(node)){throw new DOMException("WRONG_DOCUMENT_ERR")}}selProto.collapse=function(node,offset){assertNodeInSameDocument(this,node);var range=api.createRange(node);range.collapseToPoint(node,offset);this.setSingleRange(range);this.isCollapsed=true};selProto.collapseToStart=function(){if(this.rangeCount){var range=this._ranges[0];this.collapse(range.startContainer,range.startOffset)}else{throw new DOMException("INVALID_STATE_ERR")}};selProto.collapseToEnd=function(){if(this.rangeCount){var range=this._ranges[this.rangeCount-1];this.collapse(range.endContainer,range.endOffset)}else{throw new DOMException("INVALID_STATE_ERR")}};selProto.selectAllChildren=function(node){assertNodeInSameDocument(this,node);var range=api.createRange(node);range.selectNodeContents(node);this.setSingleRange(range)};selProto.deleteFromDocument=function(){if(implementsControlRange&&implementsDocSelection&&this.docSelection.type==CONTROL){var controlRange=this.docSelection.createRange();var element;while(controlRange.length){element=controlRange.item(0);controlRange.remove(element);dom.removeNode(element)}this.refresh()}else if(this.rangeCount){var ranges=this.getAllRanges();if(ranges.length){this.removeAllRanges();for(var i=0,len=ranges.length;i<len;++i){ranges[i].deleteContents()}this.addRange(ranges[len-1])}}};selProto.eachRange=function(func,returnValue){for(var i=0,len=this._ranges.length;i<len;++i){if(func(this.getRangeAt(i))){return returnValue}}};selProto.getAllRanges=function(){var ranges=[];this.eachRange(function(range){ranges.push(range)});return ranges};selProto.setSingleRange=function(range,direction){this.removeAllRanges();this.addRange(range,direction)};selProto.callMethodOnEachRange=function(methodName,params){var results=[];this.eachRange(function(range){results.push(range[methodName].apply(range,params||[]))});return results};function createStartOrEndSetter(isStart){return function(node,offset){var range;if(this.rangeCount){range=this.getRangeAt(0);range["set"+(isStart?"Start":"End")](node,offset)}else{range=api.createRange(this.win.document);range.setStartAndEnd(node,offset)}this.setSingleRange(range,this.isBackward())}}selProto.setStart=createStartOrEndSetter(true);selProto.setEnd=createStartOrEndSetter(false);api.rangePrototype.select=function(direction){getSelection(this.getDocument()).setSingleRange(this,direction)};selProto.changeEachRange=function(func){var ranges=[];var backward=this.isBackward();this.eachRange(function(range){func(range);ranges.push(range)});this.removeAllRanges();if(backward&&ranges.length==1){this.addRange(ranges[0],"backward")}else{this.setRanges(ranges)}};selProto.containsNode=function(node,allowPartial){return this.eachRange(function(range){return range.containsNode(node,allowPartial)},true)||false};selProto.getBookmark=function(containerNode){return{backward:this.isBackward(),rangeBookmarks:this.callMethodOnEachRange("getBookmark",[containerNode])}};selProto.moveToBookmark=function(bookmark){var selRanges=[];for(var i=0,rangeBookmark,range;rangeBookmark=bookmark.rangeBookmarks[i++];){range=api.createRange(this.win);range.moveToBookmark(rangeBookmark);selRanges.push(range)}if(bookmark.backward){this.setSingleRange(selRanges[0],"backward")}else{this.setRanges(selRanges)}};selProto.saveRanges=function(){return{backward:this.isBackward(),ranges:this.callMethodOnEachRange("cloneRange")}};selProto.restoreRanges=function(selRanges){this.removeAllRanges();for(var i=0,range;range=selRanges.ranges[i];++i){this.addRange(range,selRanges.backward&&i==0)}};selProto.toHtml=function(){var rangeHtmls=[];this.eachRange(function(range){rangeHtmls.push(DomRange.toHtml(range))});return rangeHtmls.join("")};if(features.implementsTextRange){selProto.getNativeTextRange=function(){var sel,textRange;if(sel=this.docSelection){var range=sel.createRange();if(isTextRange(range)){return range}else{throw module.createError("getNativeTextRange: selection is a control selection")}}else if(this.rangeCount>0){return api.WrappedTextRange.rangeToTextRange(this.getRangeAt(0))}else{throw module.createError("getNativeTextRange: selection contains no range")}}}function inspect(sel){var rangeInspects=[];var anchor=new DomPosition(sel.anchorNode,sel.anchorOffset);var focus=new DomPosition(sel.focusNode,sel.focusOffset);var name=typeof sel.getName=="function"?sel.getName():"Selection";if(typeof sel.rangeCount!="undefined"){for(var i=0,len=sel.rangeCount;i<len;++i){rangeInspects[i]=DomRange.inspect(sel.getRangeAt(i))}}return"["+name+"(Ranges: "+rangeInspects.join(", ")+")(anchor: "+anchor.inspect()+", focus: "+focus.inspect()+"]"}selProto.getName=function(){return"WrappedSelection"};selProto.inspect=function(){return inspect(this)};selProto.detach=function(){actOnCachedSelection(this.win,"delete");deleteProperties(this)};WrappedSelection.detachAll=function(){actOnCachedSelection(null,"deleteAll")};WrappedSelection.inspect=inspect;WrappedSelection.isDirectionBackward=isDirectionBackward;api.Selection=WrappedSelection;api.selectionPrototype=selProto;api.addShimListener(function(win){if(typeof win.getSelection=="undefined"){win.getSelection=function(){return getSelection(win)}}win=null})});rangy.createModule("ClassApplier",["WrappedSelection"],function(api,module){var dom=api.dom;var DomPosition=dom.DomPosition;var contains=dom.arrayContains;var util=api.util;var forEach=util.forEach;var log=log4javascript.getLogger("rangy.classapplier");var defaultTagName="span";var createElementNSSupported=util.isHostMethod(document,"createElementNS");function each(obj,func){for(var i in obj){if(obj.hasOwnProperty(i)){if(func(i,obj[i])===false){return false}}}return true}function trim(str){return str.replace(/^\s\s*/,"").replace(/\s\s*$/,"")}function classNameContainsClass(fullClassName,className){return!!fullClassName&&new RegExp("(?:^|\\s)"+className+"(?:\\s|$)").test(fullClassName)}function hasClass(el,className){if(typeof el.classList=="object"){return el.classList.contains(className)}else{var classNameSupported=typeof el.className=="string";var elClass=classNameSupported?el.className:el.getAttribute("class");return classNameContainsClass(elClass,className)}}function addClass(el,className){if(typeof el.classList=="object"){el.classList.add(className)}else{var classNameSupported=typeof el.className=="string";var elClass=classNameSupported?el.className:el.getAttribute("class");if(elClass){if(!classNameContainsClass(elClass,className)){elClass+=" "+className}}else{elClass=className}if(classNameSupported){el.className=elClass}else{el.setAttribute("class",elClass)}}}var removeClass=function(){function replacer(matched,whiteSpaceBefore,whiteSpaceAfter){return whiteSpaceBefore&&whiteSpaceAfter?" ":""}return function(el,className){if(typeof el.classList=="object"){el.classList.remove(className)}else{var classNameSupported=typeof el.className=="string";var elClass=classNameSupported?el.className:el.getAttribute("class");elClass=elClass.replace(new RegExp("(^|\\s)"+className+"(\\s|$)"),replacer);if(classNameSupported){el.className=elClass}else{el.setAttribute("class",elClass)}}}}();function getClass(el){var classNameSupported=typeof el.className=="string";return classNameSupported?el.className:el.getAttribute("class")}function sortClassName(className){return className&&className.split(/\s+/).sort().join(" ")}function getSortedClassName(el){return sortClassName(getClass(el))}function haveSameClasses(el1,el2){return getSortedClassName(el1)==getSortedClassName(el2)}function hasAllClasses(el,className){var classes=className.split(/\s+/);for(var i=0,len=classes.length;i<len;++i){if(!hasClass(el,trim(classes[i]))){return false}}return true}function canTextBeStyled(textNode){var parent=textNode.parentNode;return parent&&parent.nodeType==1&&!/^(textarea|style|script|select|iframe)$/i.test(parent.nodeName)}function movePosition(position,oldParent,oldIndex,newParent,newIndex){var posNode=position.node,posOffset=position.offset;var newNode=posNode,newOffset=posOffset;if(posNode==newParent&&posOffset>newIndex){++newOffset}if(posNode==oldParent&&(posOffset==oldIndex||posOffset==oldIndex+1)){newNode=newParent;newOffset+=newIndex-oldIndex}if(posNode==oldParent&&posOffset>oldIndex+1){--newOffset}position.node=newNode;position.offset=newOffset}function movePositionWhenRemovingNode(position,parentNode,index){log.debug("movePositionWhenRemovingNode "+position,position.node==parentNode,position.offset,index);if(position.node==parentNode&&position.offset>index){--position.offset}}function movePreservingPositions(node,newParent,newIndex,positionsToPreserve){log.group("movePreservingPositions "+dom.inspectNode(node)+" to index "+newIndex+" in "+dom.inspectNode(newParent),positionsToPreserve);if(newIndex==-1){newIndex=newParent.childNodes.length}var oldParent=node.parentNode;var oldIndex=dom.getNodeIndex(node);forEach(positionsToPreserve,function(position){movePosition(position,oldParent,oldIndex,newParent,newIndex)});if(newParent.childNodes.length==newIndex){newParent.appendChild(node)}else{newParent.insertBefore(node,newParent.childNodes[newIndex])}log.groupEnd()}function removePreservingPositions(node,positionsToPreserve){log.group("removePreservingPositions "+dom.inspectNode(node),positionsToPreserve);var oldParent=node.parentNode;var oldIndex=dom.getNodeIndex(node);forEach(positionsToPreserve,function(position){movePositionWhenRemovingNode(position,oldParent,oldIndex)});dom.removeNode(node);log.groupEnd()}function moveChildrenPreservingPositions(node,newParent,newIndex,removeNode,positionsToPreserve){var child,children=[];while(child=node.firstChild){movePreservingPositions(child,newParent,newIndex++,positionsToPreserve);children.push(child)}if(removeNode){removePreservingPositions(node,positionsToPreserve)}return children}function replaceWithOwnChildrenPreservingPositions(element,positionsToPreserve){return moveChildrenPreservingPositions(element,element.parentNode,dom.getNodeIndex(element),true,positionsToPreserve)}function rangeSelectsAnyText(range,textNode){var textNodeRange=range.cloneRange();textNodeRange.selectNodeContents(textNode);var intersectionRange=textNodeRange.intersection(range);var text=intersectionRange?intersectionRange.toString():"";return text!=""}function getEffectiveTextNodes(range){var nodes=range.getNodes([3]);var start=0,node;while((node=nodes[start])&&!rangeSelectsAnyText(range,node)){++start}var end=nodes.length-1;while((node=nodes[end])&&!rangeSelectsAnyText(range,node)){--end}return nodes.slice(start,end+1)}function elementsHaveSameNonClassAttributes(el1,el2){if(el1.attributes.length!=el2.attributes.length)return false;for(var i=0,len=el1.attributes.length,attr1,attr2,name;i<len;++i){attr1=el1.attributes[i];name=attr1.name;if(name!="class"){attr2=el2.attributes.getNamedItem(name);if(attr1===null!=(attr2===null))return false;if(attr1.specified!=attr2.specified)return false;if(attr1.specified&&attr1.nodeValue!==attr2.nodeValue)return false}}return true}function elementHasNonClassAttributes(el,exceptions){for(var i=0,len=el.attributes.length,attrName;i<len;++i){attrName=el.attributes[i].name;if(!(exceptions&&contains(exceptions,attrName))&&el.attributes[i].specified&&attrName!="class"){return true}}return false}var getComputedStyleProperty=dom.getComputedStyleProperty;var isEditableElement=function(){var testEl=document.createElement("div");return typeof testEl.isContentEditable=="boolean"?function(node){return node&&node.nodeType==1&&node.isContentEditable}:function(node){if(!node||node.nodeType!=1||node.contentEditable=="false"){return false}return node.contentEditable=="true"||isEditableElement(node.parentNode)}}();function isEditingHost(node){var parent;return node&&node.nodeType==1&&((parent=node.parentNode)&&parent.nodeType==9&&parent.designMode=="on"||isEditableElement(node)&&!isEditableElement(node.parentNode))}function isEditable(node){return(isEditableElement(node)||node.nodeType!=1&&isEditableElement(node.parentNode))&&!isEditingHost(node)}var inlineDisplayRegex=/^inline(-block|-table)?$/i;function isNonInlineElement(node){return node&&node.nodeType==1&&!inlineDisplayRegex.test(getComputedStyleProperty(node,"display"))}var htmlNonWhiteSpaceRegex=/[^\r\n\t\f \u200B]/;function isUnrenderedWhiteSpaceNode(node){if(node.data.length==0){return true}if(htmlNonWhiteSpaceRegex.test(node.data)){return false}var cssWhiteSpace=getComputedStyleProperty(node.parentNode,"whiteSpace");switch(cssWhiteSpace){case"pre":case"pre-wrap":case"-moz-pre-wrap":return false;case"pre-line":if(/[\r\n]/.test(node.data)){return false}}return isNonInlineElement(node.previousSibling)||isNonInlineElement(node.nextSibling)}function getRangeBoundaries(ranges){var positions=[],i,range;for(i=0;range=ranges[i++];){positions.push(new DomPosition(range.startContainer,range.startOffset),new DomPosition(range.endContainer,range.endOffset))}return positions}function updateRangesFromBoundaries(ranges,positions){for(var i=0,range,start,end,len=ranges.length;i<len;++i){range=ranges[i];start=positions[i*2];end=positions[i*2+1];range.setStartAndEnd(start.node,start.offset,end.node,end.offset)}}function isSplitPoint(node,offset){if(dom.isCharacterDataNode(node)){if(offset==0){return!!node.previousSibling}else if(offset==node.length){return!!node.nextSibling}else{return true}}return offset>0&&offset<node.childNodes.length}function splitNodeAt(node,descendantNode,descendantOffset,positionsToPreserve){var newNode,parentNode;var splitAtStart=descendantOffset==0;if(dom.isAncestorOf(descendantNode,node)){log.info("splitNodeAt(): Descendant is ancestor of node");return node}if(dom.isCharacterDataNode(descendantNode)){var descendantIndex=dom.getNodeIndex(descendantNode);if(descendantOffset==0){descendantOffset=descendantIndex}else if(descendantOffset==descendantNode.length){descendantOffset=descendantIndex+1}else{throw module.createError("splitNodeAt() should not be called with offset in the middle of a data node ("+descendantOffset+" in "+descendantNode.data)}descendantNode=descendantNode.parentNode}if(isSplitPoint(descendantNode,descendantOffset)){newNode=descendantNode.cloneNode(false);parentNode=descendantNode.parentNode;if(newNode.id){newNode.removeAttribute("id")}var child,newChildIndex=0;while(child=descendantNode.childNodes[descendantOffset]){movePreservingPositions(child,newNode,newChildIndex++,positionsToPreserve)}movePreservingPositions(newNode,parentNode,dom.getNodeIndex(descendantNode)+1,positionsToPreserve);return descendantNode==node?newNode:splitNodeAt(node,parentNode,dom.getNodeIndex(newNode),positionsToPreserve)}else if(node!=descendantNode){newNode=descendantNode.parentNode;var newNodeIndex=dom.getNodeIndex(descendantNode);if(!splitAtStart){newNodeIndex++}return splitNodeAt(node,newNode,newNodeIndex,positionsToPreserve)}return node}function areElementsMergeable(el1,el2){return el1.namespaceURI==el2.namespaceURI&&el1.tagName.toLowerCase()==el2.tagName.toLowerCase()&&haveSameClasses(el1,el2)&&elementsHaveSameNonClassAttributes(el1,el2)&&getComputedStyleProperty(el1,"display")=="inline"&&getComputedStyleProperty(el2,"display")=="inline"}function createAdjacentMergeableTextNodeGetter(forward){var siblingPropName=forward?"nextSibling":"previousSibling";return function(textNode,checkParentElement){var el=textNode.parentNode;var adjacentNode=textNode[siblingPropName];if(adjacentNode){if(adjacentNode&&adjacentNode.nodeType==3){return adjacentNode}}else if(checkParentElement){adjacentNode=el[siblingPropName];log.info("adjacentNode: "+adjacentNode);if(adjacentNode&&adjacentNode.nodeType==1&&areElementsMergeable(el,adjacentNode)){var adjacentNodeChild=adjacentNode[forward?"firstChild":"lastChild"];if(adjacentNodeChild&&adjacentNodeChild.nodeType==3){return adjacentNodeChild}}}return null}}var getPreviousMergeableTextNode=createAdjacentMergeableTextNodeGetter(false),getNextMergeableTextNode=createAdjacentMergeableTextNodeGetter(true);function Merge(firstNode){this.isElementMerge=firstNode.nodeType==1;this.textNodes=[];var firstTextNode=this.isElementMerge?firstNode.lastChild:firstNode;if(firstTextNode){this.textNodes[0]=firstTextNode}}Merge.prototype={doMerge:function(positionsToPreserve){var textNodes=this.textNodes;var firstTextNode=textNodes[0];if(textNodes.length>1){var firstTextNodeIndex=dom.getNodeIndex(firstTextNode);var textParts=[],combinedTextLength=0,textNode,parent;forEach(textNodes,function(textNode,i){parent=textNode.parentNode;if(i>0){parent.removeChild(textNode);if(!parent.hasChildNodes()){dom.removeNode(parent)}if(positionsToPreserve){forEach(positionsToPreserve,function(position){if(position.node==textNode){position.node=firstTextNode;position.offset+=combinedTextLength}if(position.node==parent&&position.offset>firstTextNodeIndex){--position.offset;if(position.offset==firstTextNodeIndex+1&&i<len-1){position.node=firstTextNode;position.offset=combinedTextLength}}})}}textParts[i]=textNode.data;combinedTextLength+=textNode.data.length});firstTextNode.data=textParts.join("")}return firstTextNode.data},getLength:function(){var i=this.textNodes.length,len=0;while(i--){len+=this.textNodes[i].length}return len},toString:function(){var textParts=[];forEach(this.textNodes,function(textNode,i){textParts[i]="'"+textNode.data+"'"});return"[Merge("+textParts.join(",")+")]"}};var optionProperties=["elementTagName","ignoreWhiteSpace","applyToEditableOnly","useExistingElements","removeEmptyElements","onElementCreate"];var attrNamesForProperties={};function ClassApplier(className,options,tagNames){var normalize,i,len,propName,applier=this;applier.cssClass=applier.className=className;var elementPropertiesFromOptions=null,elementAttributes={};if(typeof options=="object"&&options!==null){if(typeof options.elementTagName!=="undefined"){options.elementTagName=options.elementTagName.toLowerCase()}tagNames=options.tagNames;elementPropertiesFromOptions=options.elementProperties;elementAttributes=options.elementAttributes;for(i=0;propName=optionProperties[i++];){if(options.hasOwnProperty(propName)){applier[propName]=options[propName]}}normalize=options.normalize}else{normalize=options}applier.normalize=typeof normalize=="undefined"?true:normalize;applier.attrExceptions=[];var el=document.createElement(applier.elementTagName);applier.elementProperties=applier.copyPropertiesToElement(elementPropertiesFromOptions,el,true);each(elementAttributes,function(attrName,attrValue){applier.attrExceptions.push(attrName);elementAttributes[attrName]=""+attrValue});applier.elementAttributes=elementAttributes;applier.elementSortedClassName=applier.elementProperties.hasOwnProperty("className")?sortClassName(applier.elementProperties.className+" "+className):className;applier.applyToAnyTagName=false;var type=typeof tagNames;if(type=="string"){if(tagNames=="*"){applier.applyToAnyTagName=true}else{applier.tagNames=trim(tagNames.toLowerCase()).split(/\s*,\s*/)}}else if(type=="object"&&typeof tagNames.length=="number"){applier.tagNames=[];for(i=0,len=tagNames.length;i<len;++i){if(tagNames[i]=="*"){applier.applyToAnyTagName=true}else{applier.tagNames.push(tagNames[i].toLowerCase())}}}else{applier.tagNames=[applier.elementTagName];

}}ClassApplier.prototype={elementTagName:defaultTagName,elementProperties:{},elementAttributes:{},ignoreWhiteSpace:true,applyToEditableOnly:false,useExistingElements:true,removeEmptyElements:true,onElementCreate:null,copyPropertiesToElement:function(props,el,createCopy){var s,elStyle,elProps={},elPropsStyle,propValue,elPropValue,attrName;for(var p in props){if(props.hasOwnProperty(p)){propValue=props[p];elPropValue=el[p];if(p=="className"){addClass(el,propValue);addClass(el,this.className);el[p]=sortClassName(el[p]);if(createCopy){elProps[p]=propValue}}else if(p=="style"){elStyle=elPropValue;if(createCopy){elProps[p]=elPropsStyle={}}for(s in props[p]){if(props[p].hasOwnProperty(s)){elStyle[s]=propValue[s];if(createCopy){elPropsStyle[s]=elStyle[s]}}}this.attrExceptions.push(p)}else{el[p]=propValue;if(createCopy){elProps[p]=el[p];attrName=attrNamesForProperties.hasOwnProperty(p)?attrNamesForProperties[p]:p;this.attrExceptions.push(attrName)}}}}return createCopy?elProps:""},copyAttributesToElement:function(attrs,el){for(var attrName in attrs){if(attrs.hasOwnProperty(attrName)&&!/^class(?:Name)?$/i.test(attrName)){el.setAttribute(attrName,attrs[attrName])}}},appliesToElement:function(el){return contains(this.tagNames,el.tagName.toLowerCase())},getEmptyElements:function(range){var applier=this;return range.getNodes([1],function(el){return applier.appliesToElement(el)&&!el.hasChildNodes()})},hasClass:function(node){return node.nodeType==1&&(this.applyToAnyTagName||this.appliesToElement(node))&&hasClass(node,this.className)},getSelfOrAncestorWithClass:function(node){while(node){if(this.hasClass(node)){return node}node=node.parentNode}return null},isModifiable:function(node){return!this.applyToEditableOnly||isEditable(node)},isIgnorableWhiteSpaceNode:function(node){return this.ignoreWhiteSpace&&node&&node.nodeType==3&&isUnrenderedWhiteSpaceNode(node)},postApply:function(textNodes,range,positionsToPreserve,isUndo){log.group("postApply "+range.toHtml());var firstNode=textNodes[0],lastNode=textNodes[textNodes.length-1];var merges=[],currentMerge;var rangeStartNode=firstNode,rangeEndNode=lastNode;var rangeStartOffset=0,rangeEndOffset=lastNode.length;var textNode,precedingTextNode;forEach(textNodes,function(textNode){precedingTextNode=getPreviousMergeableTextNode(textNode,!isUndo);log.debug("Checking for merge. text node: "+textNode.data+", parent: "+dom.inspectNode(textNode.parentNode)+", preceding: "+dom.inspectNode(precedingTextNode));if(precedingTextNode){if(!currentMerge){currentMerge=new Merge(precedingTextNode);merges.push(currentMerge)}currentMerge.textNodes.push(textNode);if(textNode===firstNode){rangeStartNode=currentMerge.textNodes[0];rangeStartOffset=rangeStartNode.length}if(textNode===lastNode){rangeEndNode=currentMerge.textNodes[0];rangeEndOffset=currentMerge.getLength()}}else{currentMerge=null}});var nextTextNode=getNextMergeableTextNode(lastNode,!isUndo);if(nextTextNode){if(!currentMerge){currentMerge=new Merge(lastNode);merges.push(currentMerge)}currentMerge.textNodes.push(nextTextNode)}if(merges.length){log.info("Merging. Merges:",merges);for(i=0,len=merges.length;i<len;++i){merges[i].doMerge(positionsToPreserve)}log.info(rangeStartNode.nodeValue,rangeStartOffset,rangeEndNode.nodeValue,rangeEndOffset);range.setStartAndEnd(rangeStartNode,rangeStartOffset,rangeEndNode,rangeEndOffset);log.info("Range after merge: "+range.inspect())}log.groupEnd()},createContainer:function(parentNode){log.debug("createContainer with namespace "+parentNode.namespaceURI);var doc=dom.getDocument(parentNode);var namespace;var el=createElementNSSupported&&!dom.isHtmlNamespace(parentNode)&&(namespace=parentNode.namespaceURI)?doc.createElementNS(parentNode.namespaceURI,this.elementTagName):doc.createElement(this.elementTagName);this.copyPropertiesToElement(this.elementProperties,el,false);this.copyAttributesToElement(this.elementAttributes,el);addClass(el,this.className);if(this.onElementCreate){this.onElementCreate(el,this)}return el},elementHasProperties:function(el,props){var applier=this;return each(props,function(p,propValue){if(p=="className"){return hasAllClasses(el,propValue)}else if(typeof propValue=="object"){if(!applier.elementHasProperties(el[p],propValue)){return false}}else if(el[p]!==propValue){return false}})},elementHasAttributes:function(el,attrs){return each(attrs,function(name,value){if(el.getAttribute(name)!==value){return false}})},applyToTextNode:function(textNode,positionsToPreserve){log.group("Apply class '"+this.className+"'. textNode: "+textNode.data);log.info("Apply class  '"+this.className+"'. textNode: "+textNode.data);if(canTextBeStyled(textNode)){var parent=textNode.parentNode;if(parent.childNodes.length==1&&this.useExistingElements&&this.appliesToElement(parent)&&this.elementHasProperties(parent,this.elementProperties)&&this.elementHasAttributes(parent,this.elementAttributes)){addClass(parent,this.className)}else{var textNodeParent=textNode.parentNode;var el=this.createContainer(textNodeParent);textNodeParent.insertBefore(el,textNode);el.appendChild(textNode)}}log.groupEnd()},isRemovable:function(el){return el.tagName.toLowerCase()==this.elementTagName&&getSortedClassName(el)==this.elementSortedClassName&&this.elementHasProperties(el,this.elementProperties)&&!elementHasNonClassAttributes(el,this.attrExceptions)&&this.elementHasAttributes(el,this.elementAttributes)&&this.isModifiable(el)},isEmptyContainer:function(el){var childNodeCount=el.childNodes.length;return el.nodeType==1&&this.isRemovable(el)&&(childNodeCount==0||childNodeCount==1&&this.isEmptyContainer(el.firstChild))},removeEmptyContainers:function(range){var applier=this;var nodesToRemove=range.getNodes([1],function(el){return applier.isEmptyContainer(el)});var rangesToPreserve=[range];var positionsToPreserve=getRangeBoundaries(rangesToPreserve);forEach(nodesToRemove,function(node){log.debug("Removing empty container "+dom.inspectNode(node));removePreservingPositions(node,positionsToPreserve)});updateRangesFromBoundaries(rangesToPreserve,positionsToPreserve)},undoToTextNode:function(textNode,range,ancestorWithClass,positionsToPreserve){log.info("undoToTextNode",dom.inspectNode(textNode),range.inspect(),dom.inspectNode(ancestorWithClass),range.containsNode(ancestorWithClass));if(!range.containsNode(ancestorWithClass)){var ancestorRange=range.cloneRange();ancestorRange.selectNode(ancestorWithClass);log.info("range end in ancestor "+ancestorRange.isPointInRange(range.endContainer,range.endOffset)+", isSplitPoint "+isSplitPoint(range.endContainer,range.endOffset));if(ancestorRange.isPointInRange(range.endContainer,range.endOffset)){splitNodeAt(ancestorWithClass,range.endContainer,range.endOffset,positionsToPreserve);range.setEndAfter(ancestorWithClass)}if(ancestorRange.isPointInRange(range.startContainer,range.startOffset)){ancestorWithClass=splitNodeAt(ancestorWithClass,range.startContainer,range.startOffset,positionsToPreserve)}}log.info("isRemovable",this.isRemovable(ancestorWithClass),dom.inspectNode(ancestorWithClass),"'"+ancestorWithClass.innerHTML+"'","'"+ancestorWithClass.parentNode.innerHTML+"'");if(this.isRemovable(ancestorWithClass)){replaceWithOwnChildrenPreservingPositions(ancestorWithClass,positionsToPreserve)}else{removeClass(ancestorWithClass,this.className)}},splitAncestorWithClass:function(container,offset,positionsToPreserve){var ancestorWithClass=this.getSelfOrAncestorWithClass(container);if(ancestorWithClass){log.info("splitAncestorWithClass",dom.inspectNode(ancestorWithClass),dom.inspectNode(container),offset);splitNodeAt(ancestorWithClass,container,offset,positionsToPreserve)}},undoToAncestor:function(ancestorWithClass,positionsToPreserve){log.info("isRemovable",this.isRemovable(ancestorWithClass),dom.inspectNode(ancestorWithClass),"'"+ancestorWithClass.innerHTML+"'","'"+ancestorWithClass.parentNode.innerHTML+"'");if(this.isRemovable(ancestorWithClass)){replaceWithOwnChildrenPreservingPositions(ancestorWithClass,positionsToPreserve)}else{removeClass(ancestorWithClass,this.className)}},applyToRange:function(range,rangesToPreserve){var applier=this;rangesToPreserve=rangesToPreserve||[];var positionsToPreserve=getRangeBoundaries(rangesToPreserve||[]);range.splitBoundariesPreservingPositions(positionsToPreserve);if(applier.removeEmptyElements){applier.removeEmptyContainers(range)}var textNodes=getEffectiveTextNodes(range);if(textNodes.length){forEach(textNodes,function(textNode){log.info("textnode "+textNode.data+" is ignorable: "+applier.isIgnorableWhiteSpaceNode(textNode));if(!applier.isIgnorableWhiteSpaceNode(textNode)&&!applier.getSelfOrAncestorWithClass(textNode)&&applier.isModifiable(textNode)){applier.applyToTextNode(textNode,positionsToPreserve)}});var lastTextNode=textNodes[textNodes.length-1];range.setStartAndEnd(textNodes[0],0,lastTextNode,lastTextNode.length);if(applier.normalize){applier.postApply(textNodes,range,positionsToPreserve,false)}updateRangesFromBoundaries(rangesToPreserve,positionsToPreserve)}var emptyElements=applier.getEmptyElements(range);forEach(emptyElements,function(el){addClass(el,applier.className)})},applyToRanges:function(ranges){log.group("applyToRanges");var i=ranges.length;while(i--){this.applyToRange(ranges[i],ranges)}log.groupEnd();return ranges},applyToSelection:function(win){log.group("applyToSelection");var sel=api.getSelection(win);log.info("applyToSelection "+sel.inspect());sel.setRanges(this.applyToRanges(sel.getAllRanges()));log.groupEnd()},undoToRange:function(range,rangesToPreserve){var applier=this;rangesToPreserve=rangesToPreserve||[];var positionsToPreserve=getRangeBoundaries(rangesToPreserve);log.info("undoToRange "+range.inspect(),positionsToPreserve);range.splitBoundariesPreservingPositions(positionsToPreserve);if(applier.removeEmptyElements){applier.removeEmptyContainers(range,positionsToPreserve)}var textNodes=getEffectiveTextNodes(range);var textNode,ancestorWithClass;var lastTextNode=textNodes[textNodes.length-1];if(textNodes.length){applier.splitAncestorWithClass(range.endContainer,range.endOffset,positionsToPreserve);applier.splitAncestorWithClass(range.startContainer,range.startOffset,positionsToPreserve);for(var i=0,len=textNodes.length;i<len;++i){textNode=textNodes[i];ancestorWithClass=applier.getSelfOrAncestorWithClass(textNode);if(ancestorWithClass&&applier.isModifiable(textNode)){applier.undoToAncestor(ancestorWithClass,positionsToPreserve)}}range.setStartAndEnd(textNodes[0],0,lastTextNode,lastTextNode.length);log.info("Undo set range to '"+textNodes[0].data+"', '"+textNode.data+"'");if(applier.normalize){applier.postApply(textNodes,range,positionsToPreserve,true)}updateRangesFromBoundaries(rangesToPreserve,positionsToPreserve)}var emptyElements=applier.getEmptyElements(range);forEach(emptyElements,function(el){removeClass(el,applier.className)})},undoToRanges:function(ranges){var i=ranges.length;while(i--){this.undoToRange(ranges[i],ranges)}log.groupEnd();return ranges},undoToSelection:function(win){var sel=api.getSelection(win);var ranges=api.getSelection(win).getAllRanges();this.undoToRanges(ranges);sel.setRanges(ranges)},isAppliedToRange:function(range){if(range.collapsed||range.toString()==""){return!!this.getSelfOrAncestorWithClass(range.commonAncestorContainer)}else{var textNodes=range.getNodes([3]);if(textNodes.length)for(var i=0,textNode;textNode=textNodes[i++];){if(!this.isIgnorableWhiteSpaceNode(textNode)&&rangeSelectsAnyText(range,textNode)&&this.isModifiable(textNode)&&!this.getSelfOrAncestorWithClass(textNode)){return false}}return true}},isAppliedToRanges:function(ranges){var i=ranges.length;if(i==0){return false}while(i--){if(!this.isAppliedToRange(ranges[i])){return false}}return true},isAppliedToSelection:function(win){var sel=api.getSelection(win);return this.isAppliedToRanges(sel.getAllRanges())},toggleRange:function(range){if(this.isAppliedToRange(range)){this.undoToRange(range)}else{this.applyToRange(range)}},toggleSelection:function(win){if(this.isAppliedToSelection(win)){this.undoToSelection(win)}else{this.applyToSelection(win)}},getElementsWithClassIntersectingRange:function(range){var elements=[];var applier=this;range.getNodes([3],function(textNode){var el=applier.getSelfOrAncestorWithClass(textNode);if(el&&!contains(elements,el)){elements.push(el)}});return elements},detach:function(){}};function createClassApplier(className,options,tagNames){return new ClassApplier(className,options,tagNames)}ClassApplier.util={hasClass:hasClass,addClass:addClass,removeClass:removeClass,getClass:getClass,hasSameClasses:haveSameClasses,hasAllClasses:hasAllClasses,replaceWithOwnChildren:replaceWithOwnChildrenPreservingPositions,elementsHaveSameNonClassAttributes:elementsHaveSameNonClassAttributes,elementHasNonClassAttributes:elementHasNonClassAttributes,splitNodeAt:splitNodeAt,isEditableElement:isEditableElement,isEditingHost:isEditingHost,isEditable:isEditable};api.CssClassApplier=api.ClassApplier=ClassApplier;api.createClassApplier=createClassApplier;util.createAliasForDeprecatedMethod(api,"createCssClassApplier","createClassApplier",module)});