<?php
/**
 * JEvents Calendar Plus Module
 *
 * @version     $Id$
 * @package     JEvents
 * @copyright   Copyright (C) 2008-2009 GWE Systems Ltd
 * @license     GNU/GPLv2, see http://www.gnu.org/licenses/gpl-2.0.html
 * @link        http://www.jevents.net
 * @author		Carlos M'Cámara and Geraint Edwards
 */

//no direct access
defined('_JEXEC') or die;

$document = JFactory::getDocument();

require_once (dirname(__FILE__).'/'.'helper.php');

$jevhelper = new modJeventsCalendarPlusHelper();

JPluginHelper::importPlugin("jevents");
JLoader::register('JevJoomlaVersion',JPATH_ADMINISTRATOR."/components/com_jevents/libraries/version.php");
JLoader::register('JevModal',JPATH_LIBRARIES."/jevents/jevmodal/jevmodal.php");

// record what is running - used by the filters
$registry	= JRegistry::getInstance("jevents");
$registry->set("jevents.activeprocess","mod_jevents_cal");
$registry->set("jevents.moduleid", $module->id);
$registry->set("jevents.moduleparams", $params);

//We check if popup plugin
$popupPlugin = JPluginHelper::getPlugin('jevents', 'jevpopupdetail');
if ( $popupPlugin )
{
	$popupPluginParams = new JRegistry($popupPlugin->params);

	$detailInPopup = $popupPluginParams->get("detailinpopup",0);
}
else if ( ($params->get('jevcalplus_newwindow', 1) == 2) )
{
	$detailInPopup = 1;
}
else{
	$detailInPopup = 0;
}

if($detailInPopup)
{
	JevModal::framework();
}

$params->set('detailInPopup', $detailInPopup);

// See http://www.php.net/manual/en/timezones.php
$compparams = JComponentHelper::getParams(JEV_COM_COMPONENT);
$tz=$compparams->get("icaltimezonelive","");
if ($tz!="" && is_callable("date_default_timezone_set")){
	$timezone= date_default_timezone_get();
	//echo "timezone is ".$timezone."<br/>";
	date_default_timezone_set($tz);
	$registry->set("jevents.timezone",$timezone);
}


$theme = JEV_CommonFunctions::getJEventsViewName();
$modtheme = $params->get("com_calViewName", $theme);
if ($modtheme == "global" || $modtheme == ""){
	$modtheme=$theme;
}

$theme=$modtheme;

if ($theme == "map")
{
	// display the correct layout
	$theme = $compparams->get("fallbackview", "geraint");
}

if ($theme == "ruthin")
{
	$theme = $theme."_".$colorscheme = $compparams->get("iccolourscheme","red");
}

if($theme == "flatplus")
{
	$theme = "flat";
}

JHtml::stylesheet( 'modules/mod_jevents_calendarplus/assets/css/jevcalendarplus.css');

if (!JFile::exists(JPATH_SITE . '/modules/mod_jevents_calendarplus/assets/css/'.strtolower($theme).'.css'))
{
	$theme="default";
}

JHtml::stylesheet( 'modules/mod_jevents_calendarplus/assets/css/'.strtolower($theme).'.css');

if (JFile::exists(JPATH_SITE . "/components/com_jevents/assets/css/jevcustom.css"))
{
	JHtml::stylesheet("components/com_jevents/assets/css/jevcustom.css");
}

if($params->get('jevcalplus_loadbootstrap', 1))
{
	JHtmlBootstrap::framework();
}

if($params->get('detailInPopup', 0))
{
	JHtml::script(JUri::base().'components/com_jevents/assets/js/editpopupJQ.js', false, false);
}

JHtml::script('mod_jevents_calendarplus/underscore.min.js', false, true, false, true);
JHtml::script('mod_jevents_calendarplus/moment.min.js', false, true, false, true);
JHtml::script('mod_jevents_calendarplus/clndr.min.js', false, true, false, true);
JHtml::script('mod_jevents_calendarplus/jevcalplus.min.js', false, true, false, true);

$viewclass = $jevhelper->getViewClass('default', 'mod_jevents_calendarplus','default/'."calendar", $params);
$modview = new $viewclass($params, $module->id);
//$modview->jevlayout = $theme;
echo $modview->getCal();

// Must reset the timezone back!!
if ($tz && is_callable("date_default_timezone_set")){
	date_default_timezone_set($timezone);
}
