<?php
/**
 * JEvents Component for Joomla 1.5.x
 *
 * @version     $Id: helper.php 3194 2012-01-16 11:04:20Z geraintedwards $
 * @package     JEvents
 * @subpackage  Module JEvents Calendar Plus
 * @copyright   Copyright (C) 2006-2008 JEvents Project Group
 * @license     GNU/GPLv2, see http://www.gnu.org/licenses/gpl-2.0.html
 * @link        http://joomlacode.org/gf/project/jevents
 */
// no direct access
defined('_JEXEC') or die('Restricted access');

class modJeventsCalendarPlusHelper
{
	
	function modJeventsCalendarPlusHelper(){
		// setup for all required function and classes
		$file = JPATH_SITE . '/components/com_jevents/mod.defines.php';
		if (file_exists($file) ) {
			include_once($file);
			include_once(JEV_LIBS."/modfunctions.php");

		} else {
			die ("JEvents Calendar Plus\n<br />This module needs the JEvents component");
		}

		// load language constants
		JEVHelper::loadLanguage('modcal');
	}
	
	function getViewClass($theme, $module, $layout, $params=false){

		// If we have a specified over ride then use it here
		if ($params && strlen($params->get("layout",""))>0){
			$speciallayout = strtolower($params->get("layout",""));
			// Build the template and base path for the layout
			$tPath = JPATH_SITE.'/'.'templates'.'/'.JFactory::getApplication()->getTemplate().'/'.'html'.'/'.$module.'/'.$theme.'/'.$speciallayout.'.php';

			// If the template has a layout override use it
			if (file_exists($tPath)) {
				$viewclass = "Override".ucfirst($theme)."ModCalendarPlusView".ucfirst($speciallayout);
				require_once($tPath);
				if (class_exists($viewclass)){
					return $viewclass;
				}
			}
		}
		if ($layout=="" || $layout=="global"){
			$layout=JEV_CommonFunctions::getJEventsViewName();;
		}
		
		// Build the template and base path for the layout
		$tPath = JPATH_SITE.'/'.'templates'.'/'.JFactory::getApplication()->getTemplate().'/'.'html'.'/'.$module.'/'.$layout.'.php';
		$bPath = JPATH_SITE.'/'.'modules'.'/'.$module.'/'.'tmpl'.'/'.$layout.'.php';

		jimport('joomla.filesystem.file');
		// If the template has a layout override use it
		if (JFile::exists($tPath)) {
			require_once($tPath);
			$viewclass = "Override".ucfirst($theme)."ModCalendarPlusView";
			if (class_exists($viewclass)){
				return $viewclass;
			}
			else {
				// fall back to badly declared template override!
				$viewclass = ucfirst($theme)."ModCalendarPlusView";
				if (class_exists($viewclass)){
					return $viewclass;
				}				
			}
		}
		if (JFile::exists($bPath)) {
			require_once($bPath);
			$viewclass = ucfirst($theme)."ModCalendarPlusView";
			return $viewclass;
		}
		else {
			echo "<strong>".JText::sprintf("JEV_PLEASE_REINSTALL_LAYOUT",$theme)."</strong>";
			$bPath = JPATH_SITE.'/'.'modules'.'/'.$module.'/'.'tmpl'.'/'.'default'.'/'.'calendar.php';
			require_once($bPath);
			$viewclass = "DefaultModCalendarPlusView";
			return $viewclass;

		}
	}

	public function getEventsArray($data, $itemId, $catIdsOutLink)
	{
		$events = array();
		foreach ($data['dates'] as $day_index)
		{
			foreach($day_index['events'] as $event)
			{
				$eventArray['date'] = $day_index['year'] ."-".$day_index['month']."-".$day_index['d0']. " " .date("H:i",$event->getUnixStartTime());

				$title = str_replace("'", "&#39;", $event->title());
				$eventArray['title'] = str_replace('"', "&#34;", $title);
				$eventArray['safeTitle'] = addslashes($event->title());
				$link = $event->viewDetailLink($day_index['year'], $day_index['month'], $day_index['d0'], true, $itemId);
				$eventArray['link'] = JRoute::_($link . $catIdsOutLink);
				$eventArray['linkInPopup'] = JRoute::_($link . $catIdsOutLink."?tmpl=component");
				//$eventArray['link'] = $link;
				$events[] = $eventArray;
			}
		}

		return $events;
	}
	
}
