(function(){

// module factory: start

var moduleFactory = function($) {
// module body: start

var module = this; 
var jQuery = $; 
$.require() 
 .script("effects/core") 
 .done(function() { 
var exports = function() { 

/*
 * jQuery UI Effects Slide 1.9pre
 *
 * Copyright 2011, AUTHORS.txt (http://jqueryui.com/about)
 * Dual licensed under the MIT or GPL Version 2 licenses.
 * http://jquery.org/license
 *
 * http://docs.jquery.com/UI/Effects/Slide
 *
 * Depends:
 *	jquery.effects.core.js
 */
(function( $, undefined ) {

$.effects.effect.slide = function( o, done ) {

	// Create element
	var el = $( this ),
		props = [ "position", "top", "bottom", "left", "right", "width", "height" ],
		mode = $.effects.setMode( el, o.mode || "show" ),
		show = mode === "show",
		direction = o.direction || "left",
		ref = (direction == "up" || direction == "down") ? "top" : "left",
		positiveMotion = (direction == "up" || direction == "left"),
		distance,
		animation = {},
		size;

	// Adjust
	$.effects.save( el, props );
	el.show();
	distance = o.distance || el[ ref === "top" ? "outerHeight" : "outerWidth" ]({ 
		margin: true
	});
	
	$.effects.createWrapper( el ).css({
		overflow: "hidden"
	});
	
	if ( show ) {
		el.css( ref, positiveMotion ? (isNaN(distance) ? "-" + distance : -distance) : distance );
	}

	// Animation
	animation[ ref ] = ( show ? 
		( positiveMotion ? "+=" : "-=") : 
		( positiveMotion ? "-=" : "+=")) 
		+ distance;

	// Animate
	el.animate( animation, { 
		queue: false, 
		duration: o.duration, 
		easing: o.easing, 
		complete: function() {
			if ( mode === "hide" ) {
				el.hide(); 
			}
			$.effects.restore( el, props );
			$.effects.removeWrapper( el );
			done();
		}
	});

};

})(jQuery);

}; 

exports(); 
module.resolveWith(exports); 

}); 
// module body: end

}; 
// module factory: end

dispatch("effects/slide")
.containing(moduleFactory)
.to("Foundry/2.1 Modules");

}());