<?php

/**
 * @file plugins/blocks/relatedItems/RelatedItemsBlockPlugin.inc.php
 *
 * Copyright (c) 2014-2016 Simon Fraser University Library
 * Copyright (c) 2003-2016 John Willinsky
 * Distributed under the GNU GPL v2. For full terms see the file docs/COPYING.
 *
 * @class RelatedItemsBlockPlugin
 * @ingroup plugins_blocks_related_items
 *
 * @brief Class for related items block plugin
 */

import('lib.pkp.classes.plugins.BlockPlugin');

class RelatedItemsBlockPlugin extends BlockPlugin {
	/**
	 * Get the display name of this plugin.
	 * @return String
	 */
	function getDisplayName() {
		return __('plugins.block.relatedItems.displayName');
	}

	/**
	 * Get a description of the plugin.
	 */
	function getDescription() {
		return __('plugins.block.relatedItems.description');
	}

	/**
	 * Get the supported contexts (e.g. BLOCK_CONTEXT_...) for this block.
	 * @return array
	 */
	function getSupportedContexts() {
		return array(BLOCK_CONTEXT_LEFT_SIDEBAR);
	}

	/**
	 * @see BlockPlugin::getContents
	 */
	function getContents(&$templateMgr, $request = null) {
		$journal = $request->getJournal();

		return parent::getContents($templateMgr, $request);
	}
}

?>
