# Review Stages

1. Introduction
2. [Orientation](review.md#orientation)
3. [Editorial Actions](review.md#editorial-actions)

During the Review stage, the editor assigns reviewers to the submission.

Once the reviewers have submitted their reviews and recommendations, the editor is responsible for making an editorial decision, which will determine whether the submission is ready for the Copyediting stage or requires further revisions.

By default, the review stages begin in *Round 1* of reviews. Further rounds may be initiated if the editor requests major changes that must go through another round of review.

## <a name="orientation"></a>Orientation

Each review round consists of sections for managing review files and reviewers, along with the discussions and participants section which appear on every stage.

### <a name="review-files"></a>Review Files
All the files selected by the editor for review. These files will be visible to reviewers unless restricted when assigning the reviewer.

### <a name="reviewers"></a>Reviewers
Editors can add reviewers, assign due dates, and monitor the status and recommendations of the reviews. When a review has been completed, the editor can view and confirm the review to acknowledge that they've read it.

### <a name="revisions"></a>Revisions
Revised files uploaded by the author. During the review process, the editor may request revisions from the author. Once uploaded, they appear here and will be available to send to the Copyediting stage once they've passed review.

### <a name="discussions"></a>Review Discussions
Editors and sub-editors can initiate private conversations among themselves or with reviewers or authors. Authors cannot initiate discussions or communicate directly with reviewers.

The review discussions are not particular to any one round and will carry over to subsequent rounds if a new review round is initiated.

### <a name="participants"></a>Participants
Editors and sub-editors can add additional users to this stage to assist them in managing the review process. This is commonly used by an editor who wants a sub-editor to handle the day-to-day communications with reviewers. [Learn more](../editorial-workflow.md#participants).

## <a name="editorial-actions"></a>Editorial Actions
The editor can make one of several editorial actions during each round of the review stage. Each of these decisions automatically notifies the author by email.

### <a name="request-revisions"></a>Request Revisions
The editor can request revisions from the author without opening a new review round. This is common when minor revisions are required which the editor can approve without re-submitting for  review.

### <a name="new-review"></a>Resubmit for Review
The editor can request revisions from the author which will need to go through another round of review. Once revisions are received, a new review round will need to be created at the top of the review stage.

### <a name="copyediting"></a>Send to Copyediting
The editor can initiate the [Copyediting stage](copyediting.md) once it has passed the required review stage.

### <a name="decline"></a>Decline Submission
The editor can decline the submission if it does not pass review. The submission will be removed from the editorial workflow and sent to the Archives.
