/*
 * Decompiled with CFR 0.152.
 */
package org.jelsim.userif.overlay;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.Beans;
import org.jelsim.beans.support.BeanInterface;
import org.jelsim.beans.support.BeanPropertyHelper;
import org.jelsim.beans.support.BeanReadHelper;
import org.jelsim.beans.support.ComponentContainer;
import org.jelsim.beans.support.JSExternalizableBean;
import org.jelsim.beans.support.LinkedComponentParent;
import org.jelsim.beans.support.ModelAccessInterface;
import org.jelsim.beans.support.ShowError;
import org.jelsim.beans.support.SimpleBeanInterface;
import org.jelsim.model.access.IfAccess;
import org.jelsim.model.access.LocalModelAccess;
import org.jelsim.model.access.ModelAccess;
import org.jelsim.model.map.FixedMapProperty;
import org.jelsim.model.map.ModelPropertyInterface;
import org.jelsim.report.ReportList;
import org.jelsim.system.ErrorHandler;
import org.jelsim.trigger.TriggerCondition;
import org.jelsim.trigger.TriggerListener;
import org.jelsim.trigger.Triggerable;
import org.jelsim.userif.EditClient;
import org.jelsim.userif.EditHelperInterface;
import org.jelsim.userif.PanelSaveState;
import org.jelsim.userif.overlay.OverlayInterface;

public class Overlay
extends Container
implements EditClient,
IfAccess,
ShowError,
JSExternalizableBean,
Triggerable,
OverlayInterface,
LinkedComponentParent,
ComponentContainer {
    private int version = 1;
    private boolean opaque = false;
    private int width = 0;
    private int height = 0;
    private BeanPropertyHelper[] savedTriggerConditions;
    private OpaqueComponent opComponent = null;
    protected String title = null;
    protected boolean visible = false;
    private EditHelperInterface editHelper = null;
    private Container drawingPanel = null;
    private ModelAccess lma = null;
    public ModelAccess modt = null;
    private Dimension overlaySize = null;
    private boolean inEditMode = false;
    boolean inParent = false;
    String triggerPropertyName = null;
    private TriggerCondition triggerCondition = null;
    boolean triggerState = false;
    Component[] retainedComponents = null;
    protected int localId = -1;
    protected ModelAccessInterface ma = null;

    public Overlay() {
    }

    public Overlay(int width, int height) {
        this.setLayout(null);
        this.setSize(width, height);
        this.setVisible(true);
        this.lma = new LocalModelAccess();
        this.setEditMode(true);
    }

    public void addBean(BeanInterface bean) {
    }

    public Component addIfObject(String name, FixedMapProperty fmp) {
        return null;
    }

    public BeanInterface addLinkedComponent(String className, FixedMapProperty fmp) {
        return this.editHelper == null ? null : this.editHelper.addNamedIfObject(className, fmp);
    }

    public BeanInterface addLinkedComponent(BeanInterface bean, FixedMapProperty fmp) {
        if (fmp != null && bean instanceof SimpleBeanInterface) {
            ((SimpleBeanInterface)bean).setModelProperty((ModelPropertyInterface)fmp);
        }
        this.addBean(bean);
        return bean;
    }

    private void addOpaqueComponent() {
        if (this.opComponent == null) {
            this.opComponent = new OpaqueComponent(this);
        }
        this.drawingPanel.add((Component)this.opComponent, 0);
    }

    public void clearHelp() {
    }

    public void finalizeJelsim() {
        if (this.opComponent != null) {
            this.opComponent.setVisible(false);
            this.opComponent = null;
        }
        this.setVisible(false);
        Component[] components = this.getComponents();
        int i = 0;
        while (i < components.length) {
            if (components[i] instanceof BeanInterface) {
                ((BeanInterface)components[i]).finalizeJelsim();
            }
            this.remove(components[i]);
            ++i;
        }
        if (this.editHelper != null) {
            this.editHelper.deregisterEditClient((EditClient)this);
        }
        if (this.triggerCondition != null) {
            this.triggerCondition.removeTriggerListener((TriggerListener)this);
        }
    }

    public Object getAnnotation() {
        return null;
    }

    public Component[] getComponents() {
        return this.retainedComponents != null ? this.retainedComponents : super.getComponents();
    }

    public Component getCurrentObject() {
        return null;
    }

    public Object[] getCustomData() {
        return null;
    }

    public String getEditHelp() {
        return null;
    }

    public boolean getEditMode() {
        return this.inEditMode;
    }

    public String[] getFmpSaveNames() {
        return null;
    }

    public void getFromParent() {
        if (this.inParent) {
            this.removeOpaqueComponent();
            if (this.retainedComponents != null) {
                int i = 0;
                while (i < this.retainedComponents.length) {
                    this.drawingPanel.remove(this.retainedComponents[i]);
                    this.retainedComponents[i].setVisible(false);
                    ++i;
                }
            }
            this.inParent = false;
            this.drawingPanel.repaint(10L);
        }
    }

    public int getGlobalId() {
        return -1;
    }

    public int getLocalId() {
        return this.localId;
    }

    public String getMessagePrintTitle() {
        return "YES";
    }

    public ModelAccessInterface getModelAccess() {
        return this.ma;
    }

    public String[] getNormalSaveNames() {
        return new String[]{"opaque", "background", "title"};
    }

    public Component[] getOverlayComponents() {
        return this.getComponents();
    }

    public Dimension getPreferredSize() {
        int xmax = Integer.MIN_VALUE;
        int ymax = Integer.MIN_VALUE;
        Component[] components = this.getComponents();
        if (components.length > 0) {
            Rectangle r = null;
            int i = 0;
            while (i < components.length) {
                r = components[i].getBounds();
                int cxmax = r.x + r.width;
                int cymax = r.y + r.height;
                if (cxmax > xmax) {
                    xmax = cxmax;
                }
                if (cymax > ymax) {
                    ymax = cymax;
                }
                ++i;
            }
        } else {
            xmax = 0;
            ymax = 0;
        }
        return new Dimension(xmax, ymax);
    }

    public ReportList getReportList() {
        return null;
    }

    public int getReportPeriod() {
        return 1;
    }

    public PanelSaveState getSaveState() {
        return new PanelSaveState((IfAccess)this);
    }

    public BeanPropertyHelper[] getSavedModelProperties() {
        return null;
    }

    public Color getSelectColor() {
        return null;
    }

    public String getTitle() {
        return this.title == null ? "Untitled" : this.title;
    }

    public TriggerCondition getTriggerCondition() {
        return this.triggerCondition;
    }

    public String getTriggerPropertyName() {
        return this.triggerPropertyName;
    }

    public String[] getTriggerSaveNames() {
        return new String[]{"triggerCondition"};
    }

    public boolean getTriggerState() {
        return this.triggerState;
    }

    public String getUserHelp() {
        return null;
    }

    public int getVersion() {
        return this.version;
    }

    public void initialiseBeanObjects() {
    }

    public boolean isClearMessages() {
        return false;
    }

    public boolean isEditMessages() {
        return false;
    }

    public boolean isOpaque() {
        return this.opaque;
    }

    public boolean isPrintMessages() {
        return false;
    }

    public boolean isResizable() {
        return false;
    }

    public boolean isSaveMessages() {
        return false;
    }

    public boolean isWasEdited() {
        return true;
    }

    public void moveToParent() {
        if (!Beans.isDesignTime() && !this.inParent && this.drawingPanel != null) {
            if (this.opaque) {
                this.addOpaqueComponent();
            }
            if (this.retainedComponents == null) {
                this.retainedComponents = this.getComponents();
            }
            int i = this.retainedComponents.length - 1;
            while (i >= 0) {
                this.drawingPanel.add(this.retainedComponents[i], 0);
                this.retainedComponents[i].setVisible(true);
                --i;
            }
            this.inParent = true;
            this.drawingPanel.repaint(10L);
        }
    }

    public void paint(Graphics g) {
        if (Beans.isDesignTime()) {
            if (this.retainedComponents != null) {
                this.restoreToOverlay();
            }
            if (this.opaque) {
                g.setColor(this.getBackground());
                g.fillRect(0, 0, this.width, this.height);
            }
            if (this.editHelper != null) {
                this.editHelper.drawGrid(g);
            }
            if (this.visible) {
                super.paint(g);
            }
            if (this.editHelper != null) {
                this.editHelper.paint(g);
            }
        }
    }

    private void removeOpaqueComponent() {
        if (this.opComponent != null && this.opComponent.getParent() != null) {
            this.opComponent.getParent().remove(this.opComponent);
            this.opComponent = null;
        }
    }

    private void restoreToOverlay() {
        int i = 0;
        while (i < this.retainedComponents.length) {
            this.add(this.retainedComponents[i]);
            ++i;
        }
        this.inParent = false;
        this.retainedComponents = null;
    }

    public void setAnnotation(Object annotation) {
    }

    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.width = w;
        this.height = h;
        if (this.opComponent != null) {
            this.opComponent.setBounds(x, y, w, h);
        }
    }

    public void setClearMessages(boolean b) {
    }

    public void setCustomData(Object[] data) {
    }

    public void setDrawingPanel(Container drawingPanel) {
        this.drawingPanel = drawingPanel;
    }

    public void setEditHelp(String help) {
    }

    public void setEditHelper(EditHelperInterface newEditHelper) {
        this.editHelper = newEditHelper;
        if (this.editHelper != null) {
            this.editHelper.setEditClient((EditClient)this);
        }
    }

    public void setEditMessages(boolean b) {
    }

    public void setEditMode(boolean inEditMode) {
        this.inEditMode = inEditMode;
    }

    public void setGlobalId(int id) {
    }

    public void setLocalId(int id) {
        this.localId = id;
    }

    public void setMessagePrintTitle(String s) {
    }

    public void setModelAccess(ModelAccessInterface ma) {
        this.ma = ma;
        Component[] components = this.getComponents();
        int i = 0;
        while (i < components.length) {
            if (components[i] instanceof BeanInterface) {
                ((BeanInterface)components[i]).setModelAccess(ma);
            }
            ++i;
        }
        if (this.savedTriggerConditions != null) {
            BeanReadHelper.getReadHelper();
            BeanReadHelper.restoreTriggerConditions((BeanInterface)this, (BeanPropertyHelper[])this.savedTriggerConditions, (ModelAccessInterface)ma);
            this.savedTriggerConditions = null;
        } else if (this.triggerPropertyName != null) {
            this.setTriggerCondition(ma.getTriggerManager().getTriggerCondition(this.triggerPropertyName));
        }
    }

    public void setOpaque(boolean b) {
        this.opaque = b;
        if (!this.opaque) {
            this.removeOpaqueComponent();
        } else if (this.inParent) {
            this.addOpaqueComponent();
        }
        this.repaint();
    }

    public void setPrintMessages(boolean b) {
    }

    public void setResizable(boolean b) {
    }

    public void setSaveMessages(boolean b) {
    }

    public void setSaveState(PanelSaveState s) {
    }

    public void setSavedModelProperties(BeanPropertyHelper[] savedModelProperties) {
    }

    public void setSavedTriggers(BeanPropertyHelper[] savedTriggerConditions) {
        this.savedTriggerConditions = savedTriggerConditions;
    }

    public void setSelectColor(Color c) {
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setTriggerCondition(TriggerCondition tc) {
        if (this.triggerCondition != null) {
            this.triggerCondition.removeTriggerListener((TriggerListener)this);
        }
        this.triggerCondition = tc;
        if (this.triggerCondition != null) {
            this.triggerPropertyName = tc.getName();
            this.triggerCondition.addTriggerListener((TriggerListener)this);
            this.setTriggerState(this.triggerCondition.getTriggerState());
        } else {
            this.triggerPropertyName = null;
            this.setTriggerState(false);
        }
    }

    public void setTriggerPropertyName(String triggerPropertyName) {
        this.triggerPropertyName = triggerPropertyName;
    }

    public void setTriggerState(boolean triggerState) {
        this.triggerState = triggerState;
        if (Beans.isDesignTime()) {
            this.repaint();
        } else if (triggerState) {
            this.moveToParent();
        } else {
            this.getFromParent();
        }
    }

    public void setUserHelp(String help) {
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.visible = visible;
        Component[] cs = this.getComponents();
        int i = 0;
        while (i < cs.length) {
            cs[i].setVisible(visible);
            ++i;
        }
    }

    public void setWasEdited(boolean wasEdited) {
    }

    public void showError(String errorStr) {
        Container c = this.getParent();
        if (c != null && c instanceof ShowError) {
            ((ShowError)c).showError(errorStr);
        } else {
            ErrorHandler.reportMessage((String)errorStr);
        }
    }

    public void showHelp(String s) {
    }

    class OpaqueComponent
    extends Component {
        public OpaqueComponent(Overlay ov) {
            this.setSize(ov.getSize());
        }

        public void paint(Graphics g) {
            super.paint(g);
            g.setColor(Overlay.this.getBackground());
            g.fillRect(0, 0, Overlay.this.width, Overlay.this.height);
        }
    }
}

