/*
 * Decompiled with CFR 0.152.
 */
package org.jelsim.trigger.expression;

import java.util.Hashtable;
import java.util.Stack;
import org.jelsim.beans.support.ModelAccessInterface;

public abstract class TriggerNode {
    private boolean parenthesised = false;
    private boolean inverted = false;
    protected String operatorText = "";
    protected TriggerNode parentNode;
    protected TriggerNode leftNode;
    protected TriggerNode rightNode;
    protected StringBuffer nodeText = new StringBuffer("");

    protected abstract void evaluate();

    public void finalizeJelsim() {
        this.setModelAccess(null);
    }

    public synchronized String getNodeText() {
        return this.nodeText.toString();
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public boolean isParenthesised() {
        return this.parenthesised;
    }

    public void reconstructExpression(Stack parseStack, Hashtable propertyHash) {
        if (this.isParenthesised()) {
            parseStack.push("(");
        }
        if (this.isInverted()) {
            parseStack.push("!(");
        }
        if (this.leftNode != null) {
            this.leftNode.reconstructExpression(parseStack, propertyHash);
            parseStack.push(this.operatorText);
            if (this.rightNode != null) {
                this.rightNode.reconstructExpression(parseStack, propertyHash);
            }
            if (this.isInverted()) {
                parseStack.push(")");
            }
            if (this.isParenthesised()) {
                parseStack.push(")");
            }
        }
    }

    public void setInverted(boolean v) {
        this.inverted = v;
        this.updateNodeText();
        this.evaluate();
    }

    public void setLeftNode(TriggerNode leftNode) {
        this.leftNode = leftNode;
        leftNode.setParentNode(this);
        this.updateNodeText();
        this.evaluate();
    }

    public void setModelAccess(ModelAccessInterface ma) {
        if (this.rightNode != null) {
            this.rightNode.setModelAccess(ma);
        }
        if (this.leftNode != null) {
            this.leftNode.setModelAccess(ma);
        }
    }

    public void setParentNode(TriggerNode parentNode) {
        this.parentNode = parentNode;
    }

    public void setParenthesised(boolean v) {
        this.parenthesised = v;
        this.updateNodeText();
    }

    public void setRightNode(TriggerNode rightNode) {
        this.rightNode = rightNode;
        rightNode.setParentNode(this);
        this.updateNodeText();
        this.evaluate();
    }

    public void updateNodeText() {
        TriggerNode triggerNode = this;
        synchronized (triggerNode) {
            this.nodeText.setLength(0);
            if (this.isParenthesised()) {
                this.nodeText.append("(");
            }
            if (this.isInverted()) {
                this.nodeText.append("!(");
            }
            if (this.leftNode != null) {
                this.nodeText.append(this.leftNode.getNodeText());
                this.nodeText.append(this.operatorText);
                if (this.rightNode != null) {
                    this.nodeText.append(this.rightNode.getNodeText());
                }
                if (this.isInverted()) {
                    this.nodeText.append(")");
                }
                if (this.isParenthesised()) {
                    this.nodeText.append(")");
                }
            }
        }
        if (this.parentNode != null) {
            this.parentNode.updateNodeText();
        }
    }
}

