/*
 * Decompiled with CFR 0.152.
 */
package org.jelsim.trigger.expression;

import java.util.Hashtable;
import java.util.Stack;
import org.jelsim.beans.support.ModelAccessInterface;
import org.jelsim.model.event.ModelUpdateEvent;
import org.jelsim.model.event.ModelUpdateListener;
import org.jelsim.model.map.ModelPropertyInterface;
import org.jelsim.trigger.TriggerManager;
import org.jelsim.trigger.expression.BooleanNode;

public class BooleanLeaf
extends BooleanNode
implements ModelUpdateListener {
    ModelPropertyInterface property;
    ModelAccessInterface ma;

    public BooleanLeaf(ModelPropertyInterface property) {
        this.property = property;
        this.updateNodeText();
        this.evaluate();
    }

    protected boolean booleanOp(boolean leftValue, boolean rightValue) {
        return false;
    }

    public void evaluate() {
        if (this.property != null) {
            boolean newState = (Boolean)this.property.getValue();
            boolean bl = newState = this.isInverted() ? newState ^ true : newState;
            if (this.state != newState) {
                this.state = newState;
                if (this.parentNode != null) {
                    this.parentNode.evaluate();
                }
            }
        }
    }

    public synchronized void handleModelUpdate(ModelUpdateEvent e) {
        this.evaluate();
    }

    public void reconstructExpression(Stack parseStack, Hashtable propertyHash) {
        if (this.isParenthesised()) {
            parseStack.push("(");
        }
        if (this.isInverted()) {
            parseStack.push("!(");
        }
        String key = "B[\"" + TriggerManager.createFmpTag((ModelPropertyInterface)this.property) + "\"]";
        parseStack.push(key);
        propertyHash.put(key, this.property);
        if (this.isInverted()) {
            parseStack.push(")");
        }
        if (this.isParenthesised()) {
            parseStack.push(")");
        }
    }

    public void setModelAccess(ModelAccessInterface ma) {
        ModelAccessInterface oldMa = this.ma;
        this.ma = ma;
        if (oldMa != ma) {
            if (oldMa != null) {
                oldMa.removeModelUpdateListener(this.property, (ModelUpdateListener)this);
            }
            if (ma != null) {
                ma.addModelUpdateListener(this.property, (ModelUpdateListener)this);
            }
        }
    }

    public void updateNodeText() {
        BooleanLeaf booleanLeaf = this;
        synchronized (booleanLeaf) {
            this.nodeText.setLength(0);
            if (this.isParenthesised()) {
                this.nodeText.append("(");
            }
            if (this.isInverted()) {
                this.nodeText.append("!(");
            }
            this.nodeText.append("[" + this.property.getName() + "(" + this.property.getInstId() + ")" + "]");
            if (this.isInverted()) {
                this.nodeText.append(")");
            }
            if (this.isParenthesised()) {
                this.nodeText.append(")");
            }
        }
        if (this.parentNode != null) {
            this.parentNode.updateNodeText();
        }
    }
}

