/*
 * Decompiled with CFR 0.152.
 */
package org.jelsim.models.itemtheory;

import org.jelsim.model.MainSimClass;
import org.jelsim.model.SimClass;

public class Plot
extends SimClass {
    public double P;
    public double currentAbility;
    public int roundedP;
    public double tableAbility;
    public double tableP;
    public double c = 0.0;
    public double b = 1.0;
    public double a = 1.0;
    public double[][] AbilityPlot = new double[61][2];
    public double[][] AbilityTable = new double[7][2];
    public double[][] HorizPlot = new double[2][2];
    public double[][] VertPlot = new double[2][2];
    public double[][] cPlot = new double[2][2];
    public boolean useFactor2 = false;
    public boolean useFactors2and3 = false;
    public String[] modelMenu = new String[]{"IRT 1", "IRT 2", "IRT 3"};
    public int modelSelected = 0;
    public String menuSelected;

    public Plot(MainSimClass mainSimClass) {
        super(mainSimClass);
        this.registerProperty("Guessability", "c", 2, "calc");
        this.registerProperty("Discrimination", "a", 2, "calc");
        this.registerProperty("Difficulty", "b", 2, "calc");
        this.registerProperty("AbilityPlot", "AbilityPlot", 1);
        this.registerProperty("AbilityTable", "AbilityTable", 1);
        this.registerProperty("VertPlot", "VertPlot", 1);
        this.registerProperty("HorizPlot", "HorizPlot", 1);
        this.registerProperty("cPlot", "cPlot", 1);
        this.registerMenuProperty("Model Menu", "model", "updateModelSelected");
        this.registerProperty("IRT2", "useFactor2", 2);
        this.registerProperty("IRT3", "useFactors2and3", 2);
        this.updateModelSelected();
    }

    public void calc() {
        this.currentAbility = -3.0;
        int n = 0;
        while (n < 61) {
            this.P = this.c + (1.0 - this.c) * (1.0 / (1.0 + Math.exp(-this.a * (this.currentAbility - this.b))));
            this.AbilityPlot[n][0] = this.currentAbility;
            this.AbilityPlot[n][1] = this.P;
            this.currentAbility += 0.1;
            ++n;
        }
        this.HorizPlot[0][0] = -3.0;
        this.HorizPlot[0][1] = (1.0 + this.c) / 2.0;
        this.HorizPlot[1][0] = this.b;
        this.HorizPlot[1][1] = (1.0 + this.c) / 2.0;
        this.VertPlot[0][0] = this.b;
        this.VertPlot[0][1] = 0.0;
        this.VertPlot[1][0] = this.b;
        this.VertPlot[1][1] = (1.0 + this.c) / 2.0;
        if (this.c != 0.0) {
            this.cPlot[0][0] = -3.0;
            this.cPlot[0][1] = this.c;
            this.cPlot[1][0] = 3.0;
            this.cPlot[1][1] = this.c;
            this.sendUpdate("cPlot");
            this.sendUpdate("HorizPlot");
            this.sendUpdate("VertPlot");
            this.sendUpdate("AbilityPlot");
        } else {
            this.cPlot[0][0] = 0.0;
            this.cPlot[0][1] = 0.0;
            this.cPlot[1][0] = 0.0;
            this.cPlot[1][1] = 0.0;
            this.sendUpdate("cPlot");
            this.sendUpdate("HorizPlot");
            this.sendUpdate("VertPlot");
            this.sendUpdate("AbilityPlot");
        }
        this.tableAbility = -3.0;
        int n2 = 0;
        while (n2 < 7) {
            this.tableP = this.c + (1.0 - this.c) * (1.0 / (1.0 + Math.exp(-this.a * (this.tableAbility - this.b))));
            this.tableP *= 100.0;
            this.roundedP = (int)this.tableP;
            this.tableP = (double)this.roundedP / 100.0;
            this.AbilityTable[n2][0] = this.tableAbility;
            this.AbilityTable[n2][1] = this.tableP;
            this.tableAbility += 1.0;
            this.sendUpdate("AbilityTable");
            ++n2;
        }
    }

    public void updateModelSelected() {
        if (this.modelSelected == 2) {
            this.useFactor2 = false;
            this.useFactors2and3 = true;
        } else if (this.modelSelected == 1) {
            this.useFactor2 = true;
            this.useFactors2and3 = false;
            this.c = 0.0;
        } else {
            this.useFactor2 = false;
            this.useFactors2and3 = false;
            this.c = 0.0;
            this.a = 1.0;
        }
        this.calc();
    }
}

