/*
 * Decompiled with CFR 0.152.
 */
package org.jelsim.graph.axis;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Polygon;
import org.jelsim.beans.support.BeanSupport;
import org.jelsim.graph.axis.AxisDrawDelegate;

public class VerticalAxisDrawDelegate
extends AxisDrawDelegate {
    public static final long serialVersionUID = 3346549252745930015L;

    public VerticalAxisDrawDelegate() {
    }

    public VerticalAxisDrawDelegate(int orientation, BeanSupport parent) {
        super(1, parent);
    }

    public VerticalAxisDrawDelegate(BeanSupport parent) {
        super(1, parent);
    }

    protected int acToPixel(double val) {
        int retval = !this.showInverted ? (int)((double)this.oy - (val - this.minAxisCoord) * this.scaleFactor) : (int)((double)(this.oy - this.lengthInPixels) + (val - this.minAxisCoord) * this.scaleFactor);
        return retval;
    }

    public void adjustArrow() {
        this.arrow = new Polygon();
        this.arrow.addPoint(this.ox + 6, this.oy - this.lengthInPixels);
        this.arrow.addPoint(this.ox - 6, this.oy - this.lengthInPixels);
        this.arrow.addPoint(this.ox, this.oy - this.lengthInPixels - this.arrowLength);
    }

    public void drawLine(Graphics g) {
        g.drawLine(this.ox, this.oy, this.ox, this.oy - this.lengthInPixels);
        if (this.isShowThickAxis()) {
            g.drawLine(this.ox - 1, this.oy, this.ox - 1, this.oy - this.lengthInPixels);
        }
    }

    public void drawTicks(Graphics g) {
        double ai;
        int numSteps = (int)((this.maxMajorTick - this.minMajorTick) / this.majorTickInterval);
        numSteps = this.minMajorTick + (double)(numSteps + 1) * this.majorTickInterval <= this.maxAxisCoord ? (numSteps += 2) : ++numSteps;
        double start = this.minMajorTick - this.majorTickInterval;
        int i = 1;
        while (i <= numSteps) {
            ai = start + (double)i * this.majorTickInterval;
            int pos = this.acToPixel(ai);
            switch (this.tickMarkLocation) {
                case 0: {
                    g.drawLine(this.ox, pos, this.ox - this.majorTickLength, pos);
                    break;
                }
                case 1: {
                    g.drawLine(this.ox, pos, this.ox + this.majorTickLength, pos);
                    break;
                }
                case 2: {
                    g.drawLine(this.ox - this.majorTickLength, pos, this.ox + this.majorTickLength, pos);
                    break;
                }
            }
            ++i;
        }
        ai = this.minMajorTick;
        while (ai >= this.minAxisCoord) {
            int val = this.acToPixel(ai);
            switch (this.tickMarkLocation) {
                case 0: {
                    g.drawLine(this.ox, val, this.ox - this.minorTickLength, val);
                    break;
                }
                case 1: {
                    g.drawLine(this.ox, val, this.ox + this.minorTickLength, val);
                    break;
                }
                case 2: {
                    g.drawLine(this.ox - this.minorTickLength, val, this.ox + this.minorTickLength, val);
                    break;
                }
            }
            ai -= this.minorTickInterval;
        }
        double ai2 = this.maxMajorTick;
        while (ai2 <= this.maxAxisCoord) {
            int val = this.acToPixel(ai2);
            switch (this.tickMarkLocation) {
                case 0: {
                    g.drawLine(this.ox, val, this.ox - this.minorTickLength, val);
                    break;
                }
                case 1: {
                    g.drawLine(this.ox, val, this.ox + this.minorTickLength, val);
                    break;
                }
                case 2: {
                    g.drawLine(this.ox - this.minorTickLength, val, this.ox + this.minorTickLength, val);
                    break;
                }
            }
            ai2 += this.minorTickInterval;
        }
        double ai3 = this.minMajorTick;
        while (ai3 <= this.maxMajorTick) {
            int val = this.acToPixel(ai3);
            switch (this.tickMarkLocation) {
                case 0: {
                    g.drawLine(this.ox, val, this.ox - this.minorTickLength, val);
                    break;
                }
                case 1: {
                    g.drawLine(this.ox, val, this.ox + this.minorTickLength, val);
                    break;
                }
                case 2: {
                    g.drawLine(this.ox - this.minorTickLength, val, this.ox + this.minorTickLength, val);
                    break;
                }
            }
            ai3 += this.minorTickInterval;
        }
    }

    public int getExtraLengthRequired(int o) {
        int retval = 0;
        if (this.nfm == null) {
            return 0;
        }
        retval = (this.nfm.getLeading() + this.nfm.getMaxAscent()) / 2;
        return retval;
    }

    public int getMaxWidthRequired() {
        int retval = 0;
        FontMetrics nfmo = this.nfm;
        if (this.nfm == null) {
            return 0;
        }
        retval = nfmo != null ? this.getMaxTickLength() + this.maxLabelLength * nfmo.charWidth('0') : this.getMaxTickLength();
        return retval;
    }

    public boolean onLine(int mx, int my) {
        int tol = 3;
        return my > this.oy - this.lengthInPixels - tol && my < this.oy + tol && Math.abs(mx - this.ox) < tol;
    }

    protected double pixelToAc(double val) {
        double retval = !this.showInverted ? this.minAxisCoord - (val - (double)this.oy) / this.scaleFactor : this.minAxisCoord - ((double)(this.oy - this.lengthInPixels) - val) / this.scaleFactor;
        return retval;
    }

    protected void positionMajorTickLabels() {
        int xstart = 0;
        int ypos = 0;
        if (this.axisNumberLocation == 1) {
            xstart = this.ox + this.getSmallGap();
            if (this.tickMarkLocation == 1 || this.tickMarkLocation == 2) {
                xstart += this.getMaxTickLength();
            }
        } else {
            xstart = this.ox - this.getSmallGap();
            if (this.tickMarkLocation == 0 || this.tickMarkLocation == 2) {
                xstart -= this.getMaxTickLength();
            }
        }
        int i = 0;
        while (i < this.tickLabel.length) {
            ypos = this.acToPixel(this.tickValue[i]) + (this.nfm.getLeading() + this.nfm.getMaxAscent()) / 2;
            this.tickLabelPos[i][0] = this.axisNumberLocation == 0 ? xstart - this.nfm.stringWidth(this.tickLabel[i]) : xstart;
            this.tickLabelPos[i][1] = ypos;
            ++i;
        }
        if (this.multiplierLabel != null) {
            this.multiplierLabelPosX = this.ox - this.nfm.stringWidth(this.multiplierLabel) / 2;
            this.multiplierLabelPosY = this.oy - this.lengthInPixels - this.arrowLength - 5 - this.nfm.getMaxDescent() / 2;
        }
    }
}

