/*
 * Decompiled with CFR 0.152.
 */
package org.jelsim.graph.axis;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Polygon;
import org.jelsim.beans.support.BeanSupport;
import org.jelsim.graph.axis.AxisDrawDelegate;

public class HorizontalAxisDrawDelegate
extends AxisDrawDelegate {
    public static final long serialVersionUID = -2274913569223942472L;

    public HorizontalAxisDrawDelegate() {
    }

    public HorizontalAxisDrawDelegate(int orientation, BeanSupport parent) {
        super(0, parent);
    }

    public HorizontalAxisDrawDelegate(BeanSupport parent) {
        super(0, parent);
    }

    protected int acToPixel(double val) {
        int retval = !this.showInverted ? (int)((double)this.ox + (val - this.minAxisCoord) * this.scaleFactor) : (int)((double)(this.ox + this.lengthInPixels) - (val - this.minAxisCoord) * this.scaleFactor);
        return retval;
    }

    public void adjustArrow() {
        this.arrow = new Polygon();
        this.arrow.addPoint(this.ox + this.lengthInPixels, this.oy + 6);
        this.arrow.addPoint(this.ox + this.lengthInPixels, this.oy - 6);
        this.arrow.addPoint(this.ox + this.lengthInPixels + this.arrowLength, this.oy);
    }

    public void drawLine(Graphics g) {
        g.drawLine(this.ox, this.oy, this.ox + this.lengthInPixels, this.oy);
        if (this.isShowThickAxis()) {
            g.drawLine(this.ox, this.oy + 1, this.ox + this.lengthInPixels, this.oy + 1);
        }
    }

    public void drawTicks(Graphics g) {
        double ai;
        int numSteps = (int)((this.maxMajorTick - this.minMajorTick) / this.majorTickInterval);
        numSteps = this.minMajorTick + (double)(numSteps + 1) * this.majorTickInterval <= this.maxAxisCoord ? (numSteps += 2) : ++numSteps;
        double start = this.minMajorTick - this.majorTickInterval;
        int i = 1;
        while (i <= numSteps) {
            ai = start + (double)i * this.majorTickInterval;
            int pos = this.acToPixel(ai);
            switch (this.tickMarkLocation) {
                case 0: {
                    g.drawLine(pos, this.oy, pos, this.oy - this.majorTickLength);
                    break;
                }
                case 1: {
                    g.drawLine(pos, this.oy, pos, this.oy + this.majorTickLength);
                    break;
                }
                case 2: {
                    g.drawLine(pos, this.oy + this.majorTickLength, pos, this.oy - this.majorTickLength);
                    break;
                }
            }
            ++i;
        }
        ai = this.minMajorTick;
        while (ai >= this.minAxisCoord) {
            int val = this.acToPixel(ai);
            switch (this.tickMarkLocation) {
                case 0: {
                    g.drawLine(val, this.oy, val, this.oy - this.minorTickLength);
                    break;
                }
                case 1: {
                    g.drawLine(val, this.oy, val, this.oy + this.minorTickLength);
                    break;
                }
                case 2: {
                    g.drawLine(val, this.oy + this.minorTickLength, val, this.oy - this.minorTickLength);
                    break;
                }
            }
            ai -= this.minorTickInterval;
        }
        double ai2 = this.maxMajorTick;
        while (ai2 <= this.maxAxisCoord) {
            int val = this.acToPixel(ai2);
            switch (this.tickMarkLocation) {
                case 0: {
                    g.drawLine(val, this.oy, val, this.oy - this.minorTickLength);
                    break;
                }
                case 1: {
                    g.drawLine(val, this.oy, val, this.oy + this.minorTickLength);
                    break;
                }
                case 2: {
                    g.drawLine(val, this.oy + this.minorTickLength, val, this.oy - this.minorTickLength);
                    break;
                }
            }
            ai2 += this.minorTickInterval;
        }
        double ai3 = this.minMajorTick;
        while (ai3 <= this.maxMajorTick) {
            int val = this.acToPixel(ai3);
            switch (this.tickMarkLocation) {
                case 0: {
                    g.drawLine(val, this.oy, val, this.oy - this.minorTickLength);
                    break;
                }
                case 1: {
                    g.drawLine(val, this.oy, val, this.oy + this.minorTickLength);
                    break;
                }
                case 2: {
                    g.drawLine(val, this.oy + this.minorTickLength, val, this.oy - this.minorTickLength);
                    break;
                }
            }
            ai3 += this.minorTickInterval;
        }
    }

    public int getExtraLengthRequired(int o) {
        int retval = 0;
        if (this.nfm == null) {
            return 0;
        }
        retval = this.maxLabelLength / 2 * this.nfm.charWidth('0');
        return retval;
    }

    public int getMaxWidthRequired() {
        int retval = 0;
        FontMetrics nfmo = this.nfm;
        if (this.nfm == null) {
            return 0;
        }
        retval = nfmo != null ? this.majorTickLength + nfmo.getLeading() + nfmo.getMaxAscent() : this.majorTickLength;
        return retval;
    }

    public boolean onLine(int mx, int my) {
        int tol = 3;
        return mx > this.ox - tol && mx < this.ox + this.lengthInPixels + tol && Math.abs(my - this.oy) < tol;
    }

    protected double pixelToAc(double val) {
        double retval = !this.showInverted ? this.minAxisCoord + (val - (double)this.ox) / this.scaleFactor : this.minAxisCoord + ((double)(this.ox + this.lengthInPixels) - val) / this.scaleFactor;
        return retval;
    }

    protected void positionMajorTickLabels() {
        int ypos = 0;
        if (this.axisNumberLocation == 1) {
            ypos = this.oy + this.nfm.getLeading() + this.nfm.getMaxAscent();
            if (this.tickMarkLocation == 1 || this.tickMarkLocation == 2) {
                ypos += this.majorTickLength;
            }
        } else {
            ypos = this.oy - this.nfm.getMaxDescent() / 2;
            if (this.tickMarkLocation == 0 || this.tickMarkLocation == 2) {
                ypos -= this.majorTickLength;
            }
        }
        int i = 0;
        while (i < this.tickLabel.length) {
            this.tickLabelPos[i][0] = this.acToPixel(this.tickValue[i]) - this.nfm.stringWidth(this.tickLabel[i]) / 2;
            this.tickLabelPos[i][1] = ypos;
            ++i;
        }
        if (this.multiplierLabel != null) {
            this.multiplierLabelPosX = this.ox + this.lengthInPixels + this.arrowLength + 5;
            this.multiplierLabelPosY = this.oy + this.nfm.getMaxDescent() / 2;
        }
    }
}

