/*
 * Decompiled with CFR 0.152.
 */
package org.jelsim.graph.axis;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Polygon;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jelsim.beans.numberformatter.NumberFormatter;
import org.jelsim.beans.support.BeanSupport;
import org.jelsim.beans.support.InternalBean;
import org.jelsim.beans.support.ModelAccessInterface;
import org.jelsim.model.event.ModelUpdateEvent;
import org.jelsim.model.event.ModelUpdateListener;
import org.jelsim.model.map.ModelPropertyInterface;
import org.jelsim.system.ErrorHandler;

public class AxisDrawDelegate
implements Serializable,
InternalBean,
ModelUpdateListener {
    public static final long serialVersionUID = -4555822229430407403L;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int BOTH = 2;
    public static final int ABOVE = 0;
    public static final int BELOW = 1;
    public static final int AUTOMATIC = 0;
    public static final int MODEL_PROPERTY = 1;
    public static final int FIXED = 2;
    public static final int SCALE_NORMAL = 0;
    public static final int SCALE_LOG10_POWERS = 2;
    public static final int SCALE_LOG10 = 1;
    public static final int SCALE_LOGE = 3;
    protected transient double[] tickValue = null;
    protected transient String[] tickLabel = null;
    protected transient int[][] tickLabelPos = null;
    protected transient String multiplierLabel = null;
    protected transient int multiplierLabelPosX = 0;
    protected transient int multiplierLabelPosY = 0;
    protected transient ModelPropertyInterface minValueProperty = null;
    protected transient ModelPropertyInterface maxValueProperty = null;
    protected transient ModelPropertyInterface minorUnitProperty = null;
    protected transient ModelPropertyInterface majorUnitProperty = null;
    protected int minValueScheme = 0;
    protected int maxValueScheme = 0;
    protected int minorUnitScheme = 0;
    protected int majorUnitScheme = 0;
    protected boolean roundValues = false;
    protected double minValue = 0.0;
    protected double maxValue = 0.0;
    protected double minValueFixedValue = 0.0;
    protected double maxValueFixedValue = 100.0;
    protected double minorUnitFixedValue = 0.1;
    protected double majorUnitFixedValue = 1.0;
    protected double majorUnit = 1.0;
    protected double minorUnit = 0.1;
    protected boolean showScale = true;
    protected boolean showTicks = true;
    protected boolean showThickAxis = true;
    protected int arrowLength = 12;
    protected transient Polygon arrow = null;
    protected boolean showArrow = true;
    protected boolean allowRescale = true;
    protected boolean warnRescale = false;
    protected double maxWorldCoord = 1.0;
    protected double minWorldCoord = -1.0;
    protected int fixedStart = -1;
    protected int fixedLength = -1;
    protected int lengthInPixels;
    protected int minMinorTickGap = 8;
    protected int orientation = 0;
    protected int ox = 0;
    protected int oy = 0;
    protected int majorTickLength = 5;
    protected int minorTickLength = 2;
    protected int tickMarkLocation = 1;
    protected int axisNumberLocation = 1;
    protected transient Color axisColor = Color.black;
    protected int axisColorCode = this.axisColor.getRGB();
    protected transient Color numberColor = Color.black;
    protected int numberColorCode = this.numberColor.getRGB();
    protected transient Font font;
    protected int fontSize;
    protected int fontStyle;
    protected String fontName;
    protected String label = "unlabelled";
    protected double userMajorTickInterval = 0.0;
    protected boolean showInverted = false;
    protected int scaleType = 0;
    protected double maxMajorTick;
    protected double minMajorTick;
    protected double majorTickInterval;
    protected double minorTickInterval;
    protected int maxLabelLength = 6;
    protected double maxAxisCoord;
    protected double minAxisCoord;
    protected transient FontMetrics nfm;
    protected double scaleFactor;
    protected transient BeanSupport parent = null;
    protected transient ModelAccessInterface ma = null;
    protected NumberFormatter numberFormatter = null;

    public AxisDrawDelegate() {
    }

    public AxisDrawDelegate(int orientation, BeanSupport parent) {
        this.parent = parent;
        this.orientation = orientation;
        this.numberFormatter = new NumberFormatter();
        this.numberFormatter.setConversion(2);
        this.numberFormatter.setDecimalPlaces(2);
        this.initializeFonts();
        this.calculateScaleFactor();
        this.calculateTickValues(this.maxWorldCoord, this.minWorldCoord, this.lengthInPixels, this.minMinorTickGap);
        this.adjustArrow();
    }

    public AxisDrawDelegate(BeanSupport parent) {
        this(0, parent);
    }

    protected int acToPixel(double val) {
        return 0;
    }

    public void adjustArrow() {
    }

    private void adjustParentSize() {
        if (this.parent != null && this.parent instanceof BeanSupport) {
            this.parent.adjustSize();
        }
    }

    private double calculateMinorTickInterval(double tckmin) {
        double minorTickInterval = 0.0;
        double TCKLOG = Math.log(tckmin) / Math.log(10.0);
        int ipowr = (int)TCKLOG;
        double rem = Math.abs(TCKLOG - (double)ipowr);
        if (TCKLOG > 0.0) {
            if (ipowr != 0) {
                double AMULT = rem > Math.log(5.0) / Math.log(10.0) ? 10.0 : (rem > Math.log(2.0) / Math.log(10.0) ? 5.0 : 2.0);
                minorTickInterval = Math.pow(10.0, ipowr) * AMULT;
            } else if (ipowr == 0) {
                minorTickInterval = rem > Math.log(5.0) / Math.log(10.0) ? 10.0 : (rem > Math.log(2.0) / Math.log(10.0) ? 5.0 : 2.0);
            }
        } else if (ipowr == 0) {
            minorTickInterval = 1.0 - rem > Math.log(5.0) / Math.log(10.0) ? 1.0 : (1.0 - rem > Math.log(2.0) / Math.log(10.0) ? 0.5 : 0.2);
        } else if (ipowr != 0) {
            double AMULT = 1.0 - rem > Math.log(5.0) / Math.log(10.0) ? 1.0 : (1.0 - rem > Math.log(2.0) / Math.log(10.0) ? 0.5 : 0.2);
            minorTickInterval = Math.pow(10.0, ipowr) * AMULT;
        }
        return minorTickInterval;
    }

    protected double calculateScaleFactor() {
        switch (this.scaleType) {
            case 0: {
                this.maxAxisCoord = this.maxWorldCoord;
                this.minAxisCoord = this.minWorldCoord;
                break;
            }
            case 1: 
            case 2: {
                this.maxAxisCoord = Math.log(this.maxWorldCoord) / Math.log(10.0);
                this.minAxisCoord = Math.log(this.minWorldCoord) / Math.log(10.0);
                break;
            }
            default: {
                this.maxAxisCoord = this.maxWorldCoord;
                this.minAxisCoord = this.minWorldCoord;
            }
            case 3: 
        }
        this.scaleFactor = (double)this.lengthInPixels / (this.maxAxisCoord - this.minAxisCoord);
        return this.scaleFactor;
    }

    protected void calculateTickValues(double maxWorldCoord, double minWorldCoord, double lengthInPixels, int minMinorTickGap) {
        if (this.scaleType > 0 && (maxWorldCoord <= 0.0 || minWorldCoord <= 0.0)) {
            this.setScaleType(0);
        }
        if (this.majorUnitScheme != 0) {
            this.majorTickInterval = this.majorUnit;
            this.minorTickInterval = this.minorUnitScheme != 0 ? this.minorUnit : this.majorTickInterval / 5.0;
        } else {
            double axlen = this.maxAxisCoord - this.minAxisCoord;
            double tckmin = (double)minMinorTickGap / lengthInPixels * axlen;
            this.majorTickInterval = 5.0 * this.calculateMinorTickInterval(tckmin);
            this.minorTickInterval = this.minorUnitScheme != 0 ? this.minorUnitFixedValue : this.majorTickInterval / 5.0;
        }
        this.maxMajorTick = maxWorldCoord <= 0.0 ? (double)((int)(this.maxAxisCoord / this.majorTickInterval) - 1) * this.majorTickInterval : (double)((int)(this.maxAxisCoord / this.majorTickInterval)) * this.majorTickInterval;
        if (this.maxMajorTick + this.majorTickInterval <= this.maxAxisCoord - 1.0E-5 * (this.maxAxisCoord - this.minAxisCoord)) {
            this.maxMajorTick = this.maxAxisCoord;
        }
        this.minMajorTick = this.minAxisCoord <= 0.0 ? (double)((int)(this.minAxisCoord / this.majorTickInterval)) * this.majorTickInterval : (double)((int)(this.minAxisCoord / this.majorTickInterval) + 1) * this.majorTickInterval;
        if (this.maxMajorTick == this.minMajorTick) {
            ErrorHandler.reportMessage((String)"too small to label");
        }
    }

    public void draw(Graphics g) {
        this.getRelevantGraphicsInfo(g);
        g.setColor(this.axisColor);
        this.drawLine(g);
        if (this.showTicks) {
            g.setColor(this.axisColor);
            this.drawTicks(g);
        }
        if (this.showScale) {
            g.setColor(this.numberColor);
            this.labelMajorTicks(g);
        }
        if (this.showArrow && this.arrow != null) {
            g.setColor(this.axisColor);
            g.fillPolygon(this.arrow);
        }
    }

    public void drawLine(Graphics g) {
    }

    public void drawTicks(Graphics g) {
    }

    protected void generateMajorTickLabels() {
        double multiplier = 1.0;
        NumberFormatter nf = new NumberFormatter(this.numberFormatter);
        nf.setModelAccess(this.ma);
        boolean showMultiplier = this.numberFormatter.getConversion() == 1;
        int numSteps = 0;
        double range = this.maxMajorTick - this.minMajorTick;
        numSteps = range == 0.0 ? 0 : (int)((this.maxMajorTick - this.minMajorTick) / this.majorTickInterval);
        numSteps = this.minMajorTick + (double)(numSteps + 1) * this.majorTickInterval <= this.maxAxisCoord ? (numSteps += 2) : ++numSteps;
        this.tickValue = new double[numSteps];
        this.tickLabel = new String[numSteps];
        this.tickLabelPos = new int[numSteps][2];
        double start = this.minMajorTick - this.majorTickInterval;
        if (showMultiplier) {
            nf.setPrefixString(null);
            nf.setPostfixString(null);
            nf.setFieldWidth(8);
            nf.setDecimalPlaces(1);
            double val = Math.max(Math.abs(start + this.majorTickInterval), Math.abs(start + (double)numSteps * this.majorTickInterval));
            String valString = nf.toString(val);
            int ePos = valString.indexOf(nf.isExponentUpperCase() ? 69 : 101);
            int exponent = valString.charAt(ePos + 1) != '+' ? Integer.parseInt(valString.substring(ePos + 1)) : Integer.parseInt(valString.substring(ePos + 2).trim());
            multiplier = Math.pow(10.0, exponent);
            this.multiplierLabel = nf.toString(multiplier).trim();
            ePos = this.multiplierLabel.indexOf(nf.isExponentUpperCase() ? 69 : 101);
            this.multiplierLabel = new String("(" + this.multiplierLabel.substring(ePos) + ")");
            nf.setPrefixString(this.numberFormatter.getPrefixString());
            nf.setPostfixString(this.numberFormatter.getPostfixString());
            nf.setFieldWidth(this.numberFormatter.getFieldWidth());
            nf.setDecimalPlaces(this.numberFormatter.getDecimalPlaces());
            nf.setConversion(2);
        } else {
            this.multiplierLabel = null;
        }
        int i = 1;
        while (i <= numSteps) {
            double ai;
            this.tickValue[i - 1] = ai = start + (double)i * this.majorTickInterval;
            this.tickLabel[i - 1] = this.scaleType == 1 ? nf.toString(Math.pow(10.0, ai / multiplier)) : nf.toString(ai / multiplier);
            ++i;
        }
        this.positionMajorTickLabels();
    }

    public int getArrowLength() {
        return this.arrowLength;
    }

    public Color getAxisColor() {
        return this.axisColor;
    }

    public int getAxisNumberLocation() {
        return this.axisNumberLocation;
    }

    public int getExtraLengthRequired(int o) {
        return 30;
    }

    public int getFixedLength() {
        return this.fixedLength;
    }

    public int getFixedStart() {
        return this.fixedStart;
    }

    public Font getFont() {
        return this.font;
    }

    public int getLengthInPixels() {
        return this.lengthInPixels;
    }

    public double getMajorTickInterval() {
        return this.majorTickInterval;
    }

    public int getMajorTickLength() {
        return this.majorTickLength;
    }

    public double getMajorTickStartPoint() {
        return this.minMajorTick;
    }

    public double getMajorUnit() {
        return this.majorUnit;
    }

    public double getMajorUnitFixedValue() {
        return this.majorUnitFixedValue;
    }

    public ModelPropertyInterface getMajorUnitProperty() {
        return this.minorUnitProperty;
    }

    public int getMajorUnitScheme() {
        return this.majorUnitScheme;
    }

    public int getMaxLabelHeight() {
        return this.nfm.getHeight();
    }

    public int getMaxLabelWidth() {
        int nchar = Math.max(6, this.numberFormatter.getFieldWidth());
        return nchar * this.nfm.charWidth('0');
    }

    public int getMaxTickLength() {
        return this.majorTickLength > this.minorTickLength ? this.majorTickLength : this.minorTickLength;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public double getMaxValueFixedValue() {
        return this.maxValueFixedValue;
    }

    public ModelPropertyInterface getMaxValueProperty() {
        return this.maxValueProperty;
    }

    public int getMaxValueScheme() {
        return this.maxValueScheme;
    }

    public int getMaxWidthRequired() {
        return 100;
    }

    public double getMaxWorldCoord() {
        return this.maxWorldCoord;
    }

    public int getMinMinorTickGap() {
        return this.minMinorTickGap;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public double getMinValueFixedValue() {
        return this.minValueFixedValue;
    }

    public ModelPropertyInterface getMinValueProperty() {
        return this.minValueProperty;
    }

    public int getMinValueScheme() {
        return this.minValueScheme;
    }

    public double getMinWorldCoord() {
        return this.minWorldCoord;
    }

    public int getMinorTickLength() {
        return this.minorTickLength;
    }

    public double getMinorUnit() {
        return this.minorUnit;
    }

    public double getMinorUnitFixedValue() {
        return this.minorUnitFixedValue;
    }

    public ModelPropertyInterface getMinorUnitProperty() {
        return this.minorUnitProperty;
    }

    public int getMinorUnitScheme() {
        return this.minorUnitScheme;
    }

    public Color getNumberColor() {
        return this.numberColor;
    }

    public NumberFormatter getNumberFormatter() {
        return this.numberFormatter;
    }

    public int getNumberOfMajorTicks() {
        int numSteps;
        double range = this.maxMajorTick - this.minMajorTick;
        if (range == 0.0) {
            numSteps = 0;
            ErrorHandler.reportMessage((String)"The range of one graph axis is 0. Axes will be inaccurate");
        } else {
            numSteps = (int)((this.maxMajorTick - this.minMajorTick) / this.majorTickInterval);
        }
        numSteps = this.minMajorTick + (double)(numSteps + 1) * this.majorTickInterval <= this.maxAxisCoord ? (numSteps += 2) : ++numSteps;
        return numSteps;
    }

    public int getOx() {
        return this.ox;
    }

    public int getOy() {
        return this.oy;
    }

    public BeanSupport getParent() {
        return this.parent;
    }

    protected void getRelevantGraphicsInfo(Graphics g) {
        g.setFont(this.font);
        this.nfm = g.getFontMetrics();
    }

    public boolean getRescaleWarning() {
        return this.warnRescale;
    }

    public int getScaleType() {
        return this.scaleType;
    }

    public boolean getShowInverted() {
        return this.showInverted;
    }

    public int getSmallGap() {
        return this.nfm.charWidth('0') / 3;
    }

    public int getTickMarkLocation() {
        return this.tickMarkLocation;
    }

    public double getUserMajorTickInterval() {
        return this.userMajorTickInterval;
    }

    public synchronized void handleModelUpdate(ModelUpdateEvent e) {
        ModelPropertyInterface source = (ModelPropertyInterface)e.getSource();
        Object value = e.getValue();
        if (this.minValueProperty != null && this.minValueProperty.sameMapStore(source)) {
            if (this.minValueScheme == 1) {
                this.setMinValue(((Number)source.getValue()).doubleValue());
                this.adjustParentSize();
            }
        } else if (this.maxValueProperty != null && this.maxValueProperty.sameMapStore(source)) {
            if (this.maxValueScheme == 1) {
                this.setMaxValue(((Number)source.getValue()).doubleValue());
                this.adjustParentSize();
            }
        } else if (this.majorUnitProperty != null && this.majorUnitProperty.sameMapStore(source)) {
            if (this.majorUnitScheme == 1) {
                this.setMajorUnit(((Number)source.getValue()).doubleValue());
                this.calculateTickValues(this.maxWorldCoord, this.minWorldCoord, this.lengthInPixels, this.minMinorTickGap);
                this.adjustParentSize();
            }
        } else if (this.minorUnitProperty != null && this.minorUnitProperty.sameMapStore(source) && this.minorUnitScheme == 1) {
            this.setMinorUnit(((Number)source.getValue()).doubleValue());
            this.calculateTickValues(this.maxWorldCoord, this.minWorldCoord, this.lengthInPixels, this.minMinorTickGap);
            this.adjustParentSize();
        }
    }

    protected void initializeFonts() {
        this.font = new Font("TimesRoman", 0, 10);
        this.fontName = this.font.getName();
        this.fontSize = 10;
        this.fontStyle = 0;
        if (this.parent != null) {
            this.nfm = this.parent.getFontMetrics(this.font);
        }
    }

    public boolean isRoundValues() {
        return this.roundValues;
    }

    public boolean isShowArrow() {
        return this.showArrow;
    }

    public boolean isShowScale() {
        return this.showScale;
    }

    public boolean isShowThickAxis() {
        return this.showThickAxis;
    }

    public boolean isShowTicks() {
        return this.showTicks;
    }

    protected void labelMajorTicks(Graphics g) {
        this.generateMajorTickLabels();
        int i = 0;
        while (i < this.tickLabel.length) {
            g.drawString(this.tickLabel[i], this.tickLabelPos[i][0], this.tickLabelPos[i][1]);
            ++i;
        }
        if (this.multiplierLabel != null) {
            g.drawString(this.multiplierLabel, this.multiplierLabelPosX, this.multiplierLabelPosY);
        }
    }

    public boolean onLine(int mx, int my) {
        return false;
    }

    protected double pixelToAc(double val) {
        return 0.0;
    }

    public double pixelToWc(double val) {
        double retval = 0.0;
        if (this.scaleType == 0) {
            retval = this.pixelToAc(val);
        }
        return retval;
    }

    protected void positionMajorTickLabels() {
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.numberColor = new Color(this.numberColorCode);
        this.axisColor = new Color(this.axisColorCode);
        this.font = new Font(this.fontName, this.fontStyle, this.fontSize);
    }

    public void removeModelListeners() {
        if (this.minValueProperty != null) {
            this.ma.removeModelUpdateListener(this.minValueProperty, (ModelUpdateListener)this);
        }
        if (this.maxValueProperty != null) {
            this.ma.removeModelUpdateListener(this.maxValueProperty, (ModelUpdateListener)this);
        }
        if (this.minorUnitProperty != null) {
            this.ma.removeModelUpdateListener(this.minorUnitProperty, (ModelUpdateListener)this);
        }
        if (this.majorUnitProperty != null) {
            this.ma.removeModelUpdateListener(this.majorUnitProperty, (ModelUpdateListener)this);
        }
    }

    public void setArrowLength(int i) {
        this.arrowLength = i;
        this.adjustParentSize();
    }

    public void setAxisColor(Color col) {
        this.axisColor = col;
        this.axisColorCode = col.getRGB();
        this.adjustParentSize();
    }

    public void setAxisNumberLocation(int all) {
        this.axisNumberLocation = all;
        this.adjustParentSize();
    }

    public void setFixedLength(int i) {
        this.fixedLength = i;
        this.adjustParentSize();
    }

    public void setFixedStart(int i) {
        this.fixedStart = i;
        this.adjustParentSize();
    }

    public void setFont(Font nf) {
        this.font = nf;
        this.fontName = this.font.getName();
        this.fontSize = this.font.getSize();
        this.fontStyle = this.font.getStyle();
        if (this.parent != null) {
            this.nfm = this.parent.getFontMetrics(this.font);
        }
        this.adjustParentSize();
    }

    public void setLengthInPixels(int lip) {
        this.lengthInPixels = lip;
        this.calculateScaleFactor();
        this.calculateTickValues(this.maxWorldCoord, this.minWorldCoord, this.lengthInPixels, this.minMinorTickGap);
        this.adjustArrow();
    }

    public void setMajorTickLength(int mtl) {
        this.majorTickLength = mtl;
        this.adjustParentSize();
    }

    public void setMajorUnit(double d) {
        this.majorUnit = d;
    }

    public void setMajorUnitFixedValue(double d) {
        this.majorUnitFixedValue = Math.abs(d);
        if (this.majorUnitScheme == 2) {
            this.setMajorUnit(this.majorUnitFixedValue);
            this.calculateTickValues(this.maxWorldCoord, this.minWorldCoord, this.lengthInPixels, this.minMinorTickGap);
            this.adjustParentSize();
        }
    }

    public void setMajorUnitProperty(ModelPropertyInterface fmp) {
        if (this.majorUnitProperty != null && this.ma != null) {
            this.ma.removeModelUpdateListener(this.majorUnitProperty, (ModelUpdateListener)this);
        }
        this.majorUnitProperty = fmp;
        if (this.ma != null && this.majorUnitProperty != null) {
            this.ma.addModelUpdateListener(this.majorUnitProperty, (ModelUpdateListener)this);
            if (this.majorUnitScheme == 1) {
                this.setMajorUnit(((Number)fmp.getValue()).doubleValue());
                this.calculateTickValues(this.maxWorldCoord, this.minWorldCoord, this.lengthInPixels, this.minMinorTickGap);
            }
        }
        this.adjustParentSize();
    }

    public void setMajorUnitScheme(int i) {
        this.majorUnitScheme = i;
        if (this.majorUnitScheme == 2) {
            this.setMajorUnit(this.majorUnitFixedValue);
        } else if (this.majorUnitScheme == 1 && this.majorUnitProperty != null) {
            this.setMajorUnit(((Number)this.maxValueProperty.getValue()).doubleValue());
        }
        this.calculateTickValues(this.maxWorldCoord, this.minWorldCoord, this.lengthInPixels, this.minMinorTickGap);
        this.adjustParentSize();
    }

    public void setMaxValue(double value) {
        double oldMaxWorldCoord = this.maxWorldCoord;
        this.maxValue = value;
        this.setMinMaxWorldCoord(this.minValue, this.maxValue);
        if (this.getRescaleWarning() && this.maxWorldCoord != oldMaxWorldCoord) {
            this.parent.showError("The axis has been re-scaled");
        }
    }

    public void setMaxValueFixedValue(double d) {
        this.maxValueFixedValue = d;
        if (this.maxValueScheme == 2) {
            this.setMaxValue(d);
            this.adjustParentSize();
        }
    }

    public void setMaxValueProperty(ModelPropertyInterface fmp) {
        if (fmp != this.maxValueProperty) {
            if (this.maxValueProperty != null && this.ma != null) {
                this.ma.removeModelUpdateListener(this.maxValueProperty, (ModelUpdateListener)this);
            }
            this.maxValueProperty = fmp;
            if (this.ma != null && this.maxValueProperty != null) {
                this.ma.addModelUpdateListener(this.maxValueProperty, (ModelUpdateListener)this);
                if (this.maxValueScheme == 1) {
                    this.setMaxValue(((Number)fmp.getValue()).doubleValue());
                }
            }
            this.adjustParentSize();
        }
    }

    public void setMaxValueScheme(int i) {
        this.maxValueScheme = i;
        if (this.maxValueScheme == 2) {
            this.setMaxValue(this.maxValueFixedValue);
        } else if (this.maxValueScheme == 1 && this.maxValueProperty != null) {
            this.setMaxValue(((Number)this.maxValueProperty.getValue()).doubleValue());
        }
        this.adjustParentSize();
    }

    public void setMaxWorldCoord(double mwc) {
        this.maxWorldCoord = mwc;
        this.calculateScaleFactor();
        this.calculateTickValues(this.maxWorldCoord, this.minWorldCoord, this.lengthInPixels, this.minMinorTickGap);
    }

    public void setMinMaxWorldCoord(double min, double max) {
        double worldMax;
        double worldMin = this.roundValues ? Math.floor(min) : min;
        double d = worldMax = this.roundValues ? Math.ceil(max) : max;
        if (worldMin >= worldMax) {
            double val = worldMin;
            if (val > 0.0) {
                worldMin = 0.95 * val;
                worldMax = 1.05 * val;
            } else if (val < 0.0) {
                worldMin = 1.05 * val;
                worldMax = 0.95 * val;
            } else {
                worldMin = -1.0;
                worldMax = 1.0;
            }
        }
        this.minWorldCoord = worldMin;
        this.maxWorldCoord = worldMax;
        this.calculateScaleFactor();
        this.calculateTickValues(this.maxWorldCoord, this.minWorldCoord, this.lengthInPixels, this.minMinorTickGap);
    }

    public void setMinMinorTickGap(int mtg) {
        if (mtg != this.minMinorTickGap) {
            this.minMinorTickGap = mtg;
            this.calculateScaleFactor();
            this.calculateTickValues(this.maxWorldCoord, this.minWorldCoord, this.lengthInPixels, this.minMinorTickGap);
        }
    }

    public void setMinValue(double value) {
        double oldMinWorldCoord = this.minWorldCoord;
        this.minValue = value;
        this.setMinMaxWorldCoord(this.minValue, this.maxValue);
        if (this.getRescaleWarning() && this.minWorldCoord != oldMinWorldCoord) {
            this.parent.showError("The axis has been re-scaled");
        }
    }

    public void setMinValueFixedValue(double d) {
        this.minValueFixedValue = d;
        if (this.minValueScheme == 2) {
            this.setMinValue(d);
            this.adjustParentSize();
        }
    }

    public void setMinValueProperty(ModelPropertyInterface fmp) {
        if (this.minValueProperty != null && this.ma != null) {
            this.ma.removeModelUpdateListener(this.minValueProperty, (ModelUpdateListener)this);
        }
        this.minValueProperty = fmp;
        if (this.ma != null && this.minValueProperty != null) {
            this.ma.addModelUpdateListener(this.minValueProperty, (ModelUpdateListener)this);
            if (this.minValueScheme == 1) {
                this.setMinValue(((Number)fmp.getValue()).doubleValue());
            }
        }
        this.adjustParentSize();
    }

    public void setMinValueScheme(int i) {
        this.minValueScheme = i;
        if (this.minValueScheme == 2) {
            this.setMinValue(this.minValueFixedValue);
        } else if (this.minValueScheme == 1 && this.minValueProperty != null) {
            this.setMinValue(((Number)this.minValueProperty.getValue()).doubleValue());
        }
        this.adjustParentSize();
    }

    public void setMinWorldCoord(double mwc) {
        this.minWorldCoord = mwc;
        this.calculateScaleFactor();
        this.calculateTickValues(this.maxWorldCoord, this.minWorldCoord, this.lengthInPixels, this.minMinorTickGap);
    }

    public void setMinorTickLength(int mtl) {
        this.minorTickLength = mtl;
        this.adjustParentSize();
    }

    public void setMinorUnit(double d) {
        this.minorUnit = d;
        this.calculateTickValues(this.maxWorldCoord, this.minWorldCoord, this.lengthInPixels, this.minMinorTickGap);
        this.adjustParentSize();
    }

    public void setMinorUnitFixedValue(double d) {
        this.minorUnitFixedValue = Math.abs(d);
        if (this.minorUnitScheme == 2) {
            this.setMinorUnit(this.minorUnitFixedValue);
            this.calculateTickValues(this.maxWorldCoord, this.minWorldCoord, this.lengthInPixels, this.minMinorTickGap);
            this.adjustParentSize();
        }
    }

    public void setMinorUnitProperty(ModelPropertyInterface fmp) {
        if (this.minorUnitProperty != null && this.ma != null) {
            this.ma.removeModelUpdateListener(this.minorUnitProperty, (ModelUpdateListener)this);
        }
        this.minorUnitProperty = fmp;
        if (this.ma != null && this.minorUnitProperty != null) {
            this.ma.addModelUpdateListener(this.minorUnitProperty, (ModelUpdateListener)this);
            if (this.minorUnitScheme == 1) {
                this.setMinorUnit(((Number)fmp.getValue()).doubleValue());
                this.calculateTickValues(this.maxWorldCoord, this.minWorldCoord, this.lengthInPixels, this.minMinorTickGap);
            }
        }
        this.adjustParentSize();
    }

    public void setMinorUnitScheme(int i) {
        this.minorUnitScheme = i;
        if (this.minorUnitScheme == 2) {
            this.setMinorUnit(this.minorUnitFixedValue);
        } else if (this.minorUnitScheme == 1 && this.minorUnitProperty != null) {
            this.setMinorUnit(((Number)this.maxValueProperty.getValue()).doubleValue());
        }
        this.calculateTickValues(this.maxWorldCoord, this.minWorldCoord, this.lengthInPixels, this.minMinorTickGap);
        this.adjustParentSize();
    }

    public void setModelAccess(ModelAccessInterface ma) {
        if (this.numberFormatter != null) {
            this.numberFormatter.setModelAccess(ma);
        }
        if (this.ma != null) {
            this.removeModelListeners();
        }
        if (ma != null) {
            boolean doAdjust = false;
            if (this.minValueProperty != null) {
                ma.addModelUpdateListener(this.minValueProperty, (ModelUpdateListener)this);
                if (this.minValueScheme == 1) {
                    this.setMinValue(((Number)this.minValueProperty.getValue()).doubleValue());
                    doAdjust = true;
                }
            }
            if (this.maxValueProperty != null) {
                ma.addModelUpdateListener(this.maxValueProperty, (ModelUpdateListener)this);
                if (this.maxValueScheme == 1) {
                    this.setMaxValue(((Number)this.maxValueProperty.getValue()).doubleValue());
                    doAdjust = true;
                }
            }
            if (this.minorUnitProperty != null) {
                ma.addModelUpdateListener(this.minorUnitProperty, (ModelUpdateListener)this);
                if (this.minorUnitScheme == 1) {
                    this.setMinorUnit(((Number)this.minorUnitProperty.getValue()).doubleValue());
                    this.calculateTickValues(this.maxWorldCoord, this.minWorldCoord, this.lengthInPixels, this.minMinorTickGap);
                    doAdjust = true;
                }
            }
            if (this.majorUnitProperty != null) {
                ma.addModelUpdateListener(this.majorUnitProperty, (ModelUpdateListener)this);
                if (this.majorUnitScheme == 1) {
                    this.setMajorUnit(((Number)this.majorUnitProperty.getValue()).doubleValue());
                    this.calculateTickValues(this.maxWorldCoord, this.minWorldCoord, this.lengthInPixels, this.minMinorTickGap);
                    doAdjust = true;
                }
            }
            if (doAdjust) {
                this.adjustParentSize();
            }
        }
        this.ma = ma;
    }

    public void setNumberColor(Color col) {
        this.numberColor = col;
        this.numberColorCode = col.getRGB();
        this.adjustParentSize();
    }

    public void setNumberFormatter(NumberFormatter numberFormatter) {
        if (numberFormatter != null) {
            numberFormatter.setModelAccess(this.ma);
        }
        this.numberFormatter = numberFormatter;
        this.adjustParentSize();
    }

    public void setOx(int xpos) {
        this.ox = xpos;
        this.adjustArrow();
    }

    public void setOy(int ypos) {
        this.oy = ypos;
        this.adjustArrow();
    }

    public void setParent(BeanSupport c) {
        this.parent = c;
        this.setFont(this.font);
    }

    public void setRescaleWarning(boolean b) {
        this.warnRescale = b;
    }

    public void setRoundValues(boolean b) {
        this.roundValues = b;
        this.setMinValue(this.minValue);
        this.setMaxValue(this.maxValue);
        this.adjustParentSize();
    }

    public void setScaleType(int st) {
        if (st > 0 && (this.minWorldCoord <= 0.0 || this.maxWorldCoord <= 0.0)) {
            st = 0;
            this.parent.showError("Cannot set log scale on axis.  Values are 0 or below");
        }
        this.scaleType = st;
        this.adjustParentSize();
    }

    public void setShowArrow(boolean b) {
        this.showArrow = b;
        this.adjustParentSize();
    }

    public void setShowInverted(boolean b) {
        this.showInverted = b;
        this.adjustParentSize();
    }

    public void setShowScale(boolean b) {
        this.showScale = b;
        this.adjustParentSize();
    }

    public void setShowThickAxis(boolean b) {
        this.showThickAxis = b;
        this.adjustParentSize();
    }

    public void setShowTicks(boolean b) {
        this.showTicks = b;
        this.adjustParentSize();
    }

    public void setTickMarkLocation(int tml) {
        this.tickMarkLocation = tml;
        this.adjustParentSize();
    }

    public void setUserMajorTickInterval(double umti) {
        this.userMajorTickInterval = umti;
        this.calculateScaleFactor();
        this.calculateTickValues(this.maxWorldCoord, this.minWorldCoord, this.lengthInPixels, this.minMinorTickGap);
    }

    public int wcToPixel(double val) {
        int retval = 0;
        if (this.scaleType == 0) {
            retval = this.acToPixel(val);
        } else if (this.scaleType == 1 || this.scaleType == 2) {
            double dtmp = Math.log(val) / Math.log(10.0);
            retval = this.acToPixel(dtmp);
        }
        return retval;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }
}

