/*
 * Decompiled with CFR 0.152.
 */
package org.jelsim.graph;

import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import org.jelsim.graph.GraphKey;
import org.jelsim.graph.KeyColor;
import org.jelsim.graph.Series;
import org.jelsim.graph.XYGraph;

public class XYGraphKey
extends GraphKey {
    public static final long serialVersionUID = -1622872857491114704L;
    protected transient Series series = new Series();

    public XYGraphKey() {
        this.title = GraphKey.DEFAULT_TITLE;
        this.setSize(50, 50);
        this.resizable = true;
        this.setTitleFont(new Font("SansSerif", 1, 12));
        this.setKeyFont(new Font("SansSerif", 0, 12));
        String[] normaltmp = new String[]{"foreground", "keyFont", "linkId", "numberLinked", "title", "titleFont", "borderGap", "keySpacing", "minimumSymbolWidth", "titleCentered", "linked", "editable", "background"};
        this.normalSaveNames = normaltmp;
    }

    public void finalizeJelsim() {
        if (this.graph != null) {
            this.graph.setShowKey(false);
        }
    }

    public Series getSeries() {
        if (this.graph != null && this.graph instanceof XYGraph) {
            return ((XYGraph)this.graph).getSeries();
        }
        return null;
    }

    public void paint(Graphics g) {
        int symbolWidth = this.minimumSymbolWidth > 4 * this.maxPointRadius ? this.minimumSymbolWidth : 4 * this.maxPointRadius;
        int baseline = this.getBorderGap();
        int stringX = this.getBorderGap() + symbolWidth + this.keySpacing;
        g.setColor(((Component)((Object)this)).getBackground());
        g.fillRect(0, 0, this.width - 1, this.height - 1);
        if (this.title.length() > 0) {
            baseline += this.tfm.getLeading() + this.tfm.getAscent();
            g.setColor(((Component)((Object)this)).getForeground());
            g.setFont(this.titleFont);
            if (this.isTitleCentered()) {
                g.drawString(this.title, (this.width - this.tfm.stringWidth(this.title)) / 2, baseline);
            } else {
                g.drawString(this.title, this.getBorderGap(), baseline);
            }
        }
        g.setFont(this.keyFont);
        Object graphkeys = null;
        if (this.keys != null && this.keys.length > 0) {
            int keysHeight = this.kfm.getHeight() > 2 * this.maxPointRadius ? this.kfm.getHeight() : 2 * this.maxPointRadius;
            int i = 0;
            while (i < this.keys.length) {
                g.setColor(this.keys[i].getColor());
                g.drawString(this.keys[i].getKey(), stringX, baseline += keysHeight);
                int ly = baseline - this.kfm.getAscent() / 2;
                if (this.keys[i].getPlotType() <= 6) {
                    g.drawLine(this.getBorderGap(), ly, this.getBorderGap() + symbolWidth, ly);
                }
                ((KeyColor)this.keys[i]).plotPoint(g, this.getBorderGap() + symbolWidth / 2, ly);
                ++i;
            }
        }
    }

    public void setSeries(Series series) {
        if (this.graph != null && this.graph instanceof XYGraph) {
            ((XYGraph)this.graph).setSeries(series);
            ((Component)((Object)this)).repaint();
        }
    }
}

