/*
 * Decompiled with CFR 0.152.
 */
package org.jelsim.graph;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.lang.reflect.Array;
import org.jelsim.beans.support.FmpHelper;
import org.jelsim.beans.support.ModelAccessInterface;
import org.jelsim.beans.support.SimConst;
import org.jelsim.beans.support.SimpleBeanInterface;
import org.jelsim.graph.Graph;
import org.jelsim.graph.KeyColor;
import org.jelsim.graph.Series;
import org.jelsim.model.event.ModelUpdateEvent;
import org.jelsim.model.event.ModelUpdateListener;
import org.jelsim.model.map.ModelPropertyInterface;
import org.jelsim.system.ErrorHandler;

public class XYGraph
extends Graph
implements SimConst,
SimpleBeanInterface {
    public static final long serialVersionUID = -6079241905152164474L;
    protected static final int TOP = 1;
    protected static final int BOTTOM = 2;
    protected static final int RIGHT = 4;
    protected static final int LEFT = 8;
    protected KeyColor[] keys = null;
    protected Series series = new Series();
    protected ModelPropertyInterface[] seriesMP = null;
    private FmpHelper[] seriesRestoreHelpers = null;
    boolean[] layerValid = null;
    private int numberValid = 0;
    protected ModelPropertyInterface plotEndMP = null;
    protected int plotEnd;
    protected double[][][][] xySeries = null;
    protected int[][][][] xySeriesPix = null;
    protected double[] seriesXmin = null;
    protected double[] seriesXmax = null;
    protected double[] seriesYmin = null;
    protected double[] seriesYmax = null;
    protected transient int maxPointRadius = 5;

    public XYGraph() {
        this.setSize(450, 250);
        String[] fmptmp = new String[]{"resetProperty", "deltaProperty", "modelProperty", "minXValueProperty", "maxXValueProperty", "minYValueProperty", "maxYValueProperty", "minorXUnitProperty", "majorXUnitProperty", "minorYUnitProperty", "majorYUnitProperty", "plotEnd"};
        this.fmpSaveNames = fmptmp;
        String[] normaltmp = new String[]{"yaxis", "xaxis", "dataXmin", "dataXmax", "dataYmin", "dataYmax", "series", "editHelp", "clearOnReset", "title", "resizable", "foregroundColor", "backgroundColor", "font", "userHelp", "showKey", "zeroXAxis", "showHorizontalGridlines", "showVerticalGridlines", "showGraphBox", "linked", "numberLinked", "linkId", "showDeltaValues", "showMouseLocation", "deltaLineColor", "zeroYAxis", "borderGap", "transparent", "seriesProperties"};
        this.normalSaveNames = normaltmp;
        this.adjustSize();
    }

    public Series addModelPropertyToSeries(ModelPropertyInterface newProperty, Series oldSeries) {
        if (newProperty == null) {
            return oldSeries;
        }
        ModelPropertyInterface[] seriesProperties = oldSeries.getSeriesProperties();
        KeyColor[][] keyColors = oldSeries.getKeyColors();
        KeyColor[][] newKeyColors = null;
        ModelPropertyInterface[] newSeriesProperties = null;
        int oldLength = 0;
        if (seriesProperties != null) {
            oldLength = seriesProperties.length;
        }
        newKeyColors = new KeyColor[oldLength + 1][];
        newSeriesProperties = new ModelPropertyInterface[oldLength + 1];
        int i = 0;
        while (i < oldLength) {
            if (newProperty.sameMapStore(seriesProperties[i])) {
                return oldSeries;
            }
            newKeyColors[i] = keyColors[i];
            newSeriesProperties[i] = seriesProperties[i];
            ++i;
        }
        int dim = newProperty.getType() / 10000;
        int nplots = dim == 2 || newProperty.getValue() == null ? 1 : Array.getLength(newProperty.getValue());
        int newPlotNumber = oldSeries.getNewPlotNumber();
        KeyColor[] keys = new KeyColor[nplots];
        int i2 = 0;
        while (i2 < nplots) {
            KeyColor[] plotColors = Series.plotColors;
            keys[i2] = new KeyColor(plotColors[newPlotNumber % plotColors.length]);
            String txt = newProperty.getGid() != null ? newProperty.getGid().toString() : new Integer(newProperty.getInstId()).toString();
            keys[i2].setKey(String.valueOf(newProperty.getName()) + " (" + txt + ") " + i2);
            if (newPlotNumber++ > Series.MAX_NEW_PLOT_NUMBER) {
                newPlotNumber = 0;
            }
            ++i2;
        }
        newKeyColors[oldLength] = keys;
        newSeriesProperties[oldLength] = newProperty;
        Series newSeries = new Series();
        newSeries.setKeyColors(newKeyColors);
        newSeries.setSeriesProperties(newSeriesProperties);
        newSeries.setNewPlotNumber(newPlotNumber);
        return newSeries;
    }

    public void adjustSize() {
        super.adjustSize();
        this.xySeriesPix = this.convertToPixels(this.xySeries);
    }

    protected int calcCode(int x, int y, Rectangle clip) {
        int code = 0;
        if (x < clip.x) {
            code |= 8;
        }
        if (x > clip.x + clip.width) {
            code |= 4;
        }
        if (y < clip.y) {
            code |= 1;
        }
        if (y > clip.y + clip.height) {
            code |= 2;
        }
        return code;
    }

    protected Point calcIntersect(int code, Rectangle clip, int x0, int x1, int y0, int y1) {
        Point pt = new Point();
        if ((code & 1) != 0) {
            pt.x = x0 + (x1 - x0) * (clip.y - y0) / (y1 - y0);
            pt.y = clip.y;
        } else if ((code & 2) != 0) {
            pt.x = x0 + (x1 - x0) * (clip.y + clip.height - y0) / (y1 - y0);
            pt.y = clip.y + clip.height;
        } else if ((code & 4) != 0) {
            pt.x = clip.x + clip.width;
            pt.y = y0 + (y1 - y0) * (clip.x + clip.width - x0) / (x1 - x0);
        } else if ((code & 8) != 0) {
            pt.x = clip.x;
            pt.y = y0 + (y1 - y0) * (clip.x - x0) / (x1 - x0);
        }
        return pt;
    }

    public int[][] convertToPixels(double[][] xy) {
        int[][] ixy = null;
        if (xy != null) {
            ixy = new int[xy.length][];
            int i = 0;
            while (i < xy.length) {
                if (xy[i] != null && xy[i] != null && xy[i].length == 2) {
                    ixy[i] = new int[xy[i].length];
                    ixy[i][0] = this.xaxis.wcToPixel(xy[i][0]);
                    ixy[i][1] = this.yaxis.wcToPixel(xy[i][1]);
                }
                ++i;
            }
        }
        return ixy;
    }

    public int[][][] convertToPixels(double[][][] xy) {
        int[][][] ixy = null;
        if (xy != null) {
            ixy = new int[xy.length][][];
            int i = 0;
            while (i < xy.length) {
                if (xy[i] != null) {
                    ixy[i] = new int[xy[i].length][];
                    int j = 0;
                    while (j < xy[i].length) {
                        if (xy[i][j] != null && xy[i][j].length == 2) {
                            ixy[i][j] = new int[xy[i][j].length];
                            ixy[i][j][0] = this.xaxis.wcToPixel(xy[i][j][0]);
                            ixy[i][j][1] = this.yaxis.wcToPixel(xy[i][j][1]);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return ixy;
    }

    public int[][][][] convertToPixels(double[][][][] xy) {
        int[][][][] ixy = null;
        if (xy != null) {
            ixy = new int[xy.length][][][];
            int i = 0;
            while (i < xy.length) {
                ixy[i] = this.convertToPixels(xy[i]);
                ++i;
            }
        }
        return ixy;
    }

    protected void drawClippedLine(Graphics g, Rectangle clip, int x0, int y0, int x1, int y1) {
        int outcode0 = this.calcCode(x0, y0, clip);
        int outcode1 = this.calcCode(x1, y1, clip);
        while (true) {
            Point pt;
            int code;
            if (outcode0 == 0 && outcode1 == 0) {
                g.drawLine(x0, y0, x1, y1);
                return;
            }
            if ((outcode0 & outcode1) != 0) {
                return;
            }
            if (outcode0 == 0) {
                code = outcode1;
                pt = this.calcIntersect(code, clip, x0, x1, y0, y1);
                x1 = pt.x;
                y1 = pt.y;
                outcode1 = this.calcCode(x1, y1, clip);
                continue;
            }
            code = outcode0;
            pt = this.calcIntersect(code, clip, x0, x1, y0, y1);
            x0 = pt.x;
            y0 = pt.y;
            outcode0 = this.calcCode(x0, y0, clip);
        }
    }

    public void finalizeJelsim() {
        this.removeModelUpdateListeners();
        super.finalizeJelsim();
    }

    protected void generateKeys() {
        KeyColor[][] graphkeys;
        boolean nKeys = false;
        this.maxPointRadius = 0;
        this.keys = null;
        if (this.series != null && (graphkeys = this.series.getKeyColors()) != null) {
            this.keys = new KeyColor[this.series.getNumberOfKeysShown()];
            int keyIndex = 0;
            int i = 0;
            while (i < graphkeys.length) {
                int j = 0;
                while (j < graphkeys[i].length) {
                    if (graphkeys[i][j] instanceof KeyColor && graphkeys[i][j].isKeyShown()) {
                        this.keys[keyIndex++] = graphkeys[i][j];
                        if (graphkeys[i][j].getPlotType() > 0) {
                            int rad = graphkeys[i][j].getPointRadius();
                            this.maxPointRadius = rad > this.maxPointRadius ? rad : this.maxPointRadius;
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public ModelPropertyInterface getModelProperty() {
        return null;
    }

    public ModelPropertyInterface getPlotEnd() {
        return this.plotEndMP;
    }

    public Series getSeries() {
        return this.series;
    }

    public FmpHelper[] getSeriesProperties() {
        if (this.seriesMP == null) {
            return null;
        }
        FmpHelper[] retval = new FmpHelper[this.seriesMP.length];
        int i = 0;
        while (i < this.seriesMP.length) {
            retval[i] = new FmpHelper(this.seriesMP[i].getName(), this.seriesMP[i].getGid());
            ++i;
        }
        return retval;
    }

    public synchronized void handleModelUpdate(ModelUpdateEvent e) {
        ModelPropertyInterface source = (ModelPropertyInterface)e.getSource();
        Object value = e.getValue();
        if (this.plotEndMP != null && this.plotEndMP.sameMapStore(source)) {
            this.plotEnd = (Integer)this.plotEndMP.getValue();
            ((Component)((Object)this)).repaint();
        } else if (this.resetProperty != null && this.resetProperty.sameMapStore(source) && this.clearOnReset) {
            this.xySeries = null;
            this.xySeriesPix = null;
            ((Component)((Object)this)).repaint();
        } else if (this.isSeriesProperty(source, this.seriesMP)) {
            int i = this.matchesSeriesProperty(source, this.seriesMP);
            int dim = this.seriesMP[i].getType() / 10000;
            this.setSeriesArray(i, dim, this.seriesMP[i].getValue());
            this.adjustSize();
        } else {
            ErrorHandler.reportMessage((String)("XYGraph: update not recognised - " + source.getName()));
        }
    }

    protected void initialiseLinkedKey() {
        super.initialiseLinkedKey();
        if (this.linkedKey != null) {
            int nkeys = this.keys != null ? this.keys.length : 0;
            this.linkedKey.setKey(this.keys, nkeys, this.maxPointRadius);
        }
    }

    protected boolean isSeriesProperty(ModelPropertyInterface mp, ModelPropertyInterface[] mparray) {
        if (mparray != null) {
            int i = 0;
            while (i < mparray.length) {
                if (mparray[i].sameMapStore(mp)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected String linkedKeyClass() {
        return "org.jelsim.graph.XYGraphKey";
    }

    protected int matchesSeriesProperty(ModelPropertyInterface mp, ModelPropertyInterface[] mparray) {
        if (mparray != null) {
            int i = 0;
            while (i < mparray.length) {
                if (mparray[i].sameMapStore(mp)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.xySeries != null) {
            this.paintSeries(g);
        }
    }

    protected void paintPlot(int[][] xy, KeyColor kcol, Graphics g) {
        block8: {
            int xmin = this.xaxis.wcToPixel(this.xaxis.getMinValue());
            int xmax = this.xaxis.wcToPixel(this.xaxis.getMaxValue());
            int ymin = this.yaxis.wcToPixel(this.yaxis.getMinValue());
            int ymax = this.yaxis.wcToPixel(this.yaxis.getMaxValue());
            Rectangle clip = new Rectangle();
            clip.x = xmin < xmax ? xmin : xmax;
            clip.width = (xmax > xmin ? xmax : xmin) - clip.x;
            clip.y = ymin < ymax ? ymin : ymax;
            clip.height = (ymax > ymin ? ymax : ymin) - clip.y;
            if (xy == null || xy.length == 0 || xy[0] == null || xy[0].length != 2) {
                return;
            }
            int stop = xy.length;
            if (this.plotEndMP != null && stop >= 0 && this.plotEnd < stop) {
                stop = this.plotEnd;
            }
            if (g == null) break block8;
            int x1 = xy[0][0];
            int y1 = xy[0][1];
            g.setColor(kcol.getColor());
            kcol.plotPoint(g, x1, y1);
            if (kcol.getPlotType() <= 6) {
                int i = 1;
                while (i < stop) {
                    int x2 = xy[i][0];
                    int y2 = xy[i][1];
                    if (y1 >= Short.MIN_VALUE && y1 <= Short.MAX_VALUE && y2 >= Short.MIN_VALUE && y2 <= Short.MAX_VALUE) {
                        this.drawClippedLine(g, clip, x1, y1, x2, y2);
                        kcol.plotPoint(g, x2, y2);
                    }
                    x1 = x2;
                    y1 = y2;
                    ++i;
                }
            } else {
                int i = 1;
                while (i < stop) {
                    int x2 = xy[i][0];
                    int y2 = xy[i][1];
                    if (y2 >= Short.MIN_VALUE && y2 <= Short.MAX_VALUE) {
                        kcol.plotPoint(g, x2, y2);
                    }
                    ++i;
                }
            }
        }
    }

    public void paintSeries(Graphics g) {
        if (this.xySeries != null) {
            int i = 0;
            while (i < this.xySeries.length) {
                if (this.xySeries[i] != null) {
                    int j = 0;
                    while (j < this.xySeries[i].length) {
                        KeyColor kcol;
                        KeyColor[] kcolArray = this.series.getKeyColors()[i];
                        if (kcolArray != null && kcolArray.length > 0 && (kcol = kcolArray[j % kcolArray.length]).isPlotShown()) {
                            this.paintPlot(this.xySeriesPix[i][j], kcol, g);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    protected void plotCurrent(double[][][][] xy, int propertyno, int plotno, KeyColor kcol, Graphics g) {
        block8: {
            if (xy == null || xy[propertyno] == null || xy[propertyno][plotno] == null || xy[propertyno][plotno][0] == null || xy[propertyno][plotno][0].length != 2) {
                return;
            }
            int stop = xy[propertyno][plotno].length;
            if (this.plotEndMP != null && stop >= 0 && this.plotEnd < stop) {
                stop = this.plotEnd;
            }
            if (g == null) break block8;
            int x1 = this.xaxis.wcToPixel(xy[propertyno][plotno][0][0]);
            int y1 = this.yaxis.wcToPixel(xy[propertyno][plotno][0][1]);
            g.setColor(kcol.getColor());
            kcol.plotPoint(g, x1, y1);
            if (kcol.getPlotType() <= 6) {
                int i = 1;
                while (i < stop) {
                    int x2 = this.xaxis.wcToPixel(xy[propertyno][plotno][i][0]);
                    int y2 = this.yaxis.wcToPixel(xy[propertyno][plotno][i][1]);
                    if (y1 >= Short.MIN_VALUE && y1 <= Short.MAX_VALUE && y2 >= Short.MIN_VALUE && y2 <= Short.MAX_VALUE) {
                        g.drawLine(x1, y1, x2, y2);
                        kcol.plotPoint(g, x2, y2);
                    }
                    x1 = x2;
                    y1 = y2;
                    ++i;
                }
            } else {
                int i = 1;
                while (i < stop) {
                    int x2 = this.xaxis.wcToPixel(xy[propertyno][plotno][i][0]);
                    int y2 = this.yaxis.wcToPixel(xy[propertyno][plotno][i][1]);
                    if (y2 >= Short.MIN_VALUE && y2 <= Short.MAX_VALUE) {
                        kcol.plotPoint(g, x2, y2);
                    }
                    ++i;
                }
            }
        }
    }

    protected void registerSeriesListeners() {
        if (this.ma != null) {
            int i;
            if (this.seriesMP != null) {
                i = 0;
                while (i < this.seriesMP.length) {
                    if (this.seriesMP[i] != null) {
                        this.ma.removeModelUpdateListener(this.seriesMP[i], (ModelUpdateListener)this);
                    }
                    ++i;
                }
            }
            if (this.series != null) {
                this.seriesMP = this.series.getSeriesProperties();
                if (this.seriesMP != null && this.seriesMP.length > 0) {
                    this.seriesXmin = new double[this.seriesMP.length];
                    this.seriesXmax = new double[this.seriesMP.length];
                    this.seriesYmin = new double[this.seriesMP.length];
                    this.seriesYmax = new double[this.seriesMP.length];
                    this.xySeries = new double[this.seriesMP.length][][][];
                    this.xySeriesPix = new int[this.seriesMP.length][][][];
                    i = 0;
                    while (i < this.seriesMP.length) {
                        if (this.seriesMP[i] != null) {
                            this.ma.addModelUpdateListener(this.seriesMP[i], (ModelUpdateListener)this);
                            int dim = this.seriesMP[i].getType() / 10000;
                            this.setSeriesArray(i, dim, this.seriesMP[i].getValue());
                        }
                        ++i;
                    }
                }
            }
            if (this.series == null || this.seriesMP == null || this.seriesMP.length == 0) {
                this.series = new Series();
                this.xySeries = null;
                this.xySeriesPix = null;
                this.seriesXmin = null;
                this.seriesXmax = null;
                this.seriesYmin = null;
                this.seriesYmax = null;
                this.setDefaultDataRange();
            }
        }
    }

    protected void removeModelUpdateListeners() {
        if (this.seriesMP != null) {
            int i = 0;
            while (i < this.seriesMP.length) {
                this.finalizeMP(this.seriesMP[i]);
                ++i;
            }
        }
    }

    private void restoreSeriesProperties() {
        if (this.series != null) {
            if (this.seriesRestoreHelpers != null) {
                ModelPropertyInterface[] mps = new ModelPropertyInterface[this.seriesRestoreHelpers.length];
                int i = 0;
                while (i < mps.length) {
                    mps[i] = this.ma.getProperty(this.seriesRestoreHelpers[i].getPropertyName(), (Object)this.seriesRestoreHelpers[i].getValue());
                    if (mps[i] == null) {
                        ErrorHandler.reportMessage((String)("XYGraph: could not recover a series from property " + this.seriesRestoreHelpers[i].getPropertyName()));
                        ErrorHandler.reportMessage((String)"All series have been removed from the graph");
                        this.series = new Series();
                        return;
                    }
                    ++i;
                }
                this.series.setSeriesProperties(mps);
            } else {
                String[] propertyNames = this.series.getFmpPropertyNames();
                String[] propertyIds = this.series.getFmpPropertyIds();
                if (propertyNames != null && propertyIds != null) {
                    ModelPropertyInterface[] mps = new ModelPropertyInterface[propertyNames.length];
                    int i = 0;
                    while (i < mps.length) {
                        mps[i] = this.ma.getProperty(propertyNames[i], (Object)propertyIds[i]);
                        if (mps[i] == null) {
                            ErrorHandler.reportMessage((String)("XYGraph: could not recover a series from property " + propertyNames[i] + ":" + propertyIds[i]));
                            ErrorHandler.reportMessage((String)"All series have been removed from the graph");
                            this.series = new Series();
                            return;
                        }
                        ++i;
                    }
                    this.series.setSeriesProperties(mps);
                }
            }
            this.registerSeriesListeners();
        }
    }

    public void setModelAccess(ModelAccessInterface ma) {
        if (this.ma != ma) {
            super.setModelAccess(ma);
            this.restoreSeriesProperties();
        }
    }

    public void setModelProperty(ModelPropertyInterface fmp) {
        if (fmp != null) {
            this.setSeries(this.addModelPropertyToSeries(fmp, this.series));
        }
    }

    public void setPlotEnd(ModelPropertyInterface mp) {
        if (this.plotEndMP != null) {
            this.ma.removeModelUpdateListener(this.plotEndMP, (ModelUpdateListener)this);
        }
        this.plotEndMP = mp;
        if (mp != null) {
            this.ma.addModelUpdateListener(this.plotEndMP, (ModelUpdateListener)this);
            this.plotEnd = (Integer)mp.getValue();
        } else {
            this.plotEnd = 0;
        }
    }

    public void setSeries(Series series) {
        this.series = series;
        this.registerSeriesListeners();
        this.generateKeys();
        if (this.linkedKey != null) {
            this.linkedKey.setKey(this.keys, this.keys == null ? 0 : this.keys.length, this.maxPointRadius);
        }
        this.adjustSize();
        ((Component)((Object)this)).repaint();
    }

    private void setSeriesArray(int series, int dimension, Object array) {
        boolean calculateRange = true;
        this.seriesXmin[series] = Double.POSITIVE_INFINITY;
        this.seriesXmax[series] = Double.NEGATIVE_INFINITY;
        this.seriesYmin[series] = Double.POSITIVE_INFINITY;
        this.seriesYmax[series] = Double.NEGATIVE_INFINITY;
        if (array == null) {
            this.xySeries[series] = null;
            this.xySeriesPix[series] = null;
            calculateRange = false;
        } else {
            int j;
            Object array1;
            int i;
            if (dimension == 3) {
                double[][][] nxy = new double[Array.getLength(array)][][];
                i = 0;
                while (i < nxy.length) {
                    array1 = Array.get(array, i);
                    if (array1 == null) {
                        nxy[i] = null;
                        calculateRange = false;
                    } else {
                        nxy[i] = new double[Array.getLength(array1)][];
                        j = 0;
                        while (j < nxy[i].length) {
                            Object array2 = Array.get(array1, j);
                            if (array2 == null) {
                                nxy[i][j] = null;
                                calculateRange = false;
                            } else {
                                nxy[i][j] = new double[Array.getLength(array2)];
                                int k = 0;
                                while (k < nxy[i][j].length) {
                                    nxy[i][j][k] = ((Number)Array.get(array2, k)).doubleValue();
                                    ++k;
                                }
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
                this.xySeries[series] = nxy;
            } else if (dimension == 2) {
                this.xySeries[series] = new double[1][][];
                this.xySeriesPix[series] = new int[1][][];
                double[][] xy = new double[Array.getLength(array)][];
                i = 0;
                while (i < xy.length) {
                    array1 = Array.get(array, i);
                    if (array1 == null) {
                        xy[i] = null;
                        calculateRange = false;
                    } else {
                        xy[i] = new double[Array.getLength(array1)];
                        j = 0;
                        while (j < xy[i].length) {
                            xy[i][j] = ((Number)Array.get(array1, j)).doubleValue();
                            ++j;
                        }
                    }
                    ++i;
                }
                this.xySeries[series][0] = xy;
            }
            this.xySeriesPix[series] = this.convertToPixels(this.xySeries[series]);
            if (calculateRange) {
                int i2 = 0;
                while (i2 < this.xySeries[series].length) {
                    if (this.xySeries[series][i2] != null) {
                        int j2 = 0;
                        while (j2 < this.xySeries[series][i2].length) {
                            if (this.xySeries[series][i2][j2].length == 2) {
                                double xVal = this.xySeries[series][i2][j2][0];
                                double yVal = this.xySeries[series][i2][j2][1];
                                if (xVal < this.seriesXmin[series]) {
                                    this.seriesXmin[series] = xVal;
                                }
                                if (xVal > this.seriesXmax[series]) {
                                    this.seriesXmax[series] = xVal;
                                }
                                if (yVal < this.seriesYmin[series]) {
                                    this.seriesYmin[series] = yVal;
                                }
                                if (yVal > this.seriesYmax[series]) {
                                    this.seriesYmax[series] = yVal;
                                }
                            }
                            ++j2;
                        }
                    }
                    ++i2;
                }
            }
        }
        this.dataXmin = Double.POSITIVE_INFINITY;
        this.dataXmax = Double.NEGATIVE_INFINITY;
        this.dataYmin = Double.POSITIVE_INFINITY;
        this.dataYmax = Double.NEGATIVE_INFINITY;
        int i = 0;
        while (i < this.xySeries.length) {
            if (this.seriesXmin[i] < this.dataXmin) {
                this.dataXmin = this.seriesXmin[i];
            }
            if (this.seriesXmax[i] > this.dataXmax) {
                this.dataXmax = this.seriesXmax[i];
            }
            if (this.seriesYmin[i] < this.dataYmin) {
                this.dataYmin = this.seriesYmin[i];
            }
            if (this.seriesYmax[i] > this.dataYmax) {
                this.dataYmax = this.seriesYmax[i];
            }
            ++i;
        }
        if (this.dataXmin == Double.POSITIVE_INFINITY || this.dataXmax == Double.NEGATIVE_INFINITY || this.dataYmin == Double.POSITIVE_INFINITY || this.dataYmax == Double.NEGATIVE_INFINITY) {
            this.setDefaultDataRange();
        }
    }

    public void setSeriesProperties(FmpHelper[] propertyHelpers) {
        this.seriesRestoreHelpers = propertyHelpers;
    }

    public void setValidLayer(int i, boolean b) {
        this.layerValid[i] = b;
        this.numberValid = b ? ++this.numberValid : --this.numberValid;
        ((Component)((Object)this)).repaint();
    }

    public void setValue(ModelPropertyInterface fmp) {
        this.setModelProperty(fmp);
    }
}

