/*
 * Decompiled with CFR 0.152.
 */
package org.jelsim.graph;

import java.awt.Color;
import java.awt.Graphics;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jelsim.graph.PlotKeyInterface;

public class KeyColor
implements Serializable,
PlotKeyInterface {
    public static final long serialVersionUID = 3406995938073863259L;
    public static final int LINE = 0;
    public static final int CIRCLE = 1;
    public static final int CROSS = 2;
    public static final int SQUARE = 3;
    public static final int TRI_UP = 4;
    public static final int TRI_DOWN = 5;
    public static final int TRI_TWO = 6;
    public static final int LINE_END = 6;
    public static final int NO_OFFSET = 20;
    public static final int NOLINE_CIRCLE = 21;
    public static final int NOLINE_CROSS = 22;
    public static final int NOLINE_SQUARE = 23;
    public static final int NOLINE_TRI_UP = 24;
    public static final int NOLINE_TRI_DOWN = 25;
    public static final int NOLINE_TRI_TWO = 26;
    public static final int NOLINE_END = 27;
    private String key = null;
    private int colorRGB;
    private int plotType = 0;
    private int pointRadius = 3;
    private boolean keyShown = true;
    private boolean plotShown = true;
    private transient Color color = null;
    private transient plotter plotClass = null;

    public KeyColor() {
    }

    protected KeyColor(String s, Color c, int plotType) {
        this(s, c, plotType, 3, true);
    }

    protected KeyColor(String s, Color c, int plotType, int pointRadius, boolean keyShown) {
        this.key = s == null ? "" : s;
        this.color = c;
        if (this.color != null) {
            this.colorRGB = this.color.getRGB();
        }
        this.setPlotType(plotType);
        this.setPointRadius(pointRadius);
        this.setKeyShown(keyShown);
    }

    protected KeyColor(KeyColor kc) {
        this(kc.key, kc.color, kc.plotType, kc.pointRadius, kc.keyShown);
    }

    public Color getColor() {
        return this.color;
    }

    public String getKey() {
        return this.key;
    }

    public int getPlotType() {
        return this.plotType;
    }

    public int getPointRadius() {
        return this.pointRadius;
    }

    public boolean isKeyShown() {
        return this.keyShown;
    }

    public boolean isPlotShown() {
        return this.plotShown;
    }

    public void plotPoint(Graphics g, int x, int y) {
        this.plotClass.plotPoint(g, x, y, this.pointRadius);
    }

    public void plotPoint(Graphics g, int x, int y, int r) {
        this.plotClass.plotPoint(g, x, y, r);
    }

    private void readObject(ObjectInputStream in) throws IOException {
        try {
            in.defaultReadObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException();
        }
        this.setPlotType(this.plotType);
        this.setColor(new Color(this.colorRGB));
    }

    public void setColor(Color c) {
        this.color = c;
        this.colorRGB = c.getRGB();
    }

    public void setKey(String s) {
        this.key = s;
    }

    public void setKeyShown(boolean keyShown) {
        this.keyShown = keyShown;
    }

    public void setPlotShown(boolean plotShown) {
        this.plotShown = plotShown;
    }

    public void setPlotType(int p) {
        if (p == 0) {
            this.plotClass = new plainPlotter();
        } else if (p == 1 || p == 21) {
            this.plotClass = new circlePlotter();
        } else if (p == 2 || p == 22) {
            this.plotClass = new crossPlotter();
        } else if (p == 3 || p == 23) {
            this.plotClass = new squarePlotter();
        } else if (p == 4 || p == 24) {
            this.plotClass = new triUpPlotter();
        } else if (p == 5 || p == 25) {
            this.plotClass = new triDownPlotter();
        } else if (p == 6 || p == 26) {
            this.plotClass = new tri2Plotter();
        } else {
            throw new IllegalArgumentException("Unknown plot type " + p);
        }
        this.plotType = p;
    }

    public void setPointRadius(int pointRadius) {
        this.pointRadius = pointRadius;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    static interface plotter {
        public void plotPoint(Graphics var1, int var2, int var3, int var4);
    }

    class plainPlotter
    implements plotter {
        plainPlotter() {
        }

        public void plotPoint(Graphics g, int x, int y, int r) {
        }
    }

    class circlePlotter
    implements plotter {
        circlePlotter() {
        }

        public void plotPoint(Graphics g, int x, int y, int r) {
            g.fillOval(x - r, y - r, r * 2, r * 2);
        }
    }

    class crossPlotter
    implements plotter {
        crossPlotter() {
        }

        public void plotPoint(Graphics g, int x, int y, int r) {
            g.drawLine(x - r, y, x + r, y);
            g.drawLine(x, y - r, x, y + r);
        }
    }

    class squarePlotter
    implements plotter {
        squarePlotter() {
        }

        public void plotPoint(Graphics g, int x, int y, int r) {
            g.fillRect(x - r, y - r, r * 2, r * 2);
        }
    }

    class triUpPlotter
    implements plotter {
        triUpPlotter() {
        }

        public void plotPoint(Graphics g, int x, int y, int r) {
            int[] xp = new int[]{x, x - r, x + r};
            int[] yp = new int[]{y - r, y + r, y + r};
            g.fillPolygon(xp, yp, 3);
        }
    }

    class triDownPlotter
    implements plotter {
        triDownPlotter() {
        }

        public void plotPoint(Graphics g, int x, int y, int r) {
            int[] xp = new int[]{x, x - r, x + r};
            int[] yp = new int[]{y + r, y - r, y - r};
            g.fillPolygon(xp, yp, 3);
        }
    }

    class tri2Plotter
    implements plotter {
        tri2Plotter() {
        }

        public void plotPoint(Graphics g, int x, int y, int r) {
            int[] xp = new int[]{x - r, x + r, x, x - r, x + r};
            int[] yp = new int[]{y - r, y - r, y, y + r, y + r};
            g.fillPolygon(xp, yp, 5);
        }
    }
}

