/*
 * Decompiled with CFR 0.152.
 */
package org.jelsim.graph;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import org.jelsim.beans.numberformatter.NumberFormatter;
import org.jelsim.beans.support.BeanSupport;
import org.jelsim.beans.support.IfLinkChildInterface;
import org.jelsim.beans.support.ModelAccessInterface;
import org.jelsim.graph.Graph;

public class GraphValue
extends BeanSupport
implements IfLinkChildInterface {
    public static final long serialVersionUID = 8600246546160700617L;
    public static final int TYPE_INIT = -1;
    public static final int TYPE_DELTA = 0;
    public static final int TYPE_P1 = 1;
    public static final int TYPE_P2 = 2;
    public static final int TYPE_LOCN = 3;
    private int displayType = -1;
    private Graph graph;
    private int linkId = -1;
    private Font font;
    private FontMetrics vfm;
    private int borderGap = 12;
    private boolean linked = false;
    private String caption = "Coord ";
    private boolean useAbsolutes = false;
    protected NumberFormatter numberFormatter = null;
    private String valueString = "";
    private double xValue = 0.0;
    private double yValue = 0.0;
    private String xStr = "";
    private String sepStr = ",";
    private String yStr = "";
    private int baseLine = 0;
    private int locX;
    private int locSep;
    private int locY;

    public GraphValue() {
        this.resizable = true;
        this.numberFormatter = new NumberFormatter();
        this.numberFormatter.setConversion(2);
        this.numberFormatter.setFieldWidth(8);
        this.numberFormatter.setDecimalPlaces(2);
        this.font = new Font("SansSerif", 0, 12);
        this.vfm = ((Component)((Object)this)).getFontMetrics(this.font);
        String[] normaltmp = new String[]{"font", "foreground", "borderGap", "resizable", "editable", "linkId", "numberLinked", "linked", "displayType", "background", "caption", "useAbsolutes", "numberFormatter"};
        this.normalSaveNames = normaltmp;
        this.updateValues(this.xValue, this.yValue);
    }

    public void adjustSize() {
        this.calculateStringPositions();
    }

    private void calculateStringPositions() {
        if (this.numberFormatter.getConversion() == 0 || this.numberFormatter.getFieldWidth() == NumberFormatter.VALUE_UNSPECIFIED) {
            this.locY = this.width - this.borderGap - this.vfm.stringWidth(this.yStr);
            this.locSep = this.locY - this.vfm.stringWidth(this.sepStr);
            this.locX = this.locSep - this.vfm.stringWidth(this.xStr);
        } else {
            int fieldWidth = this.numberFormatter.getFieldWidth();
            int char8width = this.vfm.stringWidth("8");
            this.locSep = this.width - this.borderGap - char8width * fieldWidth - this.vfm.stringWidth(this.sepStr);
            if (this.numberFormatter.isLeftJustified()) {
                this.locY = this.width - this.borderGap - char8width * fieldWidth;
                this.locX = this.locSep - char8width * fieldWidth;
            } else {
                this.locY = this.width - this.borderGap - this.vfm.stringWidth(this.yStr);
                this.locX = this.locSep - this.vfm.stringWidth(this.xStr);
            }
        }
    }

    private void calculateStrings() {
        double decX = this.xValue;
        double decY = this.yValue;
        if (this.useAbsolutes) {
            decX = Math.abs(decX);
            decY = Math.abs(decY);
        }
        this.xStr = this.numberFormatter.toString(decX);
        this.yStr = this.numberFormatter.toString(decY);
    }

    public void finalizeJelsim() {
        if (this.graph != null) {
            this.graph.clearGraphValue(this);
        }
    }

    public int getBorderGap() {
        return this.borderGap;
    }

    public String getCaption() {
        return this.caption;
    }

    public int getDisplayType() {
        return this.displayType;
    }

    public Font getFont() {
        return this.font;
    }

    public int getLinkId() {
        return this.linkId;
    }

    public NumberFormatter getNumberFormatter() {
        return this.numberFormatter;
    }

    public int getNumberLinked() {
        return this.graph == null ? 0 : 1;
    }

    public Dimension getPreferredSize() {
        int x = 0;
        int y = 0;
        if (this.graph != null) {
            this.baseLine = this.vfm.getMaxAscent() + this.borderGap;
            y += this.borderGap + this.baseLine + this.vfm.getMaxDescent();
            int char8width = this.vfm.stringWidth("8");
            int numberWidth = char8width * Math.max(6, this.numberFormatter.getFieldWidth());
            x += this.vfm.stringWidth(String.valueOf(this.caption) + ",") + 2 * this.borderGap + 2 * numberWidth;
        } else {
            x = 100;
            y = 100;
        }
        return new Dimension(x, y);
    }

    public boolean isLinked() {
        return this.linked;
    }

    public boolean isUseAbsolutes() {
        return this.useAbsolutes;
    }

    public void paint(Graphics g) {
        g.setColor(((Component)((Object)this)).getBackground());
        g.fillRect(0, 0, this.width, this.height);
        g.setFont(this.font);
        g.setColor(((Component)((Object)this)).getForeground());
        g.drawString(this.caption, this.borderGap, this.baseLine);
        g.drawString(this.yStr, this.locY, this.baseLine);
        g.drawString(this.sepStr, this.locSep, this.baseLine);
        g.drawString(this.xStr, this.locX, this.baseLine);
        super.paint(g);
    }

    public void setBorderGap(int bg) {
        this.borderGap = bg;
        ((Component)((Object)this)).setSize(this.getPreferredSize());
        this.calculateStrings();
        this.calculateStringPositions();
        ((Component)((Object)this)).repaint();
    }

    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.width = w;
        this.height = h;
        this.adjustSize();
    }

    public void setBounds(Rectangle r) {
        this.setBounds(r.x, r.y, r.width, r.height);
    }

    public void setCaption(String caption) {
        this.caption = caption;
        ((Component)((Object)this)).setSize(this.getPreferredSize());
        this.calculateStringPositions();
        ((Component)((Object)this)).repaint();
    }

    public void setDisplayType(int type) {
        this.displayType = type;
    }

    public void setFont(Font f) {
        this.font = f;
        this.vfm = ((Component)((Object)this)).getFontMetrics(f);
        ((Component)((Object)this)).setSize(this.getPreferredSize());
        this.calculateStrings();
        this.calculateStringPositions();
        ((Component)((Object)this)).repaint();
    }

    public void setLinkComponent(int linkId, Component graph) {
        this.linkId = linkId;
        this.graph = (Graph)((Object)graph);
        this.graph.initialiseLinkedValue(this);
        this.baseLine = this.vfm.getMaxAscent() + this.borderGap;
        this.linked = true;
    }

    public void setLinkId(int id) {
        this.linkId = id;
    }

    public void setLinked(boolean b) {
        this.linked = b;
    }

    public void setModelAccess(ModelAccessInterface ma) {
        this.numberFormatter.setModelAccess(ma);
        super.setModelAccess(ma);
    }

    public void setNumberFormatter(NumberFormatter numberFormatter) {
        if (numberFormatter != null) {
            numberFormatter.setModelAccess(this.ma);
        }
        this.numberFormatter = numberFormatter;
        this.calculateStrings();
        this.calculateStringPositions();
        ((Component)((Object)this)).repaint();
    }

    public void setNumberLinked(int nlinked) {
    }

    public void setUseAbsolutes(boolean b) {
        this.useAbsolutes = b;
        this.calculateStrings();
        this.calculateStringPositions();
        ((Component)((Object)this)).repaint();
    }

    public void updateValues(double xValue, double yValue) {
        this.xValue = xValue;
        this.yValue = yValue;
        this.calculateStrings();
        this.calculateStringPositions();
        ((Component)((Object)this)).repaint();
    }
}

