/*
 * Decompiled with CFR 0.152.
 */
package org.jelsim.graph;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import org.jelsim.beans.support.BeanSupport;
import org.jelsim.beans.support.IfLinkChildInterface;
import org.jelsim.graph.Graph;
import org.jelsim.graph.KeyColor;
import org.jelsim.graph.PlotKeyInterface;

public class GraphKey
extends BeanSupport
implements IfLinkChildInterface {
    public static final long serialVersionUID = 7538763016418299509L;
    protected static String DEFAULT_TITLE = "Graph key";
    protected Graph graph;
    private int linkId = -1;
    private boolean linked = false;
    protected Font keyFont;
    protected FontMetrics tfm;
    protected Font titleFont;
    protected FontMetrics kfm;
    protected int borderGap = 12;
    protected int keySpacing = 5;
    protected int minimumSymbolWidth = 25;
    protected boolean titleCentered = false;
    protected int nplots = 0;
    protected int maxPointRadius = 5;
    protected PlotKeyInterface[] keys = null;
    protected String title = DEFAULT_TITLE;

    public GraphKey() {
        this.setSize(50, 50);
        this.resizable = true;
        this.setTitleFont(new Font("SansSerif", 1, 12));
        this.setKeyFont(new Font("SansSerif", 0, 12));
        String[] normaltmp = new String[]{"foreground", "keyFont", "linkId", "numberLinked", "title", "titleFont", "borderGap", "keySpacing", "minimumSymbolWidth", "titleCentered", "linked", "editable", "background"};
        this.normalSaveNames = normaltmp;
    }

    public void finalizeJelsim() {
        if (this.graph != null) {
            this.graph.setShowKey(false);
        }
    }

    public int getBorderGap() {
        return this.borderGap;
    }

    public Font getKeyFont() {
        return this.keyFont;
    }

    public int getKeySpacing() {
        return this.keySpacing;
    }

    public int getLinkId() {
        return this.linkId;
    }

    public int getMinimumSymbolWidth() {
        return this.minimumSymbolWidth;
    }

    public int getNumberLinked() {
        return this.graph == null ? 0 : 1;
    }

    public Dimension getPreferredSize() {
        int x = 0;
        int y = 0;
        x += 2 * this.borderGap;
        y += 2 * this.borderGap;
        if (this.keys != null && this.keys.length > 0) {
            int maxItemWidth = 0;
            maxItemWidth = this.tfm.stringWidth(this.title);
            if (this.keys != null) {
                int symbolWidth = this.minimumSymbolWidth > 4 * this.maxPointRadius ? this.minimumSymbolWidth : 4 * this.maxPointRadius;
                int i = 0;
                while (i < this.keys.length) {
                    if (i < this.nplots) {
                        int kw = symbolWidth + this.kfm.stringWidth(this.keys[i].getKey());
                        maxItemWidth = (kw += this.keySpacing) > maxItemWidth ? kw : maxItemWidth;
                    }
                    ++i;
                }
            }
            x += maxItemWidth;
            if (this.title.length() > 0) {
                y += this.tfm.getHeight();
            }
            int keysHeight = this.kfm.getHeight() > 2 * this.maxPointRadius ? this.kfm.getHeight() : 2 * this.maxPointRadius;
            y += this.nplots * keysHeight;
        } else {
            x = 100;
            y = 100;
        }
        return new Dimension(x, y);
    }

    public String getTitle() {
        return this.title;
    }

    public Font getTitleFont() {
        return this.titleFont;
    }

    public boolean isLinked() {
        return this.linked;
    }

    public boolean isTitleCentered() {
        return this.titleCentered;
    }

    public void paint(Graphics g) {
        int symbolWidth = this.minimumSymbolWidth > 4 * this.maxPointRadius ? this.minimumSymbolWidth : 4 * this.maxPointRadius;
        int baseline = this.borderGap;
        int stringX = this.borderGap + symbolWidth + this.keySpacing;
        g.setColor(((Component)((Object)this)).getBackground());
        g.fillRect(0, 0, this.width - 1, this.height - 1);
        if (this.title.length() > 0) {
            baseline += this.tfm.getLeading() + this.tfm.getAscent();
            g.setColor(((Component)((Object)this)).getForeground());
            g.setFont(this.titleFont);
            if (this.isTitleCentered()) {
                g.drawString(this.title, (this.width - this.tfm.stringWidth(this.title)) / 2, baseline);
            } else {
                g.drawString(this.title, this.borderGap, baseline);
            }
        }
        g.setFont(this.keyFont);
        Object graphkeys = null;
        if (this.keys != null && this.keys.length > 0) {
            int keysHeight = this.kfm.getHeight() > 2 * this.maxPointRadius ? this.kfm.getHeight() : 2 * this.maxPointRadius;
            int i = 0;
            while (i < this.keys.length) {
                g.setColor(this.keys[i].getColor());
                g.drawString(this.keys[i].getKey(), stringX, baseline += keysHeight);
                int ly = baseline - this.kfm.getAscent() / 2;
                if (this.keys[i].getPlotType() <= 6) {
                    g.drawLine(this.borderGap, ly, this.borderGap + symbolWidth, ly);
                }
                ((KeyColor)this.keys[i]).plotPoint(g, this.borderGap + symbolWidth / 2, ly);
                ++i;
            }
        }
    }

    public void setBorderGap(int bg) {
        this.borderGap = bg;
        ((Component)((Object)this)).setSize(this.getPreferredSize());
        ((Component)((Object)this)).repaint();
    }

    public void setKey(PlotKeyInterface[] keys, int nplots, int maxPointRadius) {
        this.keys = keys;
        this.nplots = nplots;
        this.maxPointRadius = maxPointRadius;
        ((Component)((Object)this)).setSize(this.getPreferredSize());
        ((Component)((Object)this)).repaint();
    }

    public void setKeyFont(Font f) {
        this.keyFont = f;
        this.kfm = ((Component)((Object)this)).getFontMetrics(f);
        ((Component)((Object)this)).setSize(this.getPreferredSize());
        ((Component)((Object)this)).repaint();
    }

    public void setKeySpacing(int ks) {
        this.keySpacing = ks;
        ((Component)((Object)this)).setSize(this.getPreferredSize());
        ((Component)((Object)this)).repaint();
    }

    public void setLinkComponent(int linkId, Component graph) {
        this.linkId = linkId;
        this.graph = (Graph)((Object)graph);
        this.graph.initialiseLinkedKey(this);
        this.linked = true;
    }

    public void setLinkId(int id) {
        this.linkId = id;
    }

    public void setLinked(boolean b) {
        this.linked = b;
    }

    public void setMinimumSymbolWidth(int width) {
        this.minimumSymbolWidth = width;
        ((Component)((Object)this)).setSize(this.getPreferredSize());
        ((Component)((Object)this)).repaint();
    }

    public void setNumberLinked(int nlinked) {
    }

    public void setTitle(String title) {
        this.title = title;
        ((Component)((Object)this)).setSize(this.getPreferredSize());
        ((Component)((Object)this)).repaint();
    }

    public void setTitleCentered(boolean centered) {
        this.titleCentered = centered;
        ((Component)((Object)this)).setSize(this.getPreferredSize());
        ((Component)((Object)this)).repaint();
    }

    public void setTitleFont(Font f) {
        this.titleFont = f;
        this.tfm = ((Component)((Object)this)).getFontMetrics(f);
        ((Component)((Object)this)).setSize(this.getPreferredSize());
        ((Component)((Object)this)).repaint();
    }
}

