/*
 * Decompiled with CFR 0.152.
 */
package org.jelsim.graph;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.beans.Beans;
import java.util.Vector;
import org.jelsim.beans.support.BeanSupport;
import org.jelsim.beans.support.HasInternalBeans;
import org.jelsim.beans.support.IfLinkChildInterface;
import org.jelsim.beans.support.IfLinkParentInterface;
import org.jelsim.beans.support.LinkedComponentParent;
import org.jelsim.beans.support.ModelAccessInterface;
import org.jelsim.graph.GraphKey;
import org.jelsim.graph.GraphValue;
import org.jelsim.graph.axis.HorizontalAxisDrawDelegate;
import org.jelsim.graph.axis.VerticalAxisDrawDelegate;
import org.jelsim.model.event.InterfaceUpdateEvent;
import org.jelsim.model.event.InterfaceUpdateListener;
import org.jelsim.model.event.ModelUpdateEvent;
import org.jelsim.model.event.ModelUpdateListener;
import org.jelsim.model.map.MapStore;
import org.jelsim.model.map.ModelPropertyInterface;
import org.jelsim.userif.EditClient;

public abstract class Graph
extends BeanSupport
implements ModelUpdateListener,
IfLinkParentInterface,
HasInternalBeans {
    static final long serialVersionUID = 8862491640131559243L;
    public static final int DEF_XSIZE = 450;
    public static final int DEF_YSIZE = 250;
    public static final int AUTOMATIC = 0;
    public static final int MODEL_PROPERTY = 1;
    public static final int FIXED = 2;
    public static final double DATA_XMIN_DEFAULT = 0.0;
    public static final double DATA_XMAX_DEFAULT = 100.0;
    public static final double DATA_YMIN_DEFAULT = 0.0;
    public static final double DATA_YMAX_DEFAULT = 100.0;
    protected double dataXmin = 0.0;
    protected double dataXmax = 100.0;
    protected double dataYmin = 0.0;
    protected double dataYmax = 100.0;
    protected transient ModelPropertyInterface resetProperty = null;
    protected int xPlotSize;
    protected int yPlotSize;
    protected int ox;
    protected int oy;
    protected int[] xticks = null;
    protected int[] yticks = null;
    private int borderGap = 12;
    protected boolean showKey = false;
    public static final Color DFLT_backgroundColor = Color.lightGray;
    public static final Color DFLT_foregroundColor = Color.black;
    public static final Color DFLT_deltaLineColor = Color.red;
    protected Color backgroundColor = null;
    protected Color foregroundColor = null;
    protected Color deltaLineColor = null;
    protected boolean clearOnReset = true;
    protected int scaleFormat;
    public static final String DFLT_FONT = "Helvetica";
    public static final int DFLT_FONT_SIZE = 12;
    protected Font font = null;
    protected FontMetrics fontm = null;
    protected int fontAscent;
    protected int maxXfont;
    protected int maxYfont;
    protected boolean showHorizontalGridlines = false;
    protected boolean showVerticalGridlines = false;
    protected boolean zeroXAxis = false;
    protected boolean zeroYAxis = false;
    protected VerticalAxisDrawDelegate yaxis = null;
    protected HorizontalAxisDrawDelegate xaxis = null;
    protected boolean showGraphBox = false;
    protected int fixedXAxisStart = -1;
    protected int fixedXAxisLength = -1;
    protected int fixedYAxisStart = -1;
    protected int fixedYAxisLength = -1;
    protected boolean showDeltaValues = false;
    protected GraphValue linkedP1Value = null;
    protected GraphValue linkedP2Value = null;
    protected GraphValue linkedDeltaValue = null;
    protected boolean showMouseLocation = false;
    protected GraphValue linkedMouseLocation = null;
    protected boolean transparent = false;
    private int linkId = -1;
    private boolean linked = true;
    private int numberLinked = 0;
    protected GraphKey linkedKey = null;
    Point deltaStart = null;
    String deltaString = null;
    String posString = null;
    Point deltaEnd = null;
    Graphics localG = null;
    double deltaRealXS;
    double deltaRealYS;
    double deltaRealXE;
    double deltaRealYE;
    double currentRealXS;
    double currentRealYS;
    private Vector listeners = null;
    private ModelPropertyInterface deltaProperty;

    public Graph() {
        this.createAxes();
        this.setFont(new Font(DFLT_FONT, 0, 12));
        this.backgroundColor = DFLT_backgroundColor;
        this.foregroundColor = DFLT_foregroundColor;
        this.deltaLineColor = DFLT_deltaLineColor;
        this.setBackgroundColor(DFLT_backgroundColor);
        this.setForegroundColor(this.foregroundColor);
        this.setDeltaLineColor(this.deltaLineColor);
        this.initialiseYAxis();
        this.initialiseXAxis();
    }

    public void addInterfaceUpdateListener(InterfaceUpdateListener l) {
        if (this.listeners == null) {
            this.listeners = new Vector(2);
        }
        if (!this.listeners.contains(l)) {
            this.listeners.addElement(l);
        }
    }

    protected void addLinkedDeltaValues() {
        Container parent = ((Component)((Object)this)).getParent();
        if (parent instanceof LinkedComponentParent) {
            Point p = ((Component)((Object)this)).getLocation();
            p.y += this.height;
            if (this.linkedP1Value == null) {
                this.linkedP1Value = (GraphValue)((Object)this.createLinkedComponent((LinkedComponentParent)parent, "org.jelsim.graph.GraphValue"));
                ((Component)((Object)this.linkedP1Value)).setLocation(p);
                this.linkedP1Value.setDisplayType(1);
                this.linkedP1Value.setCaption("Start:");
                p.x += this.linkedP1Value.getSize().width;
            }
            if (this.linkedP2Value == null) {
                this.linkedP2Value = (GraphValue)((Object)this.createLinkedComponent((LinkedComponentParent)parent, "org.jelsim.graph.GraphValue"));
                ((Component)((Object)this.linkedP2Value)).setLocation(p);
                this.linkedP2Value.setCaption("End:");
                this.linkedP2Value.setDisplayType(2);
                p.x += this.linkedP2Value.getSize().width;
            }
            if (this.linkedDeltaValue == null) {
                this.linkedDeltaValue = (GraphValue)((Object)this.createLinkedComponent((LinkedComponentParent)parent, "org.jelsim.graph.GraphValue"));
                ((Component)((Object)this.linkedDeltaValue)).setLocation(p);
                this.linkedDeltaValue.setUseAbsolutes(false);
                this.linkedDeltaValue.setDisplayType(0);
                this.linkedDeltaValue.setCaption("Difference:");
            }
            this.setLinked(true);
        } else {
            if (this.numberLinked == 0 && ((Component)((Object)this)).getParent() != null) {
                this.setLinked(false);
            }
            if (parent != null) {
                this.showError("Cannot create linked values while graph in current container");
            }
        }
    }

    protected void addLinkedKey() {
        Container parent = ((Component)((Object)this)).getParent();
        if (parent instanceof LinkedComponentParent) {
            this.linkedKey = (GraphKey)((Object)this.createLinkedComponent((LinkedComponentParent)parent, this.linkedKeyClass()));
            Point p = ((Component)((Object)this)).getLocation();
            ((Component)((Object)this.linkedKey)).setLocation(p.x + this.width, p.y);
            this.setLinked(true);
        } else {
            if (this.numberLinked == 0) {
                this.setLinked(false);
            }
            if (parent != null) {
                this.showError("Cannot create key while graph in current container");
            }
        }
    }

    protected void addLinkedMouseLocation() {
        Container parent = ((Component)((Object)this)).getParent();
        if (parent instanceof LinkedComponentParent) {
            this.linkedMouseLocation = (GraphValue)((Object)this.createLinkedComponent((LinkedComponentParent)parent, "org.jelsim.graph.GraphValue"));
            Point p = ((Component)((Object)this)).getLocation();
            ((Component)((Object)this.linkedMouseLocation)).setLocation(p.x + this.width, p.y);
            this.linkedMouseLocation.setDisplayType(3);
            this.linkedMouseLocation.setCaption("Current:");
            this.setLinked(true);
        } else {
            if (this.numberLinked == 0) {
                this.setLinked(false);
            }
            if (parent != null) {
                this.showError("Cannot link mouse location while graph in current container");
            }
        }
    }

    public void adjustSize() {
        if (this.xaxis.getFixedLength() < 0) {
            this.xPlotSize = this.width - 2 * this.borderGap - this.yaxis.getMaxLabelWidth() - this.yaxis.getSmallGap() - this.xaxis.getArrowLength() - this.xaxis.getMaxLabelWidth();
            if (this.yaxis.getTickMarkLocation() != 1) {
                this.xPlotSize -= this.yaxis.getMaxTickLength();
            }
        } else {
            this.xPlotSize = this.xaxis.getFixedLength();
        }
        if (this.xaxis.getFixedStart() < 0) {
            this.ox = this.borderGap + this.yaxis.getMaxLabelWidth() + this.yaxis.getSmallGap();
            if (this.yaxis.getTickMarkLocation() != 1) {
                this.ox += this.yaxis.getMaxTickLength();
            }
        } else {
            this.ox = this.xaxis.getFixedStart();
        }
        if (this.yaxis.getFixedLength() < 0) {
            this.yPlotSize = this.height - 2 * this.borderGap - this.xaxis.getMaxLabelHeight() - this.xaxis.getSmallGap() - this.yaxis.getArrowLength() - this.yaxis.getMaxLabelHeight();
            if (this.xaxis.getTickMarkLocation() != 0) {
                this.yPlotSize -= this.xaxis.getMaxTickLength();
            }
        } else {
            this.yPlotSize = this.yaxis.getFixedLength();
        }
        this.oy = this.yaxis.getFixedStart() < 0 ? this.borderGap + this.yaxis.getArrowLength() + this.yaxis.getMaxLabelHeight() + this.yPlotSize : this.height - this.yaxis.getFixedStart();
        if (this.xaxis.getMinValueScheme() == 0) {
            this.xaxis.setMinValue(this.dataXmin);
        }
        if (this.xaxis.getMaxValueScheme() == 0) {
            this.xaxis.setMaxValue(this.dataXmax);
        }
        if (this.yaxis.getMinValueScheme() == 0) {
            this.yaxis.setMinValue(this.dataYmin);
        }
        if (this.yaxis.getMaxValueScheme() == 0) {
            this.yaxis.setMaxValue(this.dataYmax);
        }
        this.setXAxisValues();
        this.setYAxisValues();
        this.xaxis.setOy(this.zeroXAxis ? this.yaxis.wcToPixel(0.0) : this.oy);
        this.yaxis.setOx(this.zeroYAxis ? this.xaxis.wcToPixel(0.0) : this.ox);
        if (this.deltaStart != null) {
            int xs = this.xaxis.wcToPixel(this.deltaRealXS);
            int ys = this.yaxis.wcToPixel(this.deltaRealYS);
            int xe = this.xaxis.wcToPixel(this.deltaRealXE);
            int ye = this.yaxis.wcToPixel(this.deltaRealYE);
            this.deltaStart = new Point(xs, ys);
            this.deltaEnd = new Point(xe, ye);
        }
        ((Component)((Object)this)).repaint();
    }

    protected void clearGraphValue(GraphValue value) {
        switch (value.getDisplayType()) {
            case 0: {
                if (this.linkedDeltaValue != value) break;
                this.linkedDeltaValue = null;
                --this.numberLinked;
                break;
            }
            case 1: {
                if (this.linkedP1Value != value) break;
                this.linkedP1Value = null;
                --this.numberLinked;
                break;
            }
            case 2: {
                if (this.linkedP2Value != value) break;
                this.linkedP2Value = null;
                --this.numberLinked;
                break;
            }
            case 3: {
                if (this.linkedMouseLocation != value) break;
                this.linkedMouseLocation = null;
                --this.numberLinked;
                break;
            }
            default: {
                this.showError("Value link reconstruction error, please report");
            }
        }
    }

    protected void clearLinkedDeltaValues() {
        Container parent = ((Component)((Object)this)).getParent();
        if (parent instanceof EditClient) {
            if (this.linkedDeltaValue != null) {
                ((LinkedComponentParent)parent).remove((Component)((Object)this.linkedDeltaValue));
                this.linkedDeltaValue = null;
                --this.numberLinked;
            }
            if (this.linkedP1Value != null) {
                ((EditClient)parent).remove((Component)((Object)this.linkedP1Value));
                this.linkedP1Value = null;
                --this.numberLinked;
            }
            if (this.linkedP2Value != null) {
                ((EditClient)parent).remove((Component)((Object)this.linkedP2Value));
                this.linkedP2Value = null;
                --this.numberLinked;
            }
            parent.repaint();
            if (this.numberLinked == 0) {
                this.setLinked(false);
            }
        } else if (parent != null) {
            this.showError("Cannot remove linked delta values while graph is in current container");
        }
    }

    protected void clearLinkedKey() {
        Container parent = ((Component)((Object)this)).getParent();
        if (parent instanceof EditClient) {
            parent.remove((Component)((Object)this.linkedKey));
            parent.repaint();
            if (--this.numberLinked == 0) {
                this.setLinked(false);
            }
            this.linkedKey = null;
        } else if (parent != null) {
            this.showError("Cannot remove key while graph is in current container");
        }
    }

    protected void clearLinkedMouseLocation() {
        Container parent = ((Component)((Object)this)).getParent();
        if (parent instanceof LinkedComponentParent) {
            ((LinkedComponentParent)parent).remove((Component)((Object)this.linkedMouseLocation));
            parent.repaint();
            if (--this.numberLinked == 0) {
                this.setLinked(false);
            }
            this.linkedMouseLocation = null;
        } else if (parent != null) {
            this.showError("Cannot remove mouse locaiton key while graph is in current container");
        }
    }

    protected void createAxes() {
        this.xaxis = new HorizontalAxisDrawDelegate(0, this);
        this.yaxis = new VerticalAxisDrawDelegate(1, this);
    }

    protected Component createLinkedComponent(LinkedComponentParent parent, String componentName) {
        Component retval = (Component)parent.addLinkedComponent(componentName, null);
        ((IfLinkChildInterface)retval).setLinkComponent(this.linkId, (Component)((Object)this));
        retval.setBackground(this.backgroundColor);
        retval.setSize(retval.getPreferredSize());
        ++this.numberLinked;
        return retval;
    }

    protected void drawCross(Point p, Graphics g) {
        g.setColor(this.deltaLineColor);
        g.drawLine(p.x - 5, p.y, p.x - 1, p.y);
        g.drawLine(p.x + 1, p.y, p.x + 5, p.y);
        g.drawLine(p.x, p.y - 5, p.x, p.y - 1);
        g.drawLine(p.x, p.y + 1, p.x, p.y + 5);
    }

    protected void finalizeDeltaLine(Point p) {
        this.partDeltaLine(this.localG, p);
        this.deltaRealXE = this.xaxis.pixelToWc(p.x);
        this.deltaRealYE = this.yaxis.pixelToWc(p.y);
        this.updateDeltaString();
        if (this.deltaProperty != null) {
            double[] tmp = new double[]{this.deltaRealXS, this.deltaRealYS, this.deltaRealXE, this.deltaRealYE};
            MapStore ms = new MapStore(10007);
            ms.setValue((Object)tmp);
            InterfaceUpdateEvent e = new InterfaceUpdateEvent(this.deltaProperty, (Object)ms);
            this.fireInterfaceUpdateEvent(e);
        }
        this.localG.dispose();
        ((Component)((Object)this)).repaint();
    }

    public void finalizeJelsim() {
        if (this.ma != null) {
            if (this.resetProperty != null) {
                this.finalizeMP(this.resetProperty);
            }
            if (this.xaxis != null) {
                this.xaxis.removeModelListeners();
            }
            if (this.yaxis != null) {
                this.xaxis.removeModelListeners();
            }
        }
    }

    protected void fireInterfaceUpdateEvent(InterfaceUpdateEvent e) {
        if (this.listeners != null) {
            Vector v = null;
            Graph graph = this;
            synchronized (graph) {
                v = (Vector)this.listeners.clone();
            }
            int i = 0;
            while (i < v.size()) {
                ((InterfaceUpdateListener)v.elementAt(i)).handleInterfaceUpdate(e);
                ++i;
            }
        }
    }

    protected void fullDeltaLine(Graphics g) {
        this.drawCross(this.deltaStart, g);
        this.drawCross(this.deltaEnd, g);
        g.drawLine(this.deltaStart.x, this.deltaStart.y, this.deltaEnd.x, this.deltaEnd.y);
    }

    protected void genXTicks() {
        double nextval;
        double actval = nextval = this.xaxis.getMajorTickStartPoint();
        if (this.xaxis.getNumberOfMajorTicks() >= 1) {
            this.xticks = new int[this.xaxis.getNumberOfMajorTicks()];
            if (this.xaxis.getScaleType() == 1) {
                nextval = Math.pow(10.0, actval);
            }
            this.xticks[0] = this.xaxis.wcToPixel(nextval);
            int i = 1;
            while (i < this.xticks.length) {
                nextval = this.xaxis.getScaleType() != 1 ? (nextval += this.xaxis.getMajorTickInterval()) : Math.pow(10.0, actval += this.xaxis.getMajorTickInterval());
                this.xticks[i] = this.xaxis.wcToPixel(nextval);
                ++i;
            }
        }
    }

    protected void genYTicks() {
        double nextval;
        double actval = nextval = this.yaxis.getMajorTickStartPoint();
        if (this.yaxis.getNumberOfMajorTicks() >= 1) {
            this.yticks = new int[this.yaxis.getNumberOfMajorTicks()];
            if (this.yaxis.getScaleType() == 1) {
                nextval = Math.pow(10.0, actval);
            }
            this.yticks[0] = this.yaxis.wcToPixel(nextval);
            int i = 1;
            while (i < this.yticks.length) {
                nextval = this.yaxis.getScaleType() != 1 ? (nextval += this.yaxis.getMajorTickInterval()) : Math.pow(10.0, actval += this.yaxis.getMajorTickInterval());
                this.yticks[i] = this.yaxis.wcToPixel(nextval);
                ++i;
            }
        }
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public Object getBean(int x, int y) {
        if (this.xaxis != null && this.xaxis.onLine(x, y)) {
            return this.xaxis;
        }
        if (this.yaxis != null && this.yaxis.onLine(x, y)) {
            return this.yaxis;
        }
        return this;
    }

    public int getBorderGap() {
        return this.borderGap;
    }

    public boolean getClearOnReset() {
        return this.clearOnReset;
    }

    public double getDataXmax() {
        return this.dataXmax;
    }

    public double getDataXmin() {
        return this.dataXmin;
    }

    public double getDataYmax() {
        return this.dataYmax;
    }

    public double getDataYmin() {
        return this.dataYmin;
    }

    public Color getDeltaLineColor() {
        return this.deltaLineColor;
    }

    public ModelPropertyInterface getDeltaProperty() {
        return this.deltaProperty;
    }

    public void getFixedXAxisStart() {
        this.xaxis.getFixedStart();
    }

    public void getFixedYAxisStart() {
        this.yaxis.getFixedStart();
    }

    public Font getFont() {
        return this.font;
    }

    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public int getLinkId() {
        return this.linkId;
    }

    public ModelPropertyInterface getMajorXUnitProperty() {
        return this.xaxis.getMajorUnitProperty();
    }

    public ModelPropertyInterface getMajorYUnitProperty() {
        return this.yaxis.getMajorUnitProperty();
    }

    public ModelPropertyInterface getMaxXValueProperty() {
        return this.xaxis.getMaxValueProperty();
    }

    public ModelPropertyInterface getMaxYValueProperty() {
        return this.yaxis.getMaxValueProperty();
    }

    public ModelPropertyInterface getMinXValueProperty() {
        return this.xaxis.getMinValueProperty();
    }

    public ModelPropertyInterface getMinYValueProperty() {
        return this.yaxis.getMinValueProperty();
    }

    public ModelPropertyInterface getMinorXUnitProperty() {
        return this.xaxis.getMinorUnitProperty();
    }

    public ModelPropertyInterface getMinorYUnitProperty() {
        return this.yaxis.getMinorUnitProperty();
    }

    public int getNumberLinked() {
        return this.numberLinked;
    }

    public ModelPropertyInterface getResetProperty() {
        return this.resetProperty;
    }

    public HorizontalAxisDrawDelegate getXaxis() {
        return this.xaxis;
    }

    public VerticalAxisDrawDelegate getYaxis() {
        return this.yaxis;
    }

    public abstract void handleModelUpdate(ModelUpdateEvent var1);

    protected void initialiseDeltaLine(Point p) {
        this.localG = ((Component)((Object)this)).getGraphics();
        this.localG.setColor(this.deltaLineColor);
        this.localG.setXORMode(this.backgroundColor);
        if (this.deltaStart != null) {
            this.fullDeltaLine(this.localG);
            this.deltaEnd = null;
        }
        this.deltaStart = p;
        this.drawCross(p, this.localG);
        this.deltaRealXS = this.xaxis.pixelToWc(p.x);
        this.deltaRealYS = this.yaxis.pixelToWc(p.y);
        if (this.linkedP1Value != null) {
            this.linkedP1Value.updateValues(this.deltaRealXS, this.deltaRealYS);
        }
    }

    protected void initialiseLinkedKey() {
    }

    protected void initialiseLinkedKey(GraphKey key) {
        this.linkedKey = key;
        this.initialiseLinkedKey();
    }

    protected void initialiseLinkedValue(GraphValue value) {
        switch (value.getDisplayType()) {
            case 0: {
                this.linkedDeltaValue = value;
                break;
            }
            case 1: {
                this.linkedP1Value = value;
                break;
            }
            case 2: {
                this.linkedP2Value = value;
                break;
            }
            case 3: {
                this.linkedMouseLocation = value;
                break;
            }
            default: {
                this.showError("Value link reconstruction error, please report" + value.getDisplayType());
            }
            case -1: 
        }
    }

    protected void initialiseXAxis() {
        this.xaxis.setShowTicks(true);
        this.xaxis.setShowScale(true);
        this.xaxis.setScaleType(0);
        this.setZeroXAxis(this.zeroXAxis);
        this.xaxis.setFont(this.font);
    }

    protected void initialiseYAxis() {
        this.yaxis.setTickMarkLocation(0);
        this.yaxis.setAxisNumberLocation(0);
        this.yaxis.setShowTicks(true);
        this.yaxis.setShowScale(true);
        this.yaxis.setScaleType(0);
        this.setZeroYAxis(this.zeroYAxis);
        this.yaxis.setFont(this.font);
    }

    public boolean isLinked() {
        return this.linked;
    }

    public boolean isShowDeltaValues() {
        return this.showDeltaValues;
    }

    public boolean isShowGraphBox() {
        return this.showGraphBox;
    }

    public boolean isShowHorizontalGridlines() {
        return this.showHorizontalGridlines;
    }

    public boolean isShowKey() {
        return this.showKey;
    }

    public boolean isShowMouseLocation() {
        return this.showMouseLocation;
    }

    public boolean isShowVerticalGridlines() {
        return this.showVerticalGridlines;
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public boolean isZeroXAxis() {
        return this.zeroXAxis;
    }

    public boolean isZeroYAxis() {
        return this.zeroYAxis;
    }

    protected abstract String linkedKeyClass();

    public void paint(Graphics g) {
        int i;
        super.paint(g);
        if (!this.transparent) {
            g.setColor(this.getBackgroundColor());
            g.fillRect(0, 0, this.width, this.height);
        }
        this.xaxis.draw(g);
        this.yaxis.draw(g);
        g.setColor(this.foregroundColor);
        if (this.showVerticalGridlines) {
            i = 0;
            while (i < this.xticks.length) {
                g.drawLine(this.xticks[i], this.oy, this.xticks[i], this.oy - this.yPlotSize);
                ++i;
            }
        }
        g.setColor(this.foregroundColor);
        if (this.showGraphBox) {
            g.drawLine(this.ox + this.xPlotSize, this.oy, this.ox + this.xPlotSize, this.oy - this.yPlotSize);
            g.drawLine(this.ox, this.oy, this.ox + this.xPlotSize, this.oy);
            g.drawLine(this.ox, this.oy - this.yPlotSize, this.ox + this.xPlotSize, this.oy - this.yPlotSize);
        }
        if (this.showHorizontalGridlines) {
            i = 0;
            while (i < this.yticks.length) {
                g.drawLine(this.ox, this.yticks[i], this.ox + this.xPlotSize, this.yticks[i]);
                ++i;
            }
        }
        g.setFont(this.font);
        if (this.deltaStart != null) {
            if (this.deltaEnd != null) {
                this.fullDeltaLine(g);
            } else {
                this.drawCross(this.deltaStart, g);
            }
        }
    }

    protected void partDeltaLine(Graphics g, Point p1) {
        g.setXORMode(this.backgroundColor);
        if (this.deltaEnd != null) {
            this.drawCross(this.deltaEnd, g);
            g.drawLine(this.deltaStart.x, this.deltaStart.y, this.deltaEnd.x, this.deltaEnd.y);
        }
        this.deltaEnd = p1;
        this.drawCross(this.deltaEnd, g);
        g.drawLine(this.deltaStart.x, this.deltaStart.y, this.deltaEnd.x, this.deltaEnd.y);
        this.updateCurrentMouse(p1);
        this.updateDeltaString();
    }

    public void processMouseEvent(MouseEvent e) {
        if (!Beans.isDesignTime() && this.showDeltaValues) {
            Point p = e.getPoint();
            if (((Component)((Object)this)).contains(p.x, p.y)) {
                switch (e.getID()) {
                    case 501: {
                        this.initialiseDeltaLine(e.getPoint());
                        break;
                    }
                    case 502: {
                        this.finalizeDeltaLine(e.getPoint());
                        break;
                    }
                }
            }
        }
        super.processMouseEvent(e);
    }

    public void processMouseMotionEvent(MouseEvent e) {
        if (!Beans.isDesignTime()) {
            switch (e.getID()) {
                case 506: {
                    if (!this.showDeltaValues) break;
                    this.partDeltaLine(this.localG, e.getPoint());
                    break;
                }
                case 503: {
                    if (!this.showMouseLocation) break;
                    this.updateCurrentMouse(e.getPoint());
                    break;
                }
            }
        }
        super.processMouseMotionEvent(e);
    }

    public void removeInterfaceUpdateListener(InterfaceUpdateListener l) {
        if (this.listeners != null && this.listeners.contains(l)) {
            this.listeners.removeElement(l);
        }
    }

    public void setBackgroundColor(Color c) {
        ((Component)((Object)this)).setBackground(c);
        this.backgroundColor = c;
        ((Component)((Object)this)).repaint();
    }

    public void setBorderGap(int bg) {
        this.borderGap = bg;
        this.adjustSize();
    }

    public void setBounds(int x, int y, int w, int h) {
        int oldw = this.width;
        int oldh = this.height;
        super.setBounds(x, y, w, h);
        if (oldw != this.width || oldh != this.height) {
            this.adjustSize();
        }
    }

    public void setClearOnReset(boolean b) {
        this.clearOnReset = b;
    }

    public void setDataXmax(double d) {
        this.dataXmax = d;
    }

    public void setDataXmin(double d) {
        this.dataXmin = d;
    }

    public void setDataYmax(double d) {
        this.dataYmax = d;
    }

    public void setDataYmin(double d) {
        this.dataYmin = d;
    }

    protected void setDefaultDataRange() {
        this.dataXmin = 0.0;
        this.dataXmax = 100.0;
        this.dataYmin = 0.0;
        this.dataYmax = 100.0;
    }

    public void setDeltaLineColor(Color color) {
        this.deltaLineColor = color;
        ((Component)((Object)this)).repaint();
    }

    public void setDeltaProperty(ModelPropertyInterface fmp) {
        if (this.deltaProperty != null && this.ma != null) {
            this.ma.removeModelUpdateListener(this.deltaProperty, (ModelUpdateListener)this);
        }
        this.deltaProperty = fmp;
        if (this.deltaProperty != null && this.ma != null) {
            this.ma.addModelUpdateListener(this.deltaProperty, (ModelUpdateListener)this);
        }
    }

    public void setFixedXAxisStart(int i) {
        this.xaxis.setFixedStart(i);
    }

    public void setFixedYAxisStart(int i) {
        this.yaxis.setFixedStart(i);
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.font = font;
        this.fontm = ((Component)((Object)this)).getFontMetrics(font);
        this.maxXfont = this.fontm.getMaxAdvance();
        this.fontAscent = this.fontm.getMaxAscent();
        this.maxYfont = this.fontm.getLeading() + this.fontm.getMaxAscent() + this.fontm.getMaxDescent();
        this.adjustSize();
    }

    public void setForegroundColor(Color c) {
        this.foregroundColor = c;
        ((Component)((Object)this)).repaint();
    }

    public void setLinkId(int id) {
        this.linkId = id;
        if (this.linkedKey != null) {
            this.linkedKey.setLinkComponent(id, (Component)((Object)this));
        }
        if (this.linkedDeltaValue != null) {
            this.linkedDeltaValue.setLinkComponent(id, (Component)((Object)this));
        }
        if (this.linkedP1Value != null) {
            this.linkedP1Value.setLinkComponent(id, (Component)((Object)this));
        }
        if (this.linkedP2Value != null) {
            this.linkedP2Value.setLinkComponent(id, (Component)((Object)this));
        }
        if (this.linkedMouseLocation != null) {
            this.linkedMouseLocation.setLinkComponent(id, (Component)((Object)this));
        }
    }

    public void setLinked(boolean b) {
        this.linked = b;
    }

    protected void setLinkedKey(GraphKey key) {
        this.linkedKey = key;
    }

    public void setLocalId(int id) {
        super.setLocalId(id);
        this.setLinkId(id);
    }

    public void setMajorXUnitProperty(ModelPropertyInterface mp) {
        this.yaxis.setMinorUnitProperty(mp);
    }

    public void setMajorYUnitProperty(ModelPropertyInterface mp) {
        this.yaxis.setMinorUnitProperty(mp);
    }

    public void setMaxXValueProperty(ModelPropertyInterface mp) {
        this.xaxis.setMaxValueProperty(mp);
    }

    public void setMaxYValueProperty(ModelPropertyInterface mp) {
        this.yaxis.setMaxValueProperty(mp);
    }

    public void setMinXValueProperty(ModelPropertyInterface mp) {
        this.xaxis.setMinValueProperty(mp);
    }

    public void setMinYValueProperty(ModelPropertyInterface mp) {
        this.yaxis.setMinValueProperty(mp);
    }

    public void setMinorXUnitProperty(ModelPropertyInterface mp) {
        this.xaxis.setMinorUnitProperty(mp);
    }

    public void setMinorYUnitProperty(ModelPropertyInterface mp) {
        this.yaxis.setMinorUnitProperty(mp);
    }

    public void setModelAccess(ModelAccessInterface ma) {
        ModelAccessInterface oldma = this.ma;
        super.setModelAccess(ma);
        this.addInterfaceUpdateListener((InterfaceUpdateListener)ma);
        if (oldma != null && oldma != ma) {
            this.removeInterfaceUpdateListener((InterfaceUpdateListener)oldma);
        }
        this.xaxis.setModelAccess(ma);
        this.yaxis.setModelAccess(ma);
    }

    public void setNumberLinked(int numberLinked) {
        this.numberLinked = numberLinked;
    }

    public void setResetProperty(ModelPropertyInterface fmp) {
        if (this.resetProperty != null && this.ma != null) {
            this.ma.removeModelUpdateListener(this.resetProperty, (ModelUpdateListener)this);
        }
        this.resetProperty = fmp;
        if (this.resetProperty != null && this.ma != null) {
            this.ma.addModelUpdateListener(this.resetProperty, (ModelUpdateListener)this);
        }
    }

    public void setShowDeltaValues(boolean b) {
        this.showDeltaValues = b;
        if (this.showDeltaValues) {
            this.addLinkedDeltaValues();
        } else {
            this.clearLinkedDeltaValues();
        }
    }

    public void setShowGraphBox(boolean b) {
        this.showGraphBox = b;
        ((Component)((Object)this)).repaint();
    }

    public void setShowHorizontalGridlines(boolean b) {
        this.showHorizontalGridlines = b;
        if (b) {
            this.genYTicks();
        }
        ((Component)((Object)this)).repaint();
    }

    public void setShowKey(boolean b) {
        this.showKey = b;
        if (this.showKey) {
            if (this.linkedKey == null) {
                this.addLinkedKey();
            }
        } else if (this.linkedKey != null) {
            this.clearLinkedKey();
        }
    }

    public void setShowMouseLocation(boolean b) {
        this.showMouseLocation = b;
        if (this.showMouseLocation) {
            this.addLinkedMouseLocation();
        } else {
            this.clearLinkedMouseLocation();
        }
    }

    public void setShowVerticalGridlines(boolean b) {
        this.showVerticalGridlines = b;
        if (b) {
            this.genXTicks();
        }
        ((Component)((Object)this)).repaint();
    }

    public void setSize(int w, int h) {
        this.width = w;
        this.height = h;
        this.adjustSize();
        super.setSize(w, h);
    }

    public void setTransparent(boolean b) {
        this.transparent = b;
    }

    private void setXAxisValues() {
        this.xaxis.setOx(this.ox);
        this.xaxis.setLengthInPixels(this.xPlotSize);
        if (this.showVerticalGridlines) {
            this.genXTicks();
        }
    }

    public void setXaxis(HorizontalAxisDrawDelegate a) {
        if (this.xaxis != null) {
            this.xaxis.removeModelListeners();
        }
        this.xaxis = a;
        this.xaxis.setModelAccess(this.ma);
        this.xaxis.setParent(this);
        this.adjustSize();
    }

    private void setYAxisValues() {
        this.yaxis.setLengthInPixels(this.yPlotSize);
        this.yaxis.setOy(this.oy);
        if (this.showHorizontalGridlines) {
            this.genYTicks();
        }
    }

    public void setYaxis(VerticalAxisDrawDelegate a) {
        if (this.yaxis != null) {
            this.yaxis.removeModelListeners();
        }
        this.yaxis.setModelAccess(this.ma);
        this.yaxis = a;
        this.yaxis.setParent(this);
        this.adjustSize();
    }

    public void setZeroXAxis(boolean b) {
        this.zeroXAxis = b;
        this.adjustSize();
    }

    public void setZeroYAxis(boolean b) {
        this.zeroYAxis = b;
        this.adjustSize();
    }

    protected void updateCurrentMouse(Point p) {
        this.currentRealXS = this.xaxis.pixelToWc(p.x);
        this.currentRealYS = this.yaxis.pixelToWc(p.y);
        if (this.linkedMouseLocation != null) {
            this.linkedMouseLocation.updateValues(this.currentRealXS, this.currentRealYS);
        }
    }

    private void updateDeltaString() {
        if (this.deltaStart != null && this.deltaEnd != null) {
            if (this.linkedDeltaValue != null) {
                double dx = this.xaxis.pixelToWc(this.deltaEnd.x) - this.xaxis.pixelToWc(this.deltaStart.x);
                double dy = this.yaxis.pixelToWc(this.deltaEnd.y) - this.yaxis.pixelToWc(this.deltaStart.y);
                this.linkedDeltaValue.updateValues(dx, dy);
            }
            if (this.linkedP2Value != null) {
                this.linkedP2Value.updateValues(this.currentRealXS, this.currentRealYS);
            }
        }
    }
}

