/*
 * Decompiled with CFR 0.152.
 */
package org.jelsim.beans.text;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Vector;
import org.jelsim.beans.support.BeanSupport;
import org.jelsim.beans.support.ModelAccessInterface;
import org.jelsim.beans.support.SimpleBeanSupport;
import org.jelsim.beans.text.ScriptString;
import org.jelsim.model.event.InterfaceUpdateEvent;
import org.jelsim.model.event.InterfaceUpdateListener;
import org.jelsim.model.event.ModelUpdateEvent;
import org.jelsim.model.event.ModelUpdateListener;
import org.jelsim.model.map.MapStore;
import org.jelsim.model.map.ModelPropertyInterface;
import org.jelsim.system.SystemColor;
import org.jelsim.userif.containers.compound.CompoundObject;

public class TextString
extends SimpleBeanSupport
implements ActionListener,
ModelUpdateListener {
    static final long serialVersionUID = 1562765018460038893L;
    private static final int DEFAULT_WIDTH = 120;
    private static final int DEFAULT_HEIGHT = 40;
    private static final int DEFAULT_MAXLENGTH = 25;
    protected static final String UNASSIGNED = "Not Assigned";
    protected Color titlecolor;
    protected Color optextColor;
    protected Color backgroundcolor;
    protected Color textColor;
    protected Font titleFont;
    protected FontMetrics tfm;
    protected Font stringFont;
    protected FontMetrics dfm;
    protected int stringHeight;
    protected int titleHeight;
    protected int titlex;
    protected int titley;
    protected int stringy;
    protected String value = "";
    protected boolean showTitle = true;
    protected int maxLength;
    protected boolean acceptInput = false;
    private Panel inpan = null;
    private TextField stringText = null;
    private boolean editing = false;
    protected Color editColor;
    protected Color editBackground;
    private Vector listeners = null;
    protected boolean checkScripts = true;
    protected Font scriptFont;
    protected FontMetrics sfm;
    protected ScriptString scriptStr;
    private String selectionString = "";
    private boolean entrySelects = false;

    public TextString() {
        ((BeanSupport)this).width = 120;
        ((BeanSupport)this).height = 40;
        this.titleHeight = 15;
        this.stringHeight = ((BeanSupport)this).height - this.titleHeight;
        this.titleFont = SystemColor.getFont();
        this.tfm = ((Component)((Object)this)).getFontMetrics(this.titleFont);
        this.stringFont = SystemColor.getFont();
        this.dfm = ((Component)((Object)this)).getFontMetrics(this.stringFont);
        this.scriptFont = SystemColor.getFont();
        this.sfm = ((Component)((Object)this)).getFontMetrics(this.scriptFont);
        this.setResizable(true);
        this.setSize(((BeanSupport)this).width, ((BeanSupport)this).height);
        this.backgroundcolor = SystemColor.getTextNumBGColor();
        this.titlecolor = SystemColor.getTitleFrameColor();
        this.optextColor = SystemColor.getTextNumEditColor();
        this.textColor = SystemColor.getTextNumFontColor();
        this.setMaxLength(25);
        this.setEditBackground(SystemColor.getTextNumEditColor());
        this.setEditColor(SystemColor.getTextNumBGColor());
        String[] fmptmp = new String[]{"modelProperty"};
        ((BeanSupport)this).fmpSaveNames = fmptmp;
        String[] normaltmp = new String[]{"showTitle", "titleFont", "titleBackground", "title", "stringFont", "titleColor", "stringBackground", "stringColor", "maxLength", "editHelp", "resizable", "userHelp", "editColor", "editBackground", "acceptInput", "scriptFont", "checkScripts", "entrySelects", "selectionString"};
        ((BeanSupport)this).normalSaveNames = normaltmp;
    }

    public void DrawString(Graphics g) {
        if (this.showTitle) {
            g.setColor(this.titlecolor);
            g.fillRect(0, 0, ((BeanSupport)this).width, this.titleHeight);
            g.setColor(this.textColor);
            g.setFont(this.titleFont);
            g.drawString(((BeanSupport)this).title, ((BeanSupport)this).width / 2 - this.tfm.stringWidth(((BeanSupport)this).title) / 2, this.titley);
            g.setColor(this.backgroundcolor);
            g.fillRect(0, this.titleHeight, ((BeanSupport)this).width, ((BeanSupport)this).height - this.titleHeight);
        } else {
            g.setColor(this.backgroundcolor);
            g.fillRect(0, this.titleHeight, ((BeanSupport)this).width, ((BeanSupport)this).height);
        }
        g.drawRect(0, 0, ((BeanSupport)this).width - 1, ((BeanSupport)this).height - 1);
        g.setColor(this.optextColor);
        if (this.scriptStr == null) {
            g.setFont(this.stringFont);
            g.drawString(this.value, ((BeanSupport)this).width / 2 - this.dfm.stringWidth(this.value) / 2, this.stringy);
        } else {
            this.scriptStr.drawString(g, ((BeanSupport)this).width / 2 - this.scriptStr.stringWidth() / 2, this.stringy);
        }
    }

    public void actionPerformed(ActionEvent e) {
        this.completeEdit(this.stringText.getText());
        ((Component)((Object)this)).getParent().remove(this.inpan);
        this.inpan.setEnabled(false);
        this.stringText.removeActionListener(this);
        this.stringText = null;
    }

    public void addInterfaceUpdateListener(InterfaceUpdateListener l) {
        if (this.listeners == null) {
            this.listeners = new Vector(2);
        }
        if (!this.listeners.contains(l)) {
            this.listeners.addElement(l);
        }
    }

    public void adjustSize() {
        Dimension d = this.getPreferredSize();
        this.setSize(d.width, d.height);
    }

    private void completeEdit(String str) {
        if (this.fmp != null) {
            int inputType = this.fmp.getType();
            MapStore ms = new MapStore(inputType);
            if (str.length() > 0) {
                ms.setValue(str);
            } else {
                ms.setValue("");
            }
            this.fireInterfaceUpdateEvent(new InterfaceUpdateEvent(this.fmp, (Object)ms));
        }
        this.editing = false;
        ((Component)((Object)this)).repaint();
    }

    public void finalizeJelsim() {
        super.finalizeJelsim();
        if (this.inpan != null) {
            ((Component)((Object)this)).getParent().remove(this.inpan);
        }
    }

    protected void fireInterfaceUpdateEvent(InterfaceUpdateEvent e) {
        if (this.listeners != null) {
            Vector v = null;
            Vector vector = this.listeners;
            synchronized (vector) {
                v = (Vector)this.listeners.clone();
            }
            int i = 0;
            while (i < v.size()) {
                ((InterfaceUpdateListener)v.elementAt(i)).handleInterfaceUpdate(e);
                ++i;
            }
        }
    }

    private Point getAdjust() {
        Point p = new Point(0, 0);
        Container parent = ((Component)((Object)this)).getParent();
        while (parent instanceof CompoundObject) {
            p.x += parent.getLocation().x;
            p.y += parent.getLocation().y;
            parent = parent.getParent();
        }
        return p;
    }

    public Color getEditBackground() {
        return this.editBackground;
    }

    public Color getEditColor() {
        return this.editColor;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public ModelAccessInterface getModelAccess() {
        return super.getModelAccess();
    }

    public ModelPropertyInterface getModelProperty() {
        return super.getModelProperty();
    }

    public Dimension getPreferredSize() {
        int textWidth = 0;
        int width = 0;
        int textHeight = 0;
        int height = 0;
        this.titleHeight = 0;
        if (this.showTitle && ((BeanSupport)this).title != null) {
            width = this.tfm.stringWidth(((BeanSupport)this).title) + 2 * this.tfm.stringWidth("0");
            this.titleHeight = height = this.tfm.getHeight() + this.tfm.getLeading();
        }
        if (this.value != null) {
            textWidth = this.dfm.stringWidth(this.value) + 2 * this.dfm.stringWidth("0");
            textHeight = this.dfm.getHeight() + this.dfm.getLeading();
        }
        if (width < textWidth) {
            width = textWidth;
        }
        height += textHeight;
        if (width < 120) {
            width = 120;
        }
        if (height == 0) {
            height = 40;
        }
        if (((BeanSupport)this).resizable) {
            int dwidth = (this.maxLength + 2) * this.dfm.stringWidth("0");
            if (width > dwidth) {
                width = dwidth;
            }
            if (this.checkScripts) {
                height += this.sfm.getAscent() / 2;
            }
            return new Dimension(width, height);
        }
        return new Dimension(width, height);
    }

    public Font getScriptFont() {
        return this.scriptFont;
    }

    public String getSelectionString() {
        return this.selectionString;
    }

    public boolean getShowTitle() {
        return this.showTitle;
    }

    public Color getStringBackground() {
        return this.backgroundcolor;
    }

    public Color getStringColor() {
        return this.optextColor;
    }

    public Font getStringFont() {
        return this.stringFont;
    }

    public Color getTitleBackground() {
        return this.titlecolor;
    }

    public Color getTitleColor() {
        return this.textColor;
    }

    public Font getTitleFont() {
        return this.titleFont;
    }

    public void handleModelUpdate(ModelUpdateEvent e) {
        if (((ModelPropertyInterface)e.getSource()).sameMapStore(this.fmp)) {
            this.setValue(e.getValue().toString());
        }
    }

    public boolean isAcceptInput() {
        return this.acceptInput;
    }

    public boolean isCheckScripts() {
        return this.checkScripts;
    }

    public boolean isEntrySelects() {
        return this.entrySelects;
    }

    public void paint(Graphics g) {
        this.DrawString(g);
        super.paint(g);
    }

    public void processMouseEvent(MouseEvent e) {
        if (this.acceptInput && e.getID() == 500 && !this.editing) {
            this.showInDigital();
        }
        super.processMouseEvent(e);
    }

    public void removeInterfaceUpdateListener(InterfaceUpdateListener l) {
        if (this.listeners != null && this.listeners.contains(l)) {
            this.listeners.removeElement(l);
        }
    }

    public void setAcceptInput(boolean b) {
        this.acceptInput = b;
    }

    public void setBounds(int x, int y, int w, int h) {
        int width = (this.maxLength + 2) * this.dfm.stringWidth("0");
        if (w < width) {
            width = w;
        }
        if (this.showTitle && this.tfm != null) {
            this.titlex = w / 2 - this.tfm.stringWidth(((BeanSupport)this).title) / 2;
            this.titley = this.titleHeight - this.tfm.getDescent() - this.tfm.getLeading() / 2;
        }
        int fontSpace = this.dfm.getLeading() / 2 + this.dfm.getAscent() + this.dfm.getDescent();
        this.stringHeight = h - this.titleHeight;
        this.stringy = this.stringHeight > fontSpace ? this.titleHeight + this.dfm.getLeading() / 2 + this.dfm.getAscent() + (this.stringHeight - fontSpace) / 2 : this.titleHeight + this.dfm.getLeading() / 2 + this.dfm.getAscent();
        super.setBounds(x, y, width, h);
    }

    public void setBounds(Rectangle r) {
        this.setBounds(r.x, r.y, r.width, r.height);
    }

    public void setCheckScripts(boolean b) {
        this.checkScripts = b;
        if (b) {
            this.sizeToFit();
            if (this.fmp != null) {
                this.setValue(this.fmp);
            }
        } else if (this.scriptStr != null) {
            this.scriptStr = null;
            ((Component)((Object)this)).repaint();
        }
    }

    public void setEditBackground(Color c) {
        this.editBackground = c;
    }

    public void setEditColor(Color c) {
        this.editColor = c;
    }

    public void setEntrySelects(boolean b) {
        this.entrySelects = b;
    }

    public void setMaxLength(int l) {
        this.maxLength = l;
        this.adjustSize();
    }

    public void setModelAccess(ModelAccessInterface ma) {
        ModelAccessInterface oldma = ((BeanSupport)this).ma;
        super.setModelAccess(ma);
        this.addInterfaceUpdateListener((InterfaceUpdateListener)ma);
        if (oldma != null && oldma != ma) {
            this.removeInterfaceUpdateListener((InterfaceUpdateListener)oldma);
        }
    }

    public void setModelProperty(ModelPropertyInterface fmp) {
        super.setModelProperty(fmp);
        String propName = UNASSIGNED;
        if (fmp != null) {
            propName = fmp.getName();
        }
        ((BeanSupport)this).userHelp = "This string displays a value for \"" + propName + "\"";
    }

    public void setScriptFont(Font font) {
        this.scriptFont = font;
        this.sfm = ((Component)((Object)this)).getFontMetrics(this.scriptFont);
        if (this.checkScripts && this.scriptStr != null) {
            this.scriptStr.setScriptFont(font, this.sfm);
        }
        this.sizeToFit();
    }

    public void setSelectionString(String selectionString) {
        this.selectionString = selectionString;
    }

    public void setShowTitle(boolean b) {
        this.showTitle = b;
        this.adjustSize();
    }

    public void setStringBackground(Color c) {
        this.backgroundcolor = c;
        ((Component)((Object)this)).repaint();
    }

    public void setStringColor(Color color) {
        this.optextColor = color;
        ((Component)((Object)this)).repaint();
    }

    public void setStringFont(Font font) {
        this.stringFont = font;
        this.dfm = ((Component)((Object)this)).getFontMetrics(this.stringFont);
        if (this.checkScripts && this.scriptStr != null) {
            this.scriptStr.setStringFont(font, this.dfm);
        }
        this.sizeToFit();
    }

    public void setTitle(String title) {
        super.setTitle(title);
        if (this.tfm != null) {
            this.titlex = ((BeanSupport)this).width / 2 - this.tfm.stringWidth(title) / 2;
        }
        ((Component)((Object)this)).repaint();
    }

    public void setTitleBackground(Color c) {
        this.titlecolor = c;
        ((Component)((Object)this)).repaint();
    }

    public void setTitleColor(Color color) {
        this.textColor = color;
        ((Component)((Object)this)).repaint();
    }

    public void setTitleFont(Font font) {
        this.titleFont = font;
        this.tfm = ((Component)((Object)this)).getFontMetrics(this.titleFont);
        this.sizeToFit();
    }

    protected void setValue(String v) {
        this.value = v;
        if (this.checkScripts) {
            if (v.indexOf(60) >= 0) {
                if (this.scriptStr == null) {
                    this.scriptStr = new ScriptString(this.value, this.stringFont, this.dfm, this.scriptFont, this.sfm);
                } else {
                    this.scriptStr.setString(this.value);
                }
            } else {
                this.scriptStr = null;
            }
        }
        ((Component)((Object)this)).repaint();
    }

    public void setValue(ModelPropertyInterface fmp) {
        if (fmp != null) {
            this.setValue(String.valueOf(fmp.getValue()));
        } else {
            this.setValue("");
        }
    }

    public void setVisible(boolean b) {
        super.setVisible(b);
        if (!b && this.stringText != null) {
            this.completeEdit(this.stringText.getText());
        }
    }

    private void showInDigital() {
        this.editing = true;
        this.inpan = new Panel();
        Dimension d = this.getSize();
        this.inpan.setSize(d.width, d.height - this.titleHeight);
        this.inpan.setLayout(null);
        this.inpan.setBackground(this.backgroundcolor);
        if (this.stringText == null) {
            this.stringText = new TextField();
            this.stringText.setForeground(this.editColor);
            ((Component)this.stringText).setBackground(this.editBackground);
            this.stringText.setText(this.value);
            this.stringText.setFont(this.getStringFont());
            this.stringText.addActionListener(this);
        }
        this.stringText.setSize(d.width, d.height - this.titleHeight);
        Point p = ((Component)((Object)this)).getLocation();
        p.y += this.titleHeight;
        if (System.getProperty("java.vendor").startsWith("Microsoft") && System.getProperty("java.version").startsWith("1.1") && !System.getProperty("java.version").endsWith(".4")) {
            Point adjust = this.getAdjust();
            p.x += adjust.x;
            p.y += adjust.y;
        }
        this.inpan.setLocation(p);
        ((Component)((Object)this)).getParent().add(this.inpan);
        this.inpan.add(this.stringText);
        this.stringText.requestFocus();
        if (this.entrySelects) {
            if (this.selectionString.length() > 0) {
                int selectionStart = this.value.indexOf(this.selectionString);
                if (selectionStart >= 0) {
                    this.stringText.setSelectionStart(selectionStart);
                    this.stringText.setSelectionEnd(selectionStart + this.selectionString.length());
                }
            } else if (this.value != null && this.value.length() > 0) {
                this.stringText.setSelectionStart(0);
                this.stringText.setSelectionEnd(this.value.length());
            }
        }
        ((Component)((Object)this)).repaint();
    }
}

