/*
 * Decompiled with CFR 0.152.
 */
package org.jelsim.beans.text;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.StringTokenizer;
import java.util.Vector;
import org.jelsim.beans.support.BeanSupport;
import org.jelsim.system.SystemColor;

public class TextObject
extends BeanSupport {
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int CENTRE = 2;
    static final long serialVersionUID = -4626473007583898544L;
    private static final int DEFAULT_HEIGHT = 30;
    protected String currentText;
    protected Font font;
    protected FontMetrics fm;
    protected int gap;
    protected Color textColor;
    protected Color backgroundColor = null;
    protected Color borderColor = null;
    protected int justify;
    protected Vector displayStrings;
    protected boolean isTransparent = false;

    public TextObject() {
        this.setTextColor(SystemColor.getTextNumFontColor());
        this.setBackgroundColor(SystemColor.getTitleFrameColor());
        this.font = SystemColor.getFont();
        this.fm = ((Component)((Object)this)).getFontMetrics(this.font);
        this.gap = this.fm.getHeight() / 2;
        this.setText("Double click to edit \nThis two line section of text");
        this.setJustification(0);
        String[] normaltmp = new String[]{"justification", "text", "backgroundColor", "font", "textColor", "editHelp", "userHelp", "border", "borderColor", "displayStrings", "transparent"};
        this.normalSaveNames = normaltmp;
    }

    public void adjustSize() {
        this.setText(this.currentText);
    }

    public void finalizeJelsim() {
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public int getBorder() {
        return this.gap;
    }

    public Color getBorderColor() {
        if (this.borderColor == null) {
            this.borderColor = this.backgroundColor;
            ((Component)((Object)this)).repaint();
        }
        return this.borderColor;
    }

    public String[] getDisplayStrings() {
        String[] strings = new String[this.displayStrings.size()];
        int i = 0;
        while (i < this.displayStrings.size()) {
            strings[i] = (String)this.displayStrings.elementAt(i);
            ++i;
        }
        return strings;
    }

    public Font getFont() {
        return this.font;
    }

    public int getJustification() {
        return this.justify;
    }

    public Dimension getMinimumSize() {
        if (this.width > 0) {
            return new Dimension(this.width, this.height);
        }
        return new Dimension(50, 50);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public String getText() {
        return this.currentText;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public boolean isTransparent() {
        return this.isTransparent;
    }

    public void paint(Graphics g) {
        this.paintAtLocation(0, 0, g);
    }

    public void paintAtLocation(int xpos, int ypos, Graphics g) {
        g.setFont(this.font);
        if (!this.isTransparent()) {
            if (this.borderColor != null) {
                g.setColor(this.borderColor);
            } else {
                g.setColor(this.backgroundColor);
            }
            g.fillRect(xpos, ypos, this.width, this.height);
            g.setColor(this.backgroundColor);
            g.fillRect(xpos + this.gap, ypos + this.gap, this.width - 2 * this.gap, this.height - 2 * this.gap);
        }
        g.setColor(this.textColor);
        int hgap = this.fm.getAscent() + this.fm.getDescent();
        int y = this.gap + this.fm.getHeight() - this.fm.getDescent();
        int i = 0;
        while (i < this.displayStrings.size()) {
            String str = (String)this.displayStrings.elementAt(i);
            int swidth = this.fm.stringWidth(str);
            int x = this.justify == 0 ? this.gap : (this.justify == 1 ? this.width - this.gap - swidth : this.width / 2 - swidth / 2);
            g.drawString(str, x + xpos, y + ypos);
            y += hgap;
            ++i;
        }
        super.paint(g);
    }

    public void setBackgroundColor(Color c) {
        this.backgroundColor = c;
        ((Component)((Object)this)).repaint();
    }

    public void setBorder(int borderGap) {
        this.gap = borderGap;
        this.adjustSize();
    }

    public void setBorderColor(Color bc) {
        this.borderColor = bc;
        ((Component)((Object)this)).repaint();
    }

    public void setDisplayStrings(String[] strs) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < strs.length) {
            sb.append(String.valueOf(strs[i]) + "\n");
            ++i;
        }
        this.setText(sb.toString());
    }

    public void setFont(Font font) {
        this.font = font;
        this.fm = ((Component)((Object)this)).getFontMetrics(font);
        this.sizeToFit();
    }

    public void setJustification(int j) throws IllegalArgumentException {
        if (j < 0 || j > 2) {
            throw new IllegalArgumentException("Justify range is 0-3");
        }
        this.justify = j;
        ((Component)((Object)this)).repaint();
    }

    public void setSize(int w, int h) {
        Graphics g;
        Container parent = ((Component)((Object)this)).getParent();
        if (parent != null && (g = parent.getGraphics()) != null) {
            g.setColor(parent.getBackground());
            Rectangle b = ((Component)((Object)this)).getBounds();
            g.fillRect(b.x, b.y, b.width, b.height);
        }
        super.setSize(w, h);
    }

    public void setText(String s) {
        this.currentText = s;
        StringTokenizer tok = new StringTokenizer(s, "\n", true);
        int tokens = tok.countTokens();
        this.displayStrings = new Vector(tokens);
        int newWidth = 0;
        boolean ncount = false;
        String last = null;
        int i = 0;
        while (i < tokens) {
            String str = tok.nextToken();
            if (!str.equals("\n")) {
                newWidth = Math.max(newWidth, this.fm.stringWidth(str));
                this.displayStrings.addElement(str);
            } else if (last != null && last.equals("\n")) {
                this.displayStrings.addElement("");
            }
            last = str;
            ++i;
        }
        int newHeight = this.displayStrings.size() * (this.fm.getHeight() + this.fm.getLeading()) + 2 * this.gap;
        if ((newWidth += 2 * this.gap) != this.width || newHeight != this.height) {
            this.setSize(newWidth, newHeight);
        }
    }

    public void setTextColor(Color c) {
        this.textColor = c;
        ((Component)((Object)this)).repaint();
    }

    public void setTransparent(boolean b) {
        this.isTransparent = b;
        ((Component)((Object)this)).repaint();
    }
}

