/*
 * Decompiled with CFR 0.152.
 */
package org.jelsim.beans.text;

import java.awt.Component;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.Beans;
import org.jelsim.beans.support.BeanSupport;
import org.jelsim.beans.text.ScriptString;
import org.jelsim.beans.text.TextString;
import org.jelsim.model.event.InterfaceUpdateEvent;
import org.jelsim.model.event.ModelUpdateEvent;
import org.jelsim.model.event.ModelUpdateListener;
import org.jelsim.model.map.MapStore;
import org.jelsim.model.map.ModelPropertyInterface;
import org.jelsim.system.ErrorHandler;

public class TextMenu
extends TextString
implements ModelUpdateListener,
ActionListener {
    static final long serialVersionUID = -3388843038008246162L;
    protected int selectedId = 0;
    protected String[] menuStrings = null;
    protected String[] displayStrings = null;
    protected ModelPropertyInterface selectedProperty = null;
    protected ModelPropertyInterface menuProperty = null;
    protected PopupMenu popup = null;

    public void actionPerformed(ActionEvent e) {
        String ac = e.getActionCommand();
        int index = 0;
        while (index < this.menuStrings.length) {
            if (ac.equals(this.menuStrings[index])) {
                MapStore ms = new MapStore(this.selectedProperty.getType());
                ms.setValue(index);
                this.fireInterfaceUpdateEvent(new InterfaceUpdateEvent(this.selectedProperty, (Object)ms));
                break;
            }
            ++index;
        }
        this.popup.removeActionListener(this);
        ((Component)((Object)this)).remove(this.popup);
        this.popup = null;
    }

    public void finalizeJelsim() {
        super.finalizeJelsim();
    }

    public ModelPropertyInterface getModelProperty() {
        return super.getModelProperty();
    }

    public void handleModelUpdate(ModelUpdateEvent e) {
        ModelPropertyInterface source = (ModelPropertyInterface)e.getSource();
        if (source.sameMapStore(this.selectedProperty)) {
            this.setSelected();
        } else if (source.sameMapStore(this.menuProperty)) {
            this.setMenu();
        } else {
            super.handleModelUpdate(e);
        }
    }

    private void popup(MouseEvent e) {
        if (this.menuStrings != null) {
            this.popup = new PopupMenu("Text Menu");
            int i = 0;
            while (i < this.menuStrings.length) {
                this.popup.add(this.menuStrings[i]);
                ++i;
            }
            ((Component)((Object)this)).add(this.popup);
            this.popup.addActionListener(this);
            this.popup.show((Component)((Object)this), 0, 0);
        }
    }

    public void processMouseEvent(MouseEvent e) {
        if (!Beans.isDesignTime() && e.getID() == 500) {
            this.popup(e);
        }
        super.processMouseEvent(e);
    }

    private void reportError(String error) {
        ErrorHandler.reportMessage((String)error);
    }

    private void setMenu() {
        if (this.menuProperty != null) {
            this.displayStrings = (String[])this.menuProperty.getValue();
            this.menuStrings = new String[this.displayStrings.length];
            ScriptString sstr = new ScriptString();
            int i = 0;
            while (i < this.menuStrings.length) {
                sstr.setString(this.displayStrings[i]);
                this.menuStrings[i] = sstr.getMenuString();
                ++i;
            }
        }
    }

    public void setModelProperty(ModelPropertyInterface fmp) {
        super.setModelProperty(fmp);
        if (((BeanSupport)this).ma != null) {
            if (this.selectedProperty != null) {
                ((BeanSupport)this).ma.removeModelUpdateListener(this.selectedProperty, (ModelUpdateListener)this);
            }
            if (this.menuProperty != null) {
                ((BeanSupport)this).ma.removeModelUpdateListener(this.menuProperty, (ModelUpdateListener)this);
            }
            if (fmp != null) {
                this.selectedProperty = ((BeanSupport)this).ma.getProperty(String.valueOf(fmp.getName()) + "Selected", (Object)fmp.getGid());
                if (this.selectedProperty != null) {
                    ((BeanSupport)this).ma.addModelUpdateListener(this.selectedProperty, (ModelUpdateListener)this);
                    this.setSelected();
                } else {
                    this.reportError(String.valueOf(fmp.getName()) + ":" + fmp.getGid() + " Select property missing in " + this.getClass().getName());
                }
                this.menuProperty = ((BeanSupport)this).ma.getProperty(String.valueOf(fmp.getName()) + "Menu", (Object)fmp.getGid());
                if (this.menuProperty != null) {
                    ((BeanSupport)this).ma.addModelUpdateListener(this.menuProperty, (ModelUpdateListener)this);
                    this.setMenu();
                } else {
                    this.reportError(String.valueOf(fmp.getName()) + ":" + fmp.getGid() + "Menu property missing in " + this.getClass().getName());
                }
            }
        }
    }

    private void setSelected() {
        if (this.selectedProperty != null) {
            this.selectedId = (Integer)this.selectedProperty.getValue();
        }
    }
}

