/*
 * Decompiled with CFR 0.152.
 */
package org.jelsim.beans.text;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class ScriptString {
    public static final String SUB = "<sub>";
    public static final String SUBEND = "</sub>";
    public static final String SUP = "<sup>";
    public static final String SUPEND = "</sup>";
    public static final int NORMAL = 0;
    public static final int SUBS = 1;
    public static final int SUPS = 2;
    private Font stringFont;
    private FontMetrics fm;
    private Font scriptFont;
    private FontMetrics sfm;
    private String str;
    private String[] displayStrings;
    private int[] stringTypes;
    private int numberStrings = 0;

    public ScriptString() {
    }

    public ScriptString(String str, Font stringFont, FontMetrics fm, Font scriptFont, FontMetrics sfm) {
        this.str = str;
        this.stringFont = stringFont;
        this.fm = fm;
        this.scriptFont = scriptFont;
        this.sfm = sfm;
        this.parseString();
    }

    private int countScripts(String str) {
        int count = 0;
        int startIndex = 0;
        while ((startIndex = str.indexOf(SUP, startIndex)) >= 0) {
            ++count;
            ++startIndex;
        }
        startIndex = 0;
        while ((startIndex = str.indexOf(SUB, startIndex)) >= 0) {
            ++count;
            ++startIndex;
        }
        return count;
    }

    public void drawString(Graphics g, int startX, int baseY) {
        int subY = baseY + this.sfm.getAscent() / 2 - this.sfm.getDescent();
        int supY = baseY - this.sfm.getAscent() / 2;
        int i = 0;
        while (i < this.numberStrings) {
            switch (this.stringTypes[i]) {
                case 0: {
                    g.setFont(this.stringFont);
                    g.drawString(this.displayStrings[i], startX, baseY);
                    startX += this.fm.stringWidth(this.displayStrings[i]);
                    break;
                }
                case 1: {
                    g.setFont(this.scriptFont);
                    g.drawString(this.displayStrings[i], startX, subY);
                    startX += this.sfm.stringWidth(this.displayStrings[i]);
                    break;
                }
                case 2: {
                    g.setFont(this.scriptFont);
                    g.drawString(this.displayStrings[i], startX, supY);
                    startX += this.sfm.stringWidth(this.displayStrings[i]);
                    break;
                }
            }
            ++i;
        }
    }

    public String getMenuString() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.numberStrings) {
            switch (this.stringTypes[i]) {
                case 0: {
                    sb.append(this.displayStrings[i]);
                    break;
                }
                case 1: {
                    sb.append("_");
                    sb.append(this.displayStrings[i]);
                    sb.append("_");
                    break;
                }
                case 2: {
                    sb.append("^");
                    sb.append(this.displayStrings[i]);
                    sb.append("^");
                    break;
                }
            }
            ++i;
        }
        return sb.toString();
    }

    private void parseString() {
        String lstr = this.str.toLowerCase();
        int len = this.str.length();
        int startIndex = 0;
        int nextIndex = 0;
        this.numberStrings = 0;
        int endIndex = 0;
        int maxStr = 2 * this.countScripts(lstr) + 1;
        this.displayStrings = new String[maxStr];
        this.stringTypes = new int[maxStr];
        while ((nextIndex = lstr.indexOf(60, nextIndex)) >= 0) {
            if (lstr.startsWith(SUB, nextIndex) || lstr.startsWith(SUP, nextIndex)) {
                if (nextIndex != startIndex) {
                    this.displayStrings[this.numberStrings] = this.str.substring(startIndex, nextIndex);
                    this.stringTypes[this.numberStrings] = 0;
                    ++this.numberStrings;
                    startIndex = nextIndex;
                }
                if (lstr.startsWith(SUB, nextIndex)) {
                    endIndex = lstr.indexOf(SUBEND, nextIndex);
                    this.displayStrings[this.numberStrings] = endIndex < 0 ? this.str.substring(nextIndex + 5, this.str.length()) : this.str.substring(nextIndex + 5, endIndex);
                    startIndex = nextIndex = endIndex + 6;
                    this.stringTypes[this.numberStrings] = 1;
                    ++this.numberStrings;
                    continue;
                }
                if (!lstr.startsWith(SUP, nextIndex)) continue;
                endIndex = lstr.indexOf(SUPEND, nextIndex);
                this.displayStrings[this.numberStrings] = endIndex < 0 ? this.str.substring(nextIndex + 5, this.str.length()) : this.str.substring(nextIndex + 5, endIndex);
                startIndex = nextIndex = endIndex + 6;
                this.stringTypes[this.numberStrings] = 2;
                ++this.numberStrings;
                continue;
            }
            ++nextIndex;
        }
        if (startIndex < this.str.length()) {
            this.displayStrings[this.numberStrings] = this.str.substring(startIndex);
            this.stringTypes[this.numberStrings] = 0;
            ++this.numberStrings;
        }
    }

    public void setScriptFont(Font scriptFont, FontMetrics sfm) {
        this.scriptFont = scriptFont;
        this.sfm = sfm;
    }

    public void setString(String str) {
        this.str = str;
        this.parseString();
    }

    public void setStringFont(Font stringFont, FontMetrics fm) {
        this.stringFont = stringFont;
        this.fm = fm;
    }

    public int stringWidth() {
        int width = 0;
        int i = 0;
        while (i < this.numberStrings) {
            width = this.stringTypes[i] == 0 ? (width += this.fm.stringWidth(this.displayStrings[i])) : (width += this.sfm.stringWidth(this.displayStrings[i]));
            ++i;
        }
        return width;
    }
}

