/*
 * Decompiled with CFR 0.152.
 */
package org.jelsim.beans.table;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.Beans;
import org.jelsim.beans.table.Table;
import org.jelsim.userif.containers.compound.CompoundObject;

public class TableTextField
extends Container
implements MouseListener,
ActionListener {
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_RIGHT = 1;
    public static final int ALIGN_CENTRE = 2;
    private int justify = 0;
    private int x;
    private int y;
    private int width;
    private int height;
    private String displayString = "";
    private boolean editable = false;
    private FontMetrics fm;
    private int baseLine = 0;
    private Table parent;
    int row = 0;
    int column = 0;
    int fx;
    int fy;
    int fw;
    int fh;
    private TextField tf;

    public TableTextField(Table parent, String displayString) {
        this.displayString = displayString;
        this.parent = parent;
        this.addMouseListener(this);
        this.setLayout(null);
    }

    public void actionPerformed(ActionEvent e) {
        this.displayString = this.tf.getText();
        this.tf.getParent().remove(this.tf);
        this.parent.checkAndSetArrayValue(this.row, this.column, this.displayString);
        this.tf.removeActionListener(this);
        this.tf = null;
    }

    protected void addTextField(TextField tf) {
        String selectionString = this.parent.getSelectionString();
        this.tf = tf;
        tf.setVisible(false);
        tf.setText(this.displayString);
        tf.setSize(this.width, this.height);
        tf.addActionListener(this);
        if (this.getParent() instanceof Table) {
            Point p = this.getLocation();
            Container parent = this.getParentAndAdjustPoint(p);
            tf.setLocation(p);
            parent.add(tf);
        } else {
            tf.setLocation(0, 0);
            this.add(tf);
        }
        tf.setVisible(true);
        if (this.parent.isEntrySelects()) {
            if (selectionString.length() > 0) {
                int selectionStart = this.displayString.indexOf(selectionString);
                if (selectionStart >= 0) {
                    tf.setSelectionStart(selectionStart);
                    tf.setSelectionEnd(selectionStart + selectionString.length());
                }
            } else if (this.displayString.length() > 0) {
                tf.setSelectionStart(0);
                tf.setSelectionEnd(this.displayString.length());
            }
        } else {
            tf.setCaretPosition(0);
        }
        tf.requestFocus();
    }

    protected int getColumn() {
        return this.column;
    }

    public int getJustify() {
        return this.justify;
    }

    private Container getParentAndAdjustPoint(Point p) {
        Container parent = this.getParent();
        p.x += parent.getLocation().x;
        p.y += parent.getLocation().y;
        parent = parent.getParent();
        while (parent instanceof CompoundObject) {
            if (parent instanceof CompoundObject) {
                p.x += parent.getLocation().x;
                p.y += parent.getLocation().y;
                parent = parent.getParent();
                continue;
            }
            return parent;
        }
        return parent;
    }

    public Dimension getPreferredSize() {
        return new Dimension(50, 50);
    }

    protected int getRow() {
        return this.row;
    }

    public String getText() {
        return this.displayString;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void mouseClicked(MouseEvent e) {
        if (!Beans.isDesignTime() && this.editable && e.getClickCount() >= 1) {
            this.parent.setCurrentField(this);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.fy = 1;
        this.fx = 1;
        this.fw = this.width - 2;
        this.fh = this.height - 2;
        if (this.editable) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.width - 1, this.height - 1);
            g.setColor(this.parent.getBackground());
            this.fy = 0;
            this.fx = 0;
            this.fw = this.width - 1;
            this.fh = this.height - 1;
            int i = 0;
            while (i < 3) {
                g.draw3DRect(this.fx++, this.fy++, this.fw, this.fh, false);
                this.fw -= 2;
                this.fh -= 2;
                ++i;
            }
        } else {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.width - 1, this.height - 1);
        }
        if (this.fm == null) {
            this.fm = g.getFontMetrics(this.getFont());
            this.baseLine = (this.height - 6 - this.fm.getAscent() - this.fm.getDescent()) / 2;
            this.baseLine = this.baseLine > 0 ? (this.baseLine += this.fm.getAscent()) : this.fm.getAscent() + this.fm.getLeading();
        }
        g.setColor(this.getForeground());
        g.setFont(this.getFont());
        if (this.justify == 0) {
            g.drawString(this.displayString, 5 + this.fm.getLeading(), this.baseLine);
        } else if (this.justify == 1) {
            g.drawString(this.displayString, this.width - 5 - this.fm.stringWidth(this.displayString), this.baseLine);
        } else {
            g.drawString(this.displayString, this.width / 2 - this.fm.stringWidth(this.displayString) / 2, this.baseLine);
        }
    }

    public void setBounds(int x, int y, int w, int h) {
        this.width = w;
        this.height = h;
        this.fm = null;
        super.setBounds(x, y, w, h);
    }

    public void setBounds(Rectangle r) {
        this.setBounds(r.x, r.y, r.width, r.height);
    }

    public void setColumns(int width) {
    }

    public void setEditable(boolean b) {
        this.editable = b;
        this.repaint();
    }

    public void setFont(Font f) {
        super.setFont(f);
        this.fm = null;
    }

    public void setJustify(int justify) {
        this.justify = justify;
        this.repaint();
    }

    protected void setTablePosition(int row, int column) {
        this.row = row;
        this.column = column;
    }

    public void setText(String text) {
        this.displayString = text;
        this.repaint();
    }
}

