/*
 * Decompiled with CFR 0.152.
 */
package org.jelsim.beans.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Array;
import java.util.Vector;
import org.jelsim.beans.support.BeanContainerSupport;
import org.jelsim.beans.support.ModelAccessInterface;
import org.jelsim.beans.support.SimConst;
import org.jelsim.beans.support.SimpleBeanContainerSupport;
import org.jelsim.beans.table.TableTextField;
import org.jelsim.model.event.InterfaceUpdateEvent;
import org.jelsim.model.event.InterfaceUpdateListener;
import org.jelsim.model.event.ModelUpdateEvent;
import org.jelsim.model.map.MapStore;
import org.jelsim.model.map.ModelPropertyInterface;
import org.jelsim.system.ErrorHandler;

public class Table
extends SimpleBeanContainerSupport
implements SimConst {
    static final long serialVersionUID = -8072726247772562256L;
    private boolean swapRowsAndCols = false;
    private TableTextField[][] tableFields = null;
    private Object array;
    private int justify = 0;
    private int rows = 0;
    private int cols = 0;
    private int dimensions = 0;
    private int arrayType;
    protected GridLayout panelLayout;
    private Color fieldBackground = Color.white;
    private Color editBackground = Color.white;
    private Color fieldForeground = Color.black;
    private int fieldWidth = 8;
    private Font fieldFont = new Font("SansSerif", 0, 12);
    private boolean inputTable = true;
    private ScrollPane sp = null;
    private boolean useScrollBars = false;
    private String truePrompt = "true";
    private String falsePrompt = "false";
    private TextField textField;
    private TableTextField currentField;
    private String selectionString = "";
    private boolean entrySelects = false;
    private Vector listeners;
    PopupMenu popup = null;

    public Table() {
        ((BeanContainerSupport)this).resizable = true;
        this.panelLayout = new GridLayout(2, 2, 0, 0);
        ((Container)((Object)this)).setLayout(this.panelLayout);
        this.setBackground(new Color(137, 137, 173));
        this.setSize(150, 100);
        String[] fmptmp = new String[]{"modelProperty"};
        ((BeanContainerSupport)this).fmpSaveNames = fmptmp;
        String[] normaltmp = new String[]{"fieldWidth", "hgap", "background", "fieldFont", "fieldBackground", "inputTable", "vgap", "swapRowsAndCols", "fieldForeground", "resizable", "editHelp", "userHelp", "title", "truePrompt", "falsePrompt", "justify", "editBackground", "entrySelects", "selectionString"};
        ((BeanContainerSupport)this).normalSaveNames = normaltmp;
    }

    public void addInterfaceUpdateListener(InterfaceUpdateListener l) {
        if (this.listeners == null) {
            this.listeners = new Vector(2);
        }
        if (!this.listeners.contains(l)) {
            this.listeners.addElement(l);
        }
    }

    protected void checkAndSetArrayValue(int rowIndex, int colIndex, String rep) {
        Object currentValue = null;
        Object array1 = Array.get(this.array, rowIndex);
        currentValue = this.dimensions == 1 ? array1 : Array.get(array1, colIndex);
        boolean retval = false;
        try {
            switch (this.arrayType) {
                case 0: {
                    Boolean bval = new Boolean(rep);
                    if (((Boolean)currentValue).booleanValue() != bval.booleanValue()) {
                        this.setArrayValue(array1, rowIndex, colIndex, bval);
                        retval = true;
                    }
                    break;
                }
                case 1: {
                    if (rep.length() >= 1 && ((Character)currentValue).charValue() != rep.charAt(0)) {
                        this.setArrayValue(array1, rowIndex, colIndex, new Character(rep.charAt(0)));
                        retval = true;
                    }
                    break;
                }
                case 2: {
                    Byte val = new Byte(rep);
                    if (((Byte)currentValue).byteValue() != val.byteValue()) {
                        this.setArrayValue(array1, rowIndex, colIndex, val);
                        retval = true;
                    }
                    break;
                }
                case 3: {
                    Short sval = new Short(rep);
                    if (((Short)currentValue).shortValue() != sval.shortValue()) {
                        this.setArrayValue(array1, rowIndex, colIndex, sval);
                        retval = true;
                    }
                    break;
                }
                case 4: {
                    Integer ival = new Integer(rep);
                    if (((Integer)currentValue).intValue() != ival.intValue()) {
                        this.setArrayValue(array1, rowIndex, colIndex, ival);
                        retval = true;
                    }
                    break;
                }
                case 5: {
                    Long lval = new Long(rep);
                    if (((Long)currentValue).longValue() != lval.longValue()) {
                        this.setArrayValue(array1, rowIndex, colIndex, lval);
                        retval = true;
                    }
                    break;
                }
                case 6: {
                    Float fval = new Float(rep);
                    if (((Float)currentValue).floatValue() != fval.floatValue()) {
                        this.setArrayValue(array1, rowIndex, colIndex, fval);
                        retval = true;
                    }
                    break;
                }
                case 7: {
                    Double dval = new Double(rep);
                    if (((Double)currentValue).doubleValue() != dval.doubleValue()) {
                        this.setArrayValue(array1, rowIndex, colIndex, dval);
                        retval = true;
                    }
                    break;
                }
                case 8: {
                    if (!rep.equals((String)currentValue)) {
                        this.setArrayValue(array1, rowIndex, colIndex, rep);
                        retval = true;
                    }
                    break;
                }
                default: {
                    ErrorHandler.reportMessage((String)("table: unknown array type " + this.arrayType));
                    break;
                }
            }
        }
        catch (Exception exception) {
            this.setArrayValue(array1, rowIndex, colIndex, rep);
            if (this.dimensions == 1) {
                this.tableFields[rowIndex][0].setText(String.valueOf(currentValue));
            }
            this.tableFields[rowIndex][colIndex].setText(String.valueOf(currentValue));
        }
        if (retval) {
            this.fireInterfaceUpdateEvent();
        }
    }

    private void checkEditChange() {
        if (this.textField != null && this.textField.getParent() != null && this.currentField != null && !this.textField.getText().equals(this.currentField.getText())) {
            this.checkAndSetArrayValue(this.currentField.getRow(), this.currentField.getColumn(), this.textField.getText());
        }
    }

    private void clearTableFields() {
        int i = 0;
        while (i < this.tableFields.length) {
            int j = 0;
            while (j < this.tableFields[i].length) {
                this.tableFields[i][j].removeNotify();
                ++j;
            }
            ++i;
        }
        ((Container)((Object)this)).removeAll();
        this.tableFields = null;
    }

    protected void fireInterfaceUpdateEvent() {
        MapStore ms = new MapStore(this.fmp.getType());
        ms.setValue(this.array);
        InterfaceUpdateEvent e = new InterfaceUpdateEvent(this.fmp, (Object)ms);
        this.fireInterfaceUpdateEvent(e);
    }

    protected void fireInterfaceUpdateEvent(InterfaceUpdateEvent e) {
        if (this.listeners != null) {
            Vector v = null;
            Table table = this;
            synchronized (table) {
                v = (Vector)this.listeners.clone();
            }
            int i = 0;
            while (i < v.size()) {
                ((InterfaceUpdateListener)v.elementAt(i)).handleInterfaceUpdate(e);
                ++i;
            }
        }
    }

    public Color getBackground() {
        return super.getBackground();
    }

    public Color getEditBackground() {
        return this.editBackground;
    }

    public String getFalsePrompt() {
        return this.falsePrompt;
    }

    public Color getFieldBackground() {
        return this.fieldBackground;
    }

    public Font getFieldFont() {
        return this.fieldFont;
    }

    public Color getFieldForeground() {
        return this.fieldForeground;
    }

    public int getFieldWidth() {
        return this.fieldWidth;
    }

    public int getHgap() {
        return this.panelLayout.getHgap();
    }

    public Insets getInsets() {
        return new Insets(3, 3, 3, 3);
    }

    public int getJustify() {
        return this.justify;
    }

    public ModelAccessInterface getModelAccess() {
        return super.getModelAccess();
    }

    public String getSelectionString() {
        return this.selectionString;
    }

    public String getTruePrompt() {
        return this.truePrompt;
    }

    public int getVgap() {
        return this.panelLayout.getVgap();
    }

    public void handleModelUpdate(ModelUpdateEvent e) {
        this.setValue(this.fmp);
    }

    public boolean isEntrySelects() {
        return this.entrySelects;
    }

    public boolean isInputTable() {
        return this.inputTable;
    }

    public boolean isSwapRowsAndCols() {
        return this.swapRowsAndCols;
    }

    private void layoutTable() {
        if (this.tableFields != null) {
            this.clearTableFields();
        }
        this.tableFields = new TableTextField[this.rows][this.cols];
        if (this.rows > 0 && this.cols > 0) {
            int j;
            int i = 0;
            while (i < this.rows) {
                Object array1 = Array.get(this.array, i);
                j = 0;
                while (j < this.cols) {
                    this.tableFields[i][j] = this.cols == 1 ? new TableTextField(this, String.valueOf(array1)) : new TableTextField(this, String.valueOf(Array.get(array1, j)));
                    this.tableFields[i][j].setTablePosition(i, j);
                    this.tableFields[i][j].setVisible(true);
                    this.tableFields[i][j].setFont(this.fieldFont);
                    this.tableFields[i][j].setForeground(this.fieldForeground);
                    this.tableFields[i][j].setBackground(this.fieldBackground);
                    this.tableFields[i][j].setEditable(this.inputTable);
                    this.tableFields[i][j].setJustify(this.justify);
                    if (this.arrayType == 0) {
                        if (this.tableFields[i][j].getText() == "true") {
                            this.tableFields[i][j].setText(this.truePrompt);
                        } else {
                            this.tableFields[i][j].setText(this.falsePrompt);
                        }
                    }
                    ++j;
                }
                ++i;
            }
            if (this.swapRowsAndCols) {
                this.panelLayout.setRows(this.cols);
                this.panelLayout.setColumns(this.rows);
                int j2 = 0;
                while (j2 < this.cols) {
                    int i2 = 0;
                    while (i2 < this.rows) {
                        ((Container)((Object)this)).add(this.tableFields[i2][j2]);
                        ++i2;
                    }
                    ++j2;
                }
            } else {
                this.panelLayout.setRows(this.rows);
                this.panelLayout.setColumns(this.cols);
                int i3 = 0;
                while (i3 < this.rows) {
                    j = 0;
                    while (j < this.cols) {
                        ((Container)((Object)this)).add(this.tableFields[i3][j]);
                        ++j;
                    }
                    ++i3;
                }
            }
            ((Component)((Object)this)).setSize(this.getPreferredSize());
            ((Container)((Object)this)).doLayout();
            ((Container)((Object)this)).validate();
            ((Component)((Object)this)).repaint();
        }
    }

    public void paint(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, ((BeanContainerSupport)this).width, ((BeanContainerSupport)this).height);
        super.paint(g);
    }

    private void popup() {
        this.popup = new PopupMenu("test Popup");
        this.popup.add(this.truePrompt);
        this.popup.add(this.falsePrompt);
        ((Component)((Object)this)).add(this.popup);
        this.popup.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand() == Table.this.truePrompt) {
                    Table.this.checkAndSetArrayValue(Table.this.currentField.getRow(), Table.this.currentField.getColumn(), "true");
                } else {
                    Table.this.checkAndSetArrayValue(Table.this.currentField.getRow(), Table.this.currentField.getColumn(), "false");
                }
                ((Component)((Object)Table.this)).remove(Table.this.popup);
                Table.this.popup = null;
            }
        });
        Rectangle p = this.currentField.getBounds();
        this.popup.show((Component)((Object)this), p.x, p.y);
    }

    public void removeInterfaceUpdateListener(InterfaceUpdateListener l) {
        if (this.listeners != null && this.listeners.contains(l)) {
            this.listeners.removeElement(l);
        }
    }

    private void setArrayValue(Object array1, int rowIndex, int colIndex, Object value) {
        try {
            if (this.dimensions == 1) {
                Array.set(this.array, rowIndex, value);
            } else {
                Array.set(array1, colIndex, value);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.showError("Your last table entry was not in the correct format");
        }
    }

    public void setBackground(Color c) {
        super.setBackground(c);
        ((Component)((Object)this)).repaint();
    }

    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        ((Container)((Object)this)).validate();
    }

    protected void setCurrentField(TableTextField currentField) {
        if (this.arrayType != 0) {
            if (this.textField != null) {
                this.textField.removeActionListener(this.currentField);
                this.checkEditChange();
            } else {
                this.textField = new TextField("");
                this.textField.setFont(this.getFieldFont());
                ((Component)this.textField).setBackground(this.editBackground);
            }
            this.currentField = currentField;
            currentField.addTextField(this.textField);
        } else {
            this.currentField = currentField;
            this.popup();
        }
    }

    public void setEditBackground(Color c) {
        this.editBackground = c;
        if (this.textField != null) {
            ((Component)this.textField).setBackground(c);
        }
        ((Component)((Object)this)).repaint();
    }

    public void setEntrySelects(boolean b) {
        this.entrySelects = b;
    }

    public void setFalsePrompt(String p) {
        this.falsePrompt = p;
        this.layoutTable();
    }

    public void setFieldBackground(Color c) {
        this.fieldBackground = c;
        if (this.tableFields != null) {
            int i = 0;
            while (i < this.tableFields.length) {
                int j = 0;
                while (j < this.tableFields[i].length) {
                    this.tableFields[i][j].setBackground(c);
                    this.tableFields[i][j].repaint();
                    ++j;
                }
                ++i;
            }
            ((Component)((Object)this)).repaint();
        }
    }

    public void setFieldFont(Font f) {
        if (this.textField != null) {
            this.textField.setFont(f);
        }
        if (f != this.fieldFont) {
            this.fieldFont = f;
            if (this.tableFields != null) {
                int i = 0;
                while (i < this.tableFields.length) {
                    int j = 0;
                    while (j < this.tableFields[i].length) {
                        this.tableFields[i][j].setFont(f);
                        this.tableFields[i][j].repaint();
                        ++j;
                    }
                    ++i;
                }
            }
        }
    }

    public void setFieldForeground(Color c) {
        this.fieldForeground = c;
        if (this.tableFields != null) {
            int i = 0;
            while (i < this.tableFields.length) {
                int j = 0;
                while (j < this.tableFields[i].length) {
                    this.tableFields[i][j].setForeground(c);
                    this.tableFields[i][j].repaint();
                    ++j;
                }
                ++i;
            }
            ((Component)((Object)this)).repaint();
        }
    }

    public void setFieldWidth(int w) {
        if (this.fieldWidth != w) {
            this.fieldWidth = w;
            if (this.tableFields != null) {
                int i = 0;
                while (i < this.tableFields.length) {
                    int j = 0;
                    while (j < this.tableFields[i].length) {
                        this.tableFields[i][j].setColumns(w);
                        ++j;
                    }
                    ++i;
                }
                ((Component)((Object)this)).repaint();
            }
        }
    }

    public void setHgap(int gap) {
        this.panelLayout.setHgap(gap);
        ((Container)((Object)this)).validate();
    }

    public void setInputTable(boolean b) {
        if (b != this.inputTable) {
            this.inputTable = b;
            if (this.tableFields != null) {
                int i = 0;
                while (i < this.tableFields.length) {
                    int j = 0;
                    while (j < this.tableFields[i].length) {
                        this.tableFields[i][j].setEditable(b);
                        ++j;
                    }
                    ++i;
                }
            }
        }
    }

    public void setJustify(int justify) {
        this.justify = justify;
        if (this.tableFields != null) {
            int i = 0;
            while (i < this.tableFields.length) {
                int j = 0;
                while (j < this.tableFields[i].length) {
                    this.tableFields[i][j].setJustify(justify);
                    ++j;
                }
                ++i;
            }
        }
    }

    public void setModelAccess(ModelAccessInterface ma) {
        ModelAccessInterface oldma = ((BeanContainerSupport)this).ma;
        super.setModelAccess(ma);
        this.addInterfaceUpdateListener((InterfaceUpdateListener)ma);
        if (oldma != null && oldma != ma) {
            this.removeInterfaceUpdateListener((InterfaceUpdateListener)oldma);
        }
    }

    public void setSelectionString(String selectionString) {
        this.selectionString = selectionString;
    }

    public void setSwapRowsAndCols(boolean b) {
        if (b != this.swapRowsAndCols) {
            this.swapRowsAndCols = b;
            this.layoutTable();
        }
    }

    private void setTableFields() {
        boolean subBoolean = this.arrayType == 0 && (this.truePrompt != "true" || this.falsePrompt != "false");
        int i = 0;
        while (i < this.rows) {
            Object array1 = Array.get(this.array, i);
            int j = 0;
            while (j < this.cols) {
                if (this.cols == 1) {
                    if (array1.getClass().isArray()) {
                        this.tableFields[i][j].setText(String.valueOf(Array.get(array1, j)));
                    } else {
                        this.tableFields[i][j].setText(String.valueOf(array1));
                    }
                } else {
                    this.tableFields[i][j].setText(String.valueOf(Array.get(array1, j)));
                }
                if (subBoolean) {
                    if (this.tableFields[i][j].getText() == "true") {
                        this.tableFields[i][j].setText(this.truePrompt);
                    } else {
                        this.tableFields[i][j].setText(this.falsePrompt);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public void setTruePrompt(String p) {
        this.truePrompt = p;
        this.layoutTable();
    }

    public void setValue(ModelPropertyInterface mp) {
        if (mp == null) {
            this.dimensions = 0;
            this.array = null;
        } else {
            this.dimensions = mp.getType() / 10000;
            this.arrayType = mp.getType() % 10000;
            this.array = mp.getValue();
        }
        if (this.dimensions < 1 || this.dimensions > 2) {
            ((Component)((Object)this)).getParent().remove((Component)((Object)this));
            this.showError("Tabular input output object currently deals with 1 + 2D arrays " + this.dimensions + " arrays are not handled");
            throw new IllegalArgumentException("Table object handles 1 or 2D array only.");
        }
        if (this.array != null) {
            int newRows = Array.getLength(this.array);
            int newCols = 1;
            if (newRows == 0) {
                newCols = 1;
            } else if (this.dimensions == 2) {
                Object arrayCol = Array.get(this.array, 0);
                newCols = arrayCol != null ? Array.getLength(arrayCol) : 0;
            }
            if (this.cols != newCols || this.rows != newRows) {
                this.cols = newCols;
                this.rows = newRows;
                this.layoutTable();
            }
            this.setTableFields();
        }
    }

    public void setVgap(int gap) {
        this.panelLayout.setVgap(gap);
        ((Container)((Object)this)).validate();
    }

    public void setVisible(boolean b) {
        super.setVisible(b);
        if (!b) {
            this.checkEditChange();
            if (this.textField != null && this.textField.getParent() != null) {
                this.textField.getParent().remove(this.textField);
            }
        }
        ((Container)((Object)this)).validate();
    }
}

