/*
 * Decompiled with CFR 0.152.
 */
package org.jelsim.beans.shapes;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.Beans;
import java.util.Vector;
import org.jelsim.beans.shapes.WhiteboardInterface;
import org.jelsim.beans.support.BeanSupport;

public class WhiteboardObject
extends BeanSupport
implements WhiteboardInterface {
    static final long serialVersionUID = -4394019389616946708L;
    protected int lineWidth = 1;
    protected Color fillColor = Color.white;
    protected Color controlPointColor = Color.red;
    protected boolean transparent = false;
    protected boolean fillBorder = false;
    protected Vector points = new Vector(1, 1);
    protected int minX;
    protected int maxX;
    protected int minY;
    protected int maxY;
    protected int currentX = 0;
    protected int currentY = 0;
    protected boolean pointsDefined = false;
    protected boolean pointsLimited = false;
    protected int maxPoints = 0;
    protected boolean showControlPoints = false;
    protected boolean draggingControlPoint = false;
    protected int dragPointIndex = 0;
    protected int controlPointRadius = 5;
    protected int selectedPoint = 0;

    public WhiteboardObject() {
        this.userHelp = "";
        this.editHelp = "";
        this.resizable = false;
        this.setSize(0, 0);
        String[] normaltmp = new String[]{"points", "pointsLimited", "fillColor", "maxPoints", "transparent", "pointsDefined", "transparent", "fillBorder", "foreground", "background"};
        this.normalSaveNames = normaltmp;
    }

    public void addLastPoint(int xcoord, int ycoord) {
        this.addPoint(xcoord, ycoord);
        this.pointsDefined = true;
    }

    public void addPoint(int xcoord, int ycoord) {
        int npts = this.points.size();
        if (!this.pointsDefined) {
            if (this.points.size() == 0) {
                this.setBounds(xcoord, ycoord, 10, 10);
                this.maxY = 0;
                this.minY = 0;
                this.maxX = 0;
                this.minX = 0;
            }
            this.currentX = xcoord - ((Component)((Object)this)).getLocation().x;
            this.currentY = ycoord - ((Component)((Object)this)).getLocation().y;
            if (this.points.size() == 0) {
                Point newpoint = new Point(this.currentX, this.currentY);
                this.points.add(newpoint);
            } else {
                Point lastpoint = (Point)this.points.elementAt(npts - 1);
                if (lastpoint.x != this.currentX || lastpoint.y != this.currentY) {
                    Point newpoint = new Point(this.currentX, this.currentY);
                    this.points.add(newpoint);
                }
            }
            if (this.pointsLimited && this.points.size() == this.maxPoints) {
                this.pointsDefined = true;
            }
        }
        this.fixBounds();
    }

    public void drawPoints(Graphics g) {
    }

    public void finalizeJelsim() {
    }

    protected void fixBounds() {
        int moveX = 0;
        int moveY = 0;
        Rectangle r = ((Component)((Object)this)).getBounds();
        int adj = this.controlPointRadius + this.lineWidth;
        moveX = Math.min(this.minX, this.currentX) - adj;
        moveY = Math.min(this.minY, this.currentY) - adj;
        r.x += moveX;
        r.y += moveY;
        this.shiftPoints(-moveX, -moveY);
        r.width = Math.max(this.maxX, this.currentX) + adj;
        r.height = Math.max(this.maxY, this.currentY) + adj;
        this.setBounds(r.x, r.y, r.width, r.height);
    }

    public Color getControlPointColor() {
        return this.controlPointColor;
    }

    public int getControlPointIndex(int xcoord, int ycoord) {
        int mx = xcoord - ((Component)((Object)this)).getLocation().x;
        int my = ycoord - ((Component)((Object)this)).getLocation().y;
        int rr = this.controlPointRadius * this.controlPointRadius;
        int i = 0;
        while (i < this.points.size()) {
            int px = ((Point)this.points.elementAt((int)i)).x;
            int py = ((Point)this.points.elementAt((int)i)).y;
            if ((px - mx) * (px - mx) + (py - my) * (py - my) < rr) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public int getMaxPoints() {
        return this.maxPoints;
    }

    public Vector getPoints() {
        return this.points;
    }

    public void initialiseControlDrag(int xcoord, int ycoord) {
        int mx = xcoord - ((Component)((Object)this)).getLocation().x;
        int my = ycoord - ((Component)((Object)this)).getLocation().y;
        int rr = this.controlPointRadius * this.controlPointRadius;
        this.draggingControlPoint = false;
        int i = 0;
        while (i < this.points.size()) {
            int px = ((Point)this.points.elementAt((int)i)).x;
            int py = ((Point)this.points.elementAt((int)i)).y;
            if ((px - mx) * (px - mx) + (py - my) * (py - my) < rr) {
                this.draggingControlPoint = true;
                this.dragPointIndex = i;
                break;
            }
            ++i;
        }
    }

    public boolean isFillBorder() {
        return this.fillBorder;
    }

    public boolean isPointsDefined() {
        return this.pointsDefined;
    }

    public boolean isPointsLimited() {
        return this.pointsLimited;
    }

    public boolean isShowControlPoints() {
        return this.showControlPoints;
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public void moveControlPoint(int xcoord, int ycoord) {
        this.moveControlPoint(this.dragPointIndex, xcoord, ycoord);
    }

    public void moveControlPoint(int controlIndex, int xcoord, int ycoord) {
        Point pt = new Point();
        pt.x = xcoord - ((Component)((Object)this)).getLocation().x;
        pt.y = ycoord - ((Component)((Object)this)).getLocation().y;
        this.points.setElementAt(pt, controlIndex);
        this.currentX = pt.x;
        this.currentY = pt.y;
        this.shiftPoints(0, 0);
        this.fixBounds();
    }

    public void multipleClick(int xcoord, int ycoord) {
        this.addLastPoint(xcoord, ycoord);
    }

    public int numberOfControlPoints() {
        if (this.points == null) {
            return 0;
        }
        return this.points.size();
    }

    public void paint(Graphics g) {
        g.setPaintMode();
        if (!this.transparent) {
            g.setColor(((Component)((Object)this)).getBackground());
            g.fillRect(0, 0, this.width, this.height);
        }
        if (this.points.size() > 0) {
            g.setColor(((Component)((Object)this)).getForeground());
            int lastX = ((Point)this.points.elementAt((int)0)).x;
            int lastY = ((Point)this.points.elementAt((int)0)).y;
            int i = 1;
            while (i < this.points.size()) {
                int nextX = ((Point)this.points.elementAt((int)i)).x;
                int nextY = ((Point)this.points.elementAt((int)i)).y;
                g.drawLine(lastX, lastY, nextX, nextY);
                lastX = nextX;
                lastY = nextY;
                ++i;
            }
        }
        if (this.showControlPoints) {
            this.drawPoints(g);
        }
    }

    public void processMouseEvent(MouseEvent e) {
        if (this.editable && Beans.isDesignTime() && ((Component)((Object)this)).isEnabled()) {
            switch (e.getID()) {
                case 502: {
                    this.terminateControlDrag(e);
                    break;
                }
            }
        }
        super.processMouseEvent(e);
    }

    public void processMouseMotionEvent(MouseEvent e) {
        super.processMouseMotionEvent(e);
    }

    public void setControlPointColor(Color c) {
        this.controlPointColor = c;
        ((Component)((Object)this)).repaint();
    }

    public void setCurrentPoint(int xcoord, int ycoord) {
        if (this.points.size() > 0) {
            this.currentX = xcoord - ((Component)((Object)this)).getLocation().x;
            this.currentY = ycoord - ((Component)((Object)this)).getLocation().y;
            this.fixBounds();
        }
    }

    public void setFillBorder(boolean b) {
        this.fillBorder = b;
        ((Component)((Object)this)).repaint();
    }

    public void setFillColor(Color c) {
        this.fillColor = c;
        ((Component)((Object)this)).repaint();
    }

    public void setLineWidth(int l) {
        this.lineWidth = l;
        ((Component)((Object)this)).repaint();
    }

    public void setMaxPoints(int m) {
        this.maxPoints = m;
        ((Component)((Object)this)).repaint();
    }

    public void setPoints(Vector p) {
        this.points = p;
        if (this.points.size() > 0) {
            Point pt = (Point)this.points.lastElement();
            this.currentX = pt.x;
            this.currentY = pt.y;
        } else {
            this.currentX = 0;
            this.currentY = 0;
        }
        this.shiftPoints(0, 0);
    }

    public void setPointsDefined(boolean pd) {
        this.pointsDefined = pd;
    }

    public void setPointsLimited(boolean p) {
        this.pointsLimited = p;
        ((Component)((Object)this)).repaint();
    }

    public void setShowControlPoints(boolean s) {
        this.showControlPoints = s;
        ((Component)((Object)this)).repaint();
    }

    public void setTransparent(boolean b) {
        this.transparent = b;
        ((Component)((Object)this)).repaint();
    }

    protected void shiftPoints(int dx, int dy) {
        if (this.points.size() > 0) {
            this.minX = this.maxX = ((Point)this.points.elementAt((int)0)).x + dx;
            this.minY = this.maxY = ((Point)this.points.elementAt((int)0)).y + dy;
            int i = 0;
            while (i < this.points.size()) {
                int nextX = ((Point)this.points.elementAt((int)i)).x;
                int nextY = ((Point)this.points.elementAt((int)i)).y;
                ((Point)this.points.elementAt((int)i)).x = nextX += dx;
                ((Point)this.points.elementAt((int)i)).y = nextY += dy;
                this.minX = this.minX < nextX ? this.minX : nextX;
                this.maxX = this.maxX > nextX ? this.maxX : nextX;
                this.minY = this.minY < nextY ? this.minY : nextY;
                this.maxY = this.maxY > nextY ? this.maxY : nextY;
                ++i;
            }
            this.currentX += dx;
            this.currentY += dy;
        }
    }

    protected void terminateControlDrag(MouseEvent e) {
        this.draggingControlPoint = false;
    }

    public Point topLeftAlignmentOffset() {
        return new Point(this.minX, this.maxX);
    }

    public void updatePoints(Vector p) {
        this.setPoints(p);
        this.fixBounds();
    }
}

