/*
 * Decompiled with CFR 0.152.
 */
package org.jelsim.beans.shapes;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import org.jelsim.beans.shapes.WhiteboardInterface;
import org.jelsim.beans.shapes.WhiteboardObject;

public class WbPolyline
extends WhiteboardObject
implements WhiteboardInterface {
    static final long serialVersionUID = 8677475485626111363L;
    protected boolean startArrow = false;
    protected boolean endArrow = false;
    protected int startArrowType = 0;
    protected int endArrowType = 0;
    protected int arrowSize = 10;
    protected boolean joinEndPoints = false;

    public WbPolyline() {
        this.userHelp = "";
        this.editHelp = "";
        this.resizable = false;
        this.setSize(0, 0);
        this.setFillBorder(false);
        String[] normaltmp = new String[]{"joinEndPoints", "startArrow", "endArrow", "arrowSize", "points", "pointsLimited", "fillColor", "maxPoints", "transparent", "pointsDefined", "fillBorder", "foreground", "background"};
        this.normalSaveNames = normaltmp;
    }

    public void addLastPoint(int xcoord, int ycoord) {
        this.addPoint(xcoord, ycoord);
        this.pointsDefined = true;
    }

    protected void drawArrow(Graphics g, Point apex, Point direction, int arrowlength, int type) {
        if (direction.x != 0 || direction.y != 0) {
            double dirx = direction.x;
            double diry = direction.y;
            double magscale = (double)arrowlength / Math.sqrt(dirx * dirx + diry * diry);
            double lx = -1.0 * magscale * dirx;
            double ly = -1.0 * magscale * diry;
            Point p1 = new Point();
            Point p2 = new Point();
            p1.x = (int)(-lx + 0.5 * -ly);
            p1.y = (int)(-ly + 0.5 * lx);
            p2.x = (int)(-lx + 0.5 * ly);
            p2.y = (int)(-ly + 0.5 * -lx);
            g.drawLine(apex.x, apex.y, apex.x - p1.x, apex.y - p1.y);
            g.drawLine(apex.x, apex.y, apex.x - p2.x, apex.y - p2.y);
        }
    }

    protected void drawArrows(Graphics g) {
        int npts = this.points.size();
        if (npts > 0) {
            Point direction;
            Point from;
            Point apex;
            if (this.startArrow) {
                apex = (Point)this.points.elementAt(0);
                if (npts > 1) {
                    from = (Point)this.points.elementAt(1);
                    direction = new Point(apex.x - from.x, apex.y - from.y);
                    this.drawArrow(g, apex, direction, this.arrowSize, 0);
                } else if (!this.pointsDefined) {
                    direction = new Point(apex.x - this.currentX, apex.y - this.currentY);
                    this.drawArrow(g, apex, direction, this.arrowSize, 0);
                }
            }
            if (this.endArrow) {
                if (!this.pointsDefined) {
                    apex = new Point(this.currentX, this.currentY);
                    from = (Point)this.points.elementAt(npts - 1);
                    direction = new Point(apex.x - from.x, apex.y - from.y);
                    this.drawArrow(g, apex, direction, this.arrowSize, 0);
                } else if (npts > 1) {
                    apex = (Point)this.points.elementAt(npts - 1);
                    from = (Point)this.points.elementAt(npts - 2);
                    direction = new Point(apex.x - from.x, apex.y - from.y);
                    this.drawArrow(g, apex, direction, this.arrowSize, 0);
                }
            }
        }
    }

    public void finalizeJelsim() {
    }

    protected void fixBounds() {
        int moveX = 0;
        int moveY = 0;
        Rectangle r = ((Component)((Object)this)).getBounds();
        int adj = Math.max(this.arrowSize / 2, this.controlPointRadius) + this.lineWidth;
        moveX = Math.min(this.minX, this.currentX) - adj;
        moveY = Math.min(this.minY, this.currentY) - adj;
        r.x += moveX;
        r.y += moveY;
        this.shiftPoints(-moveX, -moveY);
        r.width = Math.max(this.maxX, this.currentX) + adj;
        r.height = Math.max(this.maxY, this.currentY) + adj;
        this.setBounds(r.x, r.y, r.width, r.height);
    }

    public int getArrowSize() {
        return this.arrowSize;
    }

    public boolean getJoinEndPoints() {
        return this.joinEndPoints;
    }

    public boolean isEndArrow() {
        return this.endArrow;
    }

    public boolean isFillBorder() {
        return this.fillBorder;
    }

    protected boolean isInPolygon(int mx, int my) {
        double xx = mx;
        double yy = my;
        int numPts = this.points.size();
        boolean c = false;
        int i = 0;
        int j = numPts - 1;
        while (i < numPts) {
            double xxpi = ((Point)this.points.elementAt((int)i)).x;
            double yypi = ((Point)this.points.elementAt((int)i)).y;
            double xxpj = ((Point)this.points.elementAt((int)j)).x;
            double yypj = ((Point)this.points.elementAt((int)j)).y;
            if ((yypi <= yy && yy < yypj || yypj <= yy && yy < yypi) && xx < (xxpj - xxpi) * (yy - yypi) / (yypj - yypi) + xxpi) {
                c ^= true;
            }
            j = i++;
        }
        return c;
    }

    protected boolean isOnLine(int mx, int my) {
        double xx = mx;
        double yy = my;
        int numPts = this.points.size();
        boolean c = false;
        int i = 0;
        int j = numPts - 1;
        while (i < numPts) {
            int px = ((Point)this.points.elementAt((int)i)).x;
            int py = ((Point)this.points.elementAt((int)i)).y;
            int qx = ((Point)this.points.elementAt((int)j)).x;
            int qy = ((Point)this.points.elementAt((int)j)).y;
            if ((numPts <= 2 || i != 0 || this.joinEndPoints) && this.isOnLine(px, py, qx, qy, 2, 2)) {
                return true;
            }
            j = i++;
        }
        return false;
    }

    protected boolean isOnLine(int px, int py, int qx, int qy, int tx, int ty) {
        return Math.abs((qy - py) * (tx - px) - (ty - py) * (qx - px)) <= Math.abs(qx - px) + Math.abs(qy - py);
    }

    public boolean isStartArrow() {
        return this.startArrow;
    }

    public boolean isinside(int deltax, int deltay) {
        int locx = ((Component)((Object)this)).getLocation().x;
        int locy = ((Component)((Object)this)).getLocation().y;
        return this.isInPolygon(deltax - locx, deltay - locy);
    }

    public void multipleClick(int xcoord, int ycoord) {
        this.addLastPoint(xcoord, ycoord);
    }

    public void paint(Graphics g) {
        g.setPaintMode();
        if (this.points.size() > 0) {
            Polygon poly = new Polygon();
            int i = 0;
            while (i < this.points.size()) {
                Point nextpoint = (Point)this.points.elementAt(i);
                poly.addPoint(nextpoint.x, nextpoint.y);
                ++i;
            }
            if (this.fillBorder && !this.transparent) {
                g.setColor(this.fillColor);
                g.fillPolygon(poly);
            }
            g.setColor(((Component)((Object)this)).getForeground());
            int lastX = ((Point)this.points.elementAt((int)0)).x;
            int lastY = ((Point)this.points.elementAt((int)0)).y;
            i = 1;
            while (i < this.points.size()) {
                int nextX = ((Point)this.points.elementAt((int)i)).x;
                int nextY = ((Point)this.points.elementAt((int)i)).y;
                poly.addPoint(nextX, nextY);
                g.drawLine(lastX, lastY, nextX, nextY);
                lastX = nextX;
                lastY = nextY;
                ++i;
            }
            if (!this.pointsDefined) {
                g.drawLine(lastX, lastY, this.currentX, this.currentY);
            } else if (this.joinEndPoints) {
                i = this.points.size() - 1;
                Point p1 = (Point)this.points.elementAt(0);
                Point p2 = (Point)this.points.elementAt(i);
                g.drawLine(p1.x, p1.y, p2.x, p2.y);
            }
            this.drawArrows(g);
            if (this.showControlPoints) {
                this.drawPoints(g);
            }
        }
    }

    public void setArrowSize(int s) {
        this.arrowSize = s;
        this.fixBounds();
        ((Component)((Object)this)).repaint();
    }

    public void setEndArrow(boolean a) {
        this.endArrow = a;
        ((Component)((Object)this)).repaint();
    }

    public void setFillBorder(boolean b) {
        this.fillBorder = false;
        ((Component)((Object)this)).repaint();
    }

    public void setJoinEndPoints(boolean b) {
        this.joinEndPoints = b;
        ((Component)((Object)this)).repaint();
    }

    public void setStartArrow(boolean a) {
        this.startArrow = a;
        ((Component)((Object)this)).repaint();
    }
}

