/*
 * Decompiled with CFR 0.152.
 */
package org.jelsim.beans.shapes;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import org.jelsim.beans.shapes.WhiteboardInterface;
import org.jelsim.beans.support.BeanSupport;

public class BorderRectangle
extends BeanSupport
implements WhiteboardInterface {
    static final long serialVersionUID = 4602607721586149915L;
    protected Color borderColor = Color.black;
    protected Color fillColor = Color.black;
    protected boolean fillBorder = false;
    protected boolean transparent = false;
    protected boolean rounded = false;
    protected int borderWidth = 5;
    protected int borderArc = 5;

    public BorderRectangle() {
        this.userHelp = "";
        this.editHelp = "";
        this.resizable = true;
        this.setSize(80, 40);
        String[] normaltmp = new String[]{"rounded", "borderWidth", "borderColor", "fillColor", "transparent", "borderArc", "fillBorder", "background"};
        this.normalSaveNames = normaltmp;
    }

    public void finalizeJelsim() {
    }

    public int getBorderArc() {
        return this.borderArc;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public int getLineWidth() {
        return this.getBorderWidth();
    }

    public boolean isFillBorder() {
        return this.fillBorder;
    }

    public boolean isRounded() {
        return this.rounded;
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public void paint(Graphics g) {
        g.setPaintMode();
        if (this.rounded) {
            if (this.fillBorder) {
                g.setColor(this.fillColor);
                g.fillRoundRect(this.borderWidth, this.borderWidth, this.width - 2 * this.borderWidth, this.height - 2 * this.borderWidth, this.borderArc, this.borderArc);
            }
            g.setColor(this.borderColor);
            int i = 0;
            while (i < this.borderWidth) {
                g.drawRoundRect(i, i, this.width - 1 - 2 * i, this.height - 1 - 2 * i, this.borderArc, this.borderArc);
                if (i > 0) {
                    g.drawRoundRect(i - 1, i - 1, this.width - 2 * i, this.height - 2 * i, this.borderArc, this.borderArc);
                    g.drawRoundRect(i - 1 + 1, i - 1, this.width - 2 * i, this.height - 2 * i, this.borderArc, this.borderArc);
                    g.drawRoundRect(i - 1, i - 1 + 1, this.width - 2 * i, this.height - 2 * i, this.borderArc, this.borderArc);
                    g.drawRoundRect(i - 1 + 1, i - 1 + 1, this.width - 2 * i, this.height - 2 * i, this.borderArc, this.borderArc);
                }
                ++i;
            }
        } else {
            if (this.fillBorder) {
                g.setColor(this.fillColor);
                g.fillRect(0, 0, this.width - 1, this.height - 1);
            }
            g.setColor(this.borderColor);
            int i = 0;
            while (i < this.borderWidth) {
                g.drawRect(i, i, this.width - 1 - 2 * i, this.height - 1 - 2 * i);
                ++i;
            }
        }
    }

    public void setBorderArc(int arc) {
        this.borderArc = arc;
        ((Component)((Object)this)).repaint();
    }

    public void setBorderColor(Color c) {
        this.borderColor = c;
        ((Component)((Object)this)).repaint();
    }

    public void setBorderWidth(int w) {
        this.borderWidth = w;
        ((Component)((Object)this)).repaint();
    }

    public void setFillBorder(boolean b) {
        this.fillBorder = b;
        ((Component)((Object)this)).repaint();
    }

    public void setFillColor(Color c) {
        this.fillColor = c;
        ((Component)((Object)this)).repaint();
    }

    public void setForeground(Color c) {
        super.setForeground(c);
        this.setBorderColor(c);
    }

    public void setLineWidth(int l) {
    }

    public void setRounded(boolean b) {
        this.rounded = b;
        ((Component)((Object)this)).repaint();
    }

    public void setTransparent(boolean b) {
        this.transparent = b;
        ((Component)((Object)this)).repaint();
    }
}

