/*
 * Decompiled with CFR 0.152.
 */
package org.jelsim.beans.realinput;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.event.MouseEvent;
import java.beans.Beans;
import java.util.Vector;
import org.jelsim.beans.numberformatter.NumberFormatter;
import org.jelsim.beans.realinput.InterfaceChangeSource;
import org.jelsim.beans.realinput.RealRangeModel;
import org.jelsim.beans.support.BeanSupport;
import org.jelsim.beans.support.ModelAccessInterface;
import org.jelsim.beans.support.SimConst;
import org.jelsim.beans.support.SimpleBeanSupport;
import org.jelsim.model.event.InterfaceUpdateEvent;
import org.jelsim.model.event.InterfaceUpdateListener;
import org.jelsim.model.event.ModelUpdateEvent;
import org.jelsim.model.event.ModelUpdateListener;
import org.jelsim.model.map.MapStore;
import org.jelsim.model.map.ModelPropertyInterface;
import org.jelsim.system.SystemColor;

public class SpinButton
extends SimpleBeanSupport
implements ModelUpdateListener,
InterfaceChangeSource,
SimConst {
    static final long serialVersionUID = 2125274156291360065L;
    protected ModelPropertyInterface modelMin = null;
    protected ModelPropertyInterface modelMax = null;
    protected ModelPropertyInterface modelInc = null;
    private RealRangeModel rangeModel = null;
    private double minModel;
    private double maxModel;
    private double incModel;
    protected double value;
    int midpoint;
    int maxTriWidth;
    protected Font font;
    protected transient FontMetrics fm;
    protected Color textColor;
    protected Color backgroundColor;
    private Color buttonColor;
    protected boolean horizontal = true;
    private boolean pressed = false;
    private boolean isTopHorz = false;
    private boolean isLeftVert = false;
    private transient Vector listeners = null;
    protected String valueString;
    protected NumberFormatter numberFormatter = new NumberFormatter();

    public SpinButton() {
        ((BeanSupport)this).resizable = true;
        this.rangeModel = new RealRangeModel(this);
        this.setTextColor(SystemColor.getButtonFontColor());
        this.setBackgroundColor(SystemColor.getButtonBGColor());
        this.setFont(new Font("SansSerif", 0, 18));
        this.setTitle("spin button");
        this.valueString = new String("initial");
        this.numberFormatter.setConversion(2);
        String[] fmptmp = new String[]{"modelProperty", "modelMin", "modelMax", "modelInc"};
        ((BeanSupport)this).fmpSaveNames = fmptmp;
        String[] normaltmp = new String[]{"backgroundColor", "font", "textColor", "editHelp", "title", "userHelp", "min", "max", "inc", "horizontal", "numberFormatter"};
        ((BeanSupport)this).normalSaveNames = normaltmp;
        this.setSize(150, 50);
    }

    public void addInterfaceUpdateListener(InterfaceUpdateListener l) {
        if (this.listeners == null) {
            this.listeners = new Vector(2);
        }
        if (!this.listeners.contains(l)) {
            this.listeners.addElement(l);
        }
    }

    public void adjustSize() {
        if (this.horizontal) {
            this.setSize(((BeanSupport)this).height, ((BeanSupport)this).width / 4);
        } else {
            this.setSize(((BeanSupport)this).height * 4, ((BeanSupport)this).width);
        }
    }

    private String cutStringToPixelSize(String fullStr, int pixelWidth) {
        String strWhichFits = null;
        if (fullStr != null) {
            if (fullStr.length() > 0) {
                int numCharsThatFit = 0;
                int widthSoFar = 0;
                int i = 0;
                while (i < fullStr.length()) {
                    if ((widthSoFar += this.fm.charWidth(fullStr.charAt(i))) > pixelWidth) break;
                    ++numCharsThatFit;
                    ++i;
                }
                strWhichFits = numCharsThatFit > 0 ? fullStr.substring(0, numCharsThatFit) : "";
            } else {
                strWhichFits = "";
            }
        } else {
            strWhichFits = "";
        }
        return strWhichFits;
    }

    public void finalizeJelsim() {
    }

    public void fireInterfaceChange() {
        ((Component)((Object)this)).repaint();
        if (this.fmp != null) {
            MapStore ms = null;
            if (this.fmp.getType() == 4) {
                ms = new MapStore(4);
                ms.setValue((int)this.rangeModel.getValue());
            } else {
                ms = new MapStore(7);
                ms.setValue(this.rangeModel.getValue());
            }
            this.fireInterfaceUpdateEvent(new InterfaceUpdateEvent(this.fmp, (Object)ms));
        }
    }

    protected void fireInterfaceUpdateEvent(InterfaceUpdateEvent e) {
        if (this.listeners != null) {
            Vector v = null;
            SpinButton spinButton = this;
            synchronized (spinButton) {
                v = (Vector)this.listeners.clone();
            }
            int i = 0;
            while (i < v.size()) {
                ((InterfaceUpdateListener)v.elementAt(i)).handleInterfaceUpdate(e);
                ++i;
            }
        }
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public Font getFont() {
        return this.font;
    }

    public double getInc() {
        return this.rangeModel.getIncrement();
    }

    public double getIncModel() {
        return this.incModel;
    }

    public double getMax() {
        return this.rangeModel.getMaximum();
    }

    public double getMaxModel() {
        return this.maxModel;
    }

    public double getMin() {
        return this.rangeModel.getMinimum();
    }

    public double getMinModel() {
        return this.minModel;
    }

    public ModelPropertyInterface getModelInc() {
        return this.modelInc;
    }

    public ModelPropertyInterface getModelMax() {
        return this.modelMax;
    }

    public ModelPropertyInterface getModelMin() {
        return this.modelMin;
    }

    public ModelPropertyInterface getModelProperty() {
        return super.getModelProperty();
    }

    private Color getNewColor(int reduced) {
        return new Color(Math.max(0, this.backgroundColor.getRed() - reduced), Math.max(0, this.backgroundColor.getGreen() - reduced), Math.max(0, this.backgroundColor.getBlue() - reduced));
    }

    public NumberFormatter getNumberFormatter() {
        return this.numberFormatter;
    }

    public long getSpinDelay() {
        return this.rangeModel.getSpinDelay();
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public double getValue() {
        return this.rangeModel.getValue();
    }

    public void handleModelUpdate(ModelUpdateEvent e) {
        ModelPropertyInterface source = (ModelPropertyInterface)e.getSource();
        if (source.sameMapStore(this.fmp)) {
            this.setValue(this.numberFormatter.toString(e.getValue()));
        } else if (source.sameMapStore(this.modelMin)) {
            this.setMinModel(((Number)this.modelMin.getValue()).doubleValue());
        } else if (source.sameMapStore(this.modelMax)) {
            this.setMaxModel(((Number)this.modelMax.getValue()).doubleValue());
        } else if (source.sameMapStore(this.modelInc)) {
            this.setIncModel(((Number)this.modelInc.getValue()).doubleValue());
        }
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    private boolean isInside(int x, int y) {
        boolean inside = false;
        int xloc = ((Component)((Object)this)).getLocation().x;
        int yloc = ((Component)((Object)this)).getLocation().y;
        if (this.horizontal) {
            if (x > ((BeanSupport)this).width / 4 * 3 && x < ((BeanSupport)this).width && y > 0 && y < ((BeanSupport)this).height) {
                inside = true;
                this.isTopHorz = y < ((BeanSupport)this).height / 2;
            }
            this.isLeftVert = false;
        } else {
            if (x > 0 && x < ((BeanSupport)this).width && y > ((BeanSupport)this).height / 2 && y < ((BeanSupport)this).height) {
                inside = true;
                this.isLeftVert = x < ((BeanSupport)this).width / 2;
            }
            this.isTopHorz = false;
        }
        return inside;
    }

    public void paint(Graphics g) {
        super.paint(g);
        g.setColor(this.backgroundColor);
        g.fill3DRect(0, 0, ((BeanSupport)this).width - 1, ((BeanSupport)this).height - 1, true);
        g.setColor(SystemColor.getTextNumBGColor());
        g.draw3DRect(0, 0, ((BeanSupport)this).width - 1, ((BeanSupport)this).height - 1, true);
        this.buttonColor = this.getNewColor(10);
        if (!this.horizontal) {
            this.paintVertical(g);
        } else {
            this.paintHorizontal(g);
        }
    }

    private void paintBottomPoly(Graphics g) {
        Polygon poly = new Polygon();
        g.setColor(this.pressed && !this.isTopHorz ? this.getNewColor(20) : this.buttonColor);
        poly.addPoint(this.midpoint - this.maxTriWidth, ((BeanSupport)this).height / 2 + 5);
        poly.addPoint(this.midpoint, ((BeanSupport)this).height - 5);
        poly.addPoint(this.midpoint + this.maxTriWidth, ((BeanSupport)this).height / 2 + 5);
        g.fillPolygon(poly);
        g.setColor(this.pressed && !this.isTopHorz ? this.backgroundColor.brighter() : this.buttonColor.darker().darker());
        g.drawLine(this.midpoint + this.maxTriWidth, ((BeanSupport)this).height / 2 + 5, this.midpoint, ((BeanSupport)this).height - 5);
        g.setColor(this.pressed && !this.isTopHorz ? this.buttonColor.darker().darker() : this.backgroundColor.brighter());
        g.drawLine(this.midpoint - this.maxTriWidth, ((BeanSupport)this).height / 2 + 5, this.midpoint, ((BeanSupport)this).height - 5);
        g.drawLine(this.midpoint - this.maxTriWidth, ((BeanSupport)this).height / 2 + 5, this.midpoint + this.maxTriWidth, ((BeanSupport)this).height / 2 + 5);
    }

    public void paintHorizontal(Graphics g) {
        g.draw3DRect(((BeanSupport)this).width / 4 * 3, 0, ((BeanSupport)this).width - 1, ((BeanSupport)this).height - 1, true);
        this.midpoint = (int)((double)((BeanSupport)this).width / 8.0 * 7.0);
        this.maxTriWidth = ((BeanSupport)this).width / 10;
        this.paintTopPoly(g);
        this.paintBottomPoly(g);
        this.paintString(g);
    }

    private void paintLeftPoly(Graphics g) {
        g.setColor(this.pressed && this.isLeftVert ? this.getNewColor(20) : this.buttonColor);
        Polygon poly = new Polygon();
        poly.addPoint(((BeanSupport)this).width / 2 - 5, this.midpoint - this.maxTriWidth);
        poly.addPoint(((BeanSupport)this).width / 2 - 5, this.midpoint + this.maxTriWidth);
        poly.addPoint(5, this.midpoint);
        g.fillPolygon(poly);
        g.setColor(this.pressed && this.isLeftVert ? this.backgroundColor.brighter() : this.buttonColor.darker().darker());
        g.drawLine(5, this.midpoint, ((BeanSupport)this).width / 2 - 5, this.midpoint + this.maxTriWidth);
        g.setColor(this.pressed && this.isLeftVert ? this.buttonColor.darker().darker() : this.backgroundColor.brighter());
        g.drawLine(5, this.midpoint, ((BeanSupport)this).width / 2 - 5, this.midpoint - this.maxTriWidth);
        g.drawLine(((BeanSupport)this).width / 2 - 5, this.midpoint - this.maxTriWidth, ((BeanSupport)this).width / 2 - 5, this.midpoint + this.maxTriWidth);
    }

    private void paintRightPoly(Graphics g) {
        Polygon poly = new Polygon();
        g.setColor(this.pressed && !this.isLeftVert ? this.getNewColor(20) : this.buttonColor);
        poly.addPoint(((BeanSupport)this).width / 2 + 5, this.midpoint - this.maxTriWidth);
        poly.addPoint(((BeanSupport)this).width / 2 + 5, this.midpoint + this.maxTriWidth);
        poly.addPoint(((BeanSupport)this).width - 5, this.midpoint);
        g.fillPolygon(poly);
        g.setColor(this.pressed && !this.isLeftVert ? this.backgroundColor.brighter() : this.buttonColor.darker().darker());
        g.drawLine(((BeanSupport)this).width / 2 + 5, this.midpoint - this.maxTriWidth, ((BeanSupport)this).width / 2 + 5, this.midpoint + this.maxTriWidth);
        g.drawLine(((BeanSupport)this).width / 2 + 5, this.midpoint + this.maxTriWidth, ((BeanSupport)this).width - 5, this.midpoint);
        g.setColor(this.pressed && !this.isLeftVert ? this.buttonColor.darker().darker() : this.backgroundColor.brighter());
        g.drawLine(((BeanSupport)this).width / 2 + 5, this.midpoint - this.maxTriWidth, ((BeanSupport)this).width - 5, this.midpoint);
    }

    private void paintString(Graphics g) {
        g.setFont(this.font);
        g.setColor(this.textColor);
        if (this.horizontal) {
            String cutString = this.cutStringToPixelSize(this.valueString, ((BeanSupport)this).width / 4 * 3);
            g.drawString(cutString, ((BeanSupport)this).width / 4 * 3 / 2 - this.fm.stringWidth(cutString) / 2, ((BeanSupport)this).height / 2 + this.fm.getHeight() / 2 - 4);
        } else {
            g.drawString(this.valueString, ((BeanSupport)this).width / 2 - this.fm.stringWidth(this.valueString) / 2, ((BeanSupport)this).height / 4 + this.fm.getHeight() / 2 - 4);
        }
    }

    private void paintTopPoly(Graphics g) {
        g.setColor(this.pressed && this.isTopHorz ? this.getNewColor(20) : this.buttonColor);
        Polygon poly = new Polygon();
        poly.addPoint(this.midpoint - this.maxTriWidth, ((BeanSupport)this).height / 2 - 5);
        poly.addPoint(this.midpoint, 5);
        poly.addPoint(this.midpoint + this.maxTriWidth, ((BeanSupport)this).height / 2 - 5);
        g.fillPolygon(poly);
        g.setColor(this.pressed && this.isTopHorz ? this.backgroundColor.brighter() : this.buttonColor.darker().darker());
        g.drawLine(this.midpoint - this.maxTriWidth, ((BeanSupport)this).height / 2 - 5, this.midpoint + this.maxTriWidth, ((BeanSupport)this).height / 2 - 5);
        g.drawLine(this.midpoint + this.maxTriWidth, ((BeanSupport)this).height / 2 - 5, this.midpoint, 5);
        g.setColor(this.pressed && this.isTopHorz ? this.buttonColor.darker().darker() : this.backgroundColor.brighter());
        g.drawLine(this.midpoint - this.maxTriWidth, ((BeanSupport)this).height / 2 - 5, this.midpoint, 5);
    }

    public void paintVertical(Graphics g) {
        g.draw3DRect(0, ((BeanSupport)this).height / 2, ((BeanSupport)this).width - 1, ((BeanSupport)this).height - 1, true);
        this.midpoint = ((BeanSupport)this).height / 4 * 3;
        this.maxTriWidth = ((BeanSupport)this).height / 8;
        this.paintLeftPoly(g);
        this.paintRightPoly(g);
        this.paintString(g);
    }

    public void performaction() {
        if (this.pressed) {
            if (this.horizontal) {
                if (this.isTopHorz) {
                    this.rangeModel.startTimerThread(1);
                } else if (!this.isTopHorz) {
                    this.rangeModel.startTimerThread(2);
                }
            } else if (!this.horizontal) {
                if (!this.isLeftVert) {
                    this.rangeModel.startTimerThread(1);
                } else if (this.isLeftVert) {
                    this.rangeModel.startTimerThread(2);
                }
            }
        } else {
            this.rangeModel.stopTimerThread();
            ((Component)((Object)this)).repaint();
        }
    }

    public void processMouseEvent(MouseEvent e) {
        switch (e.getID()) {
            case 501: {
                if (Beans.isDesignTime() || !this.isInside(e.getX(), e.getY()) || this.pressed) break;
                this.pressed = true;
                this.performaction();
                break;
            }
            case 502: {
                if (Beans.isDesignTime()) break;
                this.pressed = false;
                this.performaction();
                break;
            }
        }
        super.processMouseEvent(e);
    }

    public void removeInterfaceUpdateListener(InterfaceUpdateListener l) {
        if (this.listeners != null && this.listeners.contains(l)) {
            this.listeners.removeElement(l);
        }
    }

    public void setBackgroundColor(Color c) {
        this.backgroundColor = c;
        ((Component)((Object)this)).repaint();
    }

    public void setFont(Font font) {
        this.font = font;
        this.fm = ((Component)((Object)this)).getFontMetrics(font);
        this.sizeToFit();
        ((Component)((Object)this)).repaint();
    }

    public void setHorizontal(boolean isHorz) {
        this.adjustSize();
        this.horizontal = isHorz;
        ((Component)((Object)this)).repaint();
    }

    public void setInc(double incValue) {
        if (this.modelInc == null) {
            this.rangeModel.setIncrement(incValue);
        }
        ((Component)((Object)this)).repaint();
    }

    public void setIncModel(double incValue) {
        this.rangeModel.setIncrement(incValue);
        this.incModel = this.rangeModel.getIncrement();
    }

    public void setMax(double maxValue) {
        if (this.modelMax == null) {
            this.rangeModel.setMaximum(maxValue);
        }
        ((Component)((Object)this)).repaint();
    }

    public void setMaxModel(double maxValue) {
        this.rangeModel.setMaximum(maxValue);
        this.maxModel = this.rangeModel.getMaximum();
    }

    public void setMin(double minValue) {
        if (this.modelMin == null) {
            this.rangeModel.setMinimum(minValue);
        }
        ((Component)((Object)this)).repaint();
    }

    public void setMinModel(double minValue) {
        this.rangeModel.setMinimum(minValue);
        this.minModel = this.rangeModel.getMinimum();
    }

    public void setModelAccess(ModelAccessInterface ma) {
        this.numberFormatter.setModelAccess(ma);
        ModelAccessInterface oldma = ((BeanSupport)this).ma;
        super.setModelAccess(ma);
        this.addInterfaceUpdateListener((InterfaceUpdateListener)ma);
        if (oldma != null && oldma != ma) {
            this.removeInterfaceUpdateListener((InterfaceUpdateListener)oldma);
        }
    }

    public void setModelInc(ModelPropertyInterface fmp) {
        if (this.modelInc != null && ((BeanSupport)this).ma != null) {
            ((BeanSupport)this).ma.removeModelUpdateListener(this.modelInc, (ModelUpdateListener)this);
        }
        if (fmp != null) {
            this.modelInc = fmp;
            ((BeanSupport)this).ma.addModelUpdateListener(this.modelInc, (ModelUpdateListener)this);
            this.setIncModel((Double)this.modelInc.getValue());
        } else {
            this.modelInc = null;
            this.setIncModel(this.rangeModel.getIncrement());
        }
    }

    public void setModelMax(ModelPropertyInterface fmp) {
        if (this.modelMax != null && ((BeanSupport)this).ma != null) {
            ((BeanSupport)this).ma.removeModelUpdateListener(this.modelMax, (ModelUpdateListener)this);
        }
        if (fmp != null) {
            this.modelMax = fmp;
            ((BeanSupport)this).ma.addModelUpdateListener(this.modelMax, (ModelUpdateListener)this);
            this.setMaxModel((Double)this.modelMax.getValue());
        } else {
            this.modelMax = null;
            this.setMaxModel(this.rangeModel.getMaximum());
        }
    }

    public void setModelMin(ModelPropertyInterface fmp) {
        if (this.modelMin != null && ((BeanSupport)this).ma != null) {
            ((BeanSupport)this).ma.removeModelUpdateListener(this.modelMin, (ModelUpdateListener)this);
        }
        if (fmp != null) {
            this.modelMin = fmp;
            ((BeanSupport)this).ma.addModelUpdateListener(this.modelMin, (ModelUpdateListener)this);
            this.setMinModel((Double)this.modelMin.getValue());
        } else {
            this.modelMin = null;
            this.setMinModel(this.rangeModel.getMinimum());
        }
    }

    public void setModelProperty(ModelPropertyInterface fmp) {
        if (fmp != null) {
            super.setModelProperty(fmp);
            this.setUserHelp("This SpinButton displays a value for " + fmp.getName());
        } else {
            this.setValue(this.rangeModel.getMinimum());
        }
    }

    public void setNumberFormatter(NumberFormatter numberFormatter) {
        if (numberFormatter != null) {
            numberFormatter.setModelAccess(((BeanSupport)this).ma);
        }
        this.numberFormatter = numberFormatter;
        if (this.fmp != null) {
            this.valueString = numberFormatter.toString(this.fmp.getValue());
        }
    }

    public void setSpinDelay(long n) {
        this.rangeModel.setSpinDelay(n);
    }

    public void setTextColor(Color c) {
        this.textColor = c;
        ((Component)((Object)this)).repaint();
    }

    public void setValue(double num) {
        this.rangeModel.setValue(num);
        this.value = this.rangeModel.getValue();
        ((Component)((Object)this)).repaint();
    }

    public void setValue(String strNum) {
        this.valueString = strNum;
        String numWithoutChars = this.stripPreAndPostfixes(strNum);
        this.setValue(Double.valueOf(numWithoutChars));
    }

    public void setValue(ModelPropertyInterface fmp) {
        if (fmp != null) {
            this.setValue(this.numberFormatter.toString(fmp.getValue()));
        } else {
            this.setValue(this.numberFormatter.toString(null));
        }
    }

    public String stripPreAndPostfixes(String strNum) {
        String resultNumStr = null;
        String preStr = this.numberFormatter.getPrefixString();
        String postStr = this.numberFormatter.getPostfixString();
        if (preStr == null) {
            preStr = "";
        }
        if (postStr == null) {
            postStr = "";
        }
        resultNumStr = strNum.substring(preStr.length(), strNum.length() - postStr.length());
        return resultNumStr;
    }
}

