/*
 * Decompiled with CFR 0.152.
 */
package org.jelsim.beans.realinput;

import org.jelsim.beans.realinput.InterfaceChangeSource;
import org.jelsim.system.ErrorHandler;

public class RealRangeModel
implements Runnable {
    private static final double LUDICROUS_VALUE = -9.99999999E7;
    private double value;
    private double increment;
    private double min;
    private double max;
    private double innerValue = -9.99999999E7;
    private long spinDelay = 500L;
    private long initialDelay;
    private long threadDelay = this.initialDelay = 500L;
    public static final int INCREMENT_VALUE = 1;
    public static final int DECREMENT_VALUE = 2;
    private Thread timer = null;
    private boolean running = true;
    private boolean suspended = false;
    private int task;
    private InterfaceChangeSource actingOn = null;

    public RealRangeModel(InterfaceChangeSource obj) {
        this.value = this.min = 0.0;
        this.increment = 0.5;
        this.max = 100.0;
        this.actingOn = obj;
    }

    public RealRangeModel(InterfaceChangeSource changeSource, double value, double increment, double min, double max) {
        this.actingOn = changeSource;
        if (!(max >= min && value >= min && value + increment >= value && value + increment <= max)) {
            throw new IllegalArgumentException("invalid range properties");
        }
        this.value = value;
        this.increment = increment;
        this.min = min;
        this.max = max;
    }

    public void decrementValue() {
        double newValue = this.value - this.increment;
        if (newValue < this.min) {
            newValue = this.min;
        }
        this.setValue(newValue);
    }

    public void finalizeJelsim() {
        this.running = false;
        this.timer = null;
    }

    public double getIncrement() {
        return this.increment;
    }

    public double getInnerValue() {
        return this.innerValue;
    }

    public double getMaximum() {
        return this.max;
    }

    public double getMinimum() {
        return this.min;
    }

    public long getSpinDelay() {
        return this.spinDelay;
    }

    public double getValue() {
        return this.value;
    }

    public void incrementValue() {
        double newValue = this.value + this.increment;
        if (newValue > this.max) {
            newValue = this.max;
        }
        this.setValue(newValue);
    }

    public void run() {
        while (this.running) {
            if (this.task == 1) {
                this.incrementValue();
            } else if (this.task == 2) {
                this.decrementValue();
            }
            this.actingOn.fireInterfaceChange();
            RealRangeModel realRangeModel = this;
            synchronized (realRangeModel) {
                try {
                    this.wait(this.threadDelay);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.innerValue != -9.99999999E7 && this.innerValue == this.value) {
                this.suspended = true;
            }
            if (this.value == this.max || this.value == this.min) {
                this.suspended = true;
            }
            this.threadDelay = this.spinDelay;
            try {
                if (!this.suspended) continue;
                realRangeModel = this;
                synchronized (realRangeModel) {
                    while (this.suspended) {
                        this.wait();
                    }
                }
            }
            catch (Exception e) {
                ErrorHandler.reportExceptionExtra((Throwable)e, (String)"Thread exception ", (Object)this);
            }
        }
    }

    public void setIncrement(double n) {
        double newincrement = Math.max(0.0, n);
        this.setRangeProperties(this.value, newincrement, this.min, this.max);
    }

    public void setInnerValue(double n) {
        this.innerValue = n;
    }

    public void setMaximum(double n) {
        double newMin = Math.min(n, this.min);
        double newValue = Math.min(n, this.value);
        this.setRangeProperties(newValue, this.increment, newMin, n);
    }

    public void setMinimum(double n) {
        double newMax = Math.max(n, this.max);
        double newValue = Math.max(n, this.value);
        this.setRangeProperties(newValue, this.increment, n, newMax);
    }

    public void setRangeProperties(double newValue, double newincrement, double newMin, double newMax) {
        boolean isChange;
        if (newMin > newMax) {
            newMin = newMax;
        }
        if (newValue > newMax) {
            newMax = newValue;
        }
        if (newValue < newMin) {
            newMin = newValue;
        }
        if (newincrement < 0.0) {
            newincrement = 0.0;
        }
        boolean bl = isChange = newValue != this.value || newincrement != this.increment || newMin != this.min || newMax != this.max;
        if (isChange) {
            this.value = newValue;
            this.increment = newincrement;
            this.min = newMin;
            this.max = newMax;
        }
    }

    public void setSpinDelay(long n) {
        this.spinDelay = n;
    }

    public void setValue(double n) {
        double newValue = Math.max(n, this.min);
        if (newValue >= this.max) {
            newValue = this.max;
        }
        if (this.innerValue != -9.99999999E7 && newValue >= this.innerValue) {
            newValue = this.innerValue;
        }
        this.setRangeProperties(newValue, this.increment, this.min, this.max);
    }

    public synchronized void startTimerThread(int incOrDec) {
        this.task = incOrDec;
        this.threadDelay = this.initialDelay;
        if (this.timer == null) {
            this.timer = new Thread(this);
            this.timer.setDaemon(true);
            this.timer.start();
        }
        this.suspended = false;
        this.notify();
    }

    public synchronized void stopTimerThread() {
        if (this.timer != null) {
            this.suspended = true;
            this.notify();
        }
    }
}

