/*
 * Decompiled with CFR 0.152.
 */
package org.jelsim.beans.image;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.beans.Beans;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.jelsim.beans.support.BeanSupport;
import org.jelsim.model.event.ModelUpdateEvent;
import org.jelsim.model.event.ModelUpdateListener;
import org.jelsim.model.map.ModelPropertyInterface;
import org.jelsim.system.ErrorHandler;
import org.jelsim.system.SystemColor;
import org.jelsim.userif.deploy.DeployFileProvider;

public class JSImage
extends BeanSupport
implements Runnable,
ImageObserver,
ModelUpdateListener,
DeployFileProvider {
    static final long serialVersionUID = 6951687181490442972L;
    protected ModelPropertyInterface modelScale = null;
    protected static final int DEFAULT_HEIGHT = 50;
    protected static final int DEFAULT_WIDTH = 50;
    public static final int PTYPE_NONE = 0;
    public static final int PTYPE_FILE = 1;
    public static final int PTYPE_URL = 2;
    public static final int PTYPE_RELURL = 3;
    protected String imagePath = "";
    private transient String oldImagePath = null;
    protected int imagePathType = 3;
    private transient int oldImagePathType;
    protected Image image = null;
    private int iwidth;
    private int iheight;
    private int timeout = 10000;
    protected int nonBorderWidth;
    protected int nonBorderHeight;
    protected int borderWidth = 0;
    protected int prevBorder = 0;
    protected int destWidth;
    protected int destHeight;
    protected int sourceWidth;
    protected int sourceHeight;
    protected int imageWidth;
    protected int imageHeight;
    protected int availWidth;
    protected int availHeight;
    protected int wpadding = 0;
    protected int hpadding = 0;
    protected double zValue = 1.0;
    protected double scale = 1.0;
    protected double scaleFactor = 1.0;
    protected Font font;
    protected transient FontMetrics fm;
    protected Color textColor;
    protected Color backgroundColor;
    protected Color borderColor;
    protected boolean transparent = false;
    private boolean isSetByBorder = false;
    protected URL baseURL = null;
    protected Point centerPoint = null;
    protected boolean loadError = false;
    private boolean nullImage = false;
    private boolean paintCenter = false;
    protected int animationDelay = 100;
    protected ModelPropertyInterface animationDelayMP;
    protected boolean animationSuspended = false;
    protected ModelPropertyInterface animationSuspendedMP;
    protected Thread runThread;
    protected boolean running = false;

    public JSImage() {
        this.setTextColor(SystemColor.getButtonFontColor());
        this.setBackgroundColor(SystemColor.getButtonBGColor());
        this.setFont(new Font("SansSerif", 0, 12));
        this.setBorderColor(SystemColor.getButtonBGColor());
        this.availWidth = this.width;
        this.availHeight = this.height;
        this.setBorderWidth(0);
        this.setTitle("Uninitialised image");
        String[] fmptmp = new String[]{"modelScale", "animationSuspendedMP", "animationDelayMP"};
        this.fmpSaveNames = fmptmp;
        String[] normaltmp = new String[]{"imagePath", "borderWidth", "backgroundColor", "font", "imagePathType", "textColor", "timeout", "editHelp", "title", "userHelp", "transparent", "borderColor", "zValue", "animationDelay", "animationSuspended", "scale", "paintCenter"};
        this.normalSaveNames = normaltmp;
    }

    public void adjustSize() {
        Dimension d = this.getMinimumSize();
        this.availWidth = d.width;
        this.availHeight = d.height;
        this.setSize(d.width, d.height);
    }

    protected synchronized void checkImageLoad() {
        this.wpadding = 0;
        this.hpadding = 0;
        if (this.ma != null) {
            if (this.ma.isApplet() && this.timeout < 50000) {
                this.timeout = 50000;
            }
            if (this.oldImagePathType != this.imagePathType) {
                if (this.imagePathType == 0) {
                    this.image = null;
                } else if (this.imagePath != null) {
                    this.stopAnimation();
                    this.image = this.imagePath.length() > 0 ? this.loadImage(this.imagePath) : null;
                }
            } else if (!this.imagePath.equals(this.oldImagePath) && this.imagePathType > 0) {
                this.stopAnimation();
                this.image = this.imagePath.length() > 0 ? this.loadImage(this.imagePath) : null;
            }
            this.adjustSize();
        }
    }

    protected void cutToSize() {
        this.nonBorderWidth = this.availWidth - 2 * this.borderWidth;
        this.nonBorderHeight = this.availHeight - 2 * this.borderWidth;
    }

    public void finalizeJelsim() {
    }

    public int getAnimationDelay() {
        return this.animationDelay;
    }

    public ModelPropertyInterface getAnimationDelayMP() {
        return this.animationDelayMP;
    }

    public ModelPropertyInterface getAnimationSuspendedMP() {
        return this.animationSuspendedMP;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public String[] getDeployFiles() {
        String[] stringArray;
        if (this.imagePathType == 3 && this.imagePath != null && this.imagePath.length() > 0) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = this.imagePath;
        } else {
            stringArray = null;
        }
        return stringArray;
    }

    public Font getFont() {
        return this.font;
    }

    public String getImagePath() {
        return this.imagePath;
    }

    public int getImagePathType() {
        return this.imagePathType;
    }

    public int getImageWidth() {
        return this.iwidth;
    }

    public synchronized Dimension getMinimumSize() {
        int w = 50;
        int h = 50;
        if (this.isSetByBorder) {
            this.nonBorderWidth = this.availWidth - 2 * this.borderWidth;
            w = this.width;
            this.nonBorderHeight = this.availHeight - 2 * this.borderWidth;
            h = this.height;
            this.setPadding();
        } else if (this.image == null) {
            this.nonBorderWidth = this.fm.stringWidth(this.title) + 10 + 2 * this.wpadding;
            w = this.nonBorderWidth + 2 * this.borderWidth;
            this.nonBorderHeight = this.fm.getHeight() + 10 + 2 * this.hpadding;
            h = this.nonBorderHeight + 2 * this.borderWidth;
        } else {
            this.nonBorderWidth = (int)((double)this.image.getWidth(null) * this.scale + (double)(2 * this.wpadding));
            w = this.nonBorderWidth + 2 * this.borderWidth;
            this.nonBorderHeight = (int)((double)this.image.getHeight(null) * this.scale + (double)(2 * this.hpadding));
            h = this.nonBorderHeight + 2 * this.borderWidth;
        }
        return new Dimension(w, h);
    }

    public ModelPropertyInterface getModelScale() {
        return this.modelScale;
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public double getScale() {
        return this.scale;
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public double getZValue() {
        return this.scale;
    }

    public void handleModelUpdate(ModelUpdateEvent e) {
        ModelPropertyInterface source = (ModelPropertyInterface)e.getSource();
        if (source.sameMapStore(this.modelScale)) {
            this.setScaleFactor(((Number)source.getValue()).doubleValue());
        } else if (source.sameMapStore(this.animationSuspendedMP)) {
            this.setAnimationSuspended((Boolean)source.getValue());
        } else if (source.sameMapStore(this.animationDelayMP)) {
            this.setAnimationDelay(((Number)source.getValue()).intValue());
        }
    }

    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        boolean retval = true;
        if ((infoflags & 0x20) != 0) {
            this.iwidth = img.getWidth(null);
            this.iheight = img.getHeight(null);
            this.adjustSize();
            retval = false;
        } else if ((infoflags & 0x10) != 0) {
            this.iwidth = img.getWidth(null);
            this.iheight = img.getHeight(null);
            this.adjustSize();
            retval = false;
            this.startAnimation();
        } else if ((infoflags & 0x40) != 0) {
            ErrorHandler.reportMessage((String)(String.valueOf(this.imagePath) + " image error flag raised " + infoflags));
        } else if ((infoflags & 0x40) != 0) {
            ErrorHandler.reportMessage((String)(String.valueOf(this.imagePath) + " image abort flag raised " + infoflags));
        }
        return retval;
    }

    public boolean isAnimationSuspended() {
        return this.animationSuspended;
    }

    public boolean isPaintCenter() {
        return this.paintCenter;
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    protected synchronized Image loadImage(String imagePath) {
        boolean error;
        Image oldImage;
        Image retImage;
        block17: {
            retImage = null;
            oldImage = this.image;
            error = false;
            if (this.imagePathType == 2 || this.imagePathType == 3) {
                try {
                    URL url = null;
                    if (this.imagePathType == 3) {
                        if (this.baseURL == null) {
                            this.baseURL = this.ma.getBaseURL();
                        }
                        url = new URL(String.valueOf(this.baseURL.toExternalForm()) + imagePath);
                    } else {
                        url = new URL(imagePath);
                    }
                    if (System.getProperty("java.vendor").startsWith("Microsoft")) {
                        retImage = ((Component)((Object)this)).createImage((ImageProducer)url.getContent());
                    } else {
                        URLConnection urlc = url.openConnection();
                        InputStream is = urlc.getInputStream();
                        int contentLength = 0;
                        int rbyte = 0;
                        int[] buffer = new int[1024];
                        while ((rbyte = is.read()) >= 0) {
                            buffer[contentLength++] = rbyte;
                            if (contentLength != buffer.length) continue;
                            int[] b2 = new int[contentLength + 1024];
                            System.arraycopy(buffer, 0, b2, 0, contentLength);
                            buffer = b2;
                        }
                        byte[] bbuffer = new byte[contentLength];
                        int i = 0;
                        while (i < contentLength) {
                            bbuffer[i] = (byte)buffer[i];
                            ++i;
                        }
                        retImage = ((Component)((Object)this)).getToolkit().createImage(bbuffer);
                    }
                    if (retImage != null) {
                        this.iwidth = retImage.getWidth(this);
                        this.iheight = retImage.getHeight(this);
                        break block17;
                    }
                    ErrorHandler.reportMessage((String)("No image found for path " + imagePath));
                }
                catch (Exception e) {
                    ErrorHandler.reportExceptionExtra((Throwable)e, (String)("read image exception for " + imagePath), (Object)this);
                    error = true;
                    if (this.ma.getBaseURL() != null) {
                        ErrorHandler.reportMessage((String)("JSImage: error loading  image " + imagePath));
                        ErrorHandler.reportException((Throwable)e, (Object)this);
                    }
                    break block17;
                }
            }
            File f = new File(imagePath);
            if (!f.exists()) {
                error = true;
                this.showError("JSImage: " + this.baseURL.toExternalForm() + imagePath + " does not exist, current image retained");
            } else {
                retImage = ((Component)((Object)this)).getToolkit().getImage(imagePath);
            }
        }
        if (error && (retImage = oldImage) != null) {
            this.iwidth = retImage.getWidth(null);
            this.iheight = retImage.getHeight(null);
        }
        if (this.baseURL != null && error) {
            this.loadError = true;
        }
        if (retImage == null) {
            this.nullImage = true;
        }
        return retImage;
    }

    public void paint(Graphics g) {
        if (this.image == null && this.imagePathType == 3 && !this.loadError && this.imagePath.length() > 0) {
            this.checkImageLoad();
        }
        if (this.imagePathType > 0 && this.image != null) {
            this.paintImage(g);
        } else {
            this.paintPlainRect(g);
            g.setFont(this.font);
            g.setColor(this.textColor);
            g.drawString(this.title, this.width / 2 - this.fm.stringWidth(this.title) / 2, this.height / 2 + this.fm.getMaxDescent());
        }
        super.paint(g);
    }

    protected void paintImage(Graphics g) {
        this.imageWidth = this.image.getWidth(null);
        this.imageHeight = this.image.getHeight(null);
        if (Beans.isDesignTime()) {
            g.setColor(Color.black);
            g.drawRect(0, 0, this.width - 1, this.height - 1);
            g.drawRect(this.borderWidth, this.borderWidth, this.width - 2 * this.borderWidth - 1, this.height - 2 * this.borderWidth - 1);
        } else if (!this.transparent) {
            this.paintPlainRect(g);
        }
        g.drawImage(this.image, this.wpadding + this.borderWidth, this.hpadding + this.borderWidth, this.availWidth - this.borderWidth - this.wpadding, this.availHeight - this.borderWidth - this.hpadding, 0, 0, this.imageWidth, this.imageHeight, null);
        if (Beans.isDesignTime()) {
            g.drawString(this.imagePath, this.width - (this.width - 10), this.height - (this.height - 40));
        }
    }

    protected void paintPlainRect(Graphics g) {
        g.setColor(this.borderColor);
        g.fillRect(0, 0, this.width, this.height);
        g.setColor(this.backgroundColor);
        g.fillRect(this.borderWidth, this.borderWidth, this.nonBorderWidth, this.nonBorderHeight);
    }

    protected void resetPadding() {
        this.wpadding = 0;
        this.hpadding = 0;
        this.adjustSize();
    }

    protected void resizeImage() {
        this.adjustSize();
        ((Component)((Object)this)).repaint();
    }

    public void run() {
        while (this.running) {
            try {
                if (this.animationDelay > 0) {
                    Thread.sleep(this.animationDelay);
                }
                ((Component)((Object)this)).repaint();
                if (!this.animationSuspended) continue;
                JSImage jSImage = this;
                synchronized (jSImage) {
                    while (this.animationSuspended) {
                        this.wait();
                    }
                }
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void setAnimationDelay(int animationDelay) {
        this.animationDelay = animationDelay > 0 ? animationDelay : 10;
    }

    public void setAnimationDelayMP(ModelPropertyInterface fmp) {
        if (this.animationDelayMP != null && this.ma != null) {
            this.ma.removeModelUpdateListener(this.animationDelayMP, (ModelUpdateListener)this);
        }
        if (fmp != null) {
            this.animationDelayMP = fmp;
            this.ma.addModelUpdateListener(this.animationDelayMP, (ModelUpdateListener)this);
            this.setAnimationDelay(((Number)this.animationDelayMP.getValue()).intValue());
        } else {
            this.animationDelayMP = null;
        }
    }

    public void setAnimationSuspended(boolean b) {
        boolean wasSuspended = this.animationSuspended;
        this.animationSuspended = b;
        if (this.runThread != null && wasSuspended) {
            JSImage jSImage = this;
            synchronized (jSImage) {
                this.notify();
            }
        }
    }

    public void setAnimationSuspendedMP(ModelPropertyInterface fmp) {
        if (this.animationSuspendedMP != null && this.ma != null) {
            this.ma.removeModelUpdateListener(this.animationSuspendedMP, (ModelUpdateListener)this);
        }
        if (fmp != null) {
            this.animationSuspendedMP = fmp;
            this.ma.addModelUpdateListener(this.animationSuspendedMP, (ModelUpdateListener)this);
            this.setAnimationSuspended((Boolean)this.animationSuspendedMP.getValue());
        } else {
            this.animationSuspendedMP = null;
        }
    }

    public void setBackgroundColor(Color c) {
        this.backgroundColor = c;
        ((Component)((Object)this)).repaint();
    }

    public void setBorderColor(Color c) {
        this.borderColor = c;
        ((Component)((Object)this)).repaint();
    }

    public void setBorderWidth(int w) {
        this.isSetByBorder = true;
        this.borderWidth = w;
        if (this.borderWidth < 0) {
            this.borderWidth = 0;
        }
        this.resetPadding();
        ((Component)((Object)this)).repaint();
        this.isSetByBorder = false;
    }

    public void setBounds(int x, int y, int w, int h) {
        this.availWidth = w;
        this.availHeight = h;
        this.setPadding();
        this.cutToSize();
        super.setBounds(x, y, w, h);
    }

    private void setCenterPoint() {
        this.centerPoint = new Point();
        int xaxis = ((Component)((Object)this)).getBounds().x;
        int yaxis = ((Component)((Object)this)).getBounds().y;
        if (this.image != null) {
            int xpoint = xaxis + (int)((double)this.image.getWidth(null) * this.scale / 2.0);
            int ypoint = yaxis + (int)((double)this.image.getHeight(null) * this.scale / 2.0);
            this.centerPoint.setLocation(xpoint, ypoint);
        }
        int xPoint = this.centerPoint.x - this.width / 2 >= 0 ? this.centerPoint.x - this.width / 2 : 0;
        int yPoint = this.centerPoint.y - this.height / 2 >= 0 ? this.centerPoint.y - this.height / 2 : 0;
    }

    public void setFont(Font font) {
        this.font = font;
        this.fm = ((Component)((Object)this)).getFontMetrics(font);
        this.sizeToFit();
        ((Component)((Object)this)).repaint();
    }

    public void setImagePath(String path) {
        this.loadError = false;
        this.oldImagePath = this.imagePath;
        this.imagePath = path;
        this.checkImageLoad();
    }

    public void setImagePathType(int type) throws IllegalArgumentException {
        if (type == 0 || type == 3) {
            this.imagePathType = 3;
            this.oldImagePathType = 3;
        } else if (type > 0 && type < 3) {
            this.loadError = false;
            this.oldImagePathType = this.imagePathType;
            this.imagePathType = type;
            this.checkImageLoad();
        } else {
            throw new IllegalArgumentException("Path type must be in range 0-2, was" + type);
        }
    }

    public void setModelScale(ModelPropertyInterface fmp) {
        if (this.modelScale != null && this.ma != null) {
            this.ma.removeModelUpdateListener(this.modelScale, (ModelUpdateListener)this);
        }
        if (fmp != null) {
            this.modelScale = fmp;
            this.ma.addModelUpdateListener(this.modelScale, (ModelUpdateListener)this);
            this.setScaleFactor(((Number)this.modelScale.getValue()).doubleValue());
        } else {
            this.modelScale = null;
            this.setScaleFactor(1.0);
        }
    }

    public void setPadding() {
        if (this.image == null) {
            this.wpadding = (this.availWidth - 2 * this.borderWidth - (this.fm.stringWidth(this.title) + 10)) / 2;
            this.hpadding = (this.availHeight - 2 * this.borderWidth - (this.fm.getHeight() + 10)) / 2;
        } else {
            this.wpadding = 0;
            this.hpadding = 0;
        }
        if (this.wpadding < 0) {
            this.wpadding = 0;
        }
        if (this.hpadding < 0) {
            this.hpadding = 0;
        }
    }

    public void setPaintCenter(boolean b) {
        this.paintCenter = b;
        ((Component)((Object)this)).repaint();
    }

    public void setScale(double z) {
        this.scale = this.modelScale != null ? this.scaleFactor : z;
        this.resizeImage();
    }

    public void setScaleFactor(double z) {
        this.scaleFactor = z;
        this.setScale(this.scaleFactor);
    }

    public void setSize(int w, int h) {
        super.setSize(w, h);
    }

    public void setTextColor(Color c) {
        this.textColor = c;
        ((Component)((Object)this)).repaint();
    }

    public void setTimeout(int t) {
        this.timeout = t;
    }

    public void setTransparent(boolean b) {
        this.transparent = b;
        ((Component)((Object)this)).repaint();
    }

    public void setZValue(double z) {
        this.scale = this.modelScale != null ? (this.zValue = this.scaleFactor) : (this.zValue = z);
        this.resizeImage();
    }

    protected void skipPaint(Graphics g) {
        super.paint(g);
    }

    private void startAnimation() {
        if (this.runThread != null) {
            this.stopAnimation();
        }
        this.runThread = new Thread(this);
        this.running = true;
        this.animationSuspended = false;
        this.runThread.start();
    }

    private void stopAnimation() {
        if (this.runThread != null) {
            this.running = false;
            if (this.animationSuspended) {
                this.animationSuspended = false;
                JSImage jSImage = this;
                synchronized (jSImage) {
                    this.notify();
                }
            }
        }
        this.runThread = null;
    }
}

