/*
 * Decompiled with CFR 0.152.
 */
package org.jelsim.beans.digital;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.beans.Beans;
import java.io.Serializable;
import java.util.Vector;
import org.jelsim.beans.numberformatter.NumberFormatter;
import org.jelsim.beans.support.BeanSupport;
import org.jelsim.beans.support.ModelAccessInterface;
import org.jelsim.beans.support.SimConst;
import org.jelsim.beans.support.SimpleBeanSupport;
import org.jelsim.model.event.InterfaceUpdateEvent;
import org.jelsim.model.event.InterfaceUpdateListener;
import org.jelsim.model.event.ModelUpdateEvent;
import org.jelsim.model.event.ModelUpdateListener;
import org.jelsim.model.map.MapStore;
import org.jelsim.model.map.ModelPropertyInterface;
import org.jelsim.system.ErrorHandler;
import org.jelsim.system.SystemColor;
import org.jelsim.userif.containers.compound.CompoundObject;

public class Digital
extends SimpleBeanSupport
implements ActionListener,
ModelUpdateListener,
SimConst,
TextListener,
Serializable {
    static final long serialVersionUID = -5425460353720828589L;
    private static final int DEFAULT_WIDTH = 100;
    private static final int DEFAULT_HEIGHT = 40;
    private transient boolean editing = false;
    private transient Vector listeners = null;
    private int digitalHeight;
    private int titleHeight;
    private int titlex;
    private int titley;
    private int digitaly;
    private boolean showTitle = true;
    private boolean useNumberText = false;
    private boolean keystrokeUpdates = false;
    private boolean output = false;
    private String selectionString = "";
    private boolean entrySelects = false;
    private Color titleColor;
    private Color optextColor;
    private Color backgroundColor;
    private Color textColor;
    private Color editBackground;
    private Color editColor;
    private Font titleFont;
    private FontMetrics titlefm;
    private Font digitalFont;
    private FontMetrics digitalfm;
    protected String valueString;
    private TextField numberText;
    protected NumberFormatter numberFormatter = new NumberFormatter();
    protected int maxPlaces;
    protected int maxDigits;
    private boolean overrideTextUpdate = false;

    public Digital() {
        ((BeanSupport)this).combinedResize = true;
        ((BeanSupport)this).width = 100;
        ((BeanSupport)this).height = 40;
        this.titleHeight = 15;
        this.digitalHeight = ((BeanSupport)this).height - this.titleHeight;
        this.setSize(((BeanSupport)this).width, ((BeanSupport)this).height);
        this.setResizable(true);
        this.titleFont = SystemColor.getFont();
        this.titlefm = ((Component)((Object)this)).getFontMetrics(this.titleFont);
        this.digitalFont = new Font("Monospaced", 1, 24);
        this.digitalfm = ((Component)((Object)this)).getFontMetrics(this.digitalFont);
        this.setDigitalBackground(SystemColor.getTextNumBGColor());
        this.setTitleColor(SystemColor.getTextNumFontColor());
        this.setDigitalColor(SystemColor.getTextNumEditColor());
        this.setTitleBackground(SystemColor.getTitleFrameColor());
        this.setEditBackground(SystemColor.getTextNumEditColor());
        this.setEditColor(SystemColor.getTextNumBGColor());
        this.valueString = new String("initial");
        this.setMaxDigits(8);
        this.setMaxPlaces(2);
        String[] fmptmp = new String[]{"modelProperty"};
        ((BeanSupport)this).fmpSaveNames = fmptmp;
        String[] normaltmp = new String[]{"editBackground", "editColor", "digitalBackground", "editHelp", "titleFont", "titleBackground", "title", "titleColor", "digitalFont", "userHelp", "digitalColor", "showTitle", "useNumberText", "keystrokeUpdates", "numberFormatter"};
        ((BeanSupport)this).normalSaveNames = normaltmp;
    }

    public void DrawDigital(Graphics g) {
        if (this.showTitle) {
            g.setColor(this.titleColor);
            g.fillRect(0, 0, ((BeanSupport)this).width, this.titleHeight);
            g.setColor(this.textColor);
            g.setFont(this.titleFont);
            g.drawString(((BeanSupport)this).title, this.titlex, this.titley);
        }
        g.setColor(this.backgroundColor);
        g.drawRect(0, 0, ((BeanSupport)this).width - 1, ((BeanSupport)this).height - 1);
        g.fillRect(0, this.titleHeight, ((BeanSupport)this).width, this.digitalHeight);
        g.setColor(this.optextColor);
        g.setFont(this.digitalFont);
        g.drawString(this.valueString, ((BeanSupport)this).width / 2 - this.digitalfm.stringWidth(this.valueString) / 2, this.digitaly);
    }

    public void actionPerformed(ActionEvent e) {
        if (this.numberText == null) {
            this.numberText = (TextField)e.getSource();
        }
        if (this.fmp != null) {
            this.handleNumberText();
        }
        if (!this.useNumberText) {
            this.removePanel();
        }
    }

    public void addInterfaceUpdateListener(InterfaceUpdateListener l) {
        if (this.listeners == null) {
            this.listeners = new Vector(2);
        }
        if (!this.listeners.contains(l)) {
            this.listeners.addElement(l);
        }
    }

    public void adjustSize() {
        Dimension d = this.getPreferredSize();
        this.setSize(d.width, d.height);
        ((Component)((Object)this)).invalidate();
    }

    private void completeEdit(String str) {
        block13: {
            if (this.overrideTextUpdate) {
                this.overrideTextUpdate = false;
                return;
            }
            int inputType = this.fmp.getType();
            if (str.length() > 0) {
                try {
                    MapStore ms = new MapStore(inputType);
                    Double D = Double.valueOf(str);
                    switch (inputType) {
                        case 1: {
                            ms.setValue((char)D.intValue());
                            break;
                        }
                        case 2: {
                            ms.setValue(D.byteValue());
                            break;
                        }
                        case 3: {
                            ms.setValue(D.shortValue());
                            break;
                        }
                        case 4: {
                            ms.setValue(D.intValue());
                            break;
                        }
                        case 5: {
                            ms.setValue(D.longValue());
                            break;
                        }
                        case 6: {
                            ms.setValue(D.floatValue());
                            break;
                        }
                        case 7: {
                            ms.setValue(D.doubleValue());
                            break;
                        }
                    }
                    InterfaceUpdateEvent e = new InterfaceUpdateEvent(this.fmp, (Object)ms);
                    this.fireInterfaceUpdateEvent(e);
                }
                catch (NumberFormatException numberFormatException) {
                    if (this.keystrokeUpdates) break block13;
                    this.showError("Number format error in InputDigital " + ((BeanSupport)this).title + ", previous value retained");
                }
            }
        }
        this.editing = false;
        ((Component)((Object)this)).repaint();
    }

    public void finalizeJelsim() {
        super.finalizeJelsim();
        if (this.numberText != null) {
            this.numberText.getParent().remove(this.numberText);
        }
    }

    protected void fireInterfaceUpdateEvent(InterfaceUpdateEvent e) {
        if (this.listeners != null) {
            Vector v = null;
            Digital digital = this;
            synchronized (digital) {
                v = (Vector)this.listeners.clone();
            }
            int i = 0;
            while (i < v.size()) {
                ((InterfaceUpdateListener)v.elementAt(i)).handleInterfaceUpdate(e);
                ++i;
            }
        }
    }

    private Point getAdjust() {
        Point p = new Point(0, 0);
        Container parent = ((Component)((Object)this)).getParent();
        while (parent instanceof CompoundObject) {
            p.x += parent.getLocation().x;
            p.y += parent.getLocation().y;
            parent = parent.getParent();
        }
        return p;
    }

    public Color getDigitalBackground() {
        return this.backgroundColor;
    }

    public Color getDigitalColor() {
        return this.optextColor;
    }

    public Font getDigitalFont() {
        return this.digitalFont;
    }

    public Color getEditBackground() {
        return this.editBackground;
    }

    public Color getEditColor() {
        return this.editColor;
    }

    public int getMaxDigits() {
        return this.maxDigits;
    }

    public int getMaxPlaces() {
        return this.maxPlaces;
    }

    public NumberFormatter getNumberFormatter() {
        return this.numberFormatter;
    }

    public Dimension getPreferredSize() {
        int maxDigit;
        int dwidth;
        int twidth = 0;
        int theight = 0;
        this.titleHeight = 0;
        if (((BeanSupport)this).title != null && this.showTitle) {
            twidth = this.titlefm.stringWidth(((BeanSupport)this).title) + 2 * this.titlefm.stringWidth("0");
            this.titleHeight = theight = this.titlefm.getHeight() + this.titlefm.getLeading();
        }
        if ((dwidth = ((maxDigit = this.numberFormatter.getFieldWidth() >= 0 ? this.numberFormatter.getFieldWidth() : 8) + 2) * this.digitalfm.stringWidth("0")) > twidth) {
            twidth = dwidth;
        }
        this.digitalHeight = this.digitalfm.getHeight() + this.digitalfm.getLeading();
        this.digitaly = this.titleHeight + this.digitalfm.getLeading() / 2 + this.digitalfm.getAscent();
        theight += this.digitalHeight;
        if (twidth < ((BeanSupport)this).width) {
            twidth = ((BeanSupport)this).width;
        }
        if (theight < ((BeanSupport)this).height) {
            theight = ((BeanSupport)this).height;
        }
        return new Dimension(twidth, theight);
    }

    public String getSelectionString() {
        return this.selectionString;
    }

    public Color getTitleBackground() {
        return this.titleColor;
    }

    public Color getTitleColor() {
        return this.textColor;
    }

    public Font getTitleFont() {
        return this.titleFont;
    }

    public synchronized void handleModelUpdate(ModelUpdateEvent e) {
        this.setValue(this.numberFormatter.toString(e.getValue()));
    }

    private void handleNumberText() {
        if (this.numberText.getText().compareTo("REMOVE") == 0) {
            this.setUseNumberText(false);
        } else {
            this.completeEdit(this.numberText.getText());
        }
    }

    public boolean isEntrySelects() {
        return this.entrySelects;
    }

    public boolean isKeystrokeUpdates() {
        return this.keystrokeUpdates;
    }

    public boolean isOutput() {
        return this.output;
    }

    public boolean isShowTitle() {
        return this.showTitle;
    }

    public boolean isUseNumberText() {
        return this.useNumberText;
    }

    public void paint(Graphics g) {
        if (!this.output && this.isUseNumberText() && this.numberText == null && ((BeanSupport)this).ma != null) {
            this.showInDigital();
        }
        this.DrawDigital(g);
        super.paint(g);
    }

    public void processMouseEvent(MouseEvent e) {
        if (!(Beans.isDesignTime() || e.getID() != 500 || this.editing || this.output)) {
            if (this.fmp == null) {
                ErrorHandler.reportMessage((String)"can't edit value as no model property has been set");
            } else {
                this.showInDigital();
            }
        }
        if (!Beans.isDesignTime() && e.getID() == 506) {
            ErrorHandler.reportMessage((String)"caught the exception");
        }
        super.processMouseEvent(e);
    }

    public void removeInterfaceUpdateListener(InterfaceUpdateListener l) {
        if (this.listeners != null && this.listeners.contains(l)) {
            this.listeners.removeElement(l);
        }
    }

    private void removePanel() {
        if (this.numberText != null) {
            this.numberText.getParent().remove(this.numberText);
            this.numberText.removeActionListener(this);
            this.numberText.removeTextListener(this);
            this.numberText = null;
        }
    }

    public void setBounds(int x, int y, int w, int h) {
        if (this.titlefm != null) {
            this.titlex = w / 2 - this.titlefm.stringWidth(((BeanSupport)this).title) / 2;
            this.titley = this.titleHeight - this.titlefm.getDescent() - this.titlefm.getLeading() / 2;
        }
        this.digitalHeight = h - this.titleHeight;
        super.setBounds(x, y, w, h);
        if (this.numberText != null && !this.output) {
            Point p = ((Component)((Object)this)).getLocation();
            p.y += this.titleHeight;
            Point adjust = this.getAdjust();
            p.x += adjust.x;
            p.y += adjust.y;
            this.numberText.setLocation(p);
        }
    }

    public void setDigitalBackground(Color c) {
        this.backgroundColor = c;
        ((Component)((Object)this)).repaint();
    }

    public void setDigitalColor(Color color) {
        this.optextColor = color;
        ((Component)((Object)this)).repaint();
    }

    public void setDigitalFont(Font font) {
        this.digitalFont = font;
        this.digitalfm = ((Component)((Object)this)).getFontMetrics(this.digitalFont);
        this.sizeToFit();
    }

    public void setEditBackground(Color c) {
        this.editBackground = c;
        if (this.editing && this.numberText != null) {
            ((Component)this.numberText).setBackground(this.editBackground);
            this.numberText.repaint();
        }
    }

    public void setEditColor(Color c) {
        this.editColor = c;
        if (this.editing && this.numberText != null) {
            this.numberText.setForeground(this.editColor);
            this.numberText.repaint();
        }
    }

    public void setEntrySelects(boolean b) {
        this.entrySelects = b;
    }

    public void setKeystrokeUpdates(boolean b) {
        this.keystrokeUpdates = b;
        if (this.numberText != null) {
            if (b) {
                this.numberText.addTextListener(this);
            } else {
                this.numberText.removeTextListener(this);
            }
        }
    }

    public void setMaxDigits(int digits) {
        this.maxDigits = digits;
        this.sizeToFit();
        this.setValue(this.fmp);
    }

    public void setMaxPlaces(int places) {
        this.maxPlaces = places;
        this.numberFormatter.setDecimalPlaces(places);
        this.setValue(this.fmp);
    }

    public void setModelAccess(ModelAccessInterface ma) {
        this.numberFormatter.setModelAccess(ma);
        ModelAccessInterface oldma = ((BeanSupport)this).ma;
        super.setModelAccess(ma);
        this.addInterfaceUpdateListener((InterfaceUpdateListener)ma);
        if (oldma != null && oldma != ma) {
            this.removeInterfaceUpdateListener((InterfaceUpdateListener)oldma);
        }
    }

    public void setModelProperty(ModelPropertyInterface fmp) {
        super.setModelProperty(fmp);
        String fmpName = "Not Assigned";
        if (fmp != null) {
            fmpName = fmp.getName();
        }
        ((BeanSupport)this).userHelp = this.output ? "This digital displays a value for \"" + fmpName + "\"" : "This digital displays a value for \"" + fmpName + "\" click to change model value";
    }

    public void setNumberFormatter(NumberFormatter numberFormatter) {
        if (numberFormatter != null) {
            numberFormatter.setModelAccess(((BeanSupport)this).ma);
            this.maxPlaces = numberFormatter.getDecimalPlaces();
        }
        this.numberFormatter = numberFormatter;
        if (this.fmp != null) {
            this.valueString = numberFormatter.toString(this.fmp.getValue());
        }
    }

    public void setOutput(boolean isOut) {
        this.output = isOut;
    }

    public void setSelectionString(String selectionString) {
        this.selectionString = selectionString;
    }

    public void setShowTitle(boolean b) {
        this.showTitle = b;
        this.adjustSize();
    }

    public void setTitle(String title) {
        super.setTitle(title);
        if (this.titlefm != null) {
            this.titlex = ((BeanSupport)this).width / 2 - this.titlefm.stringWidth(title) / 2;
        }
        ((Component)((Object)this)).repaint();
    }

    public void setTitleBackground(Color c) {
        this.titleColor = c;
        ((Component)((Object)this)).repaint();
    }

    public void setTitleColor(Color color) {
        this.textColor = color;
        ((Component)((Object)this)).repaint();
    }

    public void setTitleFont(Font font) {
        this.titleFont = font;
        this.titlefm = ((Component)((Object)this)).getFontMetrics(this.titleFont);
        this.sizeToFit();
    }

    public void setUseNumberText(boolean b) {
        this.useNumberText = b;
        if (!b && this.numberText != null) {
            this.removePanel();
        }
        if (b) {
            if (((Component)((Object)this)).getParent() != null) {
                this.showInDigital();
            }
        } else {
            this.editing = false;
        }
    }

    protected synchronized void setValue(String v) {
        this.valueString = v;
        ((Component)((Object)this)).repaint();
        if (this.useNumberText && this.numberText != null) {
            this.numberText.removeTextListener(this);
            this.overrideTextUpdate = true;
            this.numberText.setText(v);
            if (this.keystrokeUpdates) {
                this.numberText.addTextListener(this);
            }
        }
    }

    public void setValue(ModelPropertyInterface fmp) {
        if (fmp != null) {
            this.setValue(this.numberFormatter.toString(fmp.getValue()));
        } else {
            this.setValue(this.numberFormatter.toString(null));
        }
    }

    public void setVisible(boolean b) {
        super.setVisible(b);
        if (!b && this.fmp != null && this.numberText != null) {
            this.handleNumberText();
        }
    }

    protected void showInDigital() {
        this.editing = true;
        Dimension d = this.getSize();
        if (this.numberText == null) {
            this.numberText = new TextField();
            this.numberText.setForeground(this.editColor);
            ((Component)this.numberText).setBackground(this.editBackground);
            this.numberText.setText(this.valueString);
            this.numberText.setFont(this.getDigitalFont());
            this.numberText.addActionListener(this);
            if (this.keystrokeUpdates) {
                this.numberText.addTextListener(this);
            }
        }
        this.numberText.setSize(d.width, d.height - this.titleHeight);
        ((Component)this.numberText).setBackground(this.editBackground);
        Point p = ((Component)((Object)this)).getLocation();
        p.y += this.titleHeight;
        if (System.getProperty("java.vendor").startsWith("Microsoft") && System.getProperty("java.version").startsWith("1.1") && !System.getProperty("java.version").endsWith(".4")) {
            Point adjust = this.getAdjust();
            p.x += adjust.x;
            p.y += adjust.y;
        }
        this.numberText.setLocation(p);
        ((Component)((Object)this)).getParent().add(this.numberText);
        this.numberText.requestFocus();
        if (this.entrySelects) {
            if (this.selectionString.length() > 0) {
                int selectionStart = this.valueString.indexOf(this.selectionString);
                if (selectionStart >= 0) {
                    this.numberText.setSelectionStart(selectionStart);
                    this.numberText.setSelectionEnd(selectionStart + this.selectionString.length());
                }
            } else if (this.valueString != null && this.valueString.length() > 0) {
                this.numberText.setSelectionStart(0);
                this.numberText.setSelectionEnd(this.valueString.length());
            }
        }
        ((Component)((Object)this)).repaint();
    }

    public void textValueChanged(TextEvent e) {
        if (this.fmp != null) {
            this.handleNumberText();
        }
    }
}

