/*
 * Decompiled with CFR 0.152.
 */
package org.jelsim.applet;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Method;

public class ProgressApplet
extends Applet
implements Runnable {
    private String nameToLoad = "";
    private ProgressIndicator pInd;
    private static int SLEEP_PERIOD = 200;
    private Thread myThread;
    private boolean appletLoaded = false;
    private boolean endOfLoading = false;
    private boolean terminated = false;

    private synchronized boolean getTerminated() {
        return this.terminated;
    }

    public void init() {
        super.init();
        this.nameToLoad = this.getParameter("loadApplet");
        this.setVisible(true);
    }

    public void run() {
        this.pInd = new ProgressIndicator(this.nameToLoad);
        this.pInd.show();
        this.pInd.setMsg("Loading required classes");
        Applet loadingApplet = null;
        String appletText = new String(" ");
        String helpText = new String(" ");
        this.appletLoaded = false;
        while (!this.appletLoaded && !this.getTerminated()) {
            try {
                if (this.getAppletContext() != null && (loadingApplet = this.getAppletContext().getApplet(this.nameToLoad)) != null) {
                    this.appletLoaded = true;
                    break;
                }
            }
            catch (Exception exception) {}
            this.pInd.update();
            try {
                Thread.currentThread();
                Thread.sleep(SLEEP_PERIOD);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.pInd.setMsg("Applet " + this.nameToLoad + " loaded");
        Class<?> c = loadingApplet.getClass();
        while (c != null && !c.getName().equals("org.jelsim.applet.JSApplet")) {
            try {
                c = c.getSuperclass();
            }
            catch (Exception exception) {
                c = null;
                this.pInd.setMsg("Not a MultiVerse Applet!");
            }
        }
        if (c != null) {
            Class<?>[] ifs = c.getInterfaces();
            Class<?> o = null;
            int i = 0;
            while (i < ifs.length) {
                if (ifs[i].getName().equals("org.jelsim.applet.LoadingInformer")) {
                    try {
                        o = Class.forName(ifs[i].getName());
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        o = null;
                        this.pInd.setMsg("Cannot communicate with MultiVerse applet!");
                    }
                    break;
                }
                ++i;
            }
            if (o != null) {
                Method getMsg = null;
                Method appLoaded = null;
                try {
                    getMsg = c.getMethod("getLoadMessage", null);
                    appLoaded = c.getMethod("isLoaded", null);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    this.pInd.setMsg("Cannot access communication methods!");
                }
                catch (Exception exception) {
                    this.pInd.setMsg("Cannot access loading applet!");
                }
                if (getMsg != null && appLoaded != null) {
                    this.endOfLoading = false;
                    while (!this.endOfLoading && !this.getTerminated()) {
                        try {
                            helpText = (String)getMsg.invoke((Object)loadingApplet, null);
                        }
                        catch (Exception exception) {
                            helpText = null;
                        }
                        if (helpText != null) {
                            if (!appletText.equals(helpText)) {
                                this.pInd.setMsg(helpText);
                                appletText = helpText;
                            }
                            this.pInd.update();
                        }
                        try {
                            this.endOfLoading = (Boolean)appLoaded.invoke((Object)loadingApplet, null);
                        }
                        catch (Exception exception) {
                            this.endOfLoading = true;
                        }
                        try {
                            Thread.currentThread();
                            Thread.sleep(SLEEP_PERIOD);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }
        if (!this.getTerminated()) {
            while (this.pInd.getProg() < 100.0f) {
                try {
                    Thread.currentThread();
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
                this.pInd.update();
            }
            try {
                Thread.currentThread();
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.pInd != null) {
            ((Component)this.pInd).setVisible(false);
            this.pInd.dispose();
            this.pInd = null;
        }
    }

    public void start() {
        super.start();
        this.terminated = false;
        if (this.nameToLoad != null) {
            this.myThread = new Thread(this);
            this.myThread.start();
        }
    }

    public void stop() {
        ProgressApplet progressApplet = this;
        synchronized (progressApplet) {
            this.terminated = true;
        }
        if (this.myThread.isAlive()) {
            try {
                this.myThread.interrupt();
                this.myThread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        super.stop();
    }

    private class ProgressIndicator
    extends Frame {
        private float count = 0.0f;
        private float increment = 3.0f;
        private Point posn = new Point(0, 0);
        private Point offset = new Point(0, 0);
        private ProgressPanel progBar;
        private Label msgBar;
        public static final float MAX = 100.0f;
        public static final float MIN = 0.0f;

        ProgressIndicator(String classToLoad) {
            super(String.valueOf(classToLoad) + " loading...");
            ((Component)this).setVisible(false);
            this.progBar = new ProgressPanel();
            this.msgBar = new Label("Loading " + classToLoad + "...");
            this.msgBar.setBackground(Color.lightGray);
            this.setLayout(new GridLayout(2, 1));
            this.add(this.msgBar);
            this.add(this.progBar);
            int height = 70;
            if (this.getWarningString() != null) {
                height = (int)((double)height * 1.25);
            }
            ((Component)this).setSize(250, height);
            this.setResizable(false);
            if (ProgressApplet.this.isVisible()) {
                try {
                    this.posn = ProgressApplet.this.getLocationOnScreen();
                }
                catch (NullPointerException nullPointerException) {
                    this.posn = new Point(200, 200);
                }
            }
            ((Component)this).setLocation(this.posn.x + this.offset.x, this.posn.y + this.offset.y);
            this.validate();
            ((Component)this).setVisible(true);
            this.addWindowListener(new ExitWinAdapter());
        }

        public float getProg() {
            return this.progBar.getProgress();
        }

        public void setMsg(String s) {
            this.msgBar.setText(s);
        }

        public void setProg(float val) {
            this.progBar.setProgress(val);
        }

        public void update() {
            this.count += this.increment;
            if (this.count >= 100.0f || this.count <= 0.0f) {
                this.increment = -this.increment;
            }
            this.setProg(this.count);
        }

        private class ProgressPanel
        extends Panel {
            private float prog = 0.0f;

            ProgressPanel() {
                this.setBackground(Color.white);
                this.prog = 0.0f;
            }

            public float getProgress() {
                return this.prog;
            }

            public void paint(Graphics g) {
                Dimension dim = this.getSize();
                int BarPixelWidth = (int)((double)this.prog / 100.0 * (double)dim.width);
                g.setColor(Color.blue);
                g.fillRect(0, 0, BarPixelWidth, dim.height);
            }

            public void setProgress(float c) {
                this.prog = c;
                this.repaint();
            }
        }

        private class ExitWinAdapter
        extends WindowAdapter {
            ExitWinAdapter() {
            }

            public void windowClosing(WindowEvent e) {
                ((Component)ProgressIndicator.this).setVisible(false);
            }
        }
    }
}

