/*
 * Decompiled with CFR 0.152.
 */
package org.jelsim.trigger;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.jelsim.beans.support.ModelAccessInterface;
import org.jelsim.model.map.ModelPropertyInterface;
import org.jelsim.system.ErrorHandler;
import org.jelsim.trigger.TriggerCondition;
import org.jelsim.trigger.TriggerManagerListener;

public class TriggerManager {
    private static final int TRIGGER_CONDITION_ADDED = 0;
    private static final int TRIGGER_CONDITION_REMOVED = 1;
    private static final int TRIGGER_CONDITION_EDITED = 2;
    private static final int TRIGGER_CONDITION_RENAMED = 3;
    public static final String DELIMITER = "$";
    private Vector listeners = new Vector();
    protected ModelAccessInterface ma;
    protected Hashtable triggerConditions = new Hashtable();

    public TriggerManager() {
    }

    public TriggerManager(ModelAccessInterface ma) {
        this.setModelAccess(ma);
    }

    public void addTriggerCondition(TriggerCondition triggerCondition) {
        this.triggerConditions.put(triggerCondition.getName(), triggerCondition);
        this.fireTriggerManagerEvent(0, triggerCondition);
    }

    public void addTriggerConditions(TriggerCondition[] tcs) {
        this.triggerConditions.clear();
        int i = 0;
        while (i < tcs.length) {
            this.triggerConditions.put(tcs[i].getName(), tcs[i]);
            tcs[i].setModelAccess(this.ma);
            ++i;
        }
    }

    public void addTriggerManagerListener(TriggerManagerListener triggerManagerListener) {
        if (!this.listeners.contains(triggerManagerListener)) {
            this.listeners.add(triggerManagerListener);
        }
    }

    public void clearOverride(String conditionName) {
        TriggerCondition tc = this.getTriggerCondition(conditionName);
        if (tc != null) {
            tc.clearOverride();
        }
    }

    public static String createFmpTag(ModelPropertyInterface fmp) {
        return String.valueOf(fmp.getName()) + DELIMITER + fmp.getClassId() + DELIMITER + fmp.getInstId() + DELIMITER + fmp.getPropertyId() + DELIMITER;
    }

    public void createTriggerStructures() {
        TriggerCondition[] tc = this.getTriggerConditions();
        int i = 0;
        while (i < tc.length) {
            tc[i].createStructure();
            ++i;
        }
    }

    public void disable(String conditionName) {
        TriggerCondition tc = this.getTriggerCondition(conditionName);
        if (tc != null) {
            tc.setEnabled(false);
        }
    }

    public void enable(String conditionName) {
        TriggerCondition tc = this.getTriggerCondition(conditionName);
        if (tc != null) {
            tc.setEnabled(true);
        }
    }

    private void fireTriggerManagerEvent(int type, String oldName, TriggerCondition tc) {
        if (this.listeners != null && this.listeners.size() > 0) {
            Vector v;
            TriggerManager triggerManager = this;
            synchronized (triggerManager) {
                v = (Vector)this.listeners.clone();
            }
            int i = 0;
            while (i < v.size()) {
                TriggerManagerListener tml = (TriggerManagerListener)v.elementAt(i);
                switch (type) {
                    case 0: {
                        tml.triggerConditionAdded(tc);
                        break;
                    }
                    case 1: {
                        tml.triggerConditionRemoved(tc);
                        break;
                    }
                    case 2: {
                        tml.triggerConditionModified(tc);
                        break;
                    }
                    case 3: {
                        tml.triggerConditionRenamed(oldName, tc.getName());
                        break;
                    }
                }
                ++i;
            }
        }
    }

    private void fireTriggerManagerEvent(int type, TriggerCondition tc) {
        this.fireTriggerManagerEvent(type, null, tc);
    }

    public void flushTriggerConditions() {
        TriggerCondition[] tc = this.getTriggerConditions();
        int i = 0;
        while (i < tc.length) {
            tc[i].flush();
            ++i;
        }
    }

    public ModelAccessInterface getModelAccess() {
        return this.ma;
    }

    public ModelPropertyInterface getPropertyFromTag(String s) {
        int nextDelim = s.indexOf(DELIMITER);
        String propName = s.substring(0, nextDelim);
        int n = nextDelim + 1;
        nextDelim = s.indexOf(DELIMITER, nextDelim + 1);
        int classId = Integer.parseInt(s.substring(n, nextDelim));
        int n2 = nextDelim + 1;
        nextDelim = s.indexOf(DELIMITER, nextDelim + 1);
        int instId = Integer.parseInt(s.substring(n2, nextDelim));
        int n3 = nextDelim + 1;
        nextDelim = s.indexOf(DELIMITER, nextDelim + 1);
        int propId = Integer.parseInt(s.substring(n3, nextDelim));
        return this.ma.getProperty(classId, instId, propId);
    }

    public TriggerCondition getTriggerCondition(String triggerName) {
        return (TriggerCondition)this.triggerConditions.get(triggerName);
    }

    public TriggerCondition[] getTriggerConditions() {
        String[] names = this.getTriggerNames();
        TriggerCondition[] tcs = new TriggerCondition[names.length];
        int i = 0;
        while (i < tcs.length) {
            tcs[i] = (TriggerCondition)this.triggerConditions.get(names[i]);
            ++i;
        }
        return tcs;
    }

    public String[] getTriggerNames() {
        int i = 0;
        String[] names = new String[this.triggerConditions.size()];
        Enumeration e = this.triggerConditions.keys();
        while (e.hasMoreElements()) {
            names[i++] = (String)e.nextElement();
        }
        return names;
    }

    public String getUnusedName() {
        String name;
        int i = 0;
        while (this.triggerConditions.containsKey(name = "trigger condition " + i++)) {
        }
        return name;
    }

    public boolean hasTriggerManagerListener(TriggerManagerListener listener) {
        return this.listeners.contains(listener);
    }

    public void mergeTriggerConditions(TriggerCondition[] tcs) {
        int i = 0;
        while (i < tcs.length) {
            if (!this.triggerConditions.containsKey(tcs[i].getName())) {
                this.triggerConditions.put(tcs[i].getName(), tcs[i]);
                tcs[i].setModelAccess(this.ma);
                tcs[i].createStructure();
                this.fireTriggerManagerEvent(0, tcs[i]);
            } else {
                ErrorHandler.printMessage("WARNING imported trigger condition name clashes with existing trigger condition, imported trigger discarded " + tcs[i].getName());
            }
            ++i;
        }
    }

    public void overrideCondition(String triggerName, boolean triggerState) {
        TriggerCondition tc = this.getTriggerCondition(triggerName);
        if (tc != null) {
            tc.setOverride(triggerState);
        }
    }

    public void removeTriggerCondition(String triggerName) {
        TriggerCondition tc = (TriggerCondition)this.triggerConditions.get(triggerName);
        if (tc != null) {
            this.triggerConditions.remove(triggerName);
            this.fireTriggerManagerEvent(1, tc);
        }
    }

    public void removeTriggerManagerListener(TriggerManagerListener triggerManagerListener) {
        if (this.listeners.contains(triggerManagerListener)) {
            this.listeners.remove(triggerManagerListener);
        }
    }

    public void renameTriggerCondition(String oldName) {
        TriggerCondition tc = this.getTriggerCondition(oldName);
        if (tc != null) {
            if (!oldName.equals(tc.getName())) {
                this.triggerConditions.remove(oldName);
                this.triggerConditions.put(tc.getName(), tc);
            }
            this.fireTriggerManagerEvent(3, oldName, tc);
        }
    }

    public void setModelAccess(ModelAccessInterface ma) {
        if (this.ma != ma) {
            this.ma = ma;
        }
        TriggerCondition[] tc = this.getTriggerConditions();
        int i = 0;
        while (i < tc.length) {
            tc[i].setModelAccess(ma);
            ++i;
        }
    }

    public void updateState() {
        TriggerCondition[] tc = this.getTriggerConditions();
        int i = 0;
        while (i < tc.length) {
            tc[i].updateState();
            ++i;
        }
    }

    public void updateTriggerCondition(TriggerCondition tc) {
        if (tc != null) {
            this.fireTriggerManagerEvent(2, tc);
        }
    }
}

