/*
 * Decompiled with CFR 0.152.
 */
package org.jelsim.trigger;

import java.beans.Beans;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.jelsim.beans.support.ModelAccessInterface;
import org.jelsim.model.map.ModelPropertyInterface;
import org.jelsim.trigger.TriggerListener;
import org.jelsim.trigger.TriggerRoot;
import org.jelsim.trigger.expression.BooleanNode;
import org.jelsim.trigger.parser.Parser;

public class TriggerCondition
implements Externalizable {
    private Vector listeners = new Vector();
    private boolean overrideOn = false;
    private boolean overrideState;
    private TriggerRoot triggerRoot;
    private String name;
    private String expressionString = "";
    private boolean enabled = true;
    private boolean triggerPending = false;
    private boolean trueTriggerState = false;
    protected String[] fmpSaveNames = null;
    protected String[] fmpPropertyNames = null;
    protected String[] fmpPropertyIds = null;
    private ModelAccessInterface ma;

    public TriggerCondition() {
    }

    public TriggerCondition(String triggerName) {
        this.setName(triggerName);
    }

    public TriggerCondition(String triggerName, String expressionString, String[] fmpSaveNames, String[] fmpPropertyNames, String[] fmpPropertyIds) {
        this.name = triggerName;
        this.expressionString = expressionString;
        this.fmpSaveNames = fmpSaveNames;
        this.fmpPropertyNames = fmpPropertyNames;
        this.fmpPropertyIds = fmpPropertyIds;
    }

    public void addTriggerListener(TriggerListener triggerListener) {
        if (!this.listeners.contains(triggerListener)) {
            this.listeners.addElement(triggerListener);
        }
    }

    public void clearOverride() {
        this.overrideOn = false;
        if (this.isEnabled()) {
            this.fireTriggerEvent(this.getTriggerState());
        }
    }

    public void clearTriggerListeners() {
    }

    public void createStructure() {
        block3: {
            if (this.expressionString.equals("")) break block3;
            Hashtable<String, ModelPropertyInterface> propertyHash = new Hashtable<String, ModelPropertyInterface>();
            int i = 0;
            while (i < this.fmpPropertyNames.length) {
                ModelPropertyInterface mp = this.ma.getProperty(this.fmpPropertyNames[i], this.fmpPropertyIds[i]);
                propertyHash.put(this.fmpSaveNames[i], mp);
                ++i;
            }
            try {
                Parser parser = Parser.getParser((String)this.expressionString);
                BooleanNode expression = Parser.generateExpression((String)(String.valueOf(this.expressionString) + "EOE"), propertyHash);
                this.setTriggerRoot(new TriggerRoot(expression));
                this.getTriggerRoot().setModelAccess(this.ma);
            }
            catch (Exception exception) {}
        }
    }

    public void finalizeJelsim() {
        if (this.triggerRoot != null) {
            this.triggerRoot.setModelAccess(null);
        }
    }

    private void fireTriggerEvent(boolean triggerState) {
        if (this.listeners != null && this.listeners.size() > 0) {
            Vector v;
            TriggerCondition triggerCondition = this;
            synchronized (triggerCondition) {
                v = (Vector)this.listeners.clone();
            }
            int i = 0;
            while (i < v.size()) {
                ((TriggerListener)v.elementAt(i)).setTriggerState(triggerState);
                ++i;
            }
        }
    }

    public void flush() {
        if (this.triggerPending) {
            this.triggerPending = false;
            this.updateState();
        }
    }

    public String getExpression() {
        return this.expressionString;
    }

    public String[] getFmpPropertyIds() {
        return this.fmpPropertyIds;
    }

    public String[] getFmpPropertyNames() {
        return this.fmpPropertyNames;
    }

    public String[] getFmpSaveNames() {
        return this.fmpSaveNames;
    }

    public ModelAccessInterface getModelAccess() {
        return this.ma;
    }

    public String getName() {
        return this.name;
    }

    public boolean getOverrideState() {
        return this.overrideState;
    }

    public TriggerRoot getTriggerRoot() {
        return this.triggerRoot;
    }

    public boolean getTriggerState() {
        if (this.overrideOn && Beans.isDesignTime()) {
            return this.overrideState;
        }
        return this.trueTriggerState;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isOverrideOn() {
        return this.overrideOn;
    }

    public int numberOfListeners() {
        return this.listeners.size();
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        this.name = (String)in.readObject();
        this.expressionString = (String)in.readObject();
        this.fmpSaveNames = (String[])in.readObject();
        this.fmpPropertyNames = (String[])in.readObject();
        this.fmpPropertyIds = (String[])in.readObject();
    }

    public void removeTriggerListener(TriggerListener triggerListener) {
        if (this.listeners.contains(triggerListener)) {
            this.listeners.remove(triggerListener);
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setModelAccess(ModelAccessInterface ma) {
        if (this.ma != ma) {
            if (this.triggerRoot != null) {
                this.triggerRoot.setModelAccess(ma);
            }
            this.ma = ma;
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOverride(boolean triggerState) {
        this.overrideOn = true;
        this.overrideState = triggerState;
        if (this.isEnabled()) {
            this.fireTriggerEvent(this.overrideState);
        }
    }

    public void setTriggerRoot(TriggerRoot triggerRoot) {
        Stack parseStack = new Stack();
        Hashtable propertyHash = new Hashtable();
        this.triggerRoot = triggerRoot;
        triggerRoot.setTriggerCondition(this);
        triggerRoot.reconstructExpression(parseStack, propertyHash);
        int nprop = propertyHash.size();
        this.fmpSaveNames = new String[nprop];
        this.fmpPropertyNames = new String[nprop];
        this.fmpPropertyIds = new String[nprop];
        this.expressionString = "";
        int i = 0;
        while (i < parseStack.size()) {
            this.expressionString = String.valueOf(this.expressionString) + (String)parseStack.elementAt(i);
            ++i;
        }
        int i2 = 0;
        Enumeration e = propertyHash.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            ModelPropertyInterface mp = (ModelPropertyInterface)propertyHash.get(key);
            this.fmpSaveNames[i2] = key;
            this.fmpPropertyNames[i2] = mp.getName();
            this.fmpPropertyIds[i2] = mp.getGid();
            ++i2;
        }
    }

    public void setTriggerState(boolean triggerState) {
        if (this.isEnabled()) {
            this.triggerPending = true;
            this.trueTriggerState = triggerState;
        }
    }

    public void updateState() {
        if (this.isEnabled()) {
            this.fireTriggerEvent(this.getTriggerState());
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(1);
        out.writeObject(this.name);
        out.writeObject(this.expressionString);
        out.writeObject(this.fmpSaveNames);
        out.writeObject(this.fmpPropertyNames);
        out.writeObject(this.fmpPropertyIds);
    }
}

