/*
 * Decompiled with CFR 0.152.
 */
package org.jelsim.system;

import org.jelsim.model.SimClass;

public class ErrorHandler {
    private static boolean debugMode = true;
    private static final String MODEL_PREFIX = "org.jelsim.model";
    private static final String EXC_PREFIX = "Exception thrown in ";
    private static final String ERR_PREFIX = "Error occurred in ";
    private static final String MSG_PREFIX = "Message from ";
    private static final String MORE_PREFIX = "More details ";
    private static final String INDICATOR = "---";
    private static final String BREAK = " : ";
    private static final String UNDEFINED = "<Unknown>";

    private static String getExceptionMessage(Throwable e) {
        if (e == null) {
            return UNDEFINED;
        }
        return e.getMessage();
    }

    private static String getSourceName(Object source) {
        if (source == null) {
            return UNDEFINED;
        }
        return source.getClass().getName();
    }

    private static boolean isModel(Object source) {
        return source == null ? false : source instanceof SimClass || source.getClass().getName().startsWith(MODEL_PREFIX);
    }

    private static String parenthesise(String text) {
        return String.valueOf('(') + text + ')';
    }

    public static void printMessage(String message) {
        ErrorHandler.printMessage(message, null);
    }

    public static void printMessage(String message, Object source) {
        ErrorHandler.writeLine(MSG_PREFIX + ErrorHandler.getSourceName(source) + BREAK + ErrorHandler.parenthesise(message));
    }

    public static void reportError(String message) {
        ErrorHandler.reportError(message, null);
    }

    public static void reportError(String message, Object source) {
        if (debugMode || ErrorHandler.isModel(source)) {
            ErrorHandler.writeLine(ERR_PREFIX + ErrorHandler.getSourceName(source) + BREAK + ErrorHandler.parenthesise(message));
        }
    }

    public static void reportException(Throwable e, Object source) {
        ErrorHandler.reportExceptionExtra(e, null, source);
    }

    public static void reportException(Throwable e, String extra, Object source) {
        if (debugMode || ErrorHandler.isModel(source)) {
            ErrorHandler.writeLine(EXC_PREFIX + ErrorHandler.getSourceName(source) + BREAK + e + BREAK + ErrorHandler.parenthesise(ErrorHandler.getExceptionMessage(e)));
            if (extra != null) {
                ErrorHandler.writeLine("More details  : " + ErrorHandler.parenthesise(extra));
            }
            if (e != null) {
                e.printStackTrace();
            }
        }
    }

    public static void reportExceptionExtra(Throwable e, String extra, Object source) {
        ErrorHandler.reportException(e, extra, source);
    }

    public static void reportMessage(String message) {
        ErrorHandler.reportMessage(message, null);
    }

    public static void reportMessage(String message, Object source) {
        if (debugMode || ErrorHandler.isModel(source)) {
            ErrorHandler.writeLine(MSG_PREFIX + ErrorHandler.getSourceName(source) + BREAK + ErrorHandler.parenthesise(message));
        }
    }

    public static void setDebugMode(boolean mode) {
        debugMode = mode;
    }

    private static void writeLine(String text) {
        System.out.println(INDICATOR + text + INDICATOR);
    }
}

