/*
 * Decompiled with CFR 0.152.
 */
package org.jelsim.model;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import org.jelsim.model.SimConst;
import org.jelsim.system.ErrorHandler;

public class simutil
implements SimConst {
    public static Object copyArray(Object array) {
        Object a = array;
        Class<?> aclass = array.getClass();
        int dimensions = simutil.getDimensions(aclass);
        int[] lengths = new int[dimensions];
        int i = 0;
        while (i < dimensions) {
            lengths[i] = Array.getLength(a);
            a = Array.get(a, 0);
            ++i;
        }
        a = Array.newInstance(array.getClass().getComponentType(), lengths);
        System.arraycopy(array, 0, a, 0, Array.getLength(array));
        return a;
    }

    public static void errexit() {
        System.exit(0);
    }

    public static void errexit(String s) {
        simutil.errexit(s, new Throwable());
    }

    public static void errexit(String s, Throwable thr) {
        ErrorHandler.reportMessage("Fatal error: " + s);
    }

    public static int getDimensions(Class c) {
        if (!c.isArray()) {
            return 0;
        }
        return 1 + simutil.getDimensions(c.getComponentType());
    }

    public static int getDimensions(Field f) {
        return simutil.getDimensions(f.getType());
    }

    public static String getPropertyDescriptorString(int status, int type) {
        String typeString = null;
        String statusString = null;
        String dimensionString = "";
        statusString = status == 0 ? "Input " : (status == 1 ? "Output " : (status == 2 ? "Input/Output " : "Unknown i/o status"));
        if (type > 10000) {
            int dim = type / 10000;
            dimensionString = String.valueOf(dim) + "-dimensional array of ";
            type %= 10000;
        }
        switch (type) {
            case 0: {
                typeString = "boolean";
                break;
            }
            case 1: {
                typeString = "char";
                break;
            }
            case 2: {
                typeString = "byte";
                break;
            }
            case 3: {
                typeString = "short";
                break;
            }
            case 4: {
                typeString = "integer";
                break;
            }
            case 5: {
                typeString = "long";
                break;
            }
            case 6: {
                typeString = "float";
                break;
            }
            case 7: {
                typeString = "double";
                break;
            }
            case 8: {
                typeString = "String";
                break;
            }
            case 9: {
                typeString = "class property";
                break;
            }
            case 12: {
                typeString = "unknown class property";
                break;
            }
            case 10: {
                typeString = "reference class";
                break;
            }
            case 11: {
                typeString = "class property table";
                break;
            }
            default: {
                typeString = "unspecified";
            }
        }
        return String.valueOf(statusString) + dimensionString + typeString;
    }

    public static int getSimType(Class c) {
        if (c.isArray()) {
            return simutil.getSimType(c.getComponentType());
        }
        String name = c.getName();
        if (name.equals("boolean")) {
            return 0;
        }
        if (name.equals("char")) {
            return 1;
        }
        if (name.equals("byte")) {
            return 2;
        }
        if (name.equals("short")) {
            return 3;
        }
        if (name.equals("int")) {
            return 4;
        }
        if (name.equals("long")) {
            return 5;
        }
        if (name.equals("float")) {
            return 6;
        }
        if (name.equals("double")) {
            return 7;
        }
        if (name.equals("java.lang.String")) {
            return 8;
        }
        if (simutil.hasSuperClass(c, "RefClass")) {
            return 10;
        }
        if (simutil.hasSuperClass(c, "StaticSimClass")) {
            return 9;
        }
        if (name.endsWith(".Vector")) {
            return 11;
        }
        return -1;
    }

    public static int getSimType(Field f) {
        return simutil.getSimType(f.getType());
    }

    public static boolean hasSuperClass(Class c, String superName) {
        if (c.getName().endsWith(superName)) {
            return true;
        }
        Class supc = c.getSuperclass();
        if (supc == null) {
            return false;
        }
        return simutil.hasSuperClass(supc, superName);
    }

    public static void setField(Object instance, Field f, int simtype, Object o) {
        if (o == null) {
            return;
        }
        try {
            switch (simtype) {
                case 0: {
                    if (simutil.hasSuperClass(o.getClass(), "Boolean")) {
                        f.setBoolean(instance, (Boolean)o);
                        break;
                    }
                    if (simutil.hasSuperClass(o.getClass(), "String")) {
                        f.setBoolean(instance, new Boolean((String)o));
                    }
                    break;
                }
                case 1: {
                    f.setChar(instance, ((Character)o).charValue());
                    break;
                }
                case 2: {
                    f.setByte(instance, (Byte)o);
                    break;
                }
                case 3: {
                    f.setShort(instance, (Short)o);
                    break;
                }
                case 4: {
                    f.setInt(instance, (Integer)o);
                    break;
                }
                case 5: {
                    f.setLong(instance, (Long)o);
                    break;
                }
                case 6: {
                    f.setFloat(instance, ((Float)o).floatValue());
                    break;
                }
                case 7: {
                    f.setDouble(instance, (Double)o);
                    break;
                }
                case 8: {
                    f.set(instance, o);
                    break;
                }
                case 9: {
                    f.set(instance, o);
                    break;
                }
                case 12: {
                    ErrorHandler.reportMessage("SIMUKNOWN should not occur");
                    break;
                }
                case 11: {
                    f.set(instance, o);
                    break;
                }
                case 10: {
                    f.set(instance, o);
                    break;
                }
                default: {
                    if (simtype >= 10000) {
                        f.set(instance, o);
                    }
                    break;
                }
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            ErrorHandler.reportMessage("IllegalAccessException:Unable to access field " + f + " in setField");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ErrorHandler.reportMessage("Illegal argument for object " + o + " type " + simtype + " " + o.getClass().getName());
            System.exit(0);
        }
    }

    public static boolean validSimType(Class c) {
        if (c.isPrimitive()) {
            return true;
        }
        if (simutil.hasSuperClass(c, "StaticSimClass")) {
            return true;
        }
        if (c.getName().equals("java.lang.String")) {
            return true;
        }
        if (c.isArray()) {
            return simutil.validSimType(c.getComponentType());
        }
        ErrorHandler.reportMessage("invalid sim class " + c.getName());
        return false;
    }

    public static boolean validSimType(Field f) {
        return simutil.validSimType(f.getType());
    }
}

