/*
 * Decompiled with CFR 0.152.
 */
package org.jelsim.model.map;

import java.io.IOException;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.jelsim.model.RefClass;
import org.jelsim.model.RefPair;
import org.jelsim.model.SimConst;
import org.jelsim.model.StaticSimClass;
import org.jelsim.model.map.ClassInstance;
import org.jelsim.system.ErrorHandler;

public class MapStore
implements Serializable,
SimConst {
    private Object value;
    protected int type;

    public MapStore() {
        this.value = null;
    }

    public MapStore(int type) throws IllegalArgumentException {
        if ((type < 0 || type > 12) && type < 10000) {
            throw new IllegalArgumentException("MapStore: illegal type in constructor " + type);
        }
        this.type = type;
    }

    public MapStore(MapStore ms) {
        this.type = ms.type;
        switch (ms.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                this.value = ms.getValue();
                break;
            }
            case 9: {
                this.value = ms.getFixedValue();
                break;
            }
            case 10: {
                this.value = new RefPair((RefPair)ms.getValue());
                break;
            }
            case 11: 
            case 12: {
                this.value = ms.getFixedValue();
                break;
            }
            default: {
                if (ms.type < 10000) break;
                this.value = ms.type % 10000 == 10 ? ms.getFixedValue() : ms.getValue();
            }
        }
    }

    public Object getFixedValue() {
        RefPair[] retval = this.getValue();
        switch (this.type) {
            case 9: {
                retval = new ClassInstance((ClassInstance)retval);
                break;
            }
            case 10: {
                retval = new RefPair((RefPair)retval);
                break;
            }
            case 11: {
                Vector old = (Vector)retval;
                RefPair[] newv = new Vector(old.size());
                int i = 0;
                while (i < old.size()) {
                    Object elt = old.elementAt(i);
                    if (elt instanceof ClassInstance) {
                        newv.addElement(new ClassInstance((ClassInstance)elt));
                    } else {
                        newv.addElement(elt);
                    }
                    ++i;
                }
                retval = newv;
                break;
            }
            default: {
                if (this.type < 10000 || this.type % 10000 != 10) break;
                RefPair[] newpairs = new RefPair[Array.getLength(retval)];
                int i = 0;
                while (i < newpairs.length) {
                    newpairs[i] = new RefPair((RefPair)Array.get(retval, i));
                    ++i;
                }
                retval = newpairs;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
        }
        return retval;
    }

    public int getType() {
        return this.type;
    }

    public Object getValue() {
        Vector retval = this.value;
        if (retval == null && (this.type == 11 || this.type == 12)) {
            retval = new Vector(2);
        }
        return retval;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            in.defaultReadObject();
        }
        catch (NotActiveException notActiveException) {}
    }

    public void setValue(byte val) throws IllegalArgumentException {
        if (this.type != 2) {
            throw new IllegalArgumentException("MapStore: Non byte value");
        }
        this.value = new Byte(val);
    }

    public void setValue(char val) throws IllegalArgumentException {
        if (this.type != 1) {
            throw new IllegalArgumentException("MapStore: Non char value");
        }
        this.value = new Character(val);
    }

    public void setValue(double val) throws IllegalArgumentException {
        if (this.type != 7) {
            throw new IllegalArgumentException("MapStore: Non double value");
        }
        this.value = new Double(val);
    }

    public void setValue(float val) throws IllegalArgumentException {
        if (this.type != 6) {
            throw new IllegalArgumentException("MapStore: Non float value");
        }
        this.value = new Float(val);
    }

    public void setValue(int val) throws IllegalArgumentException {
        if (this.type != 4) {
            throw new IllegalArgumentException("MapStore: Non int value");
        }
        this.value = new Integer(val);
    }

    public void setValue(long val) throws IllegalArgumentException {
        if (this.type != 5) {
            throw new IllegalArgumentException("MapStore: Non long value");
        }
        this.value = new Long(val);
    }

    public void setValue(Object o) throws IllegalArgumentException {
        switch (this.type) {
            case 0: {
                if (o instanceof Boolean) {
                    this.value = o;
                    break;
                }
                if (!(o instanceof String)) break;
                this.setValue((String)o);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                this.value = o;
                break;
            }
            case 9: {
                if (o instanceof StaticSimClass) {
                    this.value = ((StaticSimClass)o).getCPI();
                    break;
                }
                this.value = o;
                break;
            }
            case 12: {
                ErrorHandler.reportMessage("SIMUKNOWN should not occur in MapStore.setValue " + o);
            }
            case 11: {
                if (o == null) break;
                if (o.getClass().getName().endsWith("Hashtable")) {
                    Vector v = new Vector(5, 5);
                    Enumeration e = ((Hashtable)o).elements();
                    while (e.hasMoreElements()) {
                        v.addElement(e.nextElement());
                    }
                    this.value = v;
                    break;
                }
                this.value = o;
                break;
            }
            case 10: {
                if (o instanceof RefPair) {
                    this.value = o;
                    break;
                }
                if (!(o instanceof RefClass)) break;
                this.value = ((RefClass)o).getRefPair();
                break;
            }
            default: {
                if (this.type < 10000) break;
                this.value = o;
            }
        }
    }

    public void setValue(String rep) throws IllegalArgumentException {
        switch (this.type) {
            case 0: {
                if (rep.equals("true")) {
                    this.value = new Boolean(true);
                    break;
                }
                if (rep.equals("false")) {
                    this.value = new Boolean(false);
                    break;
                }
                throw new IllegalArgumentException("MapStore: invalid boolean string");
            }
            case 1: {
                if (rep.length() == 1) {
                    this.setValue(rep.charAt(0));
                    break;
                }
                throw new IllegalArgumentException("MapStore: only on char allowed");
            }
            case 2: {
                this.setValue(new Byte(rep));
                break;
            }
            case 3: {
                this.setValue(new Short(rep));
                break;
            }
            case 4: {
                this.setValue(new Integer(rep));
                break;
            }
            case 5: {
                this.setValue(new Byte(rep));
                break;
            }
            case 6: {
                this.setValue(new Float(rep).floatValue());
                break;
            }
            case 7: {
                this.setValue(new Double(rep));
                break;
            }
            case 8: {
                this.value = rep;
                break;
            }
            default: {
                throw new IllegalArgumentException("MapStore: string set not available for type " + this.type);
            }
        }
    }

    public void setValue(Vector o) {
        if (this.type != 11 && this.type != 12) {
            throw new IllegalArgumentException("MapStore: table required " + o);
        }
        this.value = o;
    }

    public void setValue(RefPair pair) throws IllegalArgumentException {
        if (this.type != 10) {
            throw new IllegalArgumentException("MapStore: Attempt to store non-ref value " + this.type);
        }
        this.value = pair;
    }

    public void setValue(StaticSimClass o) throws IllegalArgumentException {
        if (this.type != 9) {
            throw new IllegalArgumentException("MapStore: invalid attempt to store class property");
        }
        this.value = o;
    }

    public void setValue(ClassInstance o) throws IllegalArgumentException {
        if (this.type != 9) {
            throw new IllegalArgumentException("MapStore: invalid attempt to store class property");
        }
        this.value = o;
    }

    public void setValue(MapStore ms) throws IllegalArgumentException {
        if (this.type != ms.type) {
            throw new IllegalArgumentException("MapStore: Incompatible update types " + this.type + " " + ms.type);
        }
        switch (ms.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                this.value = ms.getValue();
                break;
            }
            case 9: {
                this.value = ms.getFixedValue();
                break;
            }
            case 10: {
                this.value = new RefPair((RefPair)ms.getValue());
                break;
            }
            case 12: {
                ErrorHandler.reportMessage("MapStore:setValue(MapStore) type UNKNOWN" + ms.getValue());
            }
            case 11: {
                this.value = ms.getFixedValue();
                break;
            }
            default: {
                if (ms.type < 10000) break;
                this.value = ms.type % 10000 == 10 ? ms.getFixedValue() : ms.getValue();
            }
        }
    }

    public void setValue(short val) throws IllegalArgumentException {
        if (this.type != 3) {
            throw new IllegalArgumentException("MapStore: Non short value");
        }
        this.value = new Short(val);
    }

    public void setValue(boolean val) throws IllegalArgumentException {
        if (this.type != 0) {
            throw new IllegalArgumentException("MapStore: Non boolean value");
        }
        this.value = new Boolean(val);
    }

    public void tableAdd(ClassInstance cpi) {
        if (this.type != 11) {
            throw new IllegalArgumentException("MapStore: does not represent table " + this.type);
        }
        Vector v = (Vector)this.getValue();
        v.addElement(cpi);
    }

    public void tableClear() {
        if (this.type != 11) {
            throw new IllegalArgumentException("MapStore: does not represent table");
        }
        Vector v = (Vector)this.getValue();
        v.removeAllElements();
    }

    public void tableDelete(int index) {
        if (this.type != 11) {
            throw new IllegalArgumentException("MapStore: does not represent table" + this.type);
        }
        Vector v = (Vector)this.getValue();
        v.removeElementAt(index);
    }

    public void tableInsert(int index, ClassInstance cpi) {
        if (this.type != 11) {
            throw new IllegalArgumentException("MapStore: does not represent table");
        }
        Vector v = (Vector)this.getValue();
        if (index > v.size()) {
            throw new IllegalArgumentException("MapStore: index too high " + index);
        }
        v.insertElementAt(cpi, index);
    }

    public void tableReplace(int index, ClassInstance cpi) {
        if (this.type != 11) {
            throw new IllegalArgumentException("MapStore: does not represent table " + this.type);
        }
        Vector v = (Vector)this.getValue();
        if (index > v.size()) {
            throw new IllegalArgumentException("MapStore: index too high " + index);
        }
        v.setElementAt(cpi, index);
    }
}

