/*
 * Decompiled with CFR 0.152.
 */
package org.jelsim.model.map;

import java.io.Serializable;
import java.util.Vector;
import org.jelsim.model.RefPair;
import org.jelsim.model.SimConst;
import org.jelsim.model.event.ModelUpdateEvent;
import org.jelsim.model.event.ModelUpdateListener;
import org.jelsim.model.map.ClassInstance;
import org.jelsim.model.map.FixedMapProperty;
import org.jelsim.model.map.MapStore;
import org.jelsim.system.ErrorHandler;

public class MapProperty
implements Serializable,
SimConst {
    public String name = null;
    public int id;
    private String gid = null;
    private int instId;
    private int classId;
    private int ioType;
    public MapStore ms;
    private transient Vector listeners = null;

    public MapProperty(String name, int classId, int instId, int id, String gid, int type, int ioType) {
        this.name = name;
        this.classId = classId;
        this.instId = instId;
        this.id = id;
        this.gid = gid;
        this.ioType = ioType;
        this.ms = new MapStore(type);
    }

    public void addModelUpdateListener(ModelUpdateListener l) {
        if (this.listeners == null) {
            this.listeners = new Vector(5);
        }
        if (!this.listeners.contains(l)) {
            this.listeners.addElement(l);
        }
    }

    public void finalizeJelsim() {
        if (this.listeners != null) {
            this.listeners.removeAllElements();
            this.listeners = null;
        }
    }

    public void fireModelUpdateEvent() {
        if (this.listeners != null && this.listeners.size() > 0) {
            Vector v;
            ModelUpdateEvent mve = new ModelUpdateEvent(new FixedMapProperty(this));
            MapProperty mapProperty = this;
            synchronized (mapProperty) {
                v = (Vector)this.listeners.clone();
            }
            int i = 0;
            while (i < v.size()) {
                ((ModelUpdateListener)v.elementAt(i)).handleModelUpdate(mve);
                ++i;
            }
        }
    }

    public int getClassId() {
        return this.classId;
    }

    protected int getIOType() {
        return this.ioType;
    }

    public int getInstId() {
        return this.instId;
    }

    protected MapStore getMapStore() {
        return this.ms;
    }

    public int getPropertyId() {
        return this.id;
    }

    public String getUniqueValue() {
        return this.gid;
    }

    public Object getValue() {
        return this.ms.getValue();
    }

    public boolean isTable() {
        return this.ms.getType() == 11;
    }

    public void propertySet(byte value) {
        this.ms.setValue(value);
        this.fireModelUpdateEvent();
    }

    public void propertySet(char value) {
        this.ms.setValue(value);
        this.fireModelUpdateEvent();
    }

    public void propertySet(double value) {
        this.ms.setValue(value);
        this.fireModelUpdateEvent();
    }

    public void propertySet(float value) {
        this.ms.setValue(value);
        this.fireModelUpdateEvent();
    }

    public void propertySet(int value) {
        this.ms.setValue(value);
        this.fireModelUpdateEvent();
    }

    public void propertySet(long value) {
        this.ms.setValue(value);
        this.fireModelUpdateEvent();
    }

    public void propertySet(Object o) {
        if (o instanceof MapStore) {
            this.propertySet((MapStore)o);
        } else if (o instanceof ClassInstance) {
            this.propertySet((ClassInstance)o);
        } else {
            switch (this.ms.getType()) {
                case 0: {
                    this.propertySet((Boolean)o);
                    break;
                }
                case 1: {
                    this.propertySet(((Character)o).charValue());
                    break;
                }
                case 2: {
                    this.propertySet((Byte)o);
                    break;
                }
                case 3: {
                    this.propertySet((Short)o);
                    break;
                }
                case 4: {
                    this.propertySet((Integer)o);
                    break;
                }
                case 5: {
                    this.propertySet((Long)o);
                    break;
                }
                case 6: {
                    this.propertySet(((Float)o).floatValue());
                    break;
                }
                case 7: {
                    this.propertySet((Double)o);
                    break;
                }
                case 8: {
                    this.propertySet((String)o);
                    break;
                }
                case 10: {
                    this.propertySet((RefPair)o);
                    break;
                }
                default: {
                    if (this.ms.getType() < 10000) {
                        ErrorHandler.reportMessage("WARNING WRAPPED CLASS INCORRECTLY HANDLED " + o.getClass().getName() + " " + this.ms.getType());
                    }
                    if (this.ms.getType() < 10000) break;
                    this.ms.setValue(o);
                }
            }
        }
    }

    public void propertySet(String value) {
        this.ms.setValue(value);
        this.fireModelUpdateEvent();
    }

    public void propertySet(RefPair rc) {
        this.ms.setValue(rc);
        this.fireModelUpdateEvent();
    }

    public void propertySet(ClassInstance value) {
        this.ms.setValue(value);
        this.fireModelUpdateEvent();
    }

    public void propertySet(MapStore ms) {
        this.ms.setValue(ms);
        this.fireModelUpdateEvent();
    }

    public void propertySet(short value) {
        this.ms.setValue(value);
        this.fireModelUpdateEvent();
    }

    public void propertySet(boolean value) {
        this.ms.setValue(new Boolean(value).toString());
        this.fireModelUpdateEvent();
    }

    public void propertySet(ClassInstance[] value) {
        Vector<ClassInstance> v = new Vector<ClassInstance>(value.length);
        int i = 0;
        while (i < value.length) {
            v.addElement(value[i]);
            ++i;
        }
        this.ms.setValue(v);
        this.fireModelUpdateEvent();
    }

    public void removeModelUpdateListener(ModelUpdateListener l) {
        if (this.listeners != null && this.listeners.contains(l)) {
            this.listeners.removeElement(l);
        }
    }

    public void tableAdd(ClassInstance cpi) {
        this.ms.tableAdd(cpi);
    }

    public void tableClear() {
        this.ms.tableClear();
    }

    public void tableDelete(int index) {
        this.ms.tableDelete(index);
    }

    public void tableInsert(int index, ClassInstance cpi) {
        this.ms.tableInsert(index, cpi);
    }

    public void tableReplace(int index, ClassInstance cpi) {
        this.ms.tableReplace(index, cpi);
    }

    public String toString() {
        return String.valueOf(this.name) + " " + this.id + " " + this.ms.getType() + " " + this.ms.getValue();
    }
}

