/*
 * Decompiled with CFR 0.152.
 */
package org.jelsim.model.map;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.jelsim.model.PropertyRegister;
import org.jelsim.model.RefPair;
import org.jelsim.model.RegUpdate;
import org.jelsim.model.SimConst;
import org.jelsim.model.event.InterfaceUpdateEvent;
import org.jelsim.model.event.ModelUpdateListener;
import org.jelsim.model.event.PropertyUpdateEvent;
import org.jelsim.model.event.PropertyUpdateListener;
import org.jelsim.model.event.StructureChangeEvent;
import org.jelsim.model.event.StructureChangeListener;
import org.jelsim.model.map.ClassInstance;
import org.jelsim.model.map.ClassTemplate;
import org.jelsim.model.map.FixedMapProperty;
import org.jelsim.model.map.MapProperty;
import org.jelsim.model.map.ModelLoadCompleteInterface;
import org.jelsim.model.map.ModelPropertyInterface;
import org.jelsim.model.map.PropertyUpdate;
import org.jelsim.system.ErrorHandler;
import org.jelsim.trigger.TriggerManager;

public class MapLayer
implements SimConst,
PropertyUpdateListener {
    private boolean PropertyUpdateSent = false;
    protected ClassTemplate[] classTemps = null;
    protected int[][] cPTypes = null;
    protected Vector allProperties = null;
    protected Hashtable allPropertiesByName = null;
    protected Vector hierarchy = null;
    protected Vector fileMenuStrings = null;
    protected Vector actionMenuStrings = null;
    protected Vector customObjectStrings = null;
    protected String modelName = null;
    protected TriggerManager triggerManager = null;
    protected int modelIdentifier = (int)System.currentTimeMillis();
    ModelLoadCompleteInterface modelLoadCompletion;
    private transient Vector listeners = null;

    public MapLayer(ModelLoadCompleteInterface modelLoadCompletion) {
        this.modelLoadCompletion = modelLoadCompletion;
    }

    private void addDynamicProperties(int classId, MapProperty[] newProperties) {
        if (classId >= this.hierarchy.size()) {
            ErrorHandler.printMessage("INTERNAL ERROR ML001: parent class for dynamic property does not exist");
            return;
        }
        Vector instances = (Vector)this.hierarchy.elementAt(classId);
        if (instances.size() != newProperties.length) {
            ErrorHandler.printMessage("INTERNAL ERROR ML002: instance counts did not match during dynamic property addition");
            return;
        }
        int i = 0;
        while (i < newProperties.length) {
            MapProperty[] existingProperties = (MapProperty[])instances.elementAt(i);
            if (newProperties[i].getUniqueValue() != existingProperties[0].getUniqueValue()) {
                ErrorHandler.printMessage("INTERNAL ERROR ML003: unique instances did not match during dynamic property addition");
            } else {
                MapProperty[] replaceProperties = new MapProperty[existingProperties.length + 1];
                System.arraycopy(existingProperties, 0, replaceProperties, 0, existingProperties.length);
                replaceProperties[existingProperties.length] = newProperties[i];
                instances.setElementAt(replaceProperties, i);
                this.allProperties.addElement(newProperties[i]);
                this.allPropertiesByName.put(newProperties[i].name, newProperties[i]);
            }
            ++i;
        }
        StructureChangeEvent mve = new StructureChangeEvent(this);
        mve.setType(2);
        String uniqueId = newProperties[0].getUniqueValue();
        mve.setLastCreatedUniqueName(uniqueId);
        this.fireStructureChangeEvent(mve);
    }

    public synchronized void addModelUpdateListener(ModelPropertyInterface mp, ModelUpdateListener l) {
        this.getMapProperty(mp.getClassId(), mp.getInstId(), mp.getPropertyId()).addModelUpdateListener(l);
    }

    private void addNewClassInstance(int classIdentifier, MapProperty[] newProperties) {
        if (classIdentifier >= this.hierarchy.size()) {
            Vector newClassProperties = new Vector();
            this.hierarchy.addElement(newClassProperties);
        }
        ((Vector)this.hierarchy.elementAt(classIdentifier)).addElement(newProperties);
        int i = 0;
        while (i < newProperties.length) {
            this.allProperties.addElement(newProperties[i]);
            this.allPropertiesByName.put(newProperties[i].name, newProperties[i]);
            ++i;
        }
        StructureChangeEvent mve = new StructureChangeEvent(this);
        mve.setType(0);
        String uniqueId = newProperties[0].getUniqueValue();
        mve.setLastCreatedUniqueName(uniqueId);
        this.fireStructureChangeEvent(mve);
    }

    public void addStructureChangeListener(StructureChangeListener l) {
        if (this.listeners == null) {
            this.listeners = new Vector(5);
        }
        if (!this.listeners.contains(l)) {
            this.listeners.addElement(l);
        }
    }

    private void deleteClassInstance(int classId, String uniqueIdString) {
        Vector classInstances = (Vector)this.hierarchy.elementAt(classId);
        int instanceIndex = 0;
        while (instanceIndex < classInstances.size()) {
            MapProperty[] properties = (MapProperty[])classInstances.elementAt(instanceIndex);
            MapProperty firstProperty = properties[0];
            if (firstProperty.getUniqueValue().equals(uniqueIdString)) {
                classInstances.removeElementAt(instanceIndex);
                StructureChangeEvent mve = new StructureChangeEvent(this);
                mve.setType(1);
                this.fireStructureChangeEvent(mve);
                break;
            }
            ++instanceIndex;
        }
    }

    private void extractProperties() {
        this.allPropertiesByName = new Hashtable();
        Vector<MapProperty> v = new Vector<MapProperty>();
        int i = 0;
        while (i < this.hierarchy.size()) {
            Vector insts = (Vector)this.hierarchy.elementAt(i);
            int j = 0;
            while (j < insts.size()) {
                MapProperty[] p = (MapProperty[])insts.elementAt(j);
                int k = 0;
                while (k < p.length) {
                    v.addElement(p[k]);
                    this.allPropertiesByName.put(p[k].name, p[k]);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        this.allProperties = v;
    }

    public void finalizeJelsim() {
        this.allPropertiesByName.clear();
        this.allPropertiesByName = null;
        int i = 0;
        while (i < this.hierarchy.size()) {
            Vector insts = (Vector)this.hierarchy.elementAt(i);
            int j = 0;
            while (j < insts.size()) {
                MapProperty[] p = (MapProperty[])insts.elementAt(j);
                int k = 0;
                while (k < p.length) {
                    p[k].finalizeJelsim();
                    ++k;
                }
                ++j;
            }
            insts.removeAllElements();
            ++i;
        }
    }

    private void fireStructureChangeEvent(StructureChangeEvent mve) {
        if (this.listeners != null && this.listeners.size() > 0) {
            Vector v;
            MapLayer mapLayer = this;
            synchronized (mapLayer) {
                v = (Vector)this.listeners.clone();
            }
            int i = 0;
            while (i < v.size()) {
                ((StructureChangeListener)v.elementAt(i)).handleStructureChangeEvent(mve);
                ++i;
            }
        }
    }

    private void flushTriggerConditions() {
        if (this.triggerManager != null) {
            this.triggerManager.flushTriggerConditions();
        }
    }

    public String getActionMenuString(int strno) {
        return (String)this.actionMenuStrings.elementAt(strno);
    }

    public Vector getActionMenuStrings() {
        return this.actionMenuStrings;
    }

    public Vector getAssocRefProperties(RefPair rp) {
        Vector<ClassInstance> v = new Vector<ClassInstance>();
        int classId = rp.getRefId();
        ClassTemplate template = this.getTemplate(classId);
        Vector instances = (Vector)this.hierarchy.elementAt(classId);
        MapProperty[] properties = null;
        int i = 0;
        while (i < instances.size()) {
            properties = (MapProperty[])instances.elementAt(i);
            v.addElement(new ClassInstance(classId, properties[0].getInstId(), properties, template));
            ++i;
        }
        return v;
    }

    private MapProperty[] getClassProperties(int classIdentifier, int instIdentifier) {
        MapProperty[] properties = null;
        Vector instances = (Vector)this.hierarchy.elementAt(classIdentifier);
        int i = 0;
        while (i < instances.size()) {
            MapProperty[] imp = (MapProperty[])instances.elementAt(i);
            if (imp[0].getInstId() == instIdentifier) {
                properties = imp;
                break;
            }
            ++i;
        }
        return properties;
    }

    public Vector getCustomObjectStrings() {
        return this.customObjectStrings;
    }

    public String getFileMenuString(int strno) {
        return (String)this.fileMenuStrings.elementAt(strno);
    }

    public Vector getFileMenuStrings() {
        return this.fileMenuStrings;
    }

    public synchronized Vector getHierarchy() {
        return this.hierarchy;
    }

    public synchronized MapProperty getMapProperty(int classId, int instId, int propertyId) {
        Vector listOfInstances = (Vector)this.hierarchy.elementAt(classId);
        int actualIndex = this.instIdToIndex(listOfInstances, instId);
        if (actualIndex != -1) {
            return ((MapProperty[])listOfInstances.elementAt(actualIndex))[propertyId];
        }
        return null;
    }

    public int getModelIdentifier() {
        return this.modelIdentifier;
    }

    public String getModelName() {
        return this.modelName;
    }

    public synchronized FixedMapProperty[] getProperties() {
        FixedMapProperty[] fmps = new FixedMapProperty[this.allProperties.size()];
        int i = 0;
        while (i < fmps.length) {
            fmps[i] = new FixedMapProperty((MapProperty)this.allProperties.elementAt(i));
            ++i;
        }
        return fmps;
    }

    public synchronized FixedMapProperty getProperty(int classId, int instId, int propertyId) {
        MapProperty property = this.getMapProperty(classId, instId, propertyId);
        if (property != null) {
            return new FixedMapProperty(property);
        }
        return null;
    }

    public synchronized FixedMapProperty getProperty(String name) {
        return this.getProperty(name, null);
    }

    public synchronized FixedMapProperty getProperty(String propName, Object gid) {
        FixedMapProperty fmp = null;
        if (this.hierarchy != null) {
            Enumeration hierarchyEnum = this.hierarchy.elements();
            while (hierarchyEnum.hasMoreElements()) {
                Enumeration classEnum = ((Vector)hierarchyEnum.nextElement()).elements();
                while (classEnum.hasMoreElements()) {
                    MapProperty[] props = (MapProperty[])classEnum.nextElement();
                    if (props == null || props.length <= 0) continue;
                    int i = 0;
                    while (i < props.length) {
                        if (props[i].name.equals(propName)) {
                            if (gid == null) {
                                return new FixedMapProperty(props[i]);
                            }
                            if (gid.equals(props[i].getUniqueValue())) {
                                return new FixedMapProperty(props[i]);
                            }
                        }
                        ++i;
                    }
                }
            }
        }
        return fmp;
    }

    public synchronized FixedMapProperty getProperty(ModelPropertyInterface mp) {
        return this.getProperty(mp.getClassId(), mp.getInstId(), mp.getPropertyId());
    }

    public int getRefCount(RefPair rp) {
        return ((Vector)this.hierarchy.elementAt(rp.getRefId())).size();
    }

    public ClassInstance getRefProperty(RefPair rp) {
        int classId = rp.getRefId();
        int instId = rp.getInstId();
        return new ClassInstance(classId, instId, this.getClassProperties(classId, instId), this.getTemplate(classId));
    }

    public ClassTemplate getTemplate(int classId) {
        return this.classTemps[classId];
    }

    public synchronized void handleInterfaceUpdate(InterfaceUpdateEvent e) {
        this.getMapProperty(e.getClassId(), e.getInstId(), e.getPropertyId()).propertySet(e.getValue());
    }

    protected void handlePropertyUpdate(int classId, int instId, int propertyId, PropertyUpdate pu) {
        this.getMapProperty(classId, instId, propertyId).propertySet(pu);
    }

    public void handlePropertyUpdate(PropertyUpdateEvent e) {
        this.PropertyUpdateSent = true;
        switch (e.getEventType()) {
            case 0: {
                this.handlePropertyUpdate(e.getClassId(), e.getInstId(), e.getPropertyId(), (PropertyUpdate)e.getValue());
                break;
            }
            case 2: {
                this.addNewClassInstance(e.getClassId(), (MapProperty[])e.getValue());
                break;
            }
            case 3: {
                this.initialiseTemplates((ClassTemplate[])e.getValue());
                break;
            }
            case 4: {
                this.initialiseStore((RegUpdate)e.getValue(), e.getModelIdentifier());
                break;
            }
            case 5: {
                this.deleteClassInstance(e.getClassId(), e.getUniqueIdString());
                break;
            }
            case 6: {
                this.flushTriggerConditions();
                break;
            }
            case 7: {
                this.addDynamicProperties(e.getClassId(), (MapProperty[])e.getValue());
                break;
            }
            default: {
                ErrorHandler.reportMessage("Property event type " + e.getEventType() + " unknown");
            }
        }
    }

    public synchronized void initialiseStore(RegUpdate encVec, int modelIdentifier) {
        this.modelIdentifier = modelIdentifier;
        this.hierarchy = (Vector)encVec.elementAt(0);
        this.extractProperties();
        this.initialiseTemplates((ClassTemplate[])encVec.elementAt(1));
        this.fileMenuStrings = (Vector)encVec.elementAt(2);
        this.actionMenuStrings = (Vector)encVec.elementAt(3);
        this.modelName = (String)encVec.elementAt(4);
        this.customObjectStrings = (Vector)encVec.elementAt(5);
        this.modelLoadCompletion.completeModelLoad();
    }

    private void initialiseTemplates(ClassTemplate[] templates) {
        this.classTemps = templates;
        if (this.classTemps != null) {
            this.cPTypes = new int[this.classTemps.length][];
            int i = 0;
            while (i < this.cPTypes.length) {
                this.cPTypes[this.classTemps[i].getClassIdentifier()] = this.classTemps[i].getTypes();
                ++i;
            }
        }
    }

    private int instIdToIndex(Vector listOfInstances, int instanceId) {
        int i = 0;
        while (i < listOfInstances.size()) {
            if (((MapProperty[])listOfInstances.elementAt(i))[0].getInstId() == instanceId) {
                return i;
            }
            ++i;
        }
        ErrorHandler.reportError("Attempt to access  non-existent MapProperty ignored.");
        return -1;
    }

    public boolean isLocal() {
        return true;
    }

    public synchronized void removeModelUpdateListener(ModelPropertyInterface mp, ModelUpdateListener l) {
        MapProperty property = this.getMapProperty(mp.getClassId(), mp.getInstId(), mp.getPropertyId());
        if (property != null) {
            property.removeModelUpdateListener(l);
        } else {
            ErrorHandler.reportError("Attempt to remove MvModelUpdateListener from non-existent MapProperty ignored.");
        }
    }

    public void removeStructureChangeListener(StructureChangeListener l) {
        if (this.listeners != null && this.listeners.contains(l)) {
            this.listeners.removeElement(l);
        }
    }

    public void reset() {
        this.PropertyUpdateSent = false;
    }

    public boolean sentPropertyUpdate() {
        return this.PropertyUpdateSent;
    }

    public void setReg(PropertyRegister reg) {
    }

    public void setTriggerManager(TriggerManager triggerManager) {
        this.triggerManager = triggerManager;
    }
}

