/*
 * Decompiled with CFR 0.152.
 */
package org.jelsim.model.map;

import org.jelsim.model.map.MapProperty;
import org.jelsim.model.map.MapStore;
import org.jelsim.model.map.ModelPropertyInterface;
import org.jelsim.model.simutil;

public class FixedMapProperty
implements ModelPropertyInterface {
    public String name = null;
    public int id;
    private String gid;
    private int ioType = 0;
    private int instId = -1;
    private int classId = 0;
    private MapStore ms;

    public FixedMapProperty(MapProperty mp) {
        this.name = mp.name;
        this.id = mp.id;
        this.gid = mp.getUniqueValue();
        this.ioType = mp.getIOType();
        this.instId = mp.getInstId();
        this.classId = mp.getClassId();
        this.ms = mp.ms;
    }

    public int getClassId() {
        return this.classId;
    }

    public String getGid() {
        return this.gid;
    }

    public int getIOType() {
        return this.ioType;
    }

    public int getInstId() {
        return this.instId;
    }

    public String getName() {
        return this.name;
    }

    public String getPropertyDescriptorString() {
        return simutil.getPropertyDescriptorString(this.ioType, this.ms.getType());
    }

    public int getPropertyId() {
        return this.id;
    }

    public int getType() {
        return this.ms.getType();
    }

    public Object getValue() {
        return this.ms.getFixedValue();
    }

    public boolean matches(FixedMapProperty mp) {
        return this.gid == mp.getGid() && this.name == mp.getName();
    }

    public boolean sameMapStore(FixedMapProperty fmp) {
        return fmp == null ? false : fmp.ms == this.ms;
    }

    public boolean sameMapStore(MapStore mstest) {
        return mstest == this.ms;
    }

    public boolean sameMapStore(ModelPropertyInterface mp) {
        if (mp instanceof FixedMapProperty) {
            return this.sameMapStore((FixedMapProperty)mp);
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.name) + " " + this.id + " " + this.ms.getType() + " " + this.ms.getFixedValue();
    }
}

