/*
 * Decompiled with CFR 0.152.
 */
package org.jelsim.model.map;

import java.io.Serializable;

public class ClassTemplate
implements Serializable {
    private int classIdentifier;
    private int[] types = null;
    private String[] names = null;
    private String className = null;

    public ClassTemplate(String className, int classId, String[] names, int[] types) {
        this.className = className;
        this.classIdentifier = classId;
        this.names = names;
        this.types = types;
    }

    public void addProperty(String propertyName, int propertyType) {
        int oldLength = this.names.length;
        String[] newNames = new String[oldLength + 1];
        int[] newTypes = new int[oldLength + 1];
        int i = 0;
        while (i < oldLength) {
            newNames[i] = this.names[i];
            newTypes[i] = this.types[i];
            ++i;
        }
        newNames[oldLength] = propertyName;
        newTypes[oldLength] = propertyType;
        this.names = newNames;
        this.types = newTypes;
    }

    public int getClassIdentifier() {
        return this.classIdentifier;
    }

    public String getClassName() {
        return this.className;
    }

    public String getName(int i) {
        return this.names[i];
    }

    public String[] getNames() {
        return this.names;
    }

    public int[] getTypes() {
        return this.types;
    }

    public int matchPropertyIndex(String propertyName) {
        String lcname = propertyName.toLowerCase();
        int retval = -1;
        int i = 0;
        while (i < this.names.length) {
            if (this.names[i].toLowerCase().indexOf(lcname) >= 0) {
                retval = i;
                break;
            }
            ++i;
        }
        return retval;
    }

    public int size() {
        return this.names.length;
    }
}

