/*
 * Decompiled with CFR 0.152.
 */
package org.jelsim.model.map;

import java.io.Serializable;
import org.jelsim.model.RefPair;
import org.jelsim.model.SimClass;
import org.jelsim.model.SimConst;
import org.jelsim.model.map.ClassTemplate;
import org.jelsim.model.map.MapProperty;
import org.jelsim.model.map.MapStore;

public class ClassInstance
implements Serializable,
SimConst {
    protected ClassTemplate template = null;
    private int classIdentifier;
    private int instIdentifier;
    private RefPair refInstance = null;
    MapStore[] ms = null;

    public ClassInstance() {
    }

    public ClassInstance(int classIdentifier, int instIdentifier, MapProperty[] mp, ClassTemplate template) {
        this.template = template;
        this.classIdentifier = classIdentifier;
        this.instIdentifier = instIdentifier;
        this.refInstance = new RefPair(classIdentifier, instIdentifier);
        this.ms = new MapStore[mp.length];
        int i = 0;
        while (i < this.ms.length) {
            this.ms[i] = mp[i].getMapStore();
            ++i;
        }
    }

    public ClassInstance(int classIdentifier, int instIdentifier, MapStore[] ms, ClassTemplate template) {
        this.template = template;
        this.classIdentifier = classIdentifier;
        this.instIdentifier = instIdentifier;
        this.ms = ms;
        this.refInstance = new RefPair(classIdentifier, instIdentifier);
    }

    public ClassInstance(SimClass sc) {
        this(sc.getCPI());
    }

    public ClassInstance(ClassInstance cpi) {
        this.template = cpi.template;
        this.classIdentifier = cpi.getClassIdentifier();
        this.ms = new MapStore[cpi.ms.length];
        int i = 0;
        while (i < this.ms.length) {
            this.ms[i] = new MapStore(cpi.ms[i]);
            ++i;
        }
        this.refInstance = cpi.refInstance;
    }

    public int getClassIdentifier() {
        return this.classIdentifier;
    }

    public String getName() {
        return this.template.getClassName();
    }

    public String[] getNames() {
        return this.template.getNames();
    }

    public RefPair getRefPair() {
        return this.refInstance;
    }

    public int[] getTypes() {
        return this.template.getTypes();
    }

    public Object getValue(int i) {
        return this.ms[i].getValue();
    }

    public MapStore[] getValues() {
        return this.ms;
    }

    public int matchPropertyIndex(String propertyName) {
        return this.template.matchPropertyIndex(propertyName);
    }

    public MapStore matchPropertyStore(String propertyName) {
        int index = this.matchPropertyIndex(propertyName);
        if (index >= 0) {
            return this.ms[index];
        }
        return null;
    }

    public void setRefPair(RefPair rp) {
        this.refInstance = rp;
    }

    protected void setValues(ClassInstance cpi) {
        if (cpi.getClassIdentifier() != this.classIdentifier) {
            throw new IllegalArgumentException("CPI setValue different class");
        }
        MapStore[] newValues = cpi.getValues();
        int i = 0;
        while (i < this.ms.length) {
            this.ms[i].setValue(newValues[i].getValue());
            ++i;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Class Property " + this.ms.length + " ");
        int i = 0;
        while (i < this.ms.length) {
            sb.append(" (" + this.ms[i].getValue() + " " + this.ms[i].getType() + ")");
            ++i;
        }
        return sb.toString();
    }
}

