/*
 * Decompiled with CFR 0.152.
 */
package org.jelsim.model.access;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Rectangle;
import java.beans.Beans;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.OptionalDataException;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLConnection;
import java.util.TooManyListenersException;
import java.util.Vector;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.engines.RSAEngine;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.util.encoders.Hex;
import org.jelsim.beans.support.BeanInterface;
import org.jelsim.beans.support.BeanReadHelper;
import org.jelsim.beans.support.IfLinkChildInterface;
import org.jelsim.beans.support.IfLinkParentInterface;
import org.jelsim.beans.support.JSClassHelper;
import org.jelsim.beans.support.JSExternalizableBean;
import org.jelsim.beans.support.ModelAccessInterface;
import org.jelsim.builder.event.BuilderListener;
import org.jelsim.crypt.deploy.DeployCode;
import org.jelsim.crypt.deploy.DeployCodeProvider;
import org.jelsim.crypt.deploy.DeployException;
import org.jelsim.crypt.deploy.DeployKey;
import org.jelsim.crypt.deploy.OAEPDecoder;
import org.jelsim.crypt.deploy.Wrapper;
import org.jelsim.model.MainSimClass;
import org.jelsim.model.RefPair;
import org.jelsim.model.access.BrowserAccessInterface;
import org.jelsim.model.access.IfAccess;
import org.jelsim.model.access.ModelLoadException;
import org.jelsim.model.access.Structure;
import org.jelsim.model.event.InterfaceUpdateEvent;
import org.jelsim.model.event.InterfaceUpdateListener;
import org.jelsim.model.event.JelsimActionEvent;
import org.jelsim.model.event.JelsimActionListener;
import org.jelsim.model.event.ModelUpdateListener;
import org.jelsim.model.event.RefUpdateEvent;
import org.jelsim.model.event.RefUpdateListener;
import org.jelsim.model.event.StructureChangeListener;
import org.jelsim.model.event.TableUpdateEvent;
import org.jelsim.model.map.ClassInstance;
import org.jelsim.model.map.ClassTemplate;
import org.jelsim.model.map.FixedMapProperty;
import org.jelsim.model.map.MapLayer;
import org.jelsim.model.map.MapProperty;
import org.jelsim.model.map.ModelLoadCompleteInterface;
import org.jelsim.model.map.ModelPropertyInterface;
import org.jelsim.model.map.RefUpdate;
import org.jelsim.report.ReportGenerator;
import org.jelsim.system.ErrorHandler;
import org.jelsim.trigger.TriggerCondition;
import org.jelsim.trigger.TriggerManager;
import org.jelsim.userif.EditClient;
import org.jelsim.userif.EditHelperInterface;
import org.jelsim.userif.PanelSaveState;
import org.jelsim.userif.containers.compound.CompoundObject;
import org.jelsim.userif.containers.popup.PopupButtonInterface;
import org.jelsim.userif.deploy.CompleteSaveInterface;
import org.jelsim.userif.overlay.OverlayInterface;

public abstract class ModelAccess
implements ModelAccessInterface,
ModelLoadCompleteInterface,
InterfaceUpdateListener,
BuilderListener,
DeployCodeProvider {
    protected final int MAP_LAYER_READY = 2;
    protected final int IF_OBJECTS_READY = 4;
    protected final int LOAD_STATUS_COMPLETE = 6;
    private int loadStatus = 0;
    protected Vector ifobjects = new Vector(20, 10);
    protected IfAccess dp;
    protected boolean local;
    protected Structure[] structure = null;
    protected boolean loaded = false;
    protected boolean triggersRead = false;
    protected Object annotation = null;
    protected MainSimClass model = null;
    public MapLayer mlayer = new MapLayer(this);
    protected RefUpdateListener refListener = null;
    protected JelsimActionListener actionListener = null;
    protected InterfaceUpdateListener interfaceListener = null;
    protected int nextLocalId = 0;
    protected EditHelperInterface editHelper = null;
    protected URL baseURL = null;
    protected ReportGenerator reportGenerator = null;
    protected String reportURLString = null;
    protected String beanDirectory = "./setups";
    private String fileName = null;
    protected TriggerManager triggerManager = new TriggerManager(this);
    protected Component mainEditClient;
    private int modelStatus = -1;
    public static final int STATUS_UNINITIALISED = -1;
    public static final int STATUS_UNLICENSED = 0;
    public static final int STATUS_NOT_DEPLOYED = 1;
    public static final int STATUS_IN_TOOL = 2;
    public static final int STATUS_NO_HOST_MATCH = 3;
    public static final int STATUS_NO_MODEL_MATCH = 4;
    public static final int STATUS_LICENSED_APPLET = 5;
    public static final int STATUS_JLICENSED_APPLET = 6;
    public static final int STATUS_DEPLOY_TAMPER = 7;
    private DeployKey[] deployKeys = null;
    private DeployKey[] defaultKeys = null;
    private DeployCode defaultCode = null;
    private static final BigInteger m = new BigInteger("92e1639120ed55689c8b997f5b81326217ad444ebc79c5342498e497ea3d2e9a0104ddef74221dd514d6415691f48e70c3fcd5b9df4726b096a7a4b92d627a27ae7e6d73338e5fcb3229afa3815ac56b8c8afc36d322e073fe77947e4389a3085924cf898896054cfbcd2c98dbf7841da91801c7d0a684fb06aecfeb5ddc5556975b90b10a3a43f21b0f2ec1501d2b749ecf323c363daa336328eaa37c2204d0d4c545f6a3033520cc0dca1b3e08e77d6b3328fd502845fea10a8d9ae7a23b047c338462fa182effc80106ece25ca635ffd10e34d82a44200dc05fe0f0447febc4f6c8ea1a510abe1283e45537b9ab41a8be27d21623332c73beb84c973d4311", 16);
    private static final BigInteger pe = new BigInteger("49", 16);
    private static RSAKeyParameters pk = null;
    private static AsymmetricBlockCipher eng = null;

    public ModelAccess() {
        this.mlayer.setTriggerManager(this.triggerManager);
    }

    private int addContainerComponents(Component[] components, Vector v) {
        int linkCount = 0;
        int i = 0;
        while (i < components.length) {
            if (components[i] instanceof IfLinkParentInterface && ((IfLinkParentInterface)((Object)components[i])).isLinked()) {
                ++linkCount;
            }
            if (components[i] instanceof Container) {
                linkCount += this.addContainerComponents(((Container)components[i]).getComponents(), v);
            }
            v.addElement(components[i]);
            ++i;
        }
        return linkCount;
    }

    public synchronized void addIfObject(BeanInterface bean) {
        if (!this.ifobjects.contains(bean)) {
            if (bean instanceof CompoundObject) {
                this.setLocalIds(((CompoundObject)bean).getComponents());
            } else if (bean instanceof PopupButtonInterface) {
                this.setLocalIds(((PopupButtonInterface)((Object)bean)).getPanelComponents());
            } else if (bean instanceof OverlayInterface) {
                this.setLocalIds(((OverlayInterface)((Object)bean)).getComponents());
            }
            if (bean.getLocalId() < 0) {
                bean.setLocalId(this.nextLocalId++);
            }
            if (this.nextLocalId <= bean.getLocalId()) {
                this.nextLocalId = bean.getLocalId() + 1;
            }
            this.ifobjects.addElement(bean);
        }
    }

    public void addModelUpdateListener(ModelPropertyInterface mp, ModelUpdateListener listener) {
        this.mlayer.addModelUpdateListener(mp, listener);
    }

    public void addStructureChangeListener(StructureChangeListener listener) {
        this.mlayer.addStructureChangeListener(listener);
    }

    public void changeRefInstance(ClassInstance cpi) {
        this.refListener.handleRefUpdate(new RefUpdateEvent(new RefUpdate(cpi)));
    }

    protected void checkBeanInit(int statusFlag) {
        this.loadStatus |= statusFlag;
        if (this.loadStatus == 6 && this.editHelper != null) {
            this.editHelper.initialiseBeanObjects();
            this.editHelper.completeModelLoad();
        }
    }

    public void completeModelLoad() {
        this.createHierarchy();
        this.loaded = true;
        this.validateTriggerStructures();
        this.checkBeanInit(2);
    }

    public void createHierarchy() {
        Vector hierarchy = this.mlayer.getHierarchy();
        Vector<Structure> vs = new Vector<Structure>();
        String name = null;
        int i = 0;
        while (i < hierarchy.size()) {
            Vector insts = (Vector)hierarchy.elementAt(i);
            ClassTemplate template = this.mlayer.getTemplate(i);
            name = template.getClassName();
            name = name.substring(name.lastIndexOf(46) + 1);
            int j = 0;
            while (j < insts.size()) {
                FixedMapProperty[] fmp = new FixedMapProperty[template.size()];
                MapProperty[] p = (MapProperty[])insts.elementAt(j);
                int k = 0;
                while (k < p.length) {
                    fmp[k] = new FixedMapProperty(p[k]);
                    ++k;
                }
                vs.addElement(new Structure(String.valueOf(name) + this.getUniqueClassId(p[0]), 0, fmp));
                ++j;
            }
            ++i;
        }
        this.structure = new Structure[vs.size()];
        vs.copyInto(this.structure);
    }

    protected void createTriggerStructures() {
        this.triggerManager.createTriggerStructures();
    }

    private final int detModelStatus() {
        try {
            if (!this.getModelMatch()) {
                return 4;
            }
            if (this.baseURL.getProtocol().equals("file")) {
                if (this.defaultCode.getCid().equals("js")) {
                    return 6;
                }
                return 5;
            }
            String localHost = this.baseURL.getHost().toLowerCase();
            int i = 0;
            while (i < this.deployKeys.length) {
                DeployCode dc = ModelAccess.key2code(this.deployKeys[i]);
                String[] hosts = dc.getServerNames();
                int j = 0;
                while (j < hosts.length) {
                    String host = hosts[j].toLowerCase();
                    if (host.equals(this.defaultCode.getServerNames()[0]) || host.startsWith(localHost)) {
                        return 5;
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (DeployException de) {
            System.err.println("Deploy code exception on applet load");
            de.getTargetException().printStackTrace();
            return 7;
        }
        return 3;
    }

    public abstract void finalizeJelsim();

    public void generateMgmtReport(Object o) {
        if (this.reportGenerator != null) {
            this.reportGenerator.sendReport(this, o);
        } else {
            ErrorHandler.reportMessage("No report generator has been created");
        }
    }

    public String getActionMenuString(int strno) {
        return this.mlayer.getActionMenuString(strno);
    }

    public String[] getActionMenuStrings() {
        Vector v = this.mlayer.getActionMenuStrings();
        String[] strs = null;
        if (v != null) {
            strs = new String[v.size()];
            int i = 0;
            while (i < v.size()) {
                strs[i] = (String)v.elementAt(i);
                ++i;
            }
        }
        return strs;
    }

    public ModelPropertyInterface[] getAllProperties() {
        ModelPropertyInterface[] retval = null;
        retval = this.mlayer != null ? this.mlayer.getProperties() : new ModelPropertyInterface[]{};
        return retval;
    }

    public Object getAnnotation() {
        return this.annotation;
    }

    public Vector getAssocRefProperties(RefPair rp) {
        return this.mlayer.getAssocRefProperties(rp);
    }

    public URL getBaseURL() {
        return this.baseURL;
    }

    public abstract BrowserAccessInterface getBrowserAccess();

    public BuilderListener getBuilderListener() {
        if (this.model instanceof BuilderListener) {
            return (BuilderListener)((Object)this.model);
        }
        return null;
    }

    public String[] getCustomObjectStrings() {
        Vector v = this.mlayer.getCustomObjectStrings();
        String[] strs = null;
        if (v != null) {
            strs = new String[v.size()];
            int i = 0;
            while (i < v.size()) {
                strs[i] = (String)v.elementAt(i);
                ++i;
            }
        }
        return strs;
    }

    public final DeployKey[] getDefaultKeys() {
        return this.defaultKeys;
    }

    public final DeployCode getDeployCode(DeployKey key) throws DeployException {
        return ModelAccess.key2code(key);
    }

    public abstract String[] getDeployFiles();

    public final DeployKey[] getDeployKeys() {
        return this.deployKeys;
    }

    public EditHelperInterface getEditHelper() {
        return this.editHelper;
    }

    public String getFileMenuString(int strno) {
        return this.mlayer.getFileMenuString(strno);
    }

    public String[] getFileMenuStrings() {
        String[] strs = null;
        Vector v = this.mlayer.getFileMenuStrings();
        if (v != null) {
            strs = new String[v.size()];
            int i = 0;
            while (i < v.size()) {
                strs[i] = (String)v.elementAt(i);
                ++i;
            }
        }
        return strs;
    }

    public String getFileName() {
        return this.fileName;
    }

    public Component getGlobalObj(int gid) {
        Component lobj = null;
        int i = 0;
        while (i < this.ifobjects.size()) {
            lobj = (Component)this.ifobjects.elementAt(i);
            if (lobj instanceof BeanInterface && ((BeanInterface)((Object)lobj)).getGlobalId() == gid) break;
            ++i;
        }
        if (i < this.ifobjects.size()) {
            return lobj;
        }
        return null;
    }

    public Component getLocalObj(int id) {
        Component lobj = null;
        int i = 0;
        while (i < this.ifobjects.size()) {
            lobj = (Component)this.ifobjects.elementAt(i);
            if (lobj instanceof BeanInterface && ((BeanInterface)((Object)lobj)).getLocalId() == id) break;
            ++i;
        }
        if (i < this.ifobjects.size()) {
            return lobj;
        }
        return null;
    }

    public Component getMainEditClient() {
        return this.mainEditClient;
    }

    public int getModelIdentifier() {
        return this.mlayer.getModelIdentifier();
    }

    private boolean getModelMatch() throws DeployException {
        boolean modelMatch = false;
        String localHost = this.baseURL.getHost().toLowerCase();
        int i = 0;
        while (i < this.deployKeys.length) {
            DeployCode dc = ModelAccess.key2code(this.deployKeys[i]);
            if (dc.getMid().equals(this.defaultCode.getMid())) {
                modelMatch = true;
                break;
            }
            if (dc.getMid().equals(this.getModelName())) {
                modelMatch = true;
                break;
            }
            ++i;
        }
        return modelMatch;
    }

    public abstract String getModelName();

    public abstract void getModelState(CompleteSaveInterface var1, long var2);

    public final int getModelStatus() {
        if (this.modelStatus == -1) {
            System.err.println("Keys were not initialised before status requested");
        }
        return this.modelStatus;
    }

    public Vector getObjectVector() {
        return this.ifobjects;
    }

    public ModelPropertyInterface getProperty(int classId, int instId, int propId) {
        return this.mlayer.getProperty(classId, instId, propId);
    }

    public ModelPropertyInterface getProperty(String name) {
        return this.mlayer.getProperty(name);
    }

    public ModelPropertyInterface getProperty(String name, Object gid) {
        return this.mlayer.getProperty(name, gid);
    }

    public ModelPropertyInterface getProperty(ModelPropertyInterface mp) {
        return this.mlayer.getProperty(mp);
    }

    public int getRefCount(RefPair rp) {
        return this.mlayer.getRefCount(rp);
    }

    public ClassInstance getRefProperty(RefPair rp) {
        return this.mlayer.getRefProperty(rp);
    }

    public Structure[] getStructure() {
        return this.structure;
    }

    public TriggerManager getTriggerManager() {
        return this.triggerManager;
    }

    private String getUniqueClassId(MapProperty mp) {
        String txt = null;
        txt = mp.getUniqueValue() != null ? mp.getUniqueValue().toString() : new Integer(mp.getInstId()).toString();
        return " (" + txt + "):";
    }

    public void handleInterfaceUpdate(InterfaceUpdateEvent e) {
        if (!(e instanceof TableUpdateEvent)) {
            this.mlayer.handleInterfaceUpdate(e);
            this.interfaceListener.handleInterfaceUpdate(new InterfaceUpdateEvent(e, this.mlayer.getModelIdentifier()));
        } else {
            this.interfaceListener.handleInterfaceUpdate(new TableUpdateEvent((TableUpdateEvent)e, this.mlayer.getModelIdentifier()));
        }
    }

    public boolean hasModel() {
        return this.loaded;
    }

    public boolean ifObjectExists(Object o) {
        return this.ifobjects.contains(o);
    }

    public boolean importIfObjects(InputStream is, DeployKey[] tk) throws ModelLoadException {
        Vector objects = null;
        int savedFileVersion = 0;
        try {
            ObjectInputStream ois = new ObjectInputStream(is);
            savedFileVersion = ois.readInt();
            ois.readObject();
            ois.readObject();
            this.mergeTriggerConditions(ois);
            objects = this.readObjectVector(ois, savedFileVersion);
            ois.readObject();
            ois.readObject();
            DeployKey[] savedKey = (DeployKey[])ois.readObject();
            ois.readObject();
            ois.close();
            if (!this.isEditable(tk, savedKey)) {
                return false;
            }
        }
        catch (OptionalDataException e) {
            ErrorHandler.reportException(e, this);
            throw new ModelLoadException("Error in reading interface object " + e + " " + e.getMessage());
        }
        catch (ClassNotFoundException e) {
            ErrorHandler.reportException(e, this);
            throw new ModelLoadException("Error in reading interface object  " + e + " " + e.getMessage());
        }
        catch (IOException e) {
            ErrorHandler.reportException(e, this);
            throw new ModelLoadException("Error in reading interface object  " + e + " " + e.getMessage());
        }
        catch (Exception e) {
            ErrorHandler.reportException(e, this);
            throw new ModelLoadException("Error in reading interface object " + e + " " + e.getMessage());
        }
        if (this.editHelper != null) {
            int i = objects.size() - 1;
            while (i >= 0) {
                this.editHelper.addBean((BeanInterface)objects.elementAt(i));
                --i;
            }
        } else {
            if (this.dp != null) {
                this.dp.showError("No edit client to add imported objects to");
            }
            ErrorHandler.reportMessage("No edit client to add imported objects to");
        }
        return true;
    }

    public boolean importIfObjectsFile(String fname, DeployKey[] tk) throws ModelLoadException {
        if (this.model == null) {
            this.readIfObjectsFile(fname);
            return true;
        }
        try {
            return this.importIfObjects(new FileInputStream(fname), tk);
        }
        catch (IOException ioerr) {
            throw new ModelLoadException("Cannot import from " + fname + " " + ioerr);
        }
    }

    private static final void initialiseEngine() throws DeployException {
        try {
            eng = new RSAEngine();
            eng = new OAEPDecoder(eng);
            pk = new RSAKeyParameters(false, m, pe);
            eng.init(false, pk);
        }
        catch (Exception e) {
            throw new DeployException("Error creating crypto engine " + e);
        }
    }

    public void invokeActionMethod(int actionNumber) {
        this.actionListener.handleActionEvent(new JelsimActionEvent(actionNumber));
    }

    public void invokeActionMethod(String methodName) {
        Vector v = this.mlayer.getActionMenuStrings();
        int i = 0;
        while (i < v.size()) {
            if (((String)v.elementAt(i)).equals(methodName)) {
                this.invokeActionMethod(i);
                return;
            }
            ++i;
        }
        this.dp.showError("Action method name " + methodName + " not registered");
    }

    public void invokeFileSpecial(int fsno, String fname) {
        this.actionListener.handleActionEvent(new JelsimActionEvent(fsno, fname));
    }

    public boolean isApplet() {
        return false;
    }

    public boolean isBuilderModel() {
        if (this.model != null) {
            return this.model.isBuilderModel();
        }
        return false;
    }

    public final boolean isEditable(DeployKey[] tk) {
        return this.isEditable(tk, this.deployKeys);
    }

    public final boolean isEditable(DeployKey[] tk, DeployKey[] deployKeys) {
        DeployCode savedCode;
        boolean editable = false;
        if (deployKeys == null) {
            return true;
        }
        try {
            savedCode = ModelAccess.key2code(deployKeys[0]);
        }
        catch (DeployException deployException) {
            ErrorHandler.printMessage("The deploy keys for the loaded interface were corrupt, editing not possible");
            return false;
        }
        if (savedCode.isEditingAllowed()) {
            return true;
        }
        if (savedCode.getCid().equals("js")) {
            return true;
        }
        if (tk == null) {
            ErrorHandler.printMessage("No tool key was found, editing of the saved interface has been blocked");
            return false;
        }
        try {
            DeployCode tcode = ModelAccess.key2code(tk[0]);
            if (tcode.getCid().equals(savedCode.getCid())) {
                return true;
            }
            ErrorHandler.printMessage("The saved interface was created by a different user");
            ErrorHandler.printMessage("who has blocked editing of the interface.");
            return false;
        }
        catch (DeployException deployException) {
            ErrorHandler.printMessage("The tool key could not be decoded, editing of the saved interface has been blocked");
            return false;
        }
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public boolean isLocal() {
        return this.local;
    }

    public static synchronized DeployCode key2code(DeployKey key) throws DeployException {
        DeployCode dc = null;
        byte[] dbytes = null;
        if (eng == null) {
            ModelAccess.initialiseEngine();
        }
        byte[] bytes = Hex.decode(key.getKey());
        try {
            eng.init(false, pk);
            int inBlockSize = eng.getInputBlockSize();
            int outBlockSize = eng.getOutputBlockSize();
            int numberBlocks = bytes.length / inBlockSize;
            byte[] buildBuffer = new byte[numberBlocks * outBlockSize];
            byte[] buffer = null;
            int inIndex = 0;
            int outIndex = 0;
            int dataLength = 0;
            int i = 0;
            while (i < numberBlocks) {
                buffer = eng.processBlock(bytes, inIndex, inBlockSize);
                System.arraycopy(buffer, 0, buildBuffer, outIndex, buffer.length);
                inIndex += inBlockSize;
                outIndex += outBlockSize;
                dataLength += buffer.length;
                ++i;
            }
            dbytes = new byte[dataLength];
            System.arraycopy(buildBuffer, 0, dbytes, 0, dataLength);
        }
        catch (Exception e) {
            System.err.println("Unable to decode key " + e);
            e.printStackTrace();
            throw new DeployException("Error decrypting license key", e);
        }
        dc = (DeployCode)Wrapper.unwrapData(dbytes);
        return dc;
    }

    public void loadBean(Frame parent) {
    }

    private void loadComponent(ObjectInputStream ois) throws IOException {
        Object o = null;
        int version = ois.readInt();
        try {
            o = ois.readObject();
            if (o instanceof JSClassHelper) {
                JSClassHelper helper = (JSClassHelper)o;
                BeanReadHelper readHelper = BeanReadHelper.getReadHelper();
                o = helper.newInstance();
                if (o instanceof JSExternalizableBean) {
                    readHelper.restoreBean(helper, (JSExternalizableBean)o);
                }
            }
            ois.close();
        }
        catch (ClassNotFoundException cnf) {
            ErrorHandler.reportExceptionExtra(cnf, "Failed to locate IfObject during load" + cnf.getMessage(), this);
        }
        if (o != null) {
            Component c = (Component)o;
            Rectangle bounds = c.getBounds();
            c.setBounds(0, 0, bounds.width, bounds.height);
            this.addIfObject((BeanInterface)o);
            this.editHelper.initialiseBean((BeanInterface)((Object)c));
        }
    }

    public void loadComponent(String fname) throws ModelLoadException {
        try {
            this.loadComponent(new ObjectInputStream(new FileInputStream(fname)));
        }
        catch (IOException ioe) {
            ErrorHandler.reportExceptionExtra(ioe, "Cannot read from " + fname, this);
            throw new ModelLoadException("Unable to load bean " + fname);
        }
    }

    public abstract boolean loadModel(String var1, ObjectInputStream var2, int var3) throws Exception;

    private void mergeTriggerConditions(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.triggerManager.mergeTriggerConditions(this.readTriggerObjects(ois));
    }

    public void newRefInstance(ClassInstance cpi) {
        this.newRefInstance(cpi, null);
    }

    public void newRefInstance(ClassInstance cpi, String pname) {
        cpi.setRefPair(null);
        this.refListener.handleRefUpdate(new RefUpdateEvent(new RefUpdate(cpi, pname)));
    }

    public void readIfObjects(InputStream is) throws ModelLoadException {
        Vector objects = null;
        int savedFileVersion = 0;
        try {
            ObjectInputStream ois = new ObjectInputStream(is);
            savedFileVersion = this.readModelInfo(ois);
            objects = this.readObjectVector(ois, savedFileVersion);
            this.annotation = ois.readObject();
            this.dp.setAnnotation(this.annotation);
            this.dp.setSaveState((PanelSaveState)ois.readObject());
            this.setDeployKeys((DeployKey[])ois.readObject());
            this.setDefaultKeys((DeployKey[])ois.readObject());
            ois.close();
            int i = 0;
            while (i < objects.size()) {
                this.addIfObject((BeanInterface)objects.elementAt(i));
                ++i;
            }
        }
        catch (OptionalDataException e) {
            ErrorHandler.reportException(e, this);
            throw new ModelLoadException("Error in reading interface object " + e + " " + e.getMessage());
        }
        catch (ClassNotFoundException e) {
            ErrorHandler.reportException(e, this);
            throw new ModelLoadException("Error in reading interface object  " + e + " " + e.getMessage());
        }
        catch (IOException e) {
            ErrorHandler.reportException(e, this);
            throw new ModelLoadException("Error in reading interface object  " + e + " " + e.getMessage());
        }
        catch (Exception e) {
            ErrorHandler.reportException(e, this);
            throw new ModelLoadException("Error in reading interface object " + e + " " + e.getMessage());
        }
        this.checkBeanInit(4);
    }

    public void readIfObjectsFile(String fname) throws ModelLoadException {
        try {
            this.readIfObjects(new FileInputStream(ModelAccess.replaceAll(fname, "%20", " ")));
        }
        catch (IOException e) {
            e.printStackTrace();
            ErrorHandler.reportExceptionExtra(e, "Cannot read from: " + fname, this);
            throw new ModelLoadException("Cannot read from: " + fname + "(" + e + ")", e);
        }
    }

    public void readIfObjectsURL(URL url) throws ModelLoadException {
        try {
            URLConnection urlc = url.openConnection();
            urlc.setDefaultUseCaches(true);
            this.readIfObjects(urlc.getInputStream());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ModelLoadException("Cannot read from: " + url + "(" + e + ")", e);
        }
    }

    public void readModelFile(String fileName) throws ModelLoadException {
        ObjectInputStream ois = null;
        try {
            FileInputStream is = new FileInputStream(fileName);
            ois = new ObjectInputStream(is);
            int savedFileVersion = this.readModelInfo(ois);
        }
        catch (ModelLoadException e) {
            ErrorHandler.reportExceptionExtra(e, "Model Access read exception", this);
            throw e;
        }
        catch (FileNotFoundException e) {
            ErrorHandler.reportExceptionExtra(e, "Error while reading model portion of snapshot", this);
            throw new ModelLoadException("Input corrupt, can't find file :" + fileName);
        }
        catch (IOException e) {
            ErrorHandler.reportExceptionExtra(e, "Error while reading model portion of snapshot", this);
            throw new ModelLoadException("Input corrupt, unable to open input out put stream");
        }
    }

    protected int readModelInfo(ObjectInputStream ois) throws ModelLoadException {
        String modelName = null;
        int savedFileVersion = 0;
        try {
            savedFileVersion = ois.readInt();
            modelName = (String)ois.readObject();
            if (modelName != null) {
                this.loadModel(modelName, ois, savedFileVersion);
            } else {
                ois.readObject();
                this.tidyOnLoad();
                this.loaded = false;
            }
            this.readTriggerConditions(ois);
        }
        catch (ModelLoadException e) {
            ErrorHandler.reportExceptionExtra(e, "Error while reading model portion of snapshot", this);
            throw e;
        }
        catch (OptionalDataException e) {
            ErrorHandler.reportException(e, this);
            throw new ModelLoadException("Error reading model information  " + e + " " + e.getMessage());
        }
        catch (ClassNotFoundException e) {
            ErrorHandler.reportException(e, this);
            throw new ModelLoadException("Error reading model information  " + e + " " + e.getMessage());
        }
        catch (IOException e) {
            ErrorHandler.reportException(e, this);
            throw new ModelLoadException("Error reading model information  " + e + " " + e.getMessage());
        }
        catch (Exception e) {
            ErrorHandler.reportException(e, this);
            throw new ModelLoadException("Error reading model information  " + e + " " + e.getMessage());
        }
        return savedFileVersion;
    }

    private Vector readObjectVector(ObjectInputStream ois, int savedFileVersion) throws ModelLoadException, IOException {
        Vector<Object> objects = new Vector<Object>();
        JSClassHelper[] helpers = null;
        try {
            helpers = (JSClassHelper[])ois.readObject();
        }
        catch (InvalidClassException ice) {
            ErrorHandler.reportException(ice, this);
        }
        catch (ClassNotFoundException cnf) {
            ErrorHandler.reportExceptionExtra(cnf, "Failed to locate IfObject during load", this);
        }
        catch (OptionalDataException ode) {
            ErrorHandler.reportException(ode, this);
            if (ode.eof) {
                ois.close();
                throw new ModelLoadException("Unexpected end of file" + ode);
            }
            ois.skipBytes(ode.length);
            ErrorHandler.reportMessage("Interface object helpers ODE:" + ode);
        }
        if (helpers != null) {
            BeanReadHelper readHelper = BeanReadHelper.getReadHelper();
            int i = 0;
            while (i < helpers.length) {
                Object o = helpers[i].newInstance();
                if (o instanceof JSExternalizableBean) {
                    readHelper.restoreBean(helpers[i], (JSExternalizableBean)o);
                    if (o instanceof BeanInterface) {
                        objects.addElement(o);
                        if (o instanceof OverlayInterface) {
                            ((Component)o).setVisible(false);
                        }
                    } else {
                        ErrorHandler.reportMessage("Saved object " + o.getClass().getName() + "not recognised");
                    }
                } else {
                    System.err.println("Internal error 42: non-serialized bean restore error " + o.getClass().getName());
                }
                ++i;
            }
        }
        this.reformLinks(objects);
        return objects;
    }

    private void readTriggerConditions(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.triggerManager.addTriggerConditions(this.readTriggerObjects(ois));
        this.triggersRead = true;
        this.validateTriggerStructures();
    }

    private TriggerCondition[] readTriggerObjects(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        int version = ois.readInt();
        int numberTriggers = ois.readInt();
        TriggerCondition[] tcs = new TriggerCondition[numberTriggers];
        int i = 0;
        while (i < tcs.length) {
            JSClassHelper obj = (JSClassHelper)ois.readObject();
            tcs[i] = (TriggerCondition)obj.newInstance();
            tcs[i].readExternal(ois);
            ++i;
        }
        return tcs;
    }

    private void reformLinks(int numberLinks, Vector objects) {
        int size = objects.size();
        int i = 0;
        while (i < size && numberLinks > 0) {
            Object o = objects.elementAt(i);
            if (o instanceof IfLinkParentInterface && ((IfLinkParentInterface)o).isLinked()) {
                int numberLinked = ((IfLinkParentInterface)o).getNumberLinked();
                int searchLinkId = ((IfLinkParentInterface)o).getLinkId();
                int j = 0;
                while (j < size && numberLinked > 0) {
                    Object oj = objects.elementAt(j);
                    if (oj instanceof IfLinkChildInterface && ((IfLinkChildInterface)oj).getLinkId() == searchLinkId) {
                        ((IfLinkChildInterface)oj).setLinkComponent(searchLinkId, (Component)o);
                        --numberLinked;
                    }
                    ++j;
                }
                --numberLinks;
            }
            ++i;
        }
    }

    private void reformLinks(Vector v) {
        int linkCount = 0;
        Vector v2 = (Vector)v.clone();
        Object element = null;
        int i = 0;
        while (i < v.size()) {
            element = v.elementAt(i);
            if (element instanceof Container) {
                linkCount += this.addContainerComponents(((Container)element).getComponents(), v2);
            }
            if (element instanceof IfLinkParentInterface && ((IfLinkParentInterface)element).isLinked()) {
                ++linkCount;
            }
            ++i;
        }
        this.reformLinks(linkCount, v2);
    }

    public synchronized void removeIfObject(Object o) {
        this.ifobjects.removeElement(o);
    }

    public void removeModelUpdateListener(ModelPropertyInterface mp, ModelUpdateListener listener) {
        this.mlayer.removeModelUpdateListener(mp, listener);
    }

    /*
     * Unable to fully structure code
     */
    public static String replaceAll(String source, String oldStr, String newStr) {
        ErrorHandler.setDebugMode(true);
        sb = new StringBuffer();
        rlen = oldStr.length();
        start = 0;
        rindex = source.indexOf(oldStr);
        if (rindex >= 0) ** GOTO lbl14
        return source;
lbl-1000:
        // 1 sources

        {
            sb.append(source.substring(start, rindex));
            sb.append(newStr);
            start = rindex + rlen;
            rindex = source.indexOf(oldStr, start);
lbl14:
            // 2 sources

            ** while (rindex >= 0)
        }
lbl15:
        // 1 sources

        if (start < source.length()) {
            sb.append(source.substring(start));
        }
        return sb.toString();
    }

    public void replaceBeanInstance(BeanInterface oldBean, BeanInterface newBean) {
        int index = this.ifobjects.indexOf(oldBean);
        if (index >= 0) {
            newBean.setLocalId(oldBean.getLocalId());
            newBean.setGlobalId(oldBean.getGlobalId());
            this.ifobjects.setElementAt(newBean, index);
            oldBean.finalizeJelsim();
            System.err.println(String.valueOf(oldBean.getClass().getName()) + " substituted by " + newBean.getClass().getName());
            System.err.println("Please verify that this bean functions as expected");
        } else {
            System.err.println("Model access: Unable to replace old bean with new");
        }
    }

    public void saveBean(Frame parent) {
    }

    public void setBaseURL(URL url) {
        this.baseURL = url;
    }

    public final void setDefaultKeys(DeployKey[] defaultKeys) {
        this.defaultKeys = defaultKeys;
        if (defaultKeys != null) {
            try {
                this.defaultCode = ModelAccess.key2code(defaultKeys[0]);
            }
            catch (Exception e) {
                System.err.println("Error setting default keys, please contact jelsim");
                e.printStackTrace();
                this.defaultCode = null;
            }
        } else {
            this.defaultCode = null;
        }
        this.setModelStatus();
    }

    public final void setDeployKeys(DeployKey[] deployKeys) {
        this.deployKeys = deployKeys;
        this.setModelStatus();
    }

    public void setDrawingPanel(IfAccess dp) {
        this.dp = dp;
    }

    public void setEditClient(EditClient editClient) {
        if (Beans.isDesignTime() && this.editHelper != null) {
            this.editHelper.setEditClient(editClient);
        }
    }

    public void setEditHelper(EditHelperInterface editHelper) {
        this.editHelper = editHelper;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    private void setLocalIds(Component[] beans) {
        int i = 0;
        while (i < beans.length) {
            if (beans[i] instanceof BeanInterface) {
                BeanInterface bean = (BeanInterface)((Object)beans[i]);
                if (bean.getLocalId() < 0) {
                    bean.setLocalId(this.nextLocalId++);
                }
                if (this.nextLocalId <= bean.getLocalId()) {
                    this.nextLocalId = bean.getLocalId() + 1;
                }
                if (bean instanceof CompoundObject) {
                    this.setLocalIds(((CompoundObject)bean).getComponents());
                } else if (bean instanceof PopupButtonInterface) {
                    this.setLocalIds(((PopupButtonInterface)((Object)bean)).getPanelComponents());
                } else if (bean instanceof OverlayInterface) {
                    this.setLocalIds(((OverlayInterface)((Object)bean)).getComponents());
                }
            }
            ++i;
        }
    }

    public void setMainEditClient(EditClient mainEditClient) {
        this.mainEditClient = (Component)((Object)mainEditClient);
    }

    public void setModelInstance(MainSimClass model) {
        this.model = model;
        this.refListener = model;
        this.actionListener = model;
        this.interfaceListener = model;
        try {
            model.addPropertyUpdateListener(this.mlayer);
            model.setBrowserAccessProvider(this);
        }
        catch (TooManyListenersException tooManyListenersException) {
            System.err.println("Model listener already established");
        }
    }

    private final void setModelStatus() {
        this.modelStatus = 0;
        if (!this.isApplet()) {
            this.modelStatus = 2;
        } else if (this.defaultCode != null) {
            this.modelStatus = this.deployKeys == null ? (this.defaultCode.getCid().equals("js") ? 6 : 1) : this.detModelStatus();
        }
    }

    public void setObjectVector(Vector v) {
        this.reformLinks(v);
        int i = 0;
        while (i < v.size()) {
            this.addIfObject((BeanInterface)v.elementAt(i));
            ++i;
        }
        this.checkBeanInit(4);
    }

    public void setReportGenerator(ReportGenerator rg) {
        this.reportGenerator = rg;
    }

    public void setReportURL(String urlstr) {
        this.reportURLString = urlstr;
    }

    public void setTriggerConditions(TriggerCondition[] conditions) {
        this.triggerManager.addTriggerConditions(conditions);
        this.triggersRead = true;
        this.validateTriggerStructures();
    }

    protected void tidyOnLoad() {
        System.gc();
    }

    private void validateTriggerStructures() {
        if (this.loaded && this.triggersRead) {
            this.createTriggerStructures();
        }
    }
}

