/*
 * Decompiled with CFR 0.152.
 */
package org.jelsim.model.access;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.OptionalDataException;
import java.util.TooManyListenersException;
import java.util.Vector;
import org.jelsim.beans.support.ModelAccessInterface;
import org.jelsim.model.MainSimClass;
import org.jelsim.model.access.BrowserAccessInterface;
import org.jelsim.model.access.ModelAccess;
import org.jelsim.model.access.ModelLoadException;
import org.jelsim.model.event.InterfaceUpdateListener;
import org.jelsim.system.ErrorHandler;
import org.jelsim.userif.deploy.CompleteSaveInterface;
import org.jelsim.userif.deploy.DeployFileProvider;

public class LocalModelAccess
extends ModelAccess
implements InterfaceUpdateListener,
ModelAccessInterface {
    private BrowserAccessInterface browserAccess = null;

    public LocalModelAccess() {
        this.local = true;
        this.model = null;
    }

    public void finalizeJelsim() {
        this.model.finalizeJelsim();
        this.mlayer.finalizeJelsim();
        System.gc();
    }

    public BrowserAccessInterface getBrowserAccess() {
        if (this.browserAccess == null) {
            this.loadBrowserAccess();
        }
        return this.browserAccess;
    }

    public String[] getDeployFiles() {
        if (this.model instanceof DeployFileProvider) {
            return ((DeployFileProvider)((Object)this.model)).getDeployFiles();
        }
        return null;
    }

    private boolean getModelInstance(String ModelName) throws ModelLoadException {
        Class<?> toLoad = null;
        try {
            toLoad = Class.forName(ModelName);
        }
        catch (ClassNotFoundException cnf) {
            ErrorHandler.reportException(cnf, this);
            throw new ModelLoadException("Could not find " + ModelName + ", please check that this model is installed");
        }
        this.loaded = false;
        try {
            this.model = (MainSimClass)toLoad.newInstance();
        }
        catch (InstantiationException ie) {
            throw new ModelLoadException("Error instantiating model class " + ie);
        }
        catch (IllegalAccessException iae) {
            throw new ModelLoadException("Error accessing model class " + iae);
        }
        this.refListener = this.model;
        this.actionListener = this.model;
        this.interfaceListener = this.model;
        return true;
    }

    public String getModelName() {
        if (this.model == null) {
            return "noModel";
        }
        return this.model.getClass().getName();
    }

    public void getModelState(CompleteSaveInterface csi, long deployTaskId) {
        if (this.model == null) {
            csi.completeSave(deployTaskId, null, null);
        } else {
            csi.completeSave(deployTaskId, this.model.getSaveState(), this.getDeployFiles());
        }
    }

    private void loadBrowserAccess() {
        try {
            this.browserAccess = (BrowserAccessInterface)Class.forName("org.jelsim.model.access.SystemBrowserAccess").newInstance();
        }
        catch (Exception e) {
            ErrorHandler.reportExceptionExtra(e, "Could create system browser access", this);
        }
    }

    public boolean loadModel(String modelName, ObjectInputStream ois, int saveVersion) throws ModelLoadException {
        if (this.model != null) {
            if (!this.model.getClass().getName().equals(modelName)) {
                throw new ModelLoadException(true);
            }
            this.readModelSetup(ois, saveVersion);
            this.loaded = true;
        } else {
            try {
                this.getModelInstance(modelName);
            }
            catch (ModelLoadException e) {
                throw new ModelLoadException("Error in loading model ", e);
            }
            this.model.setBrowserAccessProvider(this);
            this.readModelSetup(ois, saveVersion);
            try {
                this.model.addPropertyUpdateListener(this.mlayer);
            }
            catch (TooManyListenersException tooManyListenersException) {
                throw new ModelLoadException("Listeners already set for model access");
            }
        }
        return true;
    }

    protected void readModelSetup(ObjectInputStream ois, int saveVersion) throws ModelLoadException {
        if (ois != null) {
            try {
                this.model.setSaveState((Vector)ois.readObject());
            }
            catch (OptionalDataException e) {
                ErrorHandler.reportException(e, this);
                throw new ModelLoadException("Error reading model setup  " + e + " " + e.getMessage());
            }
            catch (ClassNotFoundException e) {
                ErrorHandler.reportException(e, this);
                throw new ModelLoadException("Error reading model setup  " + e + " " + e.getMessage());
            }
            catch (IOException e) {
                ErrorHandler.reportException(e, this);
                throw new ModelLoadException("Error reading model setup  " + e + " " + e.getMessage());
            }
        } else {
            this.checkBeanInit(4);
        }
    }

    protected void tidyOnLoad() {
        if (this.model != null) {
            this.model.finalizeJelsim();
        }
        if (this.mlayer != null) {
            this.mlayer.finalizeJelsim();
        }
        this.model = null;
        super.tidyOnLoad();
    }
}

