/*
 * Decompiled with CFR 0.152.
 */
package org.jelsim.model;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Vector;
import org.jelsim.model.Property;
import org.jelsim.model.PropertyAccessor;
import org.jelsim.model.SimClass;
import org.jelsim.model.event.PropertyUpdateListener;
import org.jelsim.model.map.ClassInstance;
import org.jelsim.system.ErrorHandler;

public class VectorProperty
extends Property {
    public int classProp = -1;
    private Method addMethod = null;
    private Method deleteMethod = null;
    private Method insertMethod = null;
    private Method replaceMethod = null;
    private Method clearMethod = null;

    protected VectorProperty(SimClass sc, String propertyName, String fieldName, PropertyAccessor pa, int id, int gid) {
        super(sc, propertyName, fieldName, pa, id, gid);
        this.isPrimitive = false;
        Object previousValue = pa.getValue(sc);
        if (!(previousValue instanceof Vector)) {
            ErrorHandler.reportMessage("VectorProperty: attempt to register non vector", this);
            throw new IllegalArgumentException("VectorProperty: nonVector");
        }
        if (((Vector)previousValue).size() > 0) {
            this.simType = 11;
            Object elt = ((Vector)previousValue).elementAt(0);
            if (elt instanceof SimClass) {
                this.classProp = ((SimClass)elt).getClassIdentifier();
            } else {
                this.classProp = -1;
                ErrorHandler.reportMessage("VectorProperty: " + this.name + " invalid element " + elt.getClass().getName(), this);
            }
        } else {
            this.simType = 12;
            ErrorHandler.reportMessage("propertyVector: " + this.name + " type unknown until instantiated ", this);
        }
        this.setUpdateMethods(sc);
    }

    public void add(SimClass baseInstance, Object o) {
        if (this.addMethod != null) {
            Object[] arr = new Object[]{o};
            try {
                this.addMethod.invoke((Object)baseInstance, arr);
            }
            catch (IllegalAccessException illegalAccessException) {
                ErrorHandler.reportMessage("Illegal access to add method for " + this.name, this);
            }
            catch (InvocationTargetException invocationTargetException) {
                ErrorHandler.reportMessage("Add method for " + this.name + " abruptly terminated", this);
            }
        } else {
            ((Vector)this.pa.getValue(baseInstance)).addElement(o);
        }
    }

    public void checkChange(SimClass base, PropertyUpdateListener os) {
    }

    public void clear(SimClass baseInstance) {
        Vector v = (Vector)this.pa.getValue(baseInstance);
        v.removeAllElements();
    }

    public void delete(SimClass baseInstance, int index) {
        if (this.deleteMethod != null) {
            Object[] arr = new Object[]{new Integer(index)};
            Object results = null;
            try {
                results = this.deleteMethod.invoke((Object)baseInstance, arr);
            }
            catch (IllegalAccessException illegalAccessException) {
                ErrorHandler.reportMessage("Illegal access to delete method for " + this.name, this);
            }
            catch (InvocationTargetException ite) {
                ErrorHandler.reportExceptionExtra(ite.getTargetException(), "VectorProperty: Delete method for " + this.name + " abruptly terminated", this);
            }
        } else {
            Vector v = (Vector)this.pa.getValue(baseInstance);
            if (index < v.size()) {
                v.removeElementAt(index);
            } else {
                ErrorHandler.reportMessage("Index out of range for TABLE delete " + this.name, this);
            }
        }
    }

    public ClassInstance[] getCPIS(SimClass base) {
        ClassInstance[] cpis;
        Vector v = (Vector)base.getPreviousValue(this.id);
        if (v == null) {
            cpis = new ClassInstance[]{};
        } else {
            cpis = new ClassInstance[v.size()];
            int i = 0;
            while (i < cpis.length) {
                cpis[i] = ((SimClass)v.elementAt(i)).getCPI();
                ++i;
            }
        }
        return cpis;
    }

    public Vector getCPIVector(SimClass base) {
        Vector v = (Vector)base.getPreviousValue(this.id);
        Vector<ClassInstance> cpVec = new Vector<ClassInstance>();
        if (v != null) {
            int i = 0;
            while (i < v.size()) {
                cpVec.addElement(((SimClass)v.elementAt(i)).getCPI());
                ++i;
            }
        }
        return cpVec;
    }

    public Class getType(SimClass baseInstance) {
        return this.pa.getType(baseInstance);
    }

    public void insert(SimClass baseInstance, int index, Object o) {
        if (this.insertMethod != null) {
            ErrorHandler.reportMessage("Invoking insert method for " + this.name);
            Object[] arr = new Object[]{new Integer(index), o};
            try {
                this.insertMethod.invoke((Object)baseInstance, arr);
            }
            catch (IllegalAccessException illegalAccessException) {
                ErrorHandler.reportMessage("Illegal access to replace method for " + this.name, this);
            }
            catch (InvocationTargetException invocationTargetException) {
                ErrorHandler.reportMessage("Replace method for " + this.name + " abruptly terminated", this);
            }
        } else {
            Vector v = (Vector)this.pa.getValue(baseInstance);
            if (index < v.size()) {
                v.insertElementAt(o, index);
            } else {
                ErrorHandler.reportMessage("Index out of range for TABLE insertion " + this.name, this);
            }
        }
    }

    public void replace(SimClass baseInstance, int index, Object o) {
        if (this.replaceMethod != null) {
            Object[] arr = new Object[]{new Integer(index), o};
            try {
                this.replaceMethod.invoke((Object)baseInstance, arr);
            }
            catch (IllegalAccessException illegalAccessException) {
                ErrorHandler.reportMessage("Illegal access to replace method for " + this.name, this);
            }
            catch (InvocationTargetException ite) {
                ErrorHandler.reportExceptionExtra(ite.getTargetException(), "VectorProperty: Replace method for " + this.name + " abruptly terminated", this);
            }
        } else {
            Vector v = (Vector)this.pa.getValue(baseInstance);
            if (index < v.size()) {
                v.setElementAt(o, index);
            } else {
                ErrorHandler.reportMessage("Index out of range for replace " + this.name, this);
            }
        }
    }

    public void setClassProp(int classProp) {
        this.classProp = classProp;
    }

    protected void setUpdateMethods(SimClass sc) {
        Class[] oarg = new Class[]{new Object().getClass()};
        Class[] ioarg = new Class[]{Integer.TYPE, new Object().getClass()};
        Class[] iarg = new Class[]{Integer.TYPE};
        Class<?> baseClass = sc.getClass();
        try {
            this.addMethod = baseClass.getMethod(String.valueOf(this.fieldName) + "Add", oarg);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            ErrorHandler.reportMessage("Add method not declared for " + this.name, this);
        }
        catch (SecurityException securityException) {
            ErrorHandler.reportMessage("Add method cannot be accessed for " + this.name, this);
        }
        try {
            this.deleteMethod = baseClass.getMethod(String.valueOf(this.fieldName) + "Delete", iarg);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            ErrorHandler.reportMessage("Delete method not declared for " + this.name, this);
        }
        catch (SecurityException securityException) {
            ErrorHandler.reportMessage("Delete method cannot be accessed for " + this.name, this);
        }
        try {
            this.replaceMethod = baseClass.getMethod(String.valueOf(this.fieldName) + "Replace", ioarg);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            ErrorHandler.reportMessage("Replace method not declared for " + this.name, this);
        }
        catch (SecurityException securityException) {
            ErrorHandler.reportMessage("Replace method cannot be accessed for " + this.name, this);
        }
        try {
            this.insertMethod = baseClass.getMethod(String.valueOf(this.fieldName) + "Insert", ioarg);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            ErrorHandler.reportMessage("Insert method not declared for " + this.name, this);
        }
        catch (SecurityException securityException) {
            ErrorHandler.reportMessage("Insert method cannot be accessed for " + this.name, this);
        }
        try {
            this.clearMethod = baseClass.getMethod(String.valueOf(this.fieldName) + "Clear", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            ErrorHandler.reportMessage("Clear method not declared for " + this.name, this);
        }
        catch (SecurityException securityException) {
            ErrorHandler.reportMessage("Clear method cannot be accessed for " + this.name, this);
        }
    }
}

