/*
 * Decompiled with CFR 0.152.
 */
package org.jelsim.model;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Vector;
import org.jelsim.model.ClassRegister;
import org.jelsim.model.MainSimClass;
import org.jelsim.model.Property;
import org.jelsim.model.PropertyRegister;
import org.jelsim.model.RefClass;
import org.jelsim.model.RefPair;
import org.jelsim.model.SaveState;
import org.jelsim.model.SimConst;
import org.jelsim.model.event.PropertyUpdateListener;
import org.jelsim.model.map.ClassInstance;
import org.jelsim.model.map.ClassTemplate;
import org.jelsim.model.map.MapProperty;
import org.jelsim.model.map.MapStore;
import org.jelsim.system.ErrorHandler;

public class SimClass
implements SimConst {
    protected PropertyRegister reg = null;
    private int instanceNo;
    public String uniqueIdStr;
    private boolean alreadyRegistered = false;
    private ClassRegister rc = null;
    private Object[] previousValues;
    private Object[] savedValues = null;
    private boolean saveOutputs = false;
    protected MainSimClass mainClass = null;
    protected boolean alreadySaved = false;
    static /* synthetic */ Class class$org$jelsim$model$SimClass;
    static /* synthetic */ Class class$org$jelsim$model$MainSimClass;

    public SimClass() {
        if (this instanceof MainSimClass) {
            this.reg = PropertyRegister.getSimRegister((MainSimClass)this, this);
            this.mainClass = (MainSimClass)this;
        } else {
            this.reg = PropertyRegister.getLoadingRegister();
            if (this.reg != null) {
                this.mainClass = this.reg.getMainSimClass();
                this.reg = PropertyRegister.getSimRegister(this.mainClass, this);
            } else {
                ErrorHandler.printMessage("Warning: Simulation class created without main reference " + this.getClass().getName());
                String name = this.getClass().getName();
                String modelName = null;
                if (name.startsWith("MultiVerse")) {
                    modelName = name.substring(0, name.lastIndexOf(46));
                    modelName = modelName.substring(modelName.lastIndexOf(46) + 1);
                } else {
                    ErrorHandler.printMessage("Please ensure that the model resides under the MultiVerse directory");
                }
                this.reg = PropertyRegister.getSimRegister(modelName, this);
            }
        }
        this.registerUniqueField("uniqueIdStr");
    }

    public SimClass(String modelName) {
        ErrorHandler.printMessage("Warning: Simulation class created without main reference " + this.getClass().getName());
        this.reg = PropertyRegister.getSimRegister(modelName, this);
        this.registerUniqueField("uniqueIdStr");
    }

    public SimClass(MainSimClass modelInstance) {
        this.reg = PropertyRegister.getSimRegister(modelInstance, this);
        this.mainClass = modelInstance;
        this.registerUniqueField("uniqueIdStr");
    }

    public void checkChanges(PropertyUpdateListener l) {
        if (this.previousValues != null) {
            Vector pvec = this.rc.getOutputProperties();
            int length = pvec.size();
            int i = 0;
            while (i < length) {
                ((Property)pvec.elementAt(i)).checkChange(this, l);
                ++i;
            }
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private Object createClassInstance(Constructor constructor) {
        Object instance = null;
        try {
            instance = constructor.newInstance(this);
        }
        catch (IllegalAccessException iacce) {
            iacce.printStackTrace();
        }
        catch (IllegalArgumentException iarge) {
            iarge.printStackTrace();
        }
        catch (InstantiationException ie) {
            ie.printStackTrace();
        }
        catch (InvocationTargetException ite) {
            ite.printStackTrace();
        }
        catch (ExceptionInInitializerError eiie) {
            eiie.printStackTrace();
        }
        return instance;
    }

    public SimClass createSimClass(String className) {
        Class newSimClass;
        SimClass SimClassInst = null;
        Constructor SimConstructor = null;
        if ((class$org$jelsim$model$SimClass != null ? class$org$jelsim$model$SimClass : (class$org$jelsim$model$SimClass = SimClass.class$("org.jelsim.model.SimClass"))).isAssignableFrom(newSimClass = this.getClassObject(className))) {
            SimConstructor = this.getDynamicClassConstructor(newSimClass, new Class[]{class$org$jelsim$model$MainSimClass != null ? class$org$jelsim$model$MainSimClass : (class$org$jelsim$model$MainSimClass = SimClass.class$("org.jelsim.model.MainSimClass"))});
        }
        if (SimConstructor == null) {
            ErrorHandler.printMessage("Failed to load SimClass " + className);
        } else {
            SimClassInst = (SimClass)this.createClassInstance(SimConstructor);
            this.reg.checkStructureUpdate(SimClassInst);
        }
        return SimClassInst;
    }

    protected void extendPropertyStorage(Property newProperty) {
        int oldLength = this.previousValues.length;
        Object[] newPrevious = new Object[oldLength + 1];
        Object[] newSaved = new Object[oldLength + 1];
        int i = 0;
        while (i < oldLength) {
            newPrevious[i] = this.previousValues[i];
            newSaved[i] = this.savedValues[i];
            ++i;
        }
        newPrevious[oldLength] = newProperty.getValue(this);
        this.previousValues = newPrevious;
        this.savedValues = newSaved;
    }

    public void finalizeJelsim() {
        this.reg.removeClassInstance(this);
    }

    public void flushTriggerConditions() {
        this.reg.flushTriggerConditions();
    }

    public ClassInstance getCPI() {
        ClassTemplate template = this.rc.getClassTemplate();
        int[] types = template.getTypes();
        MapStore[] ms = new MapStore[template.size()];
        int i = 0;
        while (i < ms.length) {
            ms[i] = new MapStore(types[i]);
            if (types[i] > 10000) {
                ms[i].setValue(this.rc.getPropertyValue(this, i));
            } else if (types[i] != 12) {
                if (types[i] == 10) {
                    ms[i].setValue(((RefClass)this.rc.getPropertyValue(this, i)).getRefPair());
                } else if (types[i] == 9) {
                    ms[i].setValue(((SimClass)this.rc.getPropertyValue(this, i)).getCPI());
                } else if (types[i] == 11) {
                    Vector table = (Vector)this.rc.getPropertyValue(this, i);
                    Vector<RefPair> v = new Vector<RefPair>(table.size());
                    if (table.size() > 0) {
                        if (table.elementAt(0) instanceof RefClass) {
                            int j = 0;
                            while (j < table.size()) {
                                v.addElement(((RefClass)table.elementAt(j)).getRefPair());
                                ++j;
                            }
                        } else {
                            ErrorHandler.printMessage("Can only register Vectors of RefClass in class property: property=" + i);
                        }
                        ms[i].setValue(v);
                    }
                } else {
                    ms[i].setValue(this.rc.getPropertyValue(this, i));
                }
            }
            ++i;
        }
        return new ClassInstance(this.getClassIdentifier(), this.getInstance(), ms, this.rc.getClassTemplate());
    }

    private Constructor getClassConstructor(Class newClass) {
        return this.getClassConstructor(newClass, new Class[0]);
    }

    private Constructor getClassConstructor(Class newClass, Class[] paramTypes) {
        Constructor createdConstr = null;
        try {
            createdConstr = newClass.getConstructor(paramTypes);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            ErrorHandler.printMessage("MainSimClass: unable to get contructor " + newClass.getName() + " Find error");
        }
        catch (SecurityException securityException) {
            ErrorHandler.printMessage("MainSimClass: unable to get contructor " + newClass.getName() + " Security error");
        }
        return createdConstr;
    }

    protected int getClassIdentifier() {
        return this.rc != null ? this.rc.getClassIdentifier() : -1;
    }

    private Class getClassObject(String className) {
        Class<?> loadedClass = null;
        try {
            loadedClass = Class.forName(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ErrorHandler.printMessage("MainSimClass: unable to create " + className + " find error");
        }
        return loadedClass;
    }

    public Object getCustomSaveData() {
        return null;
    }

    private Constructor getDynamicClassConstructor(Class newComponentClass, Class[] constructorParamTypes) {
        Constructor componentConstructor = null;
        componentConstructor = this.getClassConstructor(newComponentClass, constructorParamTypes);
        if (componentConstructor == null) {
            componentConstructor = this.getClassConstructor(newComponentClass);
            ErrorHandler.printMessage("MainSimClass: Parameterless constructor used for ModelComponent");
        }
        return componentConstructor;
    }

    public int getInstance() {
        return this.instanceNo;
    }

    protected MapProperty[] getMapProperties() {
        Property[] allProperties = this.rc.getProperties();
        MapProperty[] mps = new MapProperty[allProperties.length];
        int i = 0;
        while (i < mps.length) {
            mps[i] = allProperties[i].getMapProperty(this);
            ++i;
        }
        return mps;
    }

    public int getModelIdentifier() {
        return this.reg.getModelIdentifier();
    }

    private Object[] getNameValues(Vector properties) {
        String[] names = new String[properties.size()];
        Object[] values = new Object[names.length];
        int i = 0;
        while (i < names.length) {
            Property p = (Property)properties.elementAt(i);
            names[i] = p.getName();
            values[i] = p.getValue(this);
            if (values[i] instanceof SimClass) {
                values[i] = ((SimClass)values[i]).getSaveStateForAllObjs();
            } else if (values[i] instanceof Vector) {
                values[i] = this.getVectorSaveState((Vector)values[i]);
            }
            ++i;
        }
        return new Object[]{names, values};
    }

    protected Object getPreviousValue(int index) {
        if (this.previousValues == null) {
            ErrorHandler.printMessage("SimClass.getPreviousValue: previousValues was null!", this);
            return null;
        }
        if (index >= this.previousValues.length) {
            ErrorHandler.printMessage("SimClass.getPreviousValue: out of bounds index " + index + ",length " + this.previousValues.length, this);
            return null;
        }
        if (this.previousValues[index] == null) {
            Property[] allProperties = this.rc.getProperties();
            this.previousValues[allProperties[index].getInClassId()] = allProperties[index].getValue(this);
        }
        return this.previousValues[index];
    }

    protected ClassRegister getRegisteredClass() {
        return this.rc;
    }

    private SimClass getRestoredClassInstance(SaveState sst) {
        SimClass restoreClass = this.reg.getUniqueInstance(sst);
        if (restoreClass == null) {
            restoreClass = (SimClass)SimClass.newInstance(this.reg, sst.getClassName(), null);
            if (restoreClass != null) {
                restoreClass.setSaveState(sst);
            }
        } else {
            restoreClass.setSaveState(sst);
        }
        return restoreClass;
    }

    protected SaveState getSaveStateForAllObjs() {
        SaveState saver = new SaveState(this.getClass().getName());
        Object[] nameValues = this.getNameValues(this.rc.getInputProperties());
        saver.setInputNames((String[])nameValues[0]);
        saver.setInputValues((Object[])nameValues[1]);
        if (this.saveOutputs) {
            Vector outputs = this.rc.getOutputProperties();
            Vector v = new Vector(outputs.size());
            int i = 0;
            while (i < outputs.size()) {
                if (((Property)outputs.elementAt(i)).getIOType() == 1) {
                    v.addElement(outputs.elementAt(i));
                }
                ++i;
            }
            nameValues = this.getNameValues(v);
            saver.setOutputNames((String[])nameValues[0]);
            saver.setOutputValues((Object[])nameValues[1]);
        }
        saver.setCustomData(this.getCustomSaveData());
        this.alreadySaved = true;
        return saver;
    }

    protected Object getSavedValue(int index) {
        return this.savedValues[index];
    }

    protected ClassTemplate getTemplate() {
        return this.rc.getClassTemplate();
    }

    public String getUniqueIdStr() {
        return this.uniqueIdStr;
    }

    private Object getUniqueInstance(Object uniqueValue) {
        return this.rc.getUniqueInstance(uniqueValue);
    }

    public String getUniqueNameBase() {
        String className = this.getClass().getName();
        return className.substring(className.lastIndexOf(46) + 1);
    }

    private Property getUniqueProperty() {
        return this.rc.getUniqueProperty();
    }

    protected String getUniqueValue() {
        Property p = this.getUniqueProperty();
        if (p != null) {
            return (String)p.getValue(this);
        }
        return null;
    }

    private Vector getVectorSaveState(Vector classInstances) {
        Vector<SaveState> retval = new Vector<SaveState>(classInstances.size());
        int i = 0;
        while (i < classInstances.size()) {
            retval.addElement(((SimClass)classInstances.elementAt(i)).getSaveStateForAllObjs());
            ++i;
        }
        return retval;
    }

    public void initialiseAfterSave() {
    }

    protected void initialisePropertyStorage() {
        Property[] allProperties = this.rc.getProperties();
        this.previousValues = new Object[allProperties.length];
        this.savedValues = new Object[allProperties.length];
        int i = 0;
        while (i < allProperties.length) {
            this.previousValues[allProperties[i].getInClassId()] = allProperties[i].getValue(this);
            ++i;
        }
    }

    protected boolean isAlreadyRegistered() {
        return this.alreadyRegistered;
    }

    public boolean isAlreadySaved() {
        return this.alreadySaved;
    }

    public boolean isSaveOutputs() {
        return this.saveOutputs;
    }

    public void mvClearPrint() {
        this.reg.mvClearPrint();
    }

    public void mvFlushPrint() {
        this.reg.mvFlushPrint();
    }

    public void mvPrint(String str) {
        this.reg.mvPrint(str);
    }

    public void mvPrintln(String str) {
        this.reg.mvPrintln(str);
    }

    public static Object newInstance(PropertyRegister reg, String className, Object[] values) {
        PropertyRegister.setLoadingRegister(reg);
        Class<?> propertyClass = null;
        SimClass inst = null;
        inst = reg.getMainSimClass().createSimClass(className);
        if (inst == null) {
            try {
                propertyClass = Class.forName(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                ErrorHandler.printMessage("simReg: unable to duplicate " + className + " find error");
            }
            try {
                inst = (SimClass)propertyClass.newInstance();
            }
            catch (InstantiationException instantiationException) {
                ErrorHandler.printMessage("simReg: Unable to instantiate duplicate instance of " + className);
            }
            catch (IllegalAccessException illegalAccessException) {
                ErrorHandler.printMessage("simReg: " + className + " duplicate inaccessible ");
            }
        }
        if (values != null && inst != null) {
            inst.setPropertyValues(values);
        }
        PropertyRegister.setLoadingRegister(null);
        return inst;
    }

    public void outputUpdate() {
        if (this.previousValues != null) {
            this.reg.outputUpdate();
        }
    }

    public void registerLinkedProperty(String propertyName, String fieldName, String indexProperty) {
        if (!this.alreadyRegistered) {
            this.reg.registerLinkedProperty(this, propertyName, fieldName, indexProperty);
        }
    }

    public void registerMenuProperty(String menuName, String baseName, String methodName) {
        if (!this.alreadyRegistered) {
            String selected = String.valueOf(baseName) + "Selected";
            String menu = String.valueOf(baseName) + "Menu";
            this.registerProperty(String.valueOf(menuName) + "Selected", selected, 4, methodName);
            this.registerProperty(String.valueOf(menuName) + "Menu", menu, 4);
            this.registerLinkedProperty(menuName, String.valueOf(menu) + "[" + selected + "]", String.valueOf(menuName) + "Selected");
        }
    }

    public void registerProperty(String propertyName, String fieldName, int type) {
        this.registerProperty(propertyName, fieldName, type, null);
    }

    public void registerProperty(String propertyName, String fieldName, int type, String methodName) {
        if (!this.alreadyRegistered) {
            this.reg.registerProperty(this, propertyName, fieldName, type, methodName);
        }
    }

    public void registerUniqueField(String fieldName) {
        if (!this.alreadyRegistered) {
            this.reg.registerUniqueField(this, fieldName);
        }
    }

    public void registrationComplete() {
        if (!this.alreadyRegistered) {
            this.reg.checkStructureUpdate(this);
        }
    }

    public void restoreClassInstance(String propertyName, SaveState sst) {
        Property p = this.rc.getProperty(propertyName);
        if (p != null) {
            SimClass restoreClass = this.reg.getUniqueInstance(sst);
            if (restoreClass == null) {
                restoreClass = (SimClass)p.getValue(this);
                if (restoreClass != null) {
                    restoreClass.setSaveState(sst);
                } else {
                    restoreClass = (SimClass)SimClass.newInstance(this.reg, sst.getClassName(), null);
                    if (restoreClass != null) {
                        restoreClass.setSaveState(sst);
                    }
                }
            } else {
                restoreClass.setSaveState(sst);
            }
            if (restoreClass != null) {
                p.setValue(this, restoreClass);
            } else {
                ErrorHandler.printMessage("simReg: could not create object for " + propertyName + " in " + sst);
            }
        }
    }

    public void restoreProperty(String name) {
        this.reg.restoreProperty(this, name);
    }

    private void restoreVectorProperty(String name, Vector stateVec) {
        Property p = this.rc.getProperty(name);
        Vector currentVec = (Vector)p.getValue(this);
        currentVec.setSize(0);
        int i = 0;
        while (i < stateVec.size()) {
            currentVec.addElement(this.getRestoredClassInstance((SaveState)stateVec.elementAt(i)));
            ++i;
        }
    }

    private void retryPropertyRestore(Vector nameValuePairs) {
        String[] names = new String[nameValuePairs.size()];
        Object[] values = new Object[names.length];
        Vector failedProperties = new Vector();
        int i = 0;
        while (i < names.length) {
            Object[] nvp = (Object[])nameValuePairs.elementAt(i);
            names[i] = (String)nvp[0];
            values[i] = nvp[1];
            ++i;
        }
        this.setNameValues(names, values, failedProperties);
        int i2 = 0;
        while (i2 < failedProperties.size()) {
            ErrorHandler.printMessage("Could not restore " + ((Object[])failedProperties.elementAt(i2))[0] + " no longer registered?", this);
            ++i2;
        }
    }

    protected void sendAllPropertyValues(PropertyUpdateListener l) {
        Property[] allProps = this.rc.getProperties();
        int i = 0;
        while (i < allProps.length) {
            allProps[i].update(this, l);
            ++i;
        }
    }

    public void sendAllUpdates() {
        if (this.previousValues != null) {
            this.reg.sendAllUpdates();
        }
    }

    public void sendUpdate(String propertyName) {
        if (this.previousValues != null) {
            this.reg.sendUpdate(this, propertyName);
        }
    }

    protected void setAlreadyRegistered(boolean b) {
        this.alreadyRegistered = b;
    }

    public void setAlreadySaved(boolean alreadySavedFlag) {
        this.alreadySaved = alreadySavedFlag;
    }

    public void setCustomSaveData(Object v) {
    }

    public void setInstance(int inst) {
        this.instanceNo = inst;
    }

    public void setMVError(String errorString) {
        this.reg.setMVError(errorString);
    }

    private void setNameValues(String[] names, Object[] values, Vector dynamicPairs) {
        int i = 0;
        while (i < names.length) {
            try {
                if (values[i] instanceof SaveState) {
                    this.restoreClassInstance(names[i], (SaveState)values[i]);
                } else if (values[i] instanceof Vector) {
                    this.restoreVectorProperty(names[i], (Vector)values[i]);
                } else {
                    this.setProperty(names[i], values[i]);
                }
            }
            catch (NullPointerException nullPointerException) {
                dynamicPairs.addElement(new Object[]{names[i], values[i]});
            }
            ++i;
        }
    }

    protected void setPreviousValue(int index, Object value) {
        this.previousValues[index] = value;
    }

    public void setProperty(String propertyName, byte val) {
        this.reg.setProperty(this, propertyName, val);
    }

    public void setProperty(String propertyName, char val) {
        this.reg.setProperty(this, propertyName, val);
    }

    public void setProperty(String propertyName, double val) {
        this.reg.setProperty(this, propertyName, val);
    }

    public void setProperty(String propertyName, float val) {
        this.reg.setProperty(this, propertyName, val);
    }

    public void setProperty(String propertyName, int val) {
        this.reg.setProperty(this, propertyName, val);
    }

    public void setProperty(String propertyName, long val) {
        this.reg.setProperty(this, propertyName, val);
    }

    public void setProperty(String propertyName, Object val) {
        this.reg.setProperty(this, propertyName, val);
    }

    public void setProperty(String propertyName, short val) {
        this.reg.setProperty(this, propertyName, val);
    }

    public void setProperty(String propertyName, boolean val) {
        this.reg.setProperty(this, propertyName, new Boolean(val).toString());
    }

    protected void setPropertyValues(Object[] values) {
        int[] types = this.rc.getClassTemplate().getTypes();
        int i = 0;
        while (i < values.length) {
            if (types[i] == 10) {
                values[i] = this.reg.getRefClass((RefPair)values[i]);
            } else if (types[i] == 11) {
                values[i] = this.reg.convertRefPairs((Vector)values[i]);
            }
            this.rc.setPropertyValue(this, i, values[i]);
            ++i;
        }
    }

    protected void setPropertyValues(MapStore[] ms) {
        Object[] objs = new Object[ms.length];
        int i = 0;
        while (i < objs.length) {
            objs[i] = ms[i].getValue();
            ++i;
        }
        this.setPropertyValues(objs);
    }

    protected void setRegisteredClass(ClassRegister rc) {
        this.rc = rc;
    }

    public void setSaveOutputs(boolean v) {
        this.saveOutputs = v;
    }

    public void setSaveState(SaveState sst) {
        Object[] values;
        String[] names;
        Vector dynamicPropertyCandidates = new Vector(5);
        if (!sst.getClassName().equals(this.getClass().getName())) {
            ErrorHandler.printMessage("SimClass: set state name clash " + sst.getClassName() + " " + this.getClass().getName());
            return;
        }
        if (sst.getInputNames() != null) {
            names = sst.getInputNames();
            values = sst.getInputValues();
            this.setNameValues(names, values, dynamicPropertyCandidates);
        }
        if (sst.getOutputNames() != null) {
            names = sst.getOutputNames();
            values = sst.getOutputValues();
            this.setNameValues(names, values, dynamicPropertyCandidates);
        }
        this.setCustomSaveData(sst.getCustomData());
        this.initialiseAfterSave();
        this.retryPropertyRestore(dynamicPropertyCandidates);
    }

    protected void setSavedValue(int index, Object value) {
        this.savedValues[index] = value;
    }

    public void setUniqueIdStr() {
        this.uniqueIdStr = String.valueOf(this.getUniqueNameBase()) + this.getInstance();
    }
}

