/*
 * Decompiled with CFR 0.152.
 */
package org.jelsim.model;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.jelsim.model.ClassRegister;
import org.jelsim.model.DotProperty;
import org.jelsim.model.LinkedProperty;
import org.jelsim.model.MainSimClass;
import org.jelsim.model.Property;
import org.jelsim.model.PropertyAccessor;
import org.jelsim.model.RefClass;
import org.jelsim.model.RefPair;
import org.jelsim.model.RegUpdate;
import org.jelsim.model.SaveState;
import org.jelsim.model.SimClass;
import org.jelsim.model.SimConst;
import org.jelsim.model.VectorProperty;
import org.jelsim.model.event.InterfaceUpdateEvent;
import org.jelsim.model.event.PropertyUpdateEvent;
import org.jelsim.model.event.PropertyUpdateListener;
import org.jelsim.model.event.RefUpdateEvent;
import org.jelsim.model.event.TableUpdateEvent;
import org.jelsim.model.map.ClassInstance;
import org.jelsim.model.map.ClassTemplate;
import org.jelsim.model.map.MapProperty;
import org.jelsim.model.map.MapStore;
import org.jelsim.model.map.RefUpdate;
import org.jelsim.system.ErrorHandler;

public final class PropertyRegister
implements SimConst {
    public static String lineSep = System.getProperty("line.separator");
    private static Hashtable allRegisters = null;
    private String modelName = null;
    private Hashtable classReg = null;
    private Vector classRegVec = null;
    private String baseClass = null;
    private int ClassRegisteres = 0;
    private static int nextModelIdentifier = 0;
    private int modelIdentifier = 0;
    private MainSimClass modelInstance = null;
    private int duplicatePropCount = 0;
    private Vector customObjectStrings = null;
    private Vector fileMethods = null;
    private Vector fileMenuStrings = null;
    private Vector actionMethods = null;
    private Vector actionMenuStrings = null;
    private Hashtable propertiesByName = null;
    private PropertyUpdateListener propertyListener;
    protected boolean regInfoSent = false;
    protected StringBuffer mvText = new StringBuffer();
    private static Hashtable instanceRegisters = null;
    private Vector modelClassInstances = null;
    private static PropertyRegister loadingRegister = null;

    private PropertyRegister(String modelName, String baseName) {
        this.modelName = modelName;
        this.classReg = new Hashtable();
        this.classRegVec = new Vector(5);
        this.propertiesByName = new Hashtable();
        ErrorHandler.reportMessage("Base class set to " + modelName);
        this.baseClass = baseName;
    }

    public void addByName(String className, Property p) {
        if (this.propertyAlreadyRegistered(className, p.name)) {
            p.name = String.valueOf(p.name) + this.duplicatePropCount++;
            ErrorHandler.reportMessage("Duplicate property in class " + className + " changed to " + p.name, this);
        }
        this.propertiesByName.put(String.valueOf(className) + p.name, p);
    }

    private void addClassInstance(SimClass c) {
        if (this.modelClassInstances == null) {
            this.modelClassInstances = new Vector(5, 5);
        }
        this.modelClassInstances.addElement(c);
    }

    private void checkInstanceNumbers() {
        int i = 0;
        while (i < this.classRegVec.size()) {
            ((ClassRegister)this.classRegVec.elementAt(i)).checkRestoredInstanceNumbers();
            ++i;
        }
    }

    protected void checkStructureUpdate(SimClass base) {
        ClassRegister rc;
        if (this.regInfoSent && (rc = (ClassRegister)this.classRegVec.elementAt(base.getClassIdentifier())).getInstanceCount() == 1) {
            this.propertyListener.handlePropertyUpdate(new PropertyUpdateEvent(3, this.getClassPropertyTemplates()));
            base.initialisePropertyStorage();
            this.propertyListener.handlePropertyUpdate(new PropertyUpdateEvent(2, base.getClassIdentifier(), base.getMapProperties()));
        }
        this.sendClassUpdate(base);
    }

    protected Vector convertRefPairs(Vector v) {
        int i = 0;
        while (i < v.size()) {
            v.setElementAt(this.getRefClass((RefPair)v.elementAt(i)), i);
            ++i;
        }
        return v;
    }

    private Property createProperty(ClassRegister rc, SimClass sc, String propName, String fieldName, int type, String methodName) {
        Property p = null;
        String className = sc.getClass().getName();
        return p;
    }

    public void deleteClassInstance(String className, String uniqueIdString) {
        ClassRegister rc = (ClassRegister)this.classReg.get(className);
        this.removeClassInstance(rc.removeInstance(uniqueIdString));
        this.propertyListener.handlePropertyUpdate(new PropertyUpdateEvent(5, rc.getClassIdentifier(), uniqueIdString));
    }

    public void encodeRegInfo() {
        int i = 0;
        while (i < this.modelClassInstances.size()) {
            ((SimClass)this.modelClassInstances.elementAt(i)).initialisePropertyStorage();
            ++i;
        }
        this.propertyListener.reset();
        this.propertyListener.handlePropertyUpdate(new PropertyUpdateEvent(4, this.getEncodeVector(), this.modelIdentifier));
        this.regInfoSent = true;
    }

    private void finalizeClassReg() {
        if (this.classReg != null) {
            this.classReg.clear();
            this.classReg = null;
        }
        if (this.classRegVec != null) {
            int i = 0;
            while (i < this.classRegVec.size()) {
                ((ClassRegister)this.classRegVec.elementAt(i)).finalizeJelsim();
                ++i;
            }
            this.classRegVec.removeAllElements();
            this.classRegVec = null;
        }
    }

    void finalizeJelsim() {
        if (instanceRegisters != null && this.modelInstance != null) {
            instanceRegisters.remove(this.modelInstance);
        } else if (allRegisters != null) {
            allRegisters.remove(this.modelName);
        }
        this.finalizeClassReg();
        this.baseClass = null;
        this.ClassRegisteres = 0;
        this.propertiesByName.clear();
        this.propertiesByName = null;
        this.propertyListener = null;
        this.fileMethods = null;
        this.fileMenuStrings = null;
        this.customObjectStrings = null;
        this.actionMethods = null;
        this.actionMenuStrings = null;
        if (this.modelClassInstances != null) {
            this.modelClassInstances.removeAllElements();
            this.modelClassInstances = null;
        }
    }

    public void flushTriggerConditions() {
        this.propertyListener.handlePropertyUpdate(new PropertyUpdateEvent(6));
    }

    private SimClass getBaseInstance(int classId, int iid) {
        return ((ClassRegister)this.classRegVec.elementAt(classId)).getInstance(iid);
    }

    private ClassTemplate[] getClassPropertyTemplates() {
        ClassTemplate[] cpt = new ClassTemplate[this.classRegVec.size()];
        int i = 0;
        while (i < cpt.length) {
            cpt[i] = ((ClassRegister)this.classRegVec.elementAt(i)).getClassTemplate();
            ++i;
        }
        return cpt;
    }

    private ClassTemplate getClassTemplate(int classId) {
        return ((ClassRegister)this.classRegVec.elementAt(classId)).getClassTemplate();
    }

    protected RegUpdate getEncodeVector() {
        RegUpdate v = new RegUpdate();
        v.addElement(this.getInstanceMapProperties());
        v.addElement(this.getClassPropertyTemplates());
        v.addElement(this.fileMenuStrings);
        v.addElement(this.actionMenuStrings);
        v.addElement(this.baseClass);
        v.addElement(this.customObjectStrings);
        return v;
    }

    private static int getIdentifier() {
        return nextModelIdentifier++;
    }

    private Vector getInstanceMapProperties() {
        Vector<Vector> v = new Vector<Vector>(5);
        int i = 0;
        while (i < this.classRegVec.size()) {
            v.addElement(((ClassRegister)this.classRegVec.elementAt(i)).getInstanceMapProperties());
            ++i;
        }
        return v;
    }

    protected static PropertyRegister getLoadingRegister() {
        return loadingRegister;
    }

    protected MainSimClass getMainSimClass() {
        return this.modelInstance;
    }

    private Method getMethod(String name, Class[] params) {
        Method method = null;
        try {
            method = this.modelInstance.getClass().getMethod(name, params);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            ErrorHandler.reportError("Method " + name + " not found in " + this.modelInstance.getClass().getName(), this);
            return null;
        }
        catch (SecurityException securityException) {
            ErrorHandler.reportError("simReg: method security exception for " + name, this);
            return null;
        }
        return method;
    }

    public int getModelIdentifier() {
        return this.modelIdentifier;
    }

    public String getModelName() {
        return this.modelName;
    }

    private Property getProperty(int classId, int pid) {
        return ((ClassRegister)this.classRegVec.elementAt(classId)).getProperty(pid);
    }

    public SimClass getRefClass(RefPair pair) {
        return this.getBaseInstance(pair.getRefId(), pair.getInstId());
    }

    protected Object getSaveState() {
        Vector<SaveState> stateInfo = new Vector<SaveState>(10, 10);
        int i = 0;
        while (i < this.classRegVec.size()) {
            ((ClassRegister)this.classRegVec.elementAt(i)).initialiseSave();
            ++i;
        }
        stateInfo.addElement(this.modelInstance.getSaveStateForAllObjs());
        int i2 = 1;
        while (i2 < this.classReg.size()) {
            ClassRegister rc = (ClassRegister)this.classRegVec.elementAt(i2);
            Vector allInstances = rc.getAllInstances();
            int j = 0;
            while (j < allInstances.size()) {
                SimClass base = (SimClass)allInstances.elementAt(j);
                stateInfo.addElement(base.getSaveStateForAllObjs());
                ++j;
            }
            ++i2;
        }
        return stateInfo;
    }

    protected static PropertyRegister getSimRegister(String modelName) {
        if (allRegisters != null) {
            return (PropertyRegister)allRegisters.get(modelName);
        }
        return null;
    }

    public static PropertyRegister getSimRegister(String modelName, SimClass o) {
        PropertyRegister sr = null;
        if (allRegisters == null) {
            allRegisters = new Hashtable();
        }
        if ((sr = (PropertyRegister)allRegisters.get(modelName)) == null) {
            sr = new PropertyRegister(modelName, o.getClass().getName());
            allRegisters.put(modelName, sr);
        }
        sr.registerClass(o);
        sr.addClassInstance(o);
        if (o instanceof MainSimClass) {
            sr.setModelIdentifier(PropertyRegister.getIdentifier());
        }
        return sr;
    }

    public static PropertyRegister getSimRegister(MainSimClass modelInstance, SimClass o) {
        PropertyRegister sr = null;
        if (instanceRegisters == null) {
            instanceRegisters = new Hashtable();
        }
        if ((sr = (PropertyRegister)instanceRegisters.get(modelInstance)) == null) {
            sr = new PropertyRegister(modelInstance.getClass().getName(), o.getClass().getName());
            instanceRegisters.put(modelInstance, sr);
        }
        sr.registerClass(o);
        sr.addClassInstance(o);
        if (o instanceof MainSimClass) {
            sr.setModelIdentifier(PropertyRegister.getIdentifier());
        }
        return sr;
    }

    private Property getTablePropertyFromName(String tableKey) {
        Property returnValue = null;
        Enumeration classKeys = this.classReg.keys();
        String propertyName = null;
        int instanceCount = 0;
        while (classKeys.hasMoreElements()) {
            propertyName = String.valueOf((String)classKeys.nextElement()) + tableKey;
            if (!this.propertiesByName.containsKey(propertyName)) continue;
            returnValue = (Property)this.propertiesByName.get(propertyName);
            ++instanceCount;
        }
        if (instanceCount > 0) {
            ErrorHandler.reportMessage("Warning more than one table found for " + tableKey, this);
        }
        return returnValue;
    }

    public SimClass getUniqueInstance(SaveState sst) {
        Object uniqueKey;
        SimClass retval = null;
        ClassRegister rc = (ClassRegister)this.classReg.get(sst.getClassName());
        if (rc != null && (uniqueKey = sst.getUniqueValue(rc.getUniqueProperty().getName())) != null) {
            retval = rc.getUniqueInstance(uniqueKey);
        }
        return retval;
    }

    public void handleInterfaceUpdate(InterfaceUpdateEvent e) {
        if (e instanceof TableUpdateEvent) {
            this.handleTableUpdate((TableUpdateEvent)e);
        } else {
            SimClass base = this.getBaseInstance(e.getClassId(), e.getInstId());
            Property p = this.getProperty(e.getClassId(), e.getPropertyId());
            Object value = e.getValue();
            if (value instanceof ClassInstance) {
                MapStore ms = new MapStore(9);
                ms.setValue(value);
                p.setValue(base, ms);
            } else {
                p.setValue(base, (MapStore)value);
            }
            if (this.modelInstance.mainThreadStatus != 4 && (!this.propertyListener.isLocal() || p.name.endsWith("Selected"))) {
                p.update(base, this.propertyListener);
            }
        }
    }

    public void handleRefUpdate(RefUpdateEvent e) {
        this.handleRefUpdate((RefUpdate)e.getSource());
    }

    public void handleRefUpdate(RefUpdate ru) {
        ClassTemplate cpt = this.getClassTemplate(ru.getClassIdentifier());
        Object[] fieldVals = new Object[cpt.size()];
        String updateTableStr = ru.getUpdateProperty();
        Property tableProperty = null;
        SimClass tableBase = null;
        if (updateTableStr != null) {
            tableProperty = this.getTablePropertyFromName(updateTableStr);
            tableBase = this.getBaseInstance(tableProperty.getClassIdentifier(), 0);
        }
        RefClass rc = null;
        MapStore[] ms = ru.getValues();
        int i = 0;
        while (i < ms.length) {
            fieldVals[i] = ms[i].getValue();
            ++i;
        }
        if (ru.getRefPair() == null) {
            SimClass ssc = (SimClass)SimClass.newInstance(this, cpt.getClassName(), fieldVals);
            rc = (RefClass)ssc;
            if (tableProperty != null) {
                if (tableProperty instanceof VectorProperty) {
                    ((VectorProperty)tableProperty).add(tableBase, ssc);
                    tableProperty.update(tableBase, this.propertyListener);
                    if (tableProperty.simType == 12) {
                        ((VectorProperty)tableProperty).setClassProp(ssc.getClassIdentifier());
                        tableProperty.simType = 11;
                    }
                } else {
                    ErrorHandler.reportMessage("attempt to RefUpdate type " + tableProperty.simType + "need to think about this!");
                }
            }
        } else {
            rc = (RefClass)this.getRefClass(ru.getRefPair());
            rc.setPropertyValues(fieldVals);
        }
        if (tableProperty != null) {
            tableProperty.update(tableBase, this.propertyListener);
        }
    }

    public void handleTableUpdate(TableUpdateEvent e) {
        SimClass ssc = null;
        SimClass base = this.getBaseInstance(e.getClassId(), e.getInstId());
        VectorProperty par = (VectorProperty)this.getProperty(e.getClassId(), e.getPropertyId());
        int index = e.getIndex();
        int command = e.getCommand();
        if (command == 4) {
            par.clear(base);
        } else if (command == 2) {
            par.delete(base, e.getIndex());
        } else {
            ClassInstance cpi = (ClassInstance)e.getValue();
            ClassTemplate cpt = this.getClassTemplate(cpi.getClassIdentifier());
            Object[] fieldVals = new Object[cpt.size()];
            MapStore[] ms = cpi.getValues();
            int i = 0;
            while (i < fieldVals.length) {
                fieldVals[i] = ms[i].getValue();
                ++i;
            }
            ssc = (SimClass)SimClass.newInstance(this, cpt.getClassName(), fieldVals);
            switch (command) {
                case 0: {
                    par.replace(base, index, ssc);
                    break;
                }
                case 1: {
                    par.insert(base, index, ssc);
                    break;
                }
                case 3: {
                    par.add(base, ssc);
                    break;
                }
            }
        }
        par.update(base, this.propertyListener);
        this.outputUpdate();
    }

    public void invokeActionMethod(int sno) {
        Method method = (Method)this.actionMethods.elementAt(sno);
        Object[] param = new Object[]{};
        try {
            method.invoke((Object)this.modelInstance, param);
        }
        catch (IllegalAccessException illegalAccessException) {
            ErrorHandler.reportError("Error accessing action method " + this.actionMethods.elementAt(sno), this);
        }
        catch (InvocationTargetException ite) {
            ErrorHandler.reportError("Error during action method execution " + this.actionMethods.elementAt(sno), this);
            ErrorHandler.reportExceptionExtra(ite.getTargetException(), "Exception for eaction method " + this.actionMethods.elementAt(sno), this);
        }
    }

    public void invokeFileSpecial(int sno, String fname) {
        Method method = (Method)this.fileMethods.elementAt(sno);
        Object[] param = new Object[]{fname};
        try {
            method.invoke((Object)this.modelInstance, param);
        }
        catch (IllegalAccessException illegalAccessException) {
            ErrorHandler.reportError("Could not access file special method", this);
        }
        catch (InvocationTargetException ite) {
            ErrorHandler.reportError("Error during file special execution, execption follows", this);
            ErrorHandler.reportExceptionExtra(ite.getTargetException(), "Invocation target exception", this);
        }
    }

    protected boolean isMapInfoSent() {
        return this.regInfoSent;
    }

    public void mvClearPrint() {
        this.mvText.setLength(0);
    }

    public void mvFlushPrint() {
        Property textProp = (Property)this.propertiesByName.get(String.valueOf(this.modelInstance.getClass().getName()) + "MVText");
        textProp.setValue((SimClass)this.modelInstance, this.mvText.toString());
        textProp.update(this.modelInstance, this.propertyListener);
        textProp.setValue((SimClass)this.modelInstance, "");
        this.mvText.setLength(0);
    }

    public void mvPrint(String str) {
        this.mvText.append(str);
    }

    public void mvPrintln(String str) {
        this.mvText.append(String.valueOf(str) + lineSep);
    }

    public synchronized void outputUpdate() {
        this.propertyListener.reset();
        if (this.modelClassInstances != null) {
            int i = 0;
            while (i < this.modelClassInstances.size()) {
                ((SimClass)this.modelClassInstances.elementAt(i)).checkChanges(this.propertyListener);
                ++i;
            }
        }
        if (this.propertyListener.sentPropertyUpdate()) {
            this.flushTriggerConditions();
        }
    }

    private boolean propertyAlreadyRegistered(String className, String propertyName) {
        return this.propertiesByName.containsKey(String.valueOf(className) + propertyName);
    }

    public void registerActionMethod(String methodName, String menuTitle) {
        boolean error = false;
        Method method = null;
        Class[] params = new Class[0];
        method = this.getMethod(methodName, params);
        if (method != null) {
            if (this.actionMethods == null) {
                this.actionMethods = new Vector(2, 2);
                this.actionMenuStrings = new Vector(2, 2);
            }
            this.actionMethods.addElement(method);
            this.actionMenuStrings.addElement(menuTitle);
        }
    }

    public void registerActionMethod(String methodName, String submenuName, String menuTitle) {
        this.registerActionMethod(methodName, String.valueOf(submenuName) + ":" + menuTitle);
    }

    private void registerClass(SimClass sc) {
        ClassRegister rc = null;
        String className = sc.getClass().getName();
        if (!this.classReg.containsKey(className)) {
            rc = new ClassRegister(sc);
            rc.setClassIdentifier(this.ClassRegisteres++);
            this.classReg.put(className, rc);
            this.classRegVec.addElement(rc);
        } else {
            rc = (ClassRegister)this.classReg.get(className);
            sc.setAlreadyRegistered(true);
        }
        sc.setRegisteredClass(rc);
        rc.addInstance(sc);
        sc.setUniqueIdStr();
        if (this.regInfoSent && rc.getInstanceCount() > 1) {
            sc.initialisePropertyStorage();
            this.propertyListener.handlePropertyUpdate(new PropertyUpdateEvent(2, sc.getClassIdentifier(), sc.getMapProperties()));
        }
    }

    public void registerCustomObject(String customObject) {
        if (this.customObjectStrings == null) {
            this.customObjectStrings = new Vector(2);
        }
        this.customObjectStrings.addElement(customObject);
    }

    public void registerDynamicProperty(SimClass sc, String propName, String fieldName, int type, String methodName) {
        ClassRegister rc = (ClassRegister)this.classReg.get(sc.getClass().getName());
        if (rc.templateExists()) {
            Property p = this.registerProperty(sc, propName, fieldName, type, methodName);
            rc.extendTemplateAndStorage(p);
            this.propertyListener.handlePropertyUpdate(new PropertyUpdateEvent(3, this.getClassPropertyTemplates()));
            Vector instances = rc.getAllInstances();
            int classCount = instances.size();
            MapProperty[] newMapProperties = new MapProperty[classCount];
            int i = 0;
            while (i < classCount) {
                newMapProperties[i] = p.getMapProperty((SimClass)instances.elementAt(i));
                ++i;
            }
            this.propertyListener.handlePropertyUpdate(new PropertyUpdateEvent(7, rc.getClassIdentifier(), newMapProperties));
        } else {
            ErrorHandler.printMessage("Dynamic property addition should only be used outside of constructor", this);
        }
    }

    public void registerFileMethod(String methodName, String menuTitle) {
        boolean error = false;
        Method method = null;
        Class[] params = new Class[]{methodName.getClass()};
        method = this.getMethod(methodName, params);
        if (method != null) {
            if (this.fileMethods == null) {
                this.fileMethods = new Vector(2, 2);
                this.fileMenuStrings = new Vector(2, 2);
            }
            this.fileMethods.addElement(method);
            this.fileMenuStrings.addElement(menuTitle);
        }
    }

    public void registerLinkedProperty(SimClass sc, String propName, String fieldName, String linkProperty) {
        String className = sc.getClass().getName();
        ClassRegister rc = (ClassRegister)this.classReg.get(className);
        Property pi = null;
        Vector outputs = rc.getOutputProperties();
        int i = 0;
        while (i < outputs.size()) {
            if (((Property)outputs.elementAt((int)i)).name.equals(linkProperty)) {
                pi = (Property)outputs.elementAt(i);
                break;
            }
            ++i;
        }
        if (pi != null) {
            LinkedProperty p = new LinkedProperty(sc, propName, fieldName, linkProperty, rc.getPropertyId(), 0);
            pi.addDependant(p);
            rc.addProperty(p);
            this.addByName(className, p);
        } else {
            ErrorHandler.reportMessage("Could not register linked property " + propName + " in " + className, this);
            ErrorHandler.reportMessage("        " + linkProperty + " must be registered first", this);
        }
    }

    public void registerProperty(SimClass sc, String propName, String fieldName, int type) {
        this.registerProperty(sc, propName, fieldName, type, null);
    }

    public Property registerProperty(SimClass sc, String propName, String fieldName, int type, String methodName) {
        PropertyAccessor pa;
        Class patype;
        String fname;
        Property p = null;
        Method method = null;
        String className = sc.getClass().getName();
        ClassRegister rc = (ClassRegister)this.classReg.get(className);
        if (methodName != null) {
            try {
                method = sc.getClass().getMethod(methodName, new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                ErrorHandler.reportError("Method " + methodName + " could not be registered against property " + propName + " in " + className, this);
            }
        }
        p = (fname = (patype = (pa = new PropertyAccessor(fieldName)).getType(sc)).toString()).endsWith("Vector") ? new VectorProperty(sc, propName, fieldName, pa, rc.getPropertyId(), 0) : new DotProperty(sc, propName, fieldName, pa, rc.getPropertyId(), 0, method);
        p.setIOType(type);
        this.addByName(className, p);
        rc.addProperty(p);
        if (type == 4 && propName == SaveState.UNIQUE_PID) {
            rc.setUniqueProperty(p);
        }
        return p;
    }

    public void registerUniqueField(SimClass sc, String uniqueField) {
        this.registerProperty(sc, SaveState.UNIQUE_PID, uniqueField, 4, null);
    }

    public void removeClassInstance(SimClass c) {
        if (this.modelClassInstances != null) {
            this.modelClassInstances.removeElement(c);
        }
    }

    public void restoreProperty(SimClass base, String propertyName) {
        ((Property)this.propertiesByName.get(String.valueOf(base.getClass().getName()) + propertyName)).restoreValue(base, this.propertyListener);
    }

    public void sendAllUpdates() {
        if (this.propertyListener != null && this.modelClassInstances != null) {
            int i = 0;
            while (i < this.modelClassInstances.size()) {
                ((SimClass)this.modelClassInstances.elementAt(i)).sendAllPropertyValues(this.propertyListener);
                ++i;
            }
        }
    }

    private void sendClassUpdate(SimClass classInstance) {
        if (this.propertyListener != null) {
            classInstance.sendAllPropertyValues(this.propertyListener);
        }
    }

    public void sendUpdate(SimClass base, String propertyName) {
        ((Property)this.propertiesByName.get(String.valueOf(base.getClass().getName()) + propertyName)).update(base, this.propertyListener);
    }

    protected static void setLoadingRegister(PropertyRegister reg) {
        loadingRegister = reg;
    }

    public void setMVError(String errorStr) {
        Property errProp = (Property)this.propertiesByName.get(String.valueOf(this.modelInstance.getClass().getName()) + "MVError");
        errProp.setValue((SimClass)this.modelInstance, errorStr);
        errProp.update(this.modelInstance, this.propertyListener);
        errProp.setValue((SimClass)this.modelInstance, "");
    }

    protected void setMainSimClass(MainSimClass model) {
        this.modelInstance = model;
    }

    private void setModelIdentifier(int modelIdentifier) {
        this.modelIdentifier = modelIdentifier;
    }

    public void setProperty(SimClass base, String propertyName, double val) {
        ((Property)this.propertiesByName.get(String.valueOf(base.getClass().getName()) + propertyName)).setValue(base, val);
    }

    public void setProperty(SimClass base, String propertyName, Object val) {
        ((Property)this.propertiesByName.get(String.valueOf(base.getClass().getName()) + propertyName)).setValue(base, val);
    }

    public void setPropertyListener(PropertyUpdateListener l) {
        this.propertyListener = l;
        this.propertyListener.setReg(this);
    }

    public void setSaveState(Vector states) {
        this.modelInstance.setSaveState((SaveState)states.elementAt(0));
        if (states.size() > 1) {
            SaveState sst = null;
            Object allInstances = null;
            SimClass sc = null;
            int i = 1;
            while (i < states.size()) {
                sst = (SaveState)states.elementAt(i);
                sc = this.getUniqueInstance(sst);
                if (sc == null) {
                    sc = this.modelInstance.createSimClass(sst.getClassName());
                }
                sc.setSaveState(sst);
                ++i;
            }
        }
        this.checkInstanceNumbers();
    }

    public static void statSetMVError(String modelName, String errorStr) {
        PropertyRegister sr = (PropertyRegister)allRegisters.get(modelName);
        Property errProp = (Property)sr.propertiesByName.get(String.valueOf(sr.modelInstance.getClass().getName()) + "MVError");
        errProp.setValue((SimClass)sr.modelInstance, errorStr);
        errProp.update(sr.modelInstance, sr.propertyListener);
        errProp.setValue((SimClass)sr.modelInstance, "");
    }
}

