/*
 * Decompiled with CFR 0.152.
 */
package org.jelsim.model;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Vector;
import org.jelsim.model.AccessDimension;
import org.jelsim.model.AccessField;
import org.jelsim.model.SimClass;
import org.jelsim.model.SimConst;
import org.jelsim.model.map.ClassInstance;
import org.jelsim.model.map.MapStore;
import org.jelsim.model.simutil;
import org.jelsim.system.ErrorHandler;

public class PropertyAccessor
implements SimConst {
    private int simtype = -1;
    private AccessField[] fieldChain = null;
    private String fieldName;
    private SimClass baseInstance;
    private Boolean primitiveField = null;

    PropertyAccessor(String fieldName) {
        this.fieldName = fieldName;
        try {
            this.fieldChain = this.getAccessFields(fieldName);
        }
        catch (IOException ioe) {
            ErrorHandler.reportExceptionExtra(ioe, "Error creating property accessor for " + fieldName, this);
        }
    }

    public AccessField[] getAccessFields(String access) throws IOException {
        boolean parsing = true;
        Vector<AccessField> sv = new Vector<AccessField>();
        StreamTokenizer tokens = new StreamTokenizer(new StringReader(access));
        tokens.ordinaryChar(91);
        tokens.ordinaryChar(93);
        tokens.ordinaryChar(46);
        tokens.wordChars(95, 95);
        while (parsing) {
            switch (tokens.nextToken()) {
                case -1: {
                    parsing = false;
                    break;
                }
                case -3: {
                    String tmp = tokens.sval;
                    if (tokens.nextToken() == 91) {
                        sv.addElement(new AccessField(tmp, this.parseArrayField(tokens)));
                        break;
                    }
                    sv.addElement(new AccessField(tmp));
                    break;
                }
            }
        }
        AccessField[] retfields = new AccessField[sv.size()];
        int i = 0;
        while (i < retfields.length) {
            retfields[i] = (AccessField)sv.elementAt(i);
            ++i;
        }
        return retfields;
    }

    /*
     * Unable to fully structure code
     */
    private Field getChainField(Object instance, int index) {
        block3: {
            f = null;
            dims = null;
            try {
                f = instance.getClass().getField(this.fieldChain[index].name);
                break block3;
            }
            catch (NoSuchFieldException v0) {
                ErrorHandler.reportMessage("GCF: No field " + this.fieldChain[index].name + " in chain " + this.fieldName + " at level " + index);
                ErrorHandler.reportMessage("Instance is " + instance.getClass().getName() + " " + instance);
                i = 0;
                ** while (i < this.fieldChain.length)
            }
lbl-1000:
            // 1 sources

            {
                ErrorHandler.reportMessage("Access field " + this.fieldChain[i].name + " " + this.fieldChain[i].dims);
                ++i;
                continue;
            }
lbl14:
            // 1 sources

            ErrorHandler.reportMessage("Attempt to access non-existent field (" + this.fieldChain[index].name + ") in model.", this);
        }
        return f;
    }

    private Object getChainVal(Object instance, int index) {
        Field f = null;
        Object chainval = null;
        AccessDimension dims = null;
        try {
            f = instance.getClass().getField(this.fieldChain[index].name);
            chainval = f.get(instance);
            dims = this.fieldChain[index].dims;
            while (dims != null) {
                chainval = Array.get(chainval, dims.getValue(this.baseInstance));
                dims = dims.getNext();
            }
        }
        catch (IllegalAccessException iae) {
            ErrorHandler.reportExceptionExtra(iae, "Unable to access field " + this.fieldChain[index].name + this.fieldChain[index].dims + " chain " + this.fieldName, this);
        }
        catch (NoSuchFieldException nsfe) {
            ErrorHandler.reportExceptionExtra(nsfe, "GCV: No field " + this.fieldChain[index].name + " in chain " + this.fieldName, this);
        }
        return chainval;
    }

    private Field getPaField(SimClass sc) {
        this.baseInstance = sc;
        if (this.fieldChain.length == 1) {
            return this.getChainField(sc, 0);
        }
        Object chainval = this.getChainVal(sc, 0);
        int i = 1;
        while (i < this.fieldChain.length - 1) {
            chainval = this.getChainVal(chainval, i);
            ++i;
        }
        return this.getChainField(chainval, this.fieldChain.length - 1);
    }

    public int getSimType(SimClass sc) {
        if (this.simtype == -1) {
            Class<?> ftype = this.getPaField(sc).getType();
            this.simtype = simutil.getSimType(ftype);
            if (ftype.isArray()) {
                int actualDims = ftype.getName().lastIndexOf(91) + 1;
                if (actualDims < 0) {
                    ErrorHandler.reportMessage("Internal error determining dimensions for " + this.fieldName);
                } else {
                    this.simtype += (actualDims - this.fieldChain[this.fieldChain.length - 1].ndimensions()) * 10000;
                }
            }
        }
        return this.simtype;
    }

    public Class getType(SimClass sc) {
        return this.getPaField(sc).getType();
    }

    public Object getValue(SimClass sc) {
        try {
            this.baseInstance = sc;
            Object chainval = null;
            chainval = this.getChainVal(sc, 0);
            int i = 1;
            while (i < this.fieldChain.length) {
                chainval = this.getChainVal(chainval, i);
                ++i;
            }
            return chainval;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public boolean isArray(SimClass sc) {
        return this.getSimType(sc) >= 10000;
    }

    public boolean isPrimitive(SimClass sc) {
        if (this.primitiveField == null) {
            Field f = this.getPaField(sc);
            this.primitiveField = f.getType().isArray() ? new Boolean(f.getType().getComponentType().isPrimitive()) : new Boolean(f.getType().isPrimitive());
        }
        return this.primitiveField;
    }

    private AccessDimension parseArrayField(StreamTokenizer tokens) throws IOException {
        int level = 1;
        AccessDimension dimensions = null;
        boolean parsing = true;
        while (parsing) {
            StringBuffer sb = new StringBuffer();
            while (level > 0) {
                switch (tokens.nextToken()) {
                    case -3: {
                        sb.append(tokens.sval);
                        break;
                    }
                    case -2: {
                        sb.append((int)tokens.nval);
                        break;
                    }
                    case -1: {
                        ErrorHandler.reportMessage("String ended before successful parse", this);
                        throw new IOException();
                    }
                    case 91: {
                        sb.append("[");
                        ++level;
                        break;
                    }
                    case 93: {
                        if (level > 1) {
                            sb.append("]");
                        }
                        --level;
                        break;
                    }
                    case 46: {
                        sb.append(".");
                        break;
                    }
                }
            }
            if (dimensions == null) {
                dimensions = new AccessDimension(sb.toString());
            } else {
                dimensions.linkNext(new AccessDimension(sb.toString()));
            }
            if (tokens.nextToken() == 91) {
                ++level;
                continue;
            }
            tokens.pushBack();
            parsing = false;
        }
        return dimensions;
    }

    public void setValue(SimClass sc, double dval) {
        this.setValue(sc, new Double(dval));
    }

    public void setValue(SimClass sc, Object value) {
        this.baseInstance = sc;
        Object chainval = sc;
        Field f = null;
        if (this.fieldChain.length == 1) {
            f = this.getChainField(sc, 0);
        } else {
            chainval = this.getChainVal(chainval, 0);
            int i = 1;
            while (i < this.fieldChain.length - 1) {
                chainval = this.getChainVal(chainval, i);
                ++i;
            }
            f = this.getChainField(chainval, this.fieldChain.length - 1);
        }
        int ndimensions = this.fieldChain[this.fieldChain.length - 1].ndimensions();
        if (ndimensions > 0) {
            try {
                chainval = f.get(chainval);
            }
            catch (IllegalAccessException iae) {
                ErrorHandler.reportExceptionExtra(iae, "Unable to access last field chain " + this.fieldName, this);
            }
            AccessDimension dims = this.fieldChain[this.fieldChain.length - 1].dims;
            int j = 0;
            while (j < ndimensions - 1) {
                chainval = Array.get(chainval, dims.getValue(this.baseInstance));
                dims = dims.getNext();
                ++j;
            }
            try {
                Array.set(chainval, dims.getValue(this.baseInstance), value);
            }
            catch (IllegalArgumentException e) {
                ErrorHandler.reportExceptionExtra(e, "Illegal array write on " + chainval + " " + this.fieldChain[this.fieldChain.length - 1].name, this);
            }
        } else {
            try {
                switch (this.simtype) {
                    case -1: {
                        ErrorHandler.reportExceptionExtra(new Throwable("Invalid type"), "Could not determine a type for field " + this.fieldName, this);
                        break;
                    }
                    case 0: {
                        if (value instanceof Boolean) {
                            f.setBoolean(chainval, (Boolean)value);
                            break;
                        }
                        if (value instanceof String) {
                            f.setBoolean(chainval, new Boolean((String)value));
                        }
                        break;
                    }
                    case 1: {
                        f.setChar(chainval, ((Character)value).charValue());
                        break;
                    }
                    case 2: {
                        f.setByte(chainval, (Byte)value);
                        break;
                    }
                    case 3: {
                        f.setShort(chainval, (Short)value);
                        break;
                    }
                    case 4: {
                        f.setInt(chainval, (Integer)value);
                        break;
                    }
                    case 5: {
                        f.setLong(chainval, (Long)value);
                        break;
                    }
                    case 6: {
                        f.setFloat(chainval, ((Float)value).floatValue());
                        break;
                    }
                    case 7: {
                        f.setDouble(chainval, (Double)value);
                        break;
                    }
                    case 8: {
                        f.set(chainval, value);
                        break;
                    }
                    case 9: {
                        if (value instanceof SimClass) {
                            f.set(chainval, value);
                            break;
                        }
                        if (value instanceof ClassInstance) {
                            ((SimClass)f.get(chainval)).setPropertyValues(((ClassInstance)value).getValues());
                        }
                        break;
                    }
                    case 12: {
                        ErrorHandler.reportMessage("SIMUKNOWN should not occur in MapStore.setValue");
                        break;
                    }
                    case 11: {
                        ErrorHandler.reportMessage("Complete SIMTABLE updates not yet supported");
                        break;
                    }
                    case 10: {
                        f.set(chainval, value);
                        break;
                    }
                    default: {
                        if (this.simtype >= 10000) {
                            f.set(chainval, value);
                        }
                        break;
                    }
                }
            }
            catch (IllegalAccessException iae) {
                ErrorHandler.reportExceptionExtra(iae, "Unable to access field " + f + " in model update", this);
            }
            catch (IllegalArgumentException iarg) {
                ErrorHandler.reportExceptionExtra(iarg, "Illegal argument for object " + value.getClass().getName() + " Field was " + f, this);
            }
        }
    }

    public void setValue(SimClass sc, MapStore pup) {
        if (this.simtype != pup.getType()) {
            ErrorHandler.reportExceptionExtra(new Throwable("Incompatible property type"), String.valueOf(this.fieldName) + " assigned incompatible value", this);
        } else {
            this.setValue(sc, pup.getValue());
        }
    }
}

