/*
 * Decompiled with CFR 0.152.
 */
package org.jelsim.model;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Vector;
import org.jelsim.model.LinkedProperty;
import org.jelsim.model.PropertyAccessor;
import org.jelsim.model.RefClass;
import org.jelsim.model.SimClass;
import org.jelsim.model.SimConst;
import org.jelsim.model.StaticSimClass;
import org.jelsim.model.VectorProperty;
import org.jelsim.model.event.PropertyUpdateEvent;
import org.jelsim.model.event.PropertyUpdateListener;
import org.jelsim.model.map.ClassInstance;
import org.jelsim.model.map.MapProperty;
import org.jelsim.model.map.MapStore;
import org.jelsim.model.map.PropertyUpdate;
import org.jelsim.system.ErrorHandler;

public abstract class Property
implements SimConst {
    public String name;
    public String fieldName;
    protected int id;
    public int gid;
    public boolean isPrimitive;
    private int classIdentifier = -1;
    public int simType = -1;
    private int ioType;
    protected PropertyAccessor pa = null;
    protected Method method = null;
    private Vector dependants = null;

    Property(SimClass sc, String propertyName, String fieldName) {
        this.name = propertyName;
        this.fieldName = fieldName;
        this.pa = null;
    }

    Property(SimClass sc, String propertyName, String fieldName, PropertyAccessor pa, int id, int gid) {
        this(sc, propertyName, fieldName, pa, id, gid, null);
    }

    Property(SimClass sc, String propertyName, String fieldName, PropertyAccessor pa, int id, int gid, Method m) {
        this.name = propertyName;
        this.fieldName = fieldName;
        this.pa = pa;
        this.id = id;
        this.gid = gid;
        this.method = m;
        this.simType = pa.getSimType(sc);
        this.classIdentifier = sc.getClassIdentifier();
    }

    public void addDependant(LinkedProperty p) {
        if (this.dependants == null) {
            this.dependants = new Vector(2, 2);
        }
        this.dependants.addElement(p);
    }

    public abstract void checkChange(SimClass var1, PropertyUpdateListener var2);

    protected int getClassIdentifier() {
        return this.classIdentifier;
    }

    public int getIOType() {
        return this.ioType;
    }

    protected int getInClassId() {
        return this.id;
    }

    public MapProperty getMapProperty(SimClass baseInstance) {
        Object paValue = null;
        MapProperty mp = new MapProperty(this.name, baseInstance.getClassIdentifier(), baseInstance.getInstance(), this.id, baseInstance.getUniqueValue(), this.simType, this.ioType);
        if (this.simType == 11 || this.simType == 12) {
            paValue = ((VectorProperty)this).getCPIS(baseInstance);
            mp.propertySet((ClassInstance[])paValue);
        } else if (this.simType >= 10000) {
            mp.propertySet(baseInstance.getPreviousValue(this.id));
        } else if (this.simType == 9) {
            paValue = this.pa.getValue(baseInstance);
            if (paValue != null) {
                mp.propertySet(((StaticSimClass)paValue).getCPI());
            }
        } else if (this.simType == 10) {
            paValue = this.pa.getValue(baseInstance);
            if (paValue != null) {
                mp.propertySet(((RefClass)this.pa.getValue(baseInstance)).getRefPair());
            }
        } else if (this.simType >= 0 && this.simType <= 8) {
            mp.propertySet(baseInstance.getPreviousValue(this.id));
        }
        return mp;
    }

    public MapStore getMapStore(SimClass baseInstance) {
        Object paValue = null;
        MapStore ms = new MapStore(this.simType);
        if (this.simType == 11 || this.simType == 12) {
            paValue = ((VectorProperty)this).getCPIS(baseInstance);
            ms.setValue(((VectorProperty)this).getCPIVector(baseInstance));
        } else if (this.simType >= 10000) {
            ms.setValue(baseInstance.getPreviousValue(this.id));
        } else if (this.simType == 9) {
            paValue = this.pa.getValue(baseInstance);
            if (paValue != null) {
                ms.setValue(((StaticSimClass)paValue).getCPI());
            }
        } else if (this.simType == 10) {
            paValue = this.pa.getValue(baseInstance);
            if (paValue != null) {
                ms.setValue(((RefClass)this.pa.getValue(baseInstance)).getRefPair());
            }
        } else if (this.simType >= 0 && this.simType <= 8) {
            ms.setValue(baseInstance.getPreviousValue(this.id));
        }
        return ms;
    }

    public String getName() {
        return this.name;
    }

    public int getSimType() {
        return this.simType;
    }

    public abstract Class getType(SimClass var1);

    public Object getValue(SimClass baseInstance) {
        return this.pa.getValue(baseInstance);
    }

    public void restoreValue(SimClass baseInstance, PropertyUpdateListener plistnr) {
        if (this.method != null) {
            Object saved = baseInstance.getSavedValue(this.id);
            if (saved != null) {
                this.pa.setValue(baseInstance, saved);
                this.update(baseInstance, plistnr);
            }
        } else {
            ErrorHandler.reportMessage("Cannot call Property.restoreValue() if there is no associated method", this);
        }
    }

    public void setIOType(int type) {
        this.ioType = type;
    }

    public void setValue(SimClass baseInstance, double dval) {
        this.pa.setValue(baseInstance, dval);
    }

    public void setValue(SimClass baseInstance, Object val) {
        this.pa.setValue(baseInstance, val);
    }

    public void setValue(SimClass baseInstance, MapStore pup) {
        block5: {
            if (this.method != null) {
                baseInstance.setSavedValue(this.id, this.pa.getValue(baseInstance));
                if (pup.getType() == 9) {
                    baseInstance.setSavedValue(this.id, ((StaticSimClass)baseInstance.getSavedValue(this.id)).getCPI());
                }
            }
            this.pa.setValue(baseInstance, pup);
            if (this.method == null) break block5;
            try {
                this.method.invoke((Object)baseInstance, new Object[0]);
            }
            catch (IllegalAccessException iae) {
                ErrorHandler.reportExceptionExtra(iae, "Access error for method " + this.method.getName() + " Property " + this.name, this);
            }
            catch (InvocationTargetException ite) {
                ErrorHandler.reportError("Error in method " + this.method.getName() + " in property " + this.name, this);
                ErrorHandler.reportExceptionExtra(ite.getTargetException(), "Method target except for Property " + this.name, this);
            }
        }
    }

    public void update(SimClass base, PropertyUpdateListener plistnr) {
        Object value = this.pa.getValue(base);
        base.setPreviousValue(this.id, value);
        plistnr.handlePropertyUpdate(new PropertyUpdateEvent(0, base.getClassIdentifier(), base.getInstance(), this.id, base.getModelIdentifier(), new PropertyUpdate(this.getMapStore(base))));
        if (this.dependants != null) {
            this.updateDependants(base, plistnr);
        }
    }

    protected void updateDependants(SimClass baseInstance, PropertyUpdateListener plistnr) {
        if (this.dependants != null) {
            Enumeration e = this.dependants.elements();
            while (e.hasMoreElements()) {
                ((LinkedProperty)e.nextElement()).update(baseInstance, plistnr);
            }
        }
    }
}

